/*
    Snowy The GP2X INTRO (Win32 Port)

	Copyright (C) 2006 Ozan Emirhan Bayyurt aka Ragnor/Manyetiq
    License: GPL
    WWW: http://ozanemirhan.blogspot.com
    Group WWW: http://manyetiq.tr-demoscene.info
    E-mail: ragnor_whr@yahoo.com

    This is our (MANYETIQ) first GP2X intro's Win32 port. Intro has a snow
    effect, a logo and a scroller. By the way we'll release windows and
    maybe linux ports of this demo. Wait for our next prod. Till then be
    happy and stay in that mood :).

    Code: Ragnor/Manyetiq
    Font: Serdar Ozturk (a friend of mine -rag.)
    Logo: Lockman_Hackim/Manyetiq
    Music: the prodigy/Manyetiq


    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <windows.h>
#include "SDL.h"
#include "SDL_mixer.h"
#include "SFonttr.h"


/* The screen surface */
SDL_Surface *screen = NULL;
SDL_Surface *logo;
SDL_Rect dest;
SFont_Font* Font;
Mix_Music *music;

typedef struct
{
    int x,y;
    int layer;
}snow;
snow kar[999];

Uint32 snowcol[3];
int oldtick, newtick, differ;
int fontx, fonty;

char message[]="HI, THIS IS MANYETIQ'S FIRST GP2X INTRO (BUT WE WILL RELEASE IT ON WINDOWS AND MAYBE LINUX TOO). IT WAS SNOWED HERE  A FEW DAYS AGO. IT STARTED IN THE MORNING, AND IN A ONE DAY (ACTUALLY HALF A DAY) EVERYWHERE WAS WHITE. IT WAS A REALLY NICE SCENE AND SAME DAY I SAW A SNOW DEMO CODE INSPIRED FROM THE PROBABLY THE LAST SNOW OF THE SEASON AND THAT DEMO CODE I CODED THIS CRAPPY INTRO. ENJOY... -- CODE: RAGNOR/MANYETIQ FONT: SERDAR OZTURK ( A FRIEND OF MINE ) LOGO: LOCKMAN_HACKIM/MAYETIQ MUSIC: THE PRODIGY/MANYETIQ --.  THATS ALL FOLKS, NOW GO AWAY!!! BY THE WAY IT WON'T CLOSE ITSELF, JUST PRESS A BUTTON AND IT WILL BE CLOSED OR MAYBE FORMAT YOUR HARD DRIVES. IT'S YOUR CHOICE, YOUR RISK :). GOODBYE.";

void putpixel(SDL_Surface *surface, int x, int y, Uint32 pixel)
{
    int bpp = surface->format->BytesPerPixel;
    Uint8 *p = (Uint8 *)surface->pixels + y * surface->pitch + x * bpp;
    switch(bpp) {
    case 1:
        *p = pixel;
        break;
    case 2:
        *(Uint16 *)p = pixel;
        break;
    case 3:
        if(SDL_BYTEORDER == SDL_BIG_ENDIAN) {
            p[0] = (pixel >> 16) & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = pixel & 0xff;
        } else {
            p[0] = pixel & 0xff;
            p[1] = (pixel >> 8) & 0xff;
            p[2] = (pixel >> 16) & 0xff;
        }
        break;
    case 4:
        *(Uint32 *)p = pixel;
        break;
    }
}

void init_snow()
{
    int i;
    for (i=0;i<999;i++)
    {
        kar[i].x=rand()%640;
        kar[i].y=0-rand()%480;
        kar[i].layer=rand()%3;
    }

    snowcol[0]=SDL_MapRGB(screen->format, 250,250,250);
    snowcol[1]=SDL_MapRGB(screen->format, 205,205,205);
    snowcol[2]=SDL_MapRGB(screen->format, 155,155,155);
}

void update_snow()
{
    int i;
    for (i=0;i<999;i++)
    {
        kar[i].y+=3-(kar[i].layer);
        //kar[i].x+=rand()%5-2;
        if (kar[i].y>=480)
        {
            kar[i].y=-1;
            kar[i].x=rand()%640;
            kar[i].layer=rand()%3;
        }
        
    }
}

void draw_text()
{
    SFont_Write(screen,Font,fontx,fonty,message);
}

void update_text()
{
    fontx-=5;
}

/* This function draws to the screen; replace this with your own code! */
static void
draw ()
{
    Uint32 color;
    int i;

    /* Create a black background */
    color = SDL_MapRGB (screen->format, 0, 0, 0);
    SDL_FillRect (screen, NULL, color);
    for (i=0;i<999;i++)
    {
        if ((kar[i].x>0 && kar[i].x<640) && (kar[i].y>0 && kar[i].y<480))
        {
            //SDL_LockSurface(screen);
            putpixel(screen,kar[i].x,kar[i].y,snowcol[kar[i].layer]);
            //SDL_UnLockSurface(screen);
        }
    }
    draw_text();
    newtick=SDL_GetTicks();
    differ=newtick-oldtick;
    if (differ>=55)
    {
        oldtick=newtick;
        update_snow();
        update_text();
    }
    
    SDL_BlitSurface(logo, NULL, screen, &dest);
    //update_snow();
    /* Make sure everything is displayed on screen */
    SDL_Flip (screen);
    /* Don't run too fast */
    SDL_Delay (1);
}


int
main (int argc, char *argv[])
{
    int done;
    
    int audio_rate = 22050;			//frekans
	Uint16 audio_format = AUDIO_S16SYS; 	//format
	int audio_channels = 2;			//2 channels = stereo
	int audio_buffers = 4096;		//bellekteki tamponun bykl

    /* Initialize SDL */
    if (SDL_Init (SDL_INIT_VIDEO | SDL_INIT_AUDIO | SDL_INIT_TIMER) < 0)
    {
        printf ("Couldn't initialize SDL: %s\n", SDL_GetError ());
        exit (1);
    }
    atexit (SDL_Quit);

    /* Set 640x480 16-bits video mode */
    screen = SDL_SetVideoMode (640, 480, 16, SDL_SWSURFACE | SDL_FULLSCREEN);
    if (screen == NULL)
    {
        printf ("Couldn't set 640x480x16 video mode: %s\n",
          SDL_GetError ());
        exit (2);
    }
    if(Mix_OpenAudio(audio_rate, audio_format, audio_channels, audio_buffers) != 0) 
	{
		fprintf(stderr,"Unable to initialize audio: %s\n", Mix_GetError());
		exit (3);
	}

    SDL_WM_SetCaption ("SDL MultiMedia Application", NULL);

    Font = SFont_InitFont(SDL_LoadBMP("font.bmp"));
    music = Mix_LoadMUS("yeniyil2.mp3");
    logo = SDL_LoadBMP("logo.bmp");

    Mix_PlayMusic(music, -1);

    srand(time(NULL));
    init_snow();
    done = 0;
    oldtick=SDL_GetTicks();
    fontx=640;
    fonty=360;
    
    dest.x = 190;
    dest.y = 50;

    while (!done)
    {
        SDL_Event event;

        /* Check for events */
        while (SDL_PollEvent (&event))
        {
            switch (event.type)
            {
            case SDL_KEYDOWN:
                done = 1;
                break;
            case SDL_QUIT:
                done = 1;
                break;
            default:
                break;
            }
        }

        /* Draw to screen */
        draw ();
    }
    
    Mix_HaltMusic();
	Mix_FreeMusic(music);
	music=NULL;
    SFont_FreeFont(Font);
    Mix_CloseAudio();

    return 0;
}
