;
;                *****************************************
;                ***                                   ***
;                ***       MegaMan_X's MegAnime        ***
;                ***                                   ***
;                ***             Coded for:            ***
;                ***   GameBoy Demo Competition  '98   ***
;                ***                                   ***
;                *****************************************
;
;
; Coded for:
; Advanced GameBoy IDE v0.70 and up
;
; Code donated to public domain.
; Please don't ask any question, I don't have time.
; Please don't ask me to convert this listing for GBDK or anything else,
; as I only know how to code for my own assembler.
;
; Copyrights:
; - This listing copyright (C) 1998 MegaMan_X, donated to public domain.
; - Advanced GameBoy IDE is copyright (C) 1996,1997,1998 MegaMan_X.
; - Advanced PCX to GameBoy converter is copyright (C) 1997,1998 MegaMan_X.
; - All images copyright (C) their respective owners.
; - GameBoy, GameBoy Pocket and Super GameBoy are trademarks (TM) of Nintendo
;
 
;*** RST 00h ***
.org 0000h
 ret
    
;*** RST 08h ***
.org 0008h
 ret
    
;*** RST 10h ***
.org 0010h
 ret
    
;*** RST 18h ***
.org 0018h
 ret
    
;*** RST 20h ***
.org 0020h
 ret
    
;*** RST 28h ***
.org 0028h
 ret
    
;*** RST 30h ***
.org 0030h
 push AF
 mov  A,11010001b       ; Set BG & Window Tile Data to [8000h]
 mov  [FF40h],A
 mov  A,072d            ; Set LCDC IRQ at line 72
 mov  [FF45h],A
 pop  AF
 ret
    
;*** RST 38h ***
;.org 0038h
; ret
     
;*** Vertical blanking IRQ ***
.org 0040h
 rst 30h
 reti
     
;*** LCD status IRQ ***
.org 0048h
 push AF
LCD-Loop:
 mov  A,[FF41h]
 bit  A.1
 jnz  @LCD-Loop
 mov  A,11000001b       ; Set BG & Window Tile Data to [8800h]
 mov  [FF40h],A
 pop  AF
 reti
     
;*** Timer owerflow IRQ ***
.org 0050h
; reti
      
;*** Serial transfer completion IRQ ***
.org 0058h
; reti
      
;*** GamePad IRQ ***
.org 0060h
; reti
      
      
;*** GameBoy "Boot Sector" **************************************************
                                                                             
.org 0101h
 jmp @Start
           
.binfile "NINLOGO.BIN"  ; Use original logo for GB compatibility
                                                                
.dt "MMX - MEGANIM   "  ; GamePak name (16 characters)
.dw C0DEh               ; New Licensee Code (two digits)
                        ; C0DE = MegaMan_X
.db 00h                 ; Super GameBoy Features (00 = none, 03h = SGB)
.db 00h                 ; ROM Only
.db 00h                 ; ROM Size 32k
.db 00h                 ; RAM Size  0k
.db 01h                 ; Destination code (00h = Japan, 01h = Other)
.db 33h                 ; Old Licensee Code (one digit / 33h = see new code)
.db 01h                 ; Version
                                 
                                 
;*** Begin ******************************************************************
                                                                             
.org  0150h
Start:
      
;*** Disable Interrupts ***
 di
   
; Initialize stack pointer
 mov  SP,FFF4h
              
;*** [FFFFh] Interrupts Enable (0:Off / 1:On) ***
; bit4 - GamePad IRQ
; bit3 - Serial I/O Transfer Complete
; bit2 - Timer Overflow
; bit1 - LCDC
; bit0 - VBlank
 mov  A,00000011b       ; Enable LCDC & VBlank IRQs
 mov  [FFFFh],A
               
;*** [FF40h] - LCD Control ***
; LCD Controller          0:Off / 1:On
; Window Tile Map         0:[9800h]-[9BFFh] / 1:[9C00h]-[9FFFh]
; Window Display          0:Off / 1:On
; BG & Window Tile Data   0:[8800h]-[97FFh] / 1:[8000h]-[8FFFh]
; Background Tile Map     0:[9800h]-[9BFFh] / 1:[9C00h]-[9FFFh]
; Sprites Size            0:8x8 / 1:16x8
; Sprites Display         0:Off / 1:On
; Background Display      0:Off / 1:On
 mov  A,01010001b
 mov  [FF40h],A
               
;*** [FF41h] - LCDC Status ***
 mov  A,01000100b       ; Make IRQ when refresh line = [FF45h]
 mov  [FF41h],A
               
 call @SetStuff         ; Set Palette, Background & Window position
; mov  BC,@ImageTiles1
; call @CopyTiles        ; Copy Tiles to 8000h
 call @SetTiles         ; Set Background Tile Map
                                                 
;*** LCD Control ***
 mov  A,11010001b
 mov  [FF40h],A
               
 ei
   
 call @BackgroundOff
                    
 mov  BC,@Title
 call @BetweenPic
                 
Loop:
     
 mov  BC,@Pic1
 call @BetweenPic
                 
 mov  BC,@Pic2
 call @BetweenPic
                 
 mov  BC,@Pic3
 call @BetweenPic
                 
 mov  BC,@Pic4
 call @BetweenPic
                 
 jmp  @Loop
           
           
;*** BetweenPic *************************************************************
BetweenPic:
 call @CopyTiles
 call @BackgroundOn
 call @BgFadeIn
 mov  C,10h
 call @CtrDelay
 call @BgFadeOut
 call @BackgroundOff
 ret
    
    
;*** Background Fade-out ****************************************************
BgFadeOut:
 push AF
 push BC
        
 mov  A,00000110b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000001b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000000b
 mov  [FF47h],A
               
 pop  BC
 pop  AF
 ret
    
    
;*** Background Fade-in *****************************************************
BgFadeIn:
 push AF
 push BC
        
 mov  A,00000001b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00000110b
 mov  [FF47h],A
               
 mov  C,01h
 call @CtrDelay
               
 mov  A,00011011b
 mov  [FF47h],A
               
 pop  BC
 pop  AF
 ret
    
;*** Register-based delay (Entry = C) ***************************************
CtrDelay:
 push HL
CtrDelayLoop1:
 mov  H,7Fh
CtrDelayLoop2:
 mov  L,FFh
CtrDelayLoop3:
 dec  L
 jnz  @CtrDelayLoop3
 dec  H
 jnz  @CtrDelayLoop2
 dec  C
 jnz  @CtrDelayLoop1
 pop  HL
 ret
    
    
;*** Set everyting off to get ready to copy new background data *************
                                                                             
BackgroundOff:
 di
 mov A,01010001b        ; LCD Off, Background On Tile=8000h Map=9800h
 mov [FF40h],A
 ret
    
    
;*** Set everyting on (LCD, background, interrupts) *************************
                                                                             
BackgroundOn:
 mov A,11010001b        ; LCD On, Background On Tile=8000h Map=9800h
 mov [FF40h],A
 ei
 ret
    
    
;*** Set Window Position at bottom of screen ********************************
                                                                             
SetStuff:
 xor  A
 mov  [FF42h],A         ; Background Scroll Y = 0
 mov  [FF43h],A         ; Background Scroll X = 0
 mov  A,00000000b       ; Set Background palette
 mov  [FF47h],A
 ret
    
    
;****************************************************************************
                                                                             
CopyTiles:
; Copy 360 Tiles to [8000h]-[9680h]
 mov  HL,8000h
 mov  DE,1780h          ; 360 Tiles * 16 bytes/tile = 5760d/1680h bytes
CopyTilesLoop:
 mov  A,[BC]
 mov  [HL],A
 inc  HL
 inc  BC
 dec  E
 jnz  @CopyTilesLoop
 dec  D
 jnz  @CopyTilesLoop
                    
 ret
    
    
;****************************************************************************
                                                                             
;*** Set Background Tiles - First 240 Tiles ***
                                               
SetTiles:
 mov  DE,000Ch
 mov  HL,9800h
 mov  A,00h             ; Start at Tile 0
 mov  C,012d            ; 12 tiles high
LoopSetTiles:
 mov  B,020d            ; 20 tiles wide
LoopSetTiles2:
 mov  [HL],A
 inc  HL
 inc  A
 dec  B
 jnz  @LoopSetTiles2
 add  HL,DE
 dec  C
 jnz  @LoopSetTiles
                   
                   
;*** Set Background Tiles - Last 120 Tiles ***
                                              
 mov  DE,000Ch
 mov  HL,9980h
 mov  A,240d            ; Start at Tile 240
 mov  C,006d            ; 6 tiles high
LoopSetTiles3:
 mov  B,020d            ; 20 tiles wide
LoopSetTiles4:
 mov  [HL],A
 inc  HL
 inc  A
 dec  B
 jnz  @LoopSetTiles4
 add  HL,DE
 dec  C
 jnz  @LoopSetTiles3
                    
 ret
    
    
;****************************************************************************
                                                                             
Title:
.binfile "TITLE.BIN"
                    
Pic1:
.binfile "DHY1.bin"
                   
Pic2:
.binfile "AMG1.bin"
                   
Pic3:
.binfile "MKR2.BIN"
                   
Pic4:
.binfile "AMG_LD4i.bin"
