; Asm-source for Critical Demo by Vulture/Outlaw Triad/Cri

DOSSEG              ; Sort the segment using DOS standard CODE DATA STACK
.MODEL SMALL        ; Data & Code both < 64kB & NEAR + seperated segments
.STACK 200h         ; 512 byte stack
.286                ; Allow 286 instructions
.DATA               ; Datasegment starts here (empty)
.CODE               ; Codesegment starts here
JUMPS               ; Let TASM handle out of range jumps

; === DATA ===

Credits DB 13,10,"                                    Critical "
        DB 13,10,"                             Intro by Vulture / Cri ",13,10
        DB 13,10,"                 Forgotten Existence    WHQ    +31 (0)2208-99473"
        DB 13,10,"                 Edge of Honor          EHQ    +31 (0)2159-37816"
        DB 13,10,"                 Datura              Distro    +31 (0)77-872195"
        DB 13,10,"                 Cyberia             Distro    +31 (0)71-790411"
        DB 13,10,"                 Napalm Assault      Distro    +31 (0)10-4566030"
        DB 13,10,"                 Death Magic         Distro    +31 (0)78-133079"
        DB 13,10,"                 Blue Thunder        Distro    +31 (0)36-5346967",13,10,"$"

INCLUDE Palette.dat
INCLUDE Picture.dat          ; First picture & palette data
INCLUDE Palette2.dat
INCLUDE Picture2.dat         ; Second picture & palette data

Parray  DB   768*2 DUP (?)   ; Array to hold 2 entire palettes

; === CODE ===

SetVGA PROC NEAR             ; Get into VGA mode
    mov     ax,0013h         ; Set the videomode 320*200*256
    int     10h              ; Call VID interrupt
    ret                      ; Return to main program
SetVGA ENDP

SetText PROC NEAR            ; Get into char mode
    mov     ax,0003h         ; Set 80x25x16 char mode
    int     10h              ; Call VID interrupt
    ret                      ; Return to main program
SetText ENDP

WaitVrt PROC NEAR            ; Waits for vertical retrace to reduce "snow"
    mov     dx,3dah
Vrt:
    in      al,dx
    test    al,8
    jnz     VRT              ; Wait until Verticle Retrace starts
NoVrt:
    in      al,dx
    test    al,8
    jz      NoVRT            ; Wait until Verticle Retrace ends
    ret                      ; Return to main program
WaitVrt ENDP

TestEsc PROC NEAR
LoopEsc:
    in      al,60h
    cmp     al,1
    jne     LoopEsc
    ret
TestEsc ENDP

SavePalette PROC NEAR        ; Save entire palette into an array
    cli                      ; Clear interrupts
    lea     bp,Parray        ; bp points to offset Palette array
    mov     dx,03c7h         ; Read register
    xor     al,al            ; Set al to 0 (start reading at color 0)
    out     dx,al            ; Give info to VGA
    mov     dx,03c9h         ; Data register
    mov     cx,768           ; Save all colors (256*3)
Saving:
    in      al,dx            ; Get what's in the register (read)
    and     al,00111111b     ; Mask of the upper 2 bits (value=0..63)
    mov     byte ptr [bp],al ; Save value into array
    mov     byte ptr [bp+768],al  ; And save into second layer of array
    inc     bp               ; Point to next cel in aray
    loop    Saving           ; And loop while cx > 0
    sti                      ; Enable interrupts again
    ret
SavePalette ENDP

FadeOut PROC NEAR            ; Fades the screen to white (63,63,63)
    cli                      ; Disable interrupts
    lea     bp,Parray        ; Load offset Palette array
    mov     cx,64            ; Set loopcounter
Loop64:
    xor     bx,bx            ; Set bx to 0
Loop768:
    cmp     byte ptr [bp],63 ; Is it 63 already?
    je      FadeOn
    inc     byte ptr [bp]    ; Increase the value with 1
FadeOn:
    inc     bp               ; Point to next cel in array
    inc     bx               ; Increase loopcounter
    cmp     bx,768           ; Done all registers?
    jl      Loop768          ; If not, loop again
    push    cx               ; Save first loopcounter
    mov     cx,768           ; Write all new R,G,B values
    call    WaitVrt          ; Wait for a vertical retrace
    call    WaitVrt          ; Twice
    sub     bp,768           ; Reset bp to 0
    mov     dx,03c8h         ; Write register
    mov     al,0             ; Start writing at color 0
    out     dx,al            ; Give info to VGA
    mov     dx,03c9h         ; Data register
WriteAll:
    mov     al,byte ptr [bp] ; Get the value
    out     dx,al            ; Write to VGA
    inc     bp               ; Point to next cel
    loop    WriteAll         ; Loop while cx > 0
    sub     bp,768           ; Point to start array again
    pop     cx               ; Restore loopcounter from stack
    loop    Loop64           ; Have we done enough?
    sti                      ; Enable interrupts
    ret                      ; Return to main program
FadeOut ENDP

FadeIn PROC NEAR             ; Fades screen to desired colors
    cli                      ; Disable interrupts
    lea     bp,Parray        ; Load offset Palette array
    mov     cx,64            ; Set loopcounter
Loop64X:
    xor     bx,bx            ; Reset bx to 0
Loop768X:
    mov     dl,byte ptr [bp]        ; Fade-up value in dl
    mov     dh,byte ptr [bp+768]    ; Store original value in dh
    cmp     dl,dh                   ; Compare them
    je      NextOne                 ; If they are equal then do the next one
    dec     byte ptr [bp]           ; Else decrease with 1 (first layer)
NextOne:
    inc     bp               ; Point to next arraycel
    inc     bx               ; Increase counter
    cmp     bx,768           ; Have we done all registers?
    jl      Loop768X
    push    cx               ; Save first loopcounter
    mov     cx,768           ; Do all R,G,B values
    call    WaitVrt          ; Wait for a vertical retrace
    call    WaitVrt          ; Twice
    sub     bp,768           ; Point to palette to fade (first one)
    mov     dx,03c8h         ; Write register
    xor     al,al            ; Start writing at color 0
    out     dx,al            ; Give info to VGA
    mov     dx,03c9h         ; Data register
WritemAll:
    mov     al,byte ptr [bp] ; Get the value (bp points to first palette)
    out     dx,al            ; Write to VGA
    inc     bp               ; Point to next cel
    loop    WritemAll        ; Loop while cx > 0
    sub     bp,768           ; Point to start palette again
    pop     cx               ; Restore loopcounter from stack
    loop    Loop64X          ; Have we done enough?
    sti                      ; Enable interrupts
    ret                      ; Return to main program
FadeIn ENDP

DrawBitMap PROC NEAR         ; Needed: ax = x-size     cx = y-size
DrawPic:
    push    cx
    mov     cx,ax
    rep     movsb
    add     di,320           ; vga=vga+320
    sub     di,ax            ; vga=vga-xsize
    pop     cx
    loop    DrawPic
    ret
DrawBitMap ENDP

START:

    call    SetVGA

    mov     ax,cs
    mov     ds,ax                ; ds points to cs
    mov     ax,0a000h
    mov     es,ax                ; es points to vga

; === Set and save palette ===
    lea     si,[Palette]         ; Load palette
    mov     dx,3c8h
    mov     al,0
    out     dx,al
    mov     dx,3c9h
    mov     cx,256*3
    rep     outsb
    call    SavePalette

; === Draw first picture ===
    lea     si,Picture          ; Draw picture
    mov     di,320*50+138
    mov     ax,44               ; X-size
    mov     cx,45               ; Y-size
    call    DrawBitMap
    call    TestEsc             ; Test for escape

    call    FadeOut             ; Fade to white

; === Erase the screen ===
    mov     al,0
    mov     cx,320*200
    xor     di,di
    rep     stosb               ; Erase screen

; === Draw second picture ===
    lea     si,Picture2         ; Draw picture
    mov     di,320*51+120
    mov     ax,82               ; X-size
    mov     cx,43               ; Y-size
    call    DrawBitMap

    call    FadeIn

    call    TestEsc

    call    SetText
    mov     ax,cs
    mov     ds,ax               ; ds points to cs (data)
    lea     dx,Credits          ; ds:dx points to string
    mov     ah,9                ; Put function 9 in AH
    int     21h                 ; Print string using DS:DX FAR-pointer
    mov     ax,4c00h            ; Return control to DOS
    int     21h                 ; Call DOS interrupt

END START                       ; End of C<><>L program