
class GreetsEffect : public demo::Effect
{
public:
  GreetsEffect(demo::EffectType& type, const String& name);
  bool init(void);
private:
  struct Entry
  {
    String text;
    Ref<GL::Texture> texture;
    Ref<render::Style> style;
    render::MeshNode* mesh;
    render::SpriteNode* sprite;
  };
  typedef std::vector<Entry*> EntryList;
  void update(Time deltaTime);
  void prepare(void) const;
  void render(void) const;
  bool outside;
  Ptr<Glow> glow;
  Ref<render::Mesh> ball;
  render::Scene scene;
  render::Camera camera;
  render::CameraNode* cameraNode;
  StarsNode* starsNode;
  BezierTrack3 motionTrack;
  BezierTrack3 targetTrack;
  EntryList entries;
};

