
#include <wendy/Wendy.h>

using namespace moira;
using namespace wendy;

#include "Stars.h"

void Stars::enqueue(render::Queue& queue, const Transform3& transform) const
{
  render::Queue local(queue.getCamera());
  sprites.enqueue(local, transform);

  const render::OperationList& operations = local.getOperations();

  for (render::OperationList::const_iterator i = operations.begin();  i != operations.end();  i++)
  {
    render::Operation operation = **i;
    operation.distance = bounds.radius;
    queue.createOperation() = operation;
  }
}

const Sphere& Stars::getBounds(void) const
{
  return bounds;
}

Stars* Stars::createInstance(float radius)
{
  Ptr<Stars> stars = new Stars();
  if (!stars->init(radius))
    return NULL;

  return stars.detachObject();
}

Stars::Stars(void)
{
}

bool Stars::init(float radius)
{
  sprites.style = render::Style::readInstance("stars");
  if (!sprites.style)
    return false;

  RandomRange range(0.2f, 2.f);
  RandomVolume volume(Vector3(-1.f, -1.f, -1.f), Vector3(1.f, 1.f, 1.f));

  sprites.slots.resize(400);
  sprites.type = render::SPHERICAL_SPRITE;

  for (unsigned int i = 0;  i < sprites.slots.size();  i++)
  {
    Vector3 position = volume.generate();
    position.scaleTo(radius);

    const float size = range.generate();

    sprites.slots[i].position = position;
    sprites.slots[i].size.set(size, size);
    sprites.slots[i].angle = 0.f;
  }

  bounds.set(Vector3::ZERO, radius);
  return true;
}

void StarsNode::setStars(Stars* newStars)
{
  stars = newStars;
  
  if (stars)
    setLocalBounds(stars->getBounds());
  else
    setLocalBounds(Sphere(Vector3::ZERO, 0.f));
}

void StarsNode::enqueue(render::Queue& queue, render::QueuePhase phase) const
{
  if (phase == render::COLLECT_GEOMETRY)
    stars->enqueue(queue, getWorldTransform());

  render::SceneNode::enqueue(queue, phase);
}

