///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////
#ifndef MOIRA_TRANSFORM_H
#define MOIRA_TRANSFORM_H
///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

class Matrix3;
class Matrix4;

///////////////////////////////////////////////////////////////////////

class Transform2
{
public:
  Transform2(void);
  Transform2(const Vector2& position, float angle);
  void invert(void);
  void concatenate(const Transform2& parent);
  void rotateVector(Vector2& vector) const;
  void translateVector(Vector2& vector) const;
  void transformVector(Vector2& vector) const;
  operator Matrix3 (void) const;
  Transform2 operator * (const Transform2& parent) const;
  Transform2& operator *= (const Transform2& parent);
  void setIdentity(void);
  void set(const Vector2& newPosition, float newAngle);
  Vector2 position;
  float angle;
};

///////////////////////////////////////////////////////////////////////

class Transform3
{
public:
  Transform3(void);
  Transform3(const Vector3& position, const Quaternion& rotation);
  void invert(void);
  void concatenate(const Transform3& parent);
  void rotateVector(Vector3& vector) const;
  void translateVector(Vector3& vector) const;
  void transformVector(Vector3& vector) const;
  operator Matrix4 (void) const;
  Transform3 operator * (const Transform3& parent) const;
  Transform3& operator *= (const Transform3& parent);
  void setIdentity(void);
  void set(const Vector3& newPosition, const Quaternion& newRotation);
  Vector3 position;
  Quaternion rotation;
};

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
#endif /*MOIRA_TRANSFORM_H*/
///////////////////////////////////////////////////////////////////////
