///////////////////////////////////////////////////////////////////////
// Moira library
// Copyright (c) 2005 Camilla Berglund <elmindreda@elmindreda.org>
//
// This software is provided 'as-is', without any express or implied
// warranty. In no event will the authors be held liable for any
// damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any
// purpose, including commercial applications, and to alter it and
// redistribute it freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you
//     must not claim that you wrote the original software. If you use
//     this software in a product, an acknowledgment in the product
//     documentation would be appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and
//     must not be misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//     distribution.
//
///////////////////////////////////////////////////////////////////////

#include <moira/Config.h>
#include <moira/Vector.h>
#include <moira/Matrix.h>
#include <moira/Quaternion.h>
#include <moira/Transform.h>
#include <moira/Ray.h>

///////////////////////////////////////////////////////////////////////

namespace moira
{
  
///////////////////////////////////////////////////////////////////////

Ray3::Ray3(void)
{
}

Ray3::Ray3(const Vector3& initOrigin, const Vector3& initDirection):
  origin(initOrigin),
  direction(initDirection)
{
}

void Ray3::transformBy(const Transform3& transform)
{
  transform.transformVector(origin);
  transform.rotateVector(direction);
}

void Ray3::setDefaults(void)
{
  origin.set(0.f, 0.f, 0.f);
  direction.set(0.f, 0.f, 1.f);
}

void Ray3::set(const Vector3& newOrigin, const Vector3& newDirection)
{
  origin = newOrigin;
  direction = newDirection;
}

///////////////////////////////////////////////////////////////////////

} /*namespace moira*/

///////////////////////////////////////////////////////////////////////
