/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import javax.media.opengl.GL;
import vitamin.math.Color4;
import vitamin.math.Vector3;

public class VParticle {
    private Vector3 _origin;
    public Vector3 _pos;
    public Vector3 _oldPos;
    public Vector3 _force;
    public Vector3 _vel;
    public Vector3 _accel;
    public float _friction;
    public float _startTime;
    public float _age;
    public float _timeToPuberty;
    public float _timeToLive;
    public float _timeToDie;
    public float _mass;
    public float _invMass;
    public float _speed;
    public float _radius;
    public Color4 _color;

    public VParticle() {
        this._origin = new Vector3();
        this._pos = new Vector3();
        this._oldPos = new Vector3();
        this._vel = new Vector3();
        this._accel = new Vector3();
        this._force = new Vector3(0.0f, 0.0f, 0.0f);
        this._age = 0.0f;
        this._timeToPuberty = (float)(Math.random() * 10.0);
        this._timeToLive = this._timeToPuberty + (float)(Math.random() * 10.0);
        this._timeToDie = this._timeToLive + (float)(Math.random() * 10.0);
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
        this._color = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public VParticle(Vector3 pos, Vector3 vel, Vector3 accel) {
        this._origin = pos.copy();
        this._pos = pos;
        this._oldPos = pos;
        this._vel = vel;
        this._accel = accel;
        this._force = new Vector3(0.0f, 0.0f, 0.0f);
        this._startTime = 0.0f;
        this._age = 0.0f;
        this._timeToPuberty = (float)(Math.random() * 10.0);
        this._timeToLive = this._timeToPuberty + (float)(Math.random() * 10.0);
        this._timeToDie = this._timeToLive + (float)(Math.random() * 10.0);
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
        this._color = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public VParticle(Vector3 pos, Vector3 vel, Vector3 accel, float age) {
        this._origin = pos.copy();
        this._pos = pos;
        this._oldPos = pos;
        this._vel = vel;
        this._accel = accel;
        this._force = new Vector3(0.0f, 0.0f, 0.0f);
        this._startTime = 0.0f;
        this._age = age;
        this._timeToPuberty = (float)(Math.random() * 10.0);
        this._timeToLive = this._timeToPuberty + (float)(Math.random() * 10.0);
        this._timeToDie = this._timeToLive + (float)(Math.random() * 10.0);
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
        this._color = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public VParticle(Vector3 pos, Vector3 vel, Vector3 accel, Vector3 force, float starttime, float age, float puberty, float live, float die) {
        this._origin = pos.copy();
        this._pos = pos;
        this._oldPos = pos;
        this._vel = vel;
        this._accel = accel;
        this._force = force;
        this._startTime = starttime;
        this._age = age;
        this._timeToPuberty = puberty;
        this._timeToLive = live;
        this._timeToDie = die;
        this._friction = 0.95f;
        this._mass = 1.0f;
        this._invMass = 1.0f / this._mass;
        this._speed = 0.0f;
        this._color = new Color4(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void position(Vector3 p) {
        this._pos = p;
    }

    public void setPosition(Vector3 p) {
        this._pos = p;
    }

    public void setPosition(float x, float y, float z) {
        this._pos.set(x, y, z);
    }

    public void addPosition(Vector3 f) {
        this._pos.add(f);
    }

    public void addPosition(float x, float y, float z) {
        this._pos.add(x, y, z);
    }

    public void velocity(Vector3 v) {
        this._accel = v;
    }

    public void setVelocity(Vector3 v) {
        this._vel = v;
    }

    public void setVelocity(float x, float y, float z) {
        this._vel.set(x, y, z);
    }

    public void accel(Vector3 a) {
        this._accel = a;
    }

    public void setAcceleration(Vector3 a) {
        this._accel = a;
    }

    public void setAcceleration(float x, float y, float z) {
        this._accel.set(x, y, z);
    }

    public void setAge(float starttime, float age, float puberty, float live, float die) {
        this._startTime = starttime;
        this._age = age;
        this._timeToPuberty = puberty;
        this._timeToLive = live;
        this._timeToDie = die;
    }

    public void setAge(float age) {
        this._age = age;
    }

    public void setAge(float age, float starttime) {
        this._age = age;
        this._startTime = starttime;
    }

    public void setAgePuberty(float age) {
        this._timeToPuberty = age;
    }

    public void setAgeLive(float age) {
        this._timeToLive = age;
    }

    public void setAgeDie(float age) {
        this._timeToDie = age;
    }

    public void applyForce(Vector3 f) {
        this._force = f;
    }

    public void applyForce(float x, float y, float z) {
        this._force.set(x, y, z);
    }

    public void setFriction(float f) {
        this._friction = f;
    }

    public void setMass(float m) {
        this._mass = m;
        this._invMass = 1.0f / m;
    }

    public Vector3 getOrigin() {
        return this._origin;
    }

    public float getStartTime() {
        return this._startTime;
    }

    public float getAge() {
        return this._age;
    }

    public float getAgePuberty() {
        return this._timeToPuberty;
    }

    public float getAgeLive() {
        return this._timeToLive;
    }

    public float getAgeDie() {
        return this._timeToDie;
    }

    public float getMass() {
        return this._mass;
    }

    public float getInvMass() {
        return this._invMass;
    }

    public float getSpeed() {
        return this._speed;
    }

    public void reset() {
        this._age = 0.0f;
        this._pos.reset();
        this._oldPos.reset();
        this._vel.reset();
        this._accel.reset();
        this._force.reset();
    }

    public boolean isPastPuberty() {
        return !(this._age <= this._timeToPuberty);
    }

    public boolean isPastLive() {
        return !(this._age <= this._timeToLive);
    }

    public boolean isDead() {
        return !(this._age <= this._timeToDie);
    }

    public void update(float dt) {
        this._oldPos = this._pos.copy();
        this._accel = Vector3.mul(this._force, this._invMass);
        this._vel.add(Vector3.mul(this._accel, dt));
        this._pos.add(Vector3.mul(this._vel, dt));
        this._vel.mul(this._friction);
        this._speed = this._vel.length();
        this._age = (float)((double)this._age + 0.03333333333333333);
    }

    public void renderPoint(GL gl) {
        gl.glBegin(0);
        gl.glColor4f(this._color.r, this._color.g, this._color.b, this._color.a);
        gl.glVertex3f(this._pos.x, this._pos.y, this._pos.z);
        gl.glEnd();
    }

    public void renderQuad(GL gl, float s) {
        gl.glBegin(7);
        gl.glColor4f(this._color.r, this._color.g, this._color.b, this._color.a);
        gl.glTexCoord2f(0.0f, 0.0f);
        gl.glVertex3f(this._pos.x + -1.0f * s, this._pos.y + 1.0f * s, this._pos.z);
        gl.glTexCoord2f(1.0f, 0.0f);
        gl.glVertex3f(this._pos.x + 1.0f * s, this._pos.y + 1.0f * s, this._pos.z);
        gl.glTexCoord2f(1.0f, 1.0f);
        gl.glVertex3f(this._pos.x + 1.0f * s, this._pos.y + -1.0f * s, this._pos.z);
        gl.glTexCoord2f(0.0f, 1.0f);
        gl.glVertex3f(this._pos.x + -1.0f * s, this._pos.y + -1.0f * s, this._pos.z);
        gl.glEnd();
    }
}

