/*
 * Decompiled with CFR 0.152.
 */
package codeanticode.glgraphics;

import processing.xml.XMLElement;

public class GLTexturedPoint {
    public float x;
    public float y;
    public float dx;
    public float dy;
    public float[] s;
    public float[] t;
    public float[] ds;
    public float[] dt;
    public int ntex;

    public GLTexturedPoint() {
        this.y = 0.0f;
        this.x = 0.0f;
        this.initTexCoordArrays(1);
    }

    public GLTexturedPoint(XMLElement xMLElement) {
        this.y = 0.0f;
        this.x = 0.0f;
        int n = xMLElement.getChildCount();
        if (n <= 1) {
            this.initTexCoordArrays(1);
        } else {
            this.initTexCoordArrays(n - 1);
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            String string3;
            String string4;
            XMLElement xMLElement2 = xMLElement.getChild(i);
            String string5 = xMLElement2.getName();
            if (string5.equals("coord")) {
                string4 = xMLElement2.getStringAttribute("x");
                string3 = xMLElement2.getStringAttribute("y");
                string2 = xMLElement2.getStringAttribute("dx");
                string = xMLElement2.getStringAttribute("dy");
                this.x = string4.equals("x") ? -1.0f : xMLElement2.getFloatAttribute("x");
                this.y = string3.equals("y") ? -1.0f : xMLElement2.getFloatAttribute("y");
                this.dx = string2 == null ? 0.0f : (string2.equals("dx") ? -1.0f : xMLElement2.getFloatAttribute("dx"));
                if (string == null) {
                    this.dy = 0.0f;
                    continue;
                }
                if (string.equals("dy")) {
                    this.dy = -1.0f;
                    continue;
                }
                this.dy = xMLElement2.getFloatAttribute("dy");
                continue;
            }
            if (!string5.equals("texcoord")) continue;
            string4 = xMLElement2.getStringAttribute("s");
            string3 = xMLElement2.getStringAttribute("t");
            string2 = xMLElement2.getStringAttribute("ds");
            string = xMLElement2.getStringAttribute("dt");
            float f = string4.equals("s") ? -1.0f : xMLElement2.getFloatAttribute("s");
            float f2 = string3.equals("t") ? -1.0f : xMLElement2.getFloatAttribute("t");
            float f3 = string2 == null ? 0.0f : (string2.equals("ds") ? -1.0f : xMLElement2.getFloatAttribute("ds"));
            float f4 = string == null ? 0.0f : (string.equals("dt") ? -1.0f : xMLElement2.getFloatAttribute("dt"));
            this.setTexCoords(n2, f, f2);
            this.setTexCoordsDelta(n2, f3, f4);
            ++n2;
        }
    }

    public GLTexturedPoint(int n) {
        this.y = 0.0f;
        this.x = 0.0f;
        this.initTexCoordArrays(n);
    }

    public GLTexturedPoint(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.initTexCoordArrays(1);
        this.s[0] = f3;
        this.t[0] = f4;
    }

    public void setTexCoords(int n, float f, float f2) {
        if (n < this.ntex) {
            this.s[n] = f;
            this.t[n] = f2;
        }
    }

    public void setTexCoordsDelta(int n, float f, float f2) {
        if (n < this.ntex) {
            this.ds[n] = f;
            this.dt[n] = f2;
        }
    }

    public void setAsUndefined() {
        this.y = -1.0f;
        this.x = -1.0f;
        this.dy = -1.0f;
        this.dx = -1.0f;
        for (int i = 0; i < this.ntex; ++i) {
            this.t[i] = -1.0f;
            this.s[i] = -1.0f;
            this.dt[i] = -1.0f;
            this.ds[i] = -1.0f;
        }
    }

    public void scaleCoords(int n, int n2) {
        this.x *= (float)n;
        this.y *= (float)n2;
    }

    public void genTexCoords(int n, int n2) {
        for (int i = 0; i < this.ntex; ++i) {
            this.s[i] = this.x / (float)n;
            this.t[i] = this.y / (float)n2;
            this.ds[i] = 1.0f / (float)n;
            this.dt[i] = 1.0f / (float)n2;
        }
    }

    public void initTexCoordArrays(int n) {
        this.ntex = n;
        this.s = new float[this.ntex];
        this.t = new float[this.ntex];
        this.ds = new float[this.ntex];
        this.dt = new float[this.ntex];
        for (int i = 0; i < this.ntex; ++i) {
            this.t[i] = 0.0f;
            this.s[i] = 0.0f;
            this.dt[i] = 0.0f;
            this.ds[i] = 0.0f;
        }
    }
}

