/*
 * Decompiled with CFR 0.152.
 */
package entities.units;

import entities.Entity;
import entities.projectiles.Laser;
import entities.projectiles.Projectile;
import entities.units.UnitType;
import entities.units.unitOrders.UnitAttackOrder;
import entities.units.unitOrders.UnitBeingBuiltOrder;
import entities.units.unitOrders.UnitBuilderBuildOrder;
import entities.units.unitOrders.UnitFactoryBuildOrder;
import entities.units.unitOrders.UnitHelpBuildOrder;
import entities.units.unitOrders.UnitMoveOrder;
import entities.units.unitOrders.UnitMoveOutFromFactoryOrder;
import entities.units.unitOrders.UnitOrder;
import fonts.Fonts;
import game.B23Client;
import game.Game;
import game.Settings;
import game.Sprite3D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import maps.B23Map;
import utils.Rect;
import utils.Vec2;

public abstract class Unit
extends Entity {
    public int myPlayerID;
    public int unitID;
    Game game;
    LinkedList<UnitOrder> orders = new LinkedList();
    protected Unit automaticTarget;
    protected boolean hasTriedFire;
    protected boolean[][][] sprite;
    protected boolean artStanding = true;
    protected double rot;
    protected double rotationOffset;
    protected double turretRotation;
    boolean canBuild = false;
    boolean factoryBuilder = false;
    int buildSpeed = 0;
    double buildRange = 0.0;
    public UnitType[] builds;
    boolean canAttack = false;
    double attackRange = 0.0;
    int reloadTime = 0;
    protected double health = 100.0;
    protected double maxHealth;
    double speed = 0.0;
    protected boolean canMove = false;
    protected boolean canMoveLand = false;
    protected boolean canMoveWater = false;
    protected int resourceMake = 0;
    protected boolean extractor = false;
    int reloadTimeCounter = this.reloadTime;
    protected boolean hasExploded = false;
    protected double previousRot;
    protected double previousTurretRot;
    protected int spriteCacheSize = 100;
    protected BufferedImage spriteCache = new BufferedImage(this.spriteCacheSize, this.spriteCacheSize, 2);
    protected long lastNotEnoughResourcesTime;

    public Unit(Game game, Vec2 pos, int myPlayerID, int unitID, UnitOrder[] startOrders) {
        this.pos = pos;
        this.myPlayerID = myPlayerID;
        this.unitID = unitID;
        this.game = game;
        this.size = 50;
        if (startOrders != null) {
            int i = 0;
            while (i < startOrders.length) {
                this.orders.addLast(startOrders[i]);
                ++i;
            }
        }
    }

    protected void initHealth(int health) {
        this.maxHealth = health;
        this.health = health;
    }

    public void simulate() {
        this.hasTriedFire = false;
        this.turretRotation = this.rot + Math.toRadians(90.0);
        this.game.map.removeUnit(this);
        UnitOrder uo = this.getCurrentOrder();
        if (uo != null) {
            if (uo instanceof UnitMoveOrder) {
                this.simulateOrder((UnitMoveOrder)uo);
            } else if (uo instanceof UnitAttackOrder) {
                this.simulateOrder((UnitAttackOrder)uo);
            } else if (uo instanceof UnitFactoryBuildOrder) {
                this.simulateOrder((UnitFactoryBuildOrder)uo);
            } else if (uo instanceof UnitMoveOutFromFactoryOrder) {
                this.simulateOrder((UnitMoveOutFromFactoryOrder)uo);
            } else if (uo instanceof UnitBeingBuiltOrder) {
                this.simulateOrder((UnitBeingBuiltOrder)uo);
            } else if (uo instanceof UnitBuilderBuildOrder) {
                this.simulateOrder((UnitBuilderBuildOrder)uo);
            } else if (uo instanceof UnitHelpBuildOrder) {
                this.simulateOrder((UnitHelpBuildOrder)uo);
            } else {
                System.err.println("unkonw unit order: " + uo);
            }
        }
        if (this.canAttack) {
            this.simulateAutomaticTarget();
        }
        this.game.map.addUnit(this);
    }

    private void simulateAutomaticTarget() {
        if (this.hasTriedFire || !this.isFinishedBuilt()) {
            return;
        }
        if (this.automaticTarget != null && this.automaticTarget.isDead()) {
            this.automaticTarget = null;
        }
        if (this.automaticTarget != null && this.disTo(this.automaticTarget) <= this.attackRange) {
            this.tryFire(this.automaticTarget);
        } else {
            this.automaticTarget = null;
            ArrayList<Unit> units = this.game.getUnits();
            int i = 0;
            while (i < units.size()) {
                Unit u = units.get(i);
                if (u.myPlayerID != this.myPlayerID && this.disTo(u) <= this.attackRange) {
                    this.automaticTarget = u;
                    break;
                }
                ++i;
            }
        }
    }

    private void simulateOrder(UnitHelpBuildOrder uhbo) {
        if (!this.canBuild || this.factoryBuilder) {
            this.nextOrder();
            return;
        }
        if (uhbo.target.isFinishedBuilt() || uhbo.target.isDead()) {
            this.nextOrder();
        } else if (uhbo.target.pos.disTo(this.pos) <= this.buildRange) {
            uhbo.target.takeBuild(this.buildSpeed);
            this.game.effectHandler.newBuildSpray(this, uhbo.target);
        } else {
            this.moveTo(uhbo.target.pos);
        }
    }

    private void simulateOrder(UnitBuilderBuildOrder ubbo) {
        if (!this.canBuild) {
            this.nextOrder();
            return;
        }
        if (ubbo.pos.disTo(this.pos) <= this.buildRange) {
            if (ubbo.buildTarget == null) {
                UnitType type = this.builds[ubbo.buildListPos];
                int cost = UnitType.getBuildCost(type);
                if (cost > this.game.findPlayer((int)this.myPlayerID).resources) {
                    if (System.currentTimeMillis() - this.lastNotEnoughResourcesTime > 3000L) {
                        this.lastNotEnoughResourcesTime = System.currentTimeMillis();
                        this.game.effectHandler.newNotEnoughResourcesEffect((int)this.pos.x, (int)this.pos.y);
                    }
                } else {
                    Unit buildUnit;
                    this.game.findPlayer((int)this.myPlayerID).resources -= cost;
                    ubbo.buildTarget = buildUnit = UnitType.newUnit(type, this.game, ubbo.pos, this.myPlayerID, this.game.nextUnitID(), new UnitOrder[]{new UnitBeingBuiltOrder(UnitType.getBuildTime(type), this.factoryBuilder)});
                    this.game.addUnit(buildUnit);
                }
            } else if (ubbo.buildTarget.isFinishedBuilt() || ubbo.buildTarget.isDead()) {
                this.nextOrder();
            } else {
                this.game.effectHandler.newBuildSpray(this, ubbo.buildTarget);
                ubbo.buildTarget.takeBuild(this.buildSpeed);
            }
        } else {
            this.moveTo(ubbo.pos);
        }
    }

    private void simulateOrder(UnitBeingBuiltOrder uo) {
        if (uo.factory) {
            this.rot = -Math.toRadians(90.0);
            this.turretRotation = Math.toRadians(180.0);
        }
        if (uo.buildTimeLeft <= 0) {
            this.nextOrder();
        }
        if (uo.buildTimeLeft > uo.buildTime) {
            this.shallBeRemoved = true;
        }
        --uo.lastBuildCounter;
        if (uo.lastBuildCounter < 0) {
            ++uo.buildTimeLeft;
        }
    }

    private void simulateOrder(UnitFactoryBuildOrder ufbo) {
        if (!this.canBuild || !this.factoryBuilder) {
            this.nextOrder();
            return;
        }
        if (ufbo.current == null) {
            if (!this.unitCollides()) {
                int buildIndex = ufbo.peekUnit();
                if (buildIndex == -1) {
                    return;
                }
                UnitType type = this.builds[buildIndex];
                int cost = UnitType.getBuildCost(type);
                if (cost > this.game.findPlayer((int)this.myPlayerID).resources) {
                    if (System.currentTimeMillis() - this.lastNotEnoughResourcesTime > 3000L) {
                        this.lastNotEnoughResourcesTime = System.currentTimeMillis();
                        this.game.effectHandler.newNotEnoughResourcesEffect((int)this.pos.x, (int)this.pos.y);
                    }
                } else {
                    Unit buildUnit;
                    ufbo.popUnit();
                    this.game.findPlayer((int)this.myPlayerID).resources -= cost;
                    UnitOrder[] subOrders = ufbo.cloneSubOrders();
                    UnitOrder[] unitOrders = new UnitOrder[2 + subOrders.length];
                    unitOrders[0] = new UnitBeingBuiltOrder(UnitType.getBuildTime(type), this.factoryBuilder);
                    unitOrders[1] = new UnitMoveOutFromFactoryOrder(this, this.pos.translateClone(0.0, (double)this.size * 0.5 + (double)UnitType.getSize(type) * 0.5 + 0.1));
                    int i = 0;
                    while (i < subOrders.length) {
                        unitOrders[2 + i] = subOrders[i];
                        ++i;
                    }
                    ufbo.current = buildUnit = UnitType.newUnit(type, this.game, this.pos.clone(), this.myPlayerID, this.game.nextUnitID(), unitOrders);
                    this.game.addUnit(buildUnit);
                }
            }
        } else if (ufbo.current.isFinishedBuilt()) {
            ufbo.current = null;
        } else {
            ufbo.current.takeBuild(this.buildSpeed);
            this.game.effectHandler.newBuildSpray(this, ufbo.current);
        }
    }

    private void simulateOrder(UnitMoveOutFromFactoryOrder uo) {
        if (!this.canMove) {
            this.nextOrder();
            return;
        }
        if (uo.moveTo.disTo(this.pos) < 1.0) {
            this.nextOrder();
        } else {
            this.moveToNoCollisionOn(uo.moveTo, uo.factory);
        }
    }

    private void takeBuild(int buildAmount) {
        if (this.getCurrentOrder() instanceof UnitBeingBuiltOrder) {
            UnitBeingBuiltOrder ubbo = (UnitBeingBuiltOrder)this.getCurrentOrder();
            ubbo.buildTimeLeft -= buildAmount;
            ubbo.lastBuildCounter = 2;
        }
    }

    public boolean isFinishedBuilt() {
        if (this.getCurrentOrder() instanceof UnitBeingBuiltOrder) {
            UnitBeingBuiltOrder ubbo = (UnitBeingBuiltOrder)this.getCurrentOrder();
            return ubbo.buildTimeLeft <= 0;
        }
        return true;
    }

    private void simulateOrder(UnitMoveOrder mo) {
        if (!this.canMove) {
            this.nextOrder();
            return;
        }
        if (mo.moveTo.disTo(this.pos) < 1.0) {
            this.nextOrder();
        } else {
            this.moveTo(mo.moveTo);
        }
    }

    private void simulateOrder(UnitAttackOrder ao) {
        if (!this.canAttack || ao == null || ao.target == null) {
            this.nextOrder();
            return;
        }
        if (ao.target.isDead()) {
            this.nextOrder();
        } else if (this.disTo(ao.target) <= this.attackRange) {
            this.tryFire(ao.target);
        } else {
            this.moveTo(ao.target.pos);
        }
    }

    private boolean isDead() {
        return this.health <= 0.0;
    }

    private void tryFire(Unit target) {
        this.hasTriedFire = true;
        --this.reloadTimeCounter;
        this.turretRotation = Game.angleFromTo(this.pos, target.pos) + Math.toRadians(90.0);
        if (this.reloadTimeCounter <= 0) {
            this.reloadTimeCounter = this.reloadTime;
            this.game.addProjectile(this.newProjectile(target));
        }
    }

    protected Projectile newProjectile(Unit target) {
        System.out.println("default newProjectile used");
        return new Laser(this.myPlayerID, this.unitID, this.pos.clone(), target.pos.clone(), this.game, Laser.LaserType.ORANGE);
    }

    private double disTo(Unit unit) {
        return this.pos.disTo(unit.pos);
    }

    private void moveTo(Vec2 target) {
        if (this.pos.disTo(target) < this.speed) {
            Vec2 oldPos = this.pos.clone();
            this.pos = target.clone();
            if (this.mapCollides() || this.unitCollides()) {
                this.pos = oldPos;
            }
        } else {
            double angle;
            Vec2 oldPos = this.pos.clone();
            this.rot = angle = Game.angleFromTo(this.pos, target);
            this.pos.x += Math.cos(angle) * this.speed;
            this.pos.y += Math.sin(angle) * this.speed;
            if (this.mapCollides() || this.unitCollides()) {
                this.pos = oldPos;
                oldPos = this.pos.clone();
                this.pos.x += Math.signum(Math.cos(angle)) * this.speed;
                if (this.mapCollides() || this.unitCollides()) {
                    this.pos = oldPos;
                    oldPos = this.pos.clone();
                }
                this.pos.y += Math.signum(Math.sin(angle)) * this.speed;
                if (this.mapCollides() || this.unitCollides()) {
                    this.pos = oldPos;
                }
            }
        }
    }

    private void moveToNoCollisionOn(Vec2 target, Unit noCollisionUnit) {
        if (this.pos.disTo(target) < this.speed) {
            Vec2 oldPos = this.pos.clone();
            this.pos = target.clone();
            if (this.mapCollides() || this.unitCollidesExcept(noCollisionUnit)) {
                this.pos = oldPos;
            }
        } else {
            double angle;
            Vec2 oldPos = this.pos.clone();
            this.rot = angle = Game.angleFromTo(this.pos, target);
            this.pos.x += Math.cos(angle) * this.speed;
            if (this.mapCollides() || this.unitCollidesExcept(noCollisionUnit)) {
                this.pos = oldPos;
                oldPos = this.pos.clone();
            }
            this.pos.y += Math.sin(angle) * this.speed;
            if (this.mapCollides() || this.unitCollidesExcept(noCollisionUnit)) {
                this.pos = oldPos;
            }
        }
    }

    private boolean unitCollidesExcept(Unit except) {
        ArrayList<Unit> units = this.game.map.getUnitsFromAdjecentTiles(this);
        int i = 0;
        while (i < units.size()) {
            if (units.get(i) != this && units.get(i) != except && this.collides(units.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean unitCollides() {
        ArrayList<Unit> units = this.game.map.getUnitsFromAdjecentTiles(this);
        int i = 0;
        while (i < units.size()) {
            if (units.get(i) != this && this.collides(units.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean mapCollides() {
        ArrayList<Vec2> corners = this.getCorners();
        corners.add(this.pos);
        for (Vec2 vec : corners) {
            B23Map.Type t = this.game.map.getType(vec);
            if (this.canPass(t)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Vec2> getCorners() {
        ArrayList<Vec2> corners = new ArrayList<Vec2>();
        corners.add(new Vec2(this.pos.x - (double)this.size / 2.0, this.pos.y));
        corners.add(new Vec2(this.pos.x, this.pos.y - (double)this.size / 2.0));
        corners.add(new Vec2(this.pos.x + (double)this.size / 2.0, this.pos.y));
        corners.add(new Vec2(this.pos.x, this.pos.y + (double)this.size / 2.0));
        return corners;
    }

    private boolean canPass(B23Map.Type t) {
        if (t == null) {
            return true;
        }
        switch (t) {
            case LAND: {
                return this.canMoveLand;
            }
            case WATER: {
                return this.canMoveWater;
            }
            case RESOURCE: {
                return this.canMoveLand;
            }
        }
        return false;
    }

    public void addOrderAndErase(UnitOrder uo) {
        if (this.getCurrentOrder() != null && this.getCurrentOrder().hasSubOrders()) {
            this.getCurrentOrder().addSubOrderAndErase(uo);
        } else if (this.getCurrentOrder() == null || this.getCurrentOrder().isCancelable()) {
            this.orders.clear();
            this.orders.add(uo);
        }
    }

    public void addOrder(UnitOrder uo) {
        if (this.getCurrentOrder() != null && this.getCurrentOrder().hasSubOrders()) {
            this.getCurrentOrder().addSubOrder(uo);
        } else {
            this.orders.add(uo);
        }
    }

    private UnitOrder getCurrentOrder() {
        if (this.orders == null || this.orders.isEmpty()) {
            return null;
        }
        return this.orders.peek();
    }

    private void nextOrder() {
        if (this.orders != null && !this.orders.isEmpty()) {
            this.orders.removeFirst();
        }
    }

    public void draw(Graphics g) {
        if (this.isSelected()) {
            g.setColor(Color.orange);
            int d = 0;
            g.drawRect((int)this.pos.x - this.size / 2 - d, (int)this.pos.y - this.size / 2 - d, this.size + d * 2, this.size + d * 2);
            Rect rect = this.getMyRect();
        }
        if (Settings.DEBUG_DRAW_COLLISION_BOX) {
            g.setColor(this.game.getPlayerColor(this.myPlayerID));
            g.drawRect((int)this.pos.x - this.size / 2, (int)this.pos.y - this.size / 2, this.size, this.size);
        }
        this.drawSprite(g);
        this.drawHealthBar(g, (int)this.pos.x, (int)(this.pos.y + (double)(this.size / 2)));
        if (this.orders != null && this.game.input.isKeyDown(this.game.input.SHIFT)) {
            this.drawOrders(g, this.orders);
            if (this.getCurrentOrder() != null && this.getCurrentOrder().hasSubOrders()) {
                this.drawOrders(g, this.getCurrentOrder().getSubOrders());
            }
        }
        if (Settings.DEBUG_DRAW_BUILDTIME && this.getCurrentOrder() instanceof UnitBeingBuiltOrder) {
            g.setColor(Color.white);
            g.drawString("" + ((UnitBeingBuiltOrder)this.getCurrentOrder()).buildTimeLeft, (int)this.pos.x, (int)this.pos.y - 20);
        }
        if (Settings.DEBUG_DRAW_RELOADTIME) {
            g.setColor(Color.white);
            g.drawString("" + this.reloadTimeCounter, (int)this.pos.x, (int)this.pos.y);
        }
        if (Settings.DEBUG_DRAW_HEALTH) {
            g.setColor(Color.white);
            g.drawString("hp: " + this.health, (int)this.pos.x, (int)this.pos.y + 20);
        }
        if (Settings.DEBUG_DRAW_CURRENT_ORDER) {
            g.setColor(Color.white);
            g.drawString("" + this.getCurrentOrder(), (int)this.pos.x, (int)this.pos.y + 40);
        }
        if (Settings.DEBUG_DRAW_UNIT_ROTATION_DEG) {
            g.setColor(Color.white);
            g.drawString("rot: " + Math.toDegrees(this.getCurrentRotRad()), (int)this.pos.x, (int)this.pos.y + 60);
        }
    }

    private void drawSprite(Graphics g) {
        if (this.rot == this.previousRot && this.turretRotation == this.previousTurretRot && !(this.getCurrentOrder() instanceof UnitBeingBuiltOrder)) {
            double hoverDelta = this.canMoveWater && this.isFinishedBuilt() ? Math.sin(6.28 * (double)(System.currentTimeMillis() % 2000L) / 2000.0) * 2.0 : 0.0;
            g.drawImage(this.spriteCache, (int)this.pos.x - this.spriteCacheSize / 2, (int)(this.pos.y - (double)(this.spriteCacheSize / 2) + hoverDelta), null);
            return;
        }
        Graphics origG = g;
        this.previousRot = this.rot;
        this.previousTurretRot = this.turretRotation;
        this.spriteCache = new BufferedImage(this.spriteCacheSize, this.spriteCacheSize, 2);
        g = this.spriteCache.getGraphics();
        g.translate(-((int)this.pos.x), -((int)this.pos.y));
        g.translate(this.spriteCacheSize / 2, this.spriteCacheSize / 2);
        if (this.artStanding) {
            if (this.isFinishedBuilt()) {
                Sprite3D.drawStanding(g, this.sprite[0], this.game.getPlayerColor(this.myPlayerID), this.pos, this.size, this.getCurrentRotRad(), true);
            } else {
                double left = ((UnitBeingBuiltOrder)this.getCurrentOrder()).buildTimeLeft;
                double tot = ((UnitBeingBuiltOrder)this.getCurrentOrder()).buildTime;
                Color col = this.game.getPlayerColor(this.myPlayerID);
                Sprite3D.drawStanding(g, this.sprite[0], col, this.pos, (double)this.size * (1.0 - left / tot), this.getCurrentRotRad(), true);
            }
        } else {
            int i = 0;
            while (i < this.sprite.length) {
                double side = (double)this.size / (double)this.sprite[i].length;
                Color color = this.game.getPlayerColor(this.myPlayerID);
                if (i == 1) {
                    color = color.darker();
                }
                double currRot = this.getCurrentRotRad();
                if (i == 1) {
                    double d = currRot = this.canAttack ? this.turretRotation : this.rot;
                }
                if (this.isFinishedBuilt()) {
                    Sprite3D.drawGround(g, this.sprite[i], color, this.pos.translateClone(0.0, (double)(-i) * side), this.size, currRot, true);
                } else {
                    double left = ((UnitBeingBuiltOrder)this.getCurrentOrder()).buildTimeLeft;
                    double tot = ((UnitBeingBuiltOrder)this.getCurrentOrder()).buildTime;
                    Color col = color;
                    Color trans = new Color(col.getRed(), col.getGreen(), col.getBlue(), (int)(128.0 * (1.0 - left / tot)));
                    Sprite3D.drawGround(g, this.sprite[i], col, this.pos.translateClone(0.0, (double)(-i) * side), (double)this.size * (1.0 - left / tot), currRot, true);
                }
                ++i;
            }
        }
        origG.drawImage(this.spriteCache, (int)this.pos.x - this.spriteCache.getWidth() / 2, (int)this.pos.y - this.spriteCache.getHeight() / 2, null);
    }

    private void drawHealthBar(Graphics g, int cx, int cy) {
        int w = 30;
        int h = 4;
        g.setColor(Color.red);
        g.fillRect(cx - w, cy - h, w * 2, h * 2);
        g.setColor(Color.green);
        g.fillRect(cx - w, cy - h, (int)((double)(w * 2) * (this.health / this.maxHealth)), h * 2);
        g.setColor(Color.black);
        g.drawRect(cx - w, cy - h, w * 2, h * 2);
    }

    private double getCurrentRotRad() {
        return this.rot + this.rotationOffset;
    }

    private void drawOrders(Graphics g, Collection<UnitOrder> drawOrders) {
        if (this.myPlayerID == this.game.myPlayerID) {
            Graphics2D g2d = (Graphics2D)g;
            Stroke origStroke = g2d.getStroke();
            int on = 20;
            int off = 20;
            int sum = on + off;
            g2d.setStroke(new BasicStroke(3.0f, 0, 2, 0.0f, new float[]{on, off}, (float)sum - (float)(System.currentTimeMillis() / 20L % (long)sum)));
            Vec2 prevPos = this.pos;
            for (UnitOrder uo : drawOrders) {
                if (!uo.isDrawable()) continue;
                g.setColor(uo.getColor());
                Vec2 newPos = uo.getPos();
                g.drawLine((int)prevPos.x, (int)prevPos.y, (int)newPos.x, (int)newPos.y);
                prevPos = newPos;
            }
            g2d.setStroke(origStroke);
        }
    }

    private boolean isSelected() {
        return this.game.isSelected(this);
    }

    public boolean canAttack() {
        return this.canAttack;
    }

    public void takeDamage(double damage) {
        this.health -= damage;
        if (this.isDead()) {
            this.tryExplode();
            this.shallBeRemoved = true;
        }
    }

    protected void tryExplode() {
        if (this.hasExploded) {
            return;
        }
        this.hasExploded = true;
        this.explode();
    }

    protected void explode() {
        this.game.effectHandler.newMediumExplosion(this.pos.clone());
    }

    public boolean canBuild() {
        return this.canBuild;
    }

    public boolean factoryBuilder() {
        return this.factoryBuilder;
    }

    public void drawBuildList(Graphics g, int buildListX, int buildListY, int size) {
        if (this.builds != null) {
            g.setColor(Color.black);
            int i = 0;
            while (i < this.builds.length) {
                BufferedImage img = UnitType.getBuildPic(this.builds[i]);
                g.drawImage(img, buildListX, buildListY + size * i, buildListX + size, buildListY + size * (i + 1), 0, 0, img.getWidth(), img.getHeight(), null);
                g.drawRect(buildListX, buildListY + size * i, size, size);
                ++i;
            }
            if (this.getCurrentOrder() instanceof UnitFactoryBuildOrder) {
                UnitFactoryBuildOrder ufb = (UnitFactoryBuildOrder)this.getCurrentOrder();
                LinkedList<int[]> buildList = ufb.factoryBuildQueue;
                int[] total = new int[this.builds.length];
                for (int[] is : buildList) {
                    int unit;
                    int amount = is[0];
                    int n = unit = is[1];
                    total[n] = total[n] + amount;
                }
                g.setFont(Fonts.c64size20);
                int i2 = 0;
                while (i2 < this.builds.length) {
                    if (total[i2] != 0) {
                        g.setColor(Color.black);
                        g.drawString("" + total[i2], buildListX + size / 3 + 3, buildListY + i2 * size + size / 2 + 3 + 10);
                        g.setColor(B23Client.GUI_GREEN);
                        g.drawString("" + total[i2], buildListX + size / 3, buildListY + i2 * size + size / 2 + 10);
                    }
                    ++i2;
                }
            }
        }
    }

    public void factoryBuildAdd(int buildListPos, int amount) {
        if (this.getCurrentOrder() instanceof UnitFactoryBuildOrder) {
            UnitFactoryBuildOrder ufbo = (UnitFactoryBuildOrder)this.getCurrentOrder();
            int[] unitAndAmount = new int[]{amount, buildListPos};
            ufbo.factoryBuildQueue.add(unitAndAmount);
        } else {
            this.addOrder(new UnitFactoryBuildOrder(buildListPos, amount));
        }
    }

    public void factoryBuildRemove(int buildListPos, int amount) {
        if (this.getCurrentOrder() instanceof UnitFactoryBuildOrder) {
            UnitFactoryBuildOrder ufbo = (UnitFactoryBuildOrder)this.getCurrentOrder();
            ufbo.remove(buildListPos, amount);
        } else {
            this.addOrder(new UnitFactoryBuildOrder(buildListPos, amount));
        }
    }

    public void finishBeforeRemove() {
        this.game.map.removeUnit(this);
    }

    public int getBuildListPosOf(UnitType type) {
        int i = 0;
        while (i < this.builds.length) {
            if (this.builds[i] == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int resourceMake() {
        UnitOrder uo = this.getCurrentOrder();
        if (uo != null && uo instanceof UnitBeingBuiltOrder) {
            return 0;
        }
        return this.resourceMake;
    }

    public Vec2 getBuildSprayOrigin() {
        return this.pos.clone();
    }

    public UnitType getBuilds(int i) {
        if (this.builds == null || this.builds.length <= i) {
            return null;
        }
        return this.builds[i];
    }
}

