/*
 * Decompiled with CFR 0.152.
 */
package game;

import fonts.Fonts;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;

public class C64Intro {
    JFrame frame;
    Message[] messages;
    int currentMessage = 0;
    boolean finished = false;
    int delayBetween;
    int delayBetweenCounter = this.delayBetween = 10;
    Color bg = new Color(49, 64, 255);
    Color txtCol = new Color(135, 140, 255);

    public C64Intro(JFrame frame) {
        this.frame = frame;
        int typed = 5;
        this.messages = new Message[]{new Message("      **** COMMODORE 64 BASIC V2 ****", 0), new Message(" 64K RAM SYSTEM 38911 BASIC BYTES FREE", 0), new Message("", 0), new Message("READY.", 0), new Message("LOAD", typed), new Message("", 0), new Message("PRESS PLAY ON TAPE", 0), new Message("OK", 0), new Message("", 0), new Message("SEARCHING", 0), new Message("FOUND AGE OF ANNIHILATION", 0), new Message("LOADING", 0), new Message("READY.", 0), new Message("", 0), new Message("RUN", typed)};
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void draw(Graphics g) {
        g.setColor(this.txtCol);
        g.fillRect(0, 0, 800, 800);
        g.setColor(this.bg);
        g.fillRect(50, 50, 700, 700);
        g.setColor(this.txtCol);
        g.setFont(Fonts.c64size20);
        int i = 0;
        while (i <= this.currentMessage && i < this.messages.length) {
            g.drawString(this.messages[i].text(), 60, 70 + i * 25);
            ++i;
        }
        if (System.currentTimeMillis() % 800L < 400L) {
            if (this.messages[i - 1].finished) {
                g.fillRect(60, 70 + i * 25 - 20, 20, 20);
            } else {
                g.fillRect(60 + this.messages[i - 1].text().length() * 20, 70 + i * 25 - 40, 20, 20);
            }
        }
    }

    public void update() {
        if (this.delayBetweenCounter > 0) {
            --this.delayBetweenCounter;
        } else if (this.currentMessage == this.messages.length) {
            this.finished = true;
        } else {
            this.messages[this.currentMessage].update();
            if (this.messages[this.currentMessage].finished) {
                ++this.currentMessage;
                this.delayBetweenCounter = this.delayBetween;
            }
        }
    }

    private class Message {
        private String text;
        int delay;
        int counter;
        int pos;
        boolean finished = false;

        public Message(String text, int delay) {
            this.text = text;
            this.delay = delay;
            this.counter = delay;
        }

        public String text() {
            return this.text.substring(0, this.pos);
        }

        public void update() {
            if (this.delay == 0) {
                this.finished = true;
                this.pos = this.text.length();
            } else {
                --this.counter;
                if (this.counter <= 0) {
                    ++this.pos;
                    this.counter = this.delay;
                    if (this.pos == this.text.length()) {
                        this.finished = true;
                    }
                }
            }
        }
    }
}

