/*
 * Decompiled with CFR 0.152.
 */
package maps;

import art.Art;
import entities.Entity;
import entities.units.Unit;
import game.Game;
import game.Hud;
import game.Settings;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import utils.Rect;
import utils.Vec2;

public abstract class B23Map {
    public static final int scale = 3;
    public static final int graphicsBlockSize = 20;
    protected int width;
    protected int height;
    protected BufferedImage mapImage;
    protected BufferedImage miniMapImage;
    private int unitsBoxSize = 100;
    protected Game game;
    protected String name;
    protected ArrayListUnit[][] unitBlocks;
    protected ArrayList<Rect> resources = new ArrayList();
    protected Type[][] mapType;

    public B23Map(BufferedImage orignalImage, Game game, String name) {
        this.game = game;
        this.name = name;
        this.width = orignalImage.getWidth() * 3;
        this.height = orignalImage.getHeight() * 3;
        this.mapImage = new BufferedImage(this.width, this.height, 1);
        Graphics g = this.mapImage.getGraphics();
        g.drawImage(orignalImage, 0, 0, this.width, this.height, 0, 0, orignalImage.getWidth(), orignalImage.getHeight(), null);
        this.mapType = new Type[this.width][this.height];
        int x = 0;
        while (x < orignalImage.getWidth()) {
            int y = 0;
            while (y < orignalImage.getHeight()) {
                Type t = this.colorToType(orignalImage.getRGB(x, y));
                if (t == Type.RESOURCE) {
                    this.resources.add(new Rect(x * 3, y * 3, 1.0, 1.0));
                }
                int x2 = 0;
                while (x2 < 3) {
                    int y2 = 0;
                    while (y2 < 3) {
                        this.mapType[x * 3 + x2][y * 3 + y2] = t;
                        ++y2;
                    }
                    ++x2;
                }
                ++y;
            }
            ++x;
        }
        Graphics mapG = this.mapImage.getGraphics();
        int x2 = 0;
        while (x2 < this.mapImage.getWidth() / 20) {
            int y = 0;
            while (y < this.mapImage.getWidth() / 20) {
                double r = Math.random();
                int x22 = 0;
                while (x22 < 20) {
                    int y2 = 0;
                    while (y2 < 20) {
                        int ix = x2 * 20 + x22;
                        int iy = y * 20 + y2;
                        if (ix < this.mapImage.getWidth() && iy < this.mapImage.getHeight()) {
                            mapG.setColor(this.distort(r, new Color(this.mapImage.getRGB(ix, iy))));
                            mapG.fillRect(ix, iy, 1, 1);
                        }
                        ++y2;
                    }
                    ++x22;
                }
                ++y;
            }
            ++x2;
        }
        this.unitBlocks = new ArrayListUnit[this.width / this.unitsBoxSize + 1][this.height / this.unitsBoxSize + 1];
        x2 = 0;
        while (x2 < this.unitBlocks.length) {
            int y = 0;
            while (y < this.unitBlocks[0].length) {
                this.unitBlocks[x2][y] = new ArrayListUnit();
                ++y;
            }
            ++x2;
        }
        this.miniMapImage = new BufferedImage(Hud.MINIMAP_SIZE, Hud.MINIMAP_SIZE, 1);
        this.miniMapImage.getGraphics().drawImage(this.mapImage, 0, 0, Hud.MINIMAP_SIZE, Hud.MINIMAP_SIZE, null);
    }

    public void addUnit(Unit u) {
        int ix = (int)(u.pos.x / (double)this.unitsBoxSize);
        int iy = (int)(u.pos.y / (double)this.unitsBoxSize);
        if (ix < 0 || iy < 0 || ix >= this.unitBlocks.length || iy >= this.unitBlocks[0].length) {
            return;
        }
        this.unitBlocks[ix][iy].list.add(u);
    }

    public void removeUnit(Unit u) {
        int ix = (int)(u.pos.x / (double)this.unitsBoxSize);
        int iy = (int)(u.pos.y / (double)this.unitsBoxSize);
        if (ix < 0 || iy < 0 || ix >= this.unitBlocks.length || iy >= this.unitBlocks[0].length) {
            return;
        }
        this.unitBlocks[ix][iy].list.remove(u);
    }

    private Color distort(double ran, Color c) {
        ran = 0.9 + ran * 0.1;
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        r = (int)((double)r * ran);
        g = (int)((double)g * ran);
        b = (int)((double)b * ran);
        return new Color(r, g, b);
    }

    protected Type colorToType(int color) {
        switch (color) {
            case -16776961: {
                return Type.WATER;
            }
            case -1237980: {
                return Type.RESOURCE;
            }
        }
        return Type.LAND;
    }

    public void draw(Graphics g) {
        if (this.mapImage != null) {
            g.drawImage(this.mapImage, 0, 0, null);
        }
        int i = 0;
        while (i < this.resources.size()) {
            g.drawImage(Art.resourceSpot, (int)(this.resources.get((int)i).x - (double)(Art.resourceSpot.getWidth() / 2)), (int)(this.resources.get((int)i).y - (double)(Art.resourceSpot.getHeight() / 2)), null);
            ++i;
        }
        if (this.game.isCurrentBuildExtractor()) {
            for (Rect r : this.resources) {
                g.setColor(Color.red);
                double p = (double)(System.currentTimeMillis() % 500L) / 500.0;
                double w = Art.resExtractor.getWidth() * 7;
                g.drawOval((int)(r.x - w * p / 2.0), (int)(r.y - w * p / 2.0), (int)(w * p), (int)(w * p));
            }
        }
        if (Settings.DEBUG_DRAW_MAP_COLLISION_BOXES) {
            g.setColor(Color.red);
            int x = 0;
            while (x < this.unitBlocks.length) {
                int y = 0;
                while (y < this.unitBlocks[0].length) {
                    g.drawRect(x * this.unitsBoxSize, y * this.unitsBoxSize, this.unitsBoxSize, this.unitsBoxSize);
                    g.drawString("" + this.unitBlocks[x][y].list.size(), x * this.unitsBoxSize + 10, y * this.unitsBoxSize + 10);
                    ++y;
                }
                ++x;
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Type getType(Vec2 pos) {
        if (!this.onMap(pos)) {
            return null;
        }
        return this.mapType[(int)pos.x][(int)pos.y];
    }

    private boolean onMap(Vec2 pos) {
        return pos.x >= 0.0 && pos.y >= 0.0 && pos.x < (double)this.width && pos.y < (double)this.height;
    }

    public ArrayList<Unit> getUnitsFromAdjecentTiles(Entity u) {
        return this.getUnitsFromAdjecentTiles(u.pos);
    }

    public ArrayList<Unit> getUnitsFromAdjecentTiles(Vec2 pos) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        int ix = (int)(pos.x / (double)this.unitsBoxSize);
        int iy = (int)(pos.y / (double)this.unitsBoxSize);
        int x = ix - 1;
        while (x <= ix + 1) {
            int y = iy - 1;
            while (y <= iy + 1) {
                if (x >= 0 && y >= 0 && x < this.unitBlocks.length && y < this.unitBlocks[0].length) {
                    units.addAll(this.unitBlocks[x][y].list);
                }
                ++y;
            }
            ++x;
        }
        return units;
    }

    public Vec2 getSpawnPoint(int i) {
        return new Vec2(200 + i * 75, 200.0);
    }

    public BufferedImage getMiniMapImage() {
        return this.mapImage;
    }

    public boolean onResource(Rect r) {
        int i = 0;
        while (i < this.resources.size()) {
            if (r.intersects(this.resources.get(i)) || this.resources.get(i).intersects(r)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vec2 randomPos() {
        return new Vec2(Math.random() * (double)this.width, Math.random() * (double)this.height);
    }

    private class ArrayListUnit {
        ArrayList<Unit> list = new ArrayList();

        private ArrayListUnit() {
        }
    }

    public static enum Type {
        LAND,
        WATER,
        RESOURCE;

    }
}

