/*
 * Decompiled with CFR 0.152.
 */
package sound;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.swing.JOptionPane;
import sound.SoundFile;

public class Sound {
    public static final SoundFile GAME_MUSIC = new SoundFile("wolframDanceShort.wav");
    public static final SoundFile MENU_MUSIC = new SoundFile("wolframDanceMenuShort.wav");
    public static final SoundFile VICTORY = new SoundFile("dkVictory.wav");
    public static final SoundFile EXPLOSION_SMALL = new SoundFile("explodeSmall.wav");
    public static final SoundFile EXPLOSION_MEDIUM = new SoundFile("explodeMedium.wav");
    public static final SoundFile EXPLOSION_LARGE = new SoundFile("explodeLarge.wav");
    public static final SoundFile LASER_ORANGE = new SoundFile("laserOrange.wav");
    public static final SoundFile MISSILE = new SoundFile("missile.wav");
    public static final SoundFile CANNON = new SoundFile("cannon.wav");
    public static final SoundFile CLICK = new SoundFile("click.wav");
    private SoundFile currentMusic;
    private double soundVolume;
    private double musicVolume;
    private Clip musicClip;

    public Sound(double soundVolume, double musicVolume) {
        this.soundVolume = soundVolume;
        this.musicVolume = musicVolume;
    }

    public void playSound(SoundFile sound) {
        try {
            Clip clip = (Clip)AudioSystem.getLine(sound.info);
            clip.open(sound.af, sound.audio, 0, sound.size);
            FloatControl volume = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.soundVolume)));
            clip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "play sound " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setMusic(SoundFile music) {
        if (this.currentMusic == music) {
            return;
        }
        if (this.musicClip != null) {
            this.musicClip.stop();
        }
        this.currentMusic = music;
        try {
            this.musicClip = (Clip)AudioSystem.getLine(music.info);
            this.musicClip.open(music.af, music.audio, 0, music.size);
            this.musicClip.loop(-1);
            FloatControl volume = (FloatControl)this.musicClip.getControl(FloatControl.Type.MASTER_GAIN);
            volume.setValue((float)(20.0 * Math.log10(this.musicVolume)));
            this.musicClip.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "set music " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void stopMusic() {
        this.currentMusic = null;
        this.musicClip.stop();
    }
}

