var http = require("http"),
    url = require("url"),
    fs = require("fs");

http.createServer(function(request, response) {
    var file = url.parse(request.url).pathname;
    console.log(file);
    if (file == '/') file = '/index.html';
    if (file == '/exit') process.exit(0);
    var filename = __dirname + "/build"+ file;
    fs.exists(filename, function(exists) {
        if(!exists) {
            response.statusCode = 404;
            response.end();
            return;
        }
        fs.readFile(filename, "binary", function(err, file) {
            if(err) {
                response.statusCode = 500;
                response.end();
                return;
            }
            var ctype = 'application/octet-stream';
            if (filename.indexOf('html') > -1)
                ctype = 'text/html';

            response.writeHead(200, {
                'Content-Type': ctype
            });
            response.write(file, "binary");
            response.end();
        });
    });
}).listen(31337);

console.log("go to http://localhost:31337");