
//Change this to true for a stretchy canvas!
//
var RESIZEABLE_CANVAS=false;

//Start us up!
//
window.onload=function( e ){

	if( RESIZEABLE_CANVAS ){
		window.onresize=function( e ){
			var canvas=document.getElementById( "GameCanvas" );

			//This vs window.innerWidth, which apparently doesn't account for scrollbar?
			var width=document.body.clientWidth;
			
			//This vs document.body.clientHeight, which does weird things - document seems to 'grow'...perhaps canvas resize pushing page down?
			var height=window.innerHeight;			

			canvas.width=width;
			canvas.height=height;
		}
		window.onresize( null );
	}

	BBMonkeyGame.Main( document.getElementById( "GameCanvas" ) );
}

//${CONFIG_BEGIN}
CFG_BINARY_FILES="*.bin|*.dat";
CFG_BRL_GAMETARGET_IMPLEMENTED="1";
CFG_BRL_THREAD_IMPLEMENTED="1";
CFG_CD="";
CFG_CONFIG="debug";
CFG_HOST="winnt";
CFG_IMAGE_FILES="*.png|*.jpg";
CFG_LANG="js";
CFG_MODPATH=".;C:/Monkey/MonkeyPro70g/projects/Pickel;C:/Monkey/MonkeyPro70g/modules;C:/Monkey/MonkeyPro70g/modules_ext;C:/Monkey/MonkeyPro70g/targets/html5/modules";
CFG_MOJO_AUTO_SUSPEND_ENABLED="0";
CFG_MONKEYDIR="";
CFG_MUSIC_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_OPENGL_GLES20_ENABLED="0";
CFG_SAFEMODE="0";
CFG_SOUND_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_TARGET="html5";
CFG_TEXT_FILES="*.txt|*.xml|*.json";
CFG_TRANSDIR="";
//${CONFIG_END}

//${METADATA_BEGIN}
var META_DATA="[mojo_font.png];type=image/png;width=864;height=13;\n[DerHase.png];type=image/png;width=333;height=333;\n[baah.png];type=image/png;width=843;height=366;\n[bg.png];type=image/png;width=1920;height=1080;\n[blink.png];type=image/png;width=1173;height=297;\n[cubes.png];type=image/png;width=4800;height=400;\n[font.png];type=image/png;width=600;height=800;\n[fontsmall.png];type=image/png;width=304;height=400;\n[intro.png];type=image/png;width=496;height=738;\n[oooh.png];type=image/png;width=843;height=366;\n[pointer.png];type=image/png;width=267;height=89;\n[spotparticles.png];type=image/png;width=512;height=128;\n[spots.png];type=image/png;width=1536;height=512;\n";
//${METADATA_END}

//${TRANSCODE_BEGIN}

// Javascript Monkey runtime.
//
// Placed into the public domain 24/02/2011.
// No warranty implied; use at your own risk.

//***** JavaScript Runtime *****

var D2R=0.017453292519943295;
var R2D=57.29577951308232;

var err_info="";
var err_stack=[];

var dbg_index=0;

function push_err(){
	err_stack.push( err_info );
}

function pop_err(){
	err_info=err_stack.pop();
}

function stackTrace(){
	if( !err_info.length ) return "";
	var str=err_info+"\n";
	for( var i=err_stack.length-1;i>0;--i ){
		str+=err_stack[i]+"\n";
	}
	return str;
}

function print( str ){
	var cons=document.getElementById( "GameConsole" );
	if( cons ){
		cons.value+=str+"\n";
		cons.scrollTop=cons.scrollHeight-cons.clientHeight;
	}else if( window.console!=undefined ){
		window.console.log( str );
	}
	return 0;
}

function alertError( err ){
	if( typeof(err)=="string" && err=="" ) return;
	alert( "Monkey Runtime Error : "+err.toString()+"\n\n"+stackTrace() );
}

function error( err ){
	throw err;
}

function debugLog( str ){
	if( window.console!=undefined ) window.console.log( str );
}

function debugStop(){
	debugger;	//	error( "STOP" );
}

function dbg_object( obj ){
	if( obj ) return obj;
	error( "Null object access" );
}

function dbg_charCodeAt( str,index ){
	if( index<0 || index>=str.length ) error( "Character index out of range" );
	return str.charCodeAt( index );
}

function dbg_array( arr,index ){
	if( index<0 || index>=arr.length ) error( "Array index out of range" );
	dbg_index=index;
	return arr;
}

function new_bool_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=false;
	return arr;
}

function new_number_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=0;
	return arr;
}

function new_string_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]='';
	return arr;
}

function new_array_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=[];
	return arr;
}

function new_object_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=null;
	return arr;
}

function resize_bool_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=false;
	return arr;
}

function resize_number_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=0;
	return arr;
}

function resize_string_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]="";
	return arr;
}

function resize_array_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=[];
	return arr;
}

function resize_object_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=null;
	return arr;
}

function string_compare( lhs,rhs ){
	var n=Math.min( lhs.length,rhs.length ),i,t;
	for( i=0;i<n;++i ){
		t=lhs.charCodeAt(i)-rhs.charCodeAt(i);
		if( t ) return t;
	}
	return lhs.length-rhs.length;
}

function string_replace( str,find,rep ){	//no unregex replace all?!?
	var i=0;
	for(;;){
		i=str.indexOf( find,i );
		if( i==-1 ) return str;
		str=str.substring( 0,i )+rep+str.substring( i+find.length );
		i+=rep.length;
	}
}

function string_trim( str ){
	var i=0,i2=str.length;
	while( i<i2 && str.charCodeAt(i)<=32 ) i+=1;
	while( i2>i && str.charCodeAt(i2-1)<=32 ) i2-=1;
	return str.slice( i,i2 );
}

function string_startswith( str,substr ){
	return substr.length<=str.length && str.slice(0,substr.length)==substr;
}

function string_endswith( str,substr ){
	return substr.length<=str.length && str.slice(str.length-substr.length,str.length)==substr;
}

function string_tochars( str ){
	var arr=new Array( str.length );
	for( var i=0;i<str.length;++i ) arr[i]=str.charCodeAt(i);
	return arr;
}

function string_fromchars( chars ){
	var str="",i;
	for( i=0;i<chars.length;++i ){
		str+=String.fromCharCode( chars[i] );
	}
	return str;
}

function object_downcast( obj,clas ){
	if( obj instanceof clas ) return obj;
	return null;
}

function object_implements( obj,iface ){
	if( obj && obj.implments && obj.implments[iface] ) return obj;
	return null;
}

function extend_class( clas ){
	var tmp=function(){};
	tmp.prototype=clas.prototype;
	return new tmp;
}

function ThrowableObject(){
}

ThrowableObject.prototype.toString=function(){ 
	return "Uncaught Monkey Exception"; 
}

function BBGameEvent(){}
BBGameEvent.KeyDown=1;
BBGameEvent.KeyUp=2;
BBGameEvent.KeyChar=3;
BBGameEvent.MouseDown=4;
BBGameEvent.MouseUp=5;
BBGameEvent.MouseMove=6;
BBGameEvent.TouchDown=7;
BBGameEvent.TouchUp=8;
BBGameEvent.TouchMove=9;
BBGameEvent.MotionAccel=10;

function BBGameDelegate(){}
BBGameDelegate.prototype.StartGame=function(){}
BBGameDelegate.prototype.SuspendGame=function(){}
BBGameDelegate.prototype.ResumeGame=function(){}
BBGameDelegate.prototype.UpdateGame=function(){}
BBGameDelegate.prototype.RenderGame=function(){}
BBGameDelegate.prototype.KeyEvent=function( ev,data ){}
BBGameDelegate.prototype.MouseEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.TouchEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.MotionEvent=function( ev,data,x,y,z ){}
BBGameDelegate.prototype.DiscardGraphics=function(){}

function BBGame(){
	BBGame._game=this;
	this._delegate=null;
	this._keyboardEnabled=false;
	this._updateRate=0;
	this._started=false;
	this._suspended=false;
	this._debugExs=(CFG_CONFIG=="debug");
	this._startms=Date.now();
}

BBGame.Game=function(){
	return BBGame._game;
}

BBGame.prototype.SetDelegate=function( delegate ){
	this._delegate=delegate;
}

BBGame.prototype.Delegate=function(){
	return this._delegate;
}

BBGame.prototype.SetUpdateRate=function( updateRate ){
	this._updateRate=updateRate;
}

BBGame.prototype.SetKeyboardEnabled=function( keyboardEnabled ){
	this._keyboardEnabled=keyboardEnabled;
}

BBGame.prototype.Started=function(){
	return this._started;
}

BBGame.prototype.Suspended=function(){
	return this._suspended;
}

BBGame.prototype.Millisecs=function(){
	return Date.now()-this._startms;
}

BBGame.prototype.GetDate=function( date ){
	var n=date.length;
	if( n>0 ){
		var t=new Date();
		date[0]=t.getFullYear();
		if( n>1 ){
			date[1]=t.getMonth()+1;
			if( n>2 ){
				date[2]=t.getDate();
				if( n>3 ){
					date[3]=t.getHours();
					if( n>4 ){
						date[4]=t.getMinutes();
						if( n>5 ){
							date[5]=t.getSeconds();
							if( n>6 ){
								date[6]=t.getMilliseconds();
							}
						}
					}
				}
			}
		}
	}
}

BBGame.prototype.SaveState=function( state ){
	localStorage.setItem( "monkeystate@"+document.URL,state );	//key can't start with dot in Chrome!
	return 1;
}

BBGame.prototype.LoadState=function(){
	var state=localStorage.getItem( "monkeystate@"+document.URL );
	if( state ) return state;
	return "";
}

BBGame.prototype.LoadString=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );
	
	xhr.send( null );
	
	if( xhr.status==200 || xhr.status==0 ) return xhr.responseText;
	
	return "";
}

BBGame.prototype.PollJoystick=function( port,joyx,joyy,joyz,buttons ){
	return false;
}

BBGame.prototype.OpenUrl=function( url ){
	window.location=url;
}

BBGame.prototype.SetMouseVisible=function( visible ){
	if( visible ){
		this._canvas.style.cursor='default';	
	}else{
		this._canvas.style.cursor="url('data:image/cur;base64,AAACAAEAICAAAAAAAACoEAAAFgAAACgAAAAgAAAAQAAAAAEAIAAAAAAAgBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA55ZXBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOeWVxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADnllcGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////9////////////////////+////////f/////////8%3D'), auto";
	}
}

BBGame.prototype.PathToFilePath=function( path ){
	return "";
}

//***** js Game *****

BBGame.prototype.PathToUrl=function( path ){
	return path;
}

BBGame.prototype.LoadData=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );

	if( xhr.overrideMimeType ) xhr.overrideMimeType( "text/plain; charset=x-user-defined" );

	xhr.send( null );
	if( xhr.status!=200 && xhr.status!=0 ) return null;

	var r=xhr.responseText;
	var buf=new ArrayBuffer( r.length );
	var bytes=new Int8Array( buf );
	for( var i=0;i<r.length;++i ){
		bytes[i]=r.charCodeAt( i );
	}
	return buf;
}

//***** INTERNAL ******

BBGame.prototype.Die=function( ex ){

	this._delegate=new BBGameDelegate();
	
	if( !ex.toString() ){
		return;
	}
	
	if( this._debugExs ){
		print( "Monkey Runtime Error : "+ex.toString() );
		print( stackTrace() );
	}
	
	throw ex;
}

BBGame.prototype.StartGame=function(){

	if( this._started ) return;
	this._started=true;
	
	if( this._debugExs ){
		try{
			this._delegate.StartGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.StartGame();
	}
}

BBGame.prototype.SuspendGame=function(){

	if( !this._started || this._suspended ) return;
	this._suspended=true;
	
	if( this._debugExs ){
		try{
			this._delegate.SuspendGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.SuspendGame();
	}
}

BBGame.prototype.ResumeGame=function(){

	if( !this._started || !this._suspended ) return;
	this._suspended=false;
	
	if( this._debugExs ){
		try{
			this._delegate.ResumeGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.ResumeGame();
	}
}

BBGame.prototype.UpdateGame=function(){

	if( !this._started || this._suspended ) return;

	if( this._debugExs ){
		try{
			this._delegate.UpdateGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.UpdateGame();
	}
}

BBGame.prototype.RenderGame=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.RenderGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.RenderGame();
	}
}

BBGame.prototype.KeyEvent=function( ev,data ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.KeyEvent( ev,data );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.KeyEvent( ev,data );
	}
}

BBGame.prototype.MouseEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MouseEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MouseEvent( ev,data,x,y );
	}
}

BBGame.prototype.TouchEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.TouchEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.TouchEvent( ev,data,x,y );
	}
}

BBGame.prototype.MotionEvent=function( ev,data,x,y,z ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MotionEvent( ev,data,x,y,z );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MotionEvent( ev,data,x,y,z );
	}
}

BBGame.prototype.DiscardGraphics=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.DiscardGraphics();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.DiscardGraphics();
	}
}

function BBHtml5Game( canvas ){
	BBGame.call( this );
	BBHtml5Game._game=this;
	this._canvas=canvas;
	this._loading=0;
	this._timerSeq=0;
	this._gl=null;
	if( CFG_OPENGL_GLES20_ENABLED=="1" ){
		this._gl=this._canvas.getContext( "webgl" );
		if( !this._gl ) this._gl=this._canvas.getContext( "experimental-webgl" );
		if( !this._gl ) this.Die( "Can't create WebGL" );
		gl=this._gl;
	}
}

BBHtml5Game.prototype=extend_class( BBGame );

BBHtml5Game.Html5Game=function(){
	return BBHtml5Game._game;
}

BBHtml5Game.prototype.ValidateUpdateTimer=function(){

	++this._timerSeq;

	if( !this._updateRate || this._suspended ) return;
	
	var game=this;
	var updatePeriod=1000.0/this._updateRate;
	var nextUpdate=Date.now()+updatePeriod;
	var seq=game._timerSeq;
	
	function timeElapsed(){
		if( seq!=game._timerSeq ) return;

		var time;		
		var updates;
		
		for( updates=0;updates<4;++updates ){
		
			nextUpdate+=updatePeriod;
			
			game.UpdateGame();
			if( seq!=game._timerSeq ) return;
			
			if( nextUpdate-Date.now()>0 ) break;
		}
		
		game.RenderGame();
		if( seq!=game._timerSeq ) return;
		
		if( updates==4 ){
			nextUpdate=Date.now();
			setTimeout( timeElapsed,0 );
		}else{
			var delay=nextUpdate-Date.now();
			setTimeout( timeElapsed,delay>0 ? delay : 0 );
		}
	}

	setTimeout( timeElapsed,updatePeriod );
}

//***** BBGame methods *****

BBHtml5Game.prototype.SetUpdateRate=function( updateRate ){

	BBGame.prototype.SetUpdateRate.call( this,updateRate );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.GetMetaData=function( path,key ){
	if( path.indexOf( "monkey://data/" )!=0 ) return "";
	path=path.slice(14);

	var i=META_DATA.indexOf( "["+path+"]" );
	if( i==-1 ) return "";
	i+=path.length+2;

	var e=META_DATA.indexOf( "\n",i );
	if( e==-1 ) e=META_DATA.length;

	i=META_DATA.indexOf( ";"+key+"=",i )
	if( i==-1 || i>=e ) return "";
	i+=key.length+2;

	e=META_DATA.indexOf( ";",i );
	if( e==-1 ) return "";

	return META_DATA.slice( i,e );
}

BBHtml5Game.prototype.PathToUrl=function( path ){
	if( path.indexOf( "monkey:" )!=0 ){
		return path;
	}else if( path.indexOf( "monkey://data/" )==0 ) {
		return "data/"+path.slice( 14 );
	}
	return "";
}

BBHtml5Game.prototype.GetLoading=function(){
	return this._loading;
}

BBHtml5Game.prototype.IncLoading=function(){
	++this._loading;
	return this._loading;
}

BBHtml5Game.prototype.DecLoading=function(){
	--this._loading;
	return this._loading;
}

BBHtml5Game.prototype.GetCanvas=function(){
	return this._canvas;
}

BBHtml5Game.prototype.GetWebGL=function(){
	return this._gl;
}

//***** INTERNAL *****

BBHtml5Game.prototype.UpdateGame=function(){

	if( !this._loading ) BBGame.prototype.UpdateGame.call( this );
}

BBHtml5Game.prototype.SuspendGame=function(){

	BBGame.prototype.SuspendGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.ResumeGame=function(){

	BBGame.prototype.ResumeGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.Run=function(){

	var game=this;
	var canvas=game._canvas;
	
	var touchIds=new Array( 32 );
	for( i=0;i<32;++i ) touchIds[i]=-1;
	
	function eatEvent( e ){
		if( e.stopPropagation ){
			e.stopPropagation();
			e.preventDefault();
		}else{
			e.cancelBubble=true;
			e.returnValue=false;
		}
	}
	
	function keyToChar( key ){
		switch( key ){
		case 8:case 9:case 13:case 27:case 32:return key;
		case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 45:return key|0x10000;
		case 46:return 127;
		}
		return 0;
	}
	
	function mouseX( e ){
		var x=e.clientX+document.body.scrollLeft;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}
	
	function mouseY( e ){
		var y=e.clientY+document.body.scrollTop;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}

	function touchX( touch ){
		var x=touch.pageX;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x;
	}			
	
	function touchY( touch ){
		var y=touch.pageY;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y;
	}
	
	canvas.onkeydown=function( e ){
		game.KeyEvent( BBGameEvent.KeyDown,e.keyCode );
		var chr=keyToChar( e.keyCode );
		if( chr ) game.KeyEvent( BBGameEvent.KeyChar,chr );
		if( e.keyCode<48 || (e.keyCode>111 && e.keyCode<122) ) eatEvent( e );
	}

	canvas.onkeyup=function( e ){
		game.KeyEvent( BBGameEvent.KeyUp,e.keyCode );
	}

	canvas.onkeypress=function( e ){
		if( e.charCode ){
			game.KeyEvent( BBGameEvent.KeyChar,e.charCode );
		}else if( e.which ){
			game.KeyEvent( BBGameEvent.KeyChar,e.which );
		}
	}

	canvas.onmousedown=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseDown,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseDown,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseDown,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmouseup=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmousemove=function( e ){
		game.MouseEvent( BBGameEvent.MouseMove,-1,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.onmouseout=function( e ){
		game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );
		eatEvent( e );
	}

	canvas.ontouchstart=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=-1 ) continue;
				touchIds[j]=touch.identifier;
				game.TouchEvent( BBGameEvent.TouchDown,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchmove=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				game.TouchEvent( BBGameEvent.TouchMove,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchend=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				touchIds[j]=-1;
				game.TouchEvent( BBGameEvent.TouchUp,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	window.ondevicemotion=function( e ){
		var tx=e.accelerationIncludingGravity.x/9.81;
		var ty=e.accelerationIncludingGravity.y/9.81;
		var tz=e.accelerationIncludingGravity.z/9.81;
		var x,y;
		switch( window.orientation ){
		case   0:x=+tx;y=-ty;break;
		case 180:x=-tx;y=+ty;break;
		case  90:x=-ty;y=-tx;break;
		case -90:x=+ty;y=+tx;break;
		}
		game.MotionEvent( BBGameEvent.MotionAccel,0,x,y,tz );
		eatEvent( e );
	}

	canvas.onfocus=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.ResumeGame();
		}
	}
	
	canvas.onblur=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.SuspendGame();
		}
	}
	
	canvas.focus();
	
	game.StartGame();

	game.RenderGame();
}

function BBMonkeyGame( canvas ){
	BBHtml5Game.call( this,canvas );
}

BBMonkeyGame.prototype=extend_class( BBHtml5Game );

BBMonkeyGame.Main=function( canvas ){

	var game=new BBMonkeyGame( canvas );

	try{

		bbInit();
		bbMain();

	}catch( ex ){
	
		game.Die( ex );
		return;
	}

	if( !game.Delegate() ) return;
	
	game.Run();
}

// HTML5 mojo runtime.
//
// Copyright 2011 Mark Sibly, all rights reserved.
// No warranty implied; use at your own risk.

//***** gxtkGraphics class *****

function gxtkGraphics(){
	this.game=BBHtml5Game.Html5Game();
	this.canvas=this.game.GetCanvas()
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	this.gl=null;
	this.gc=this.canvas.getContext( '2d' );
	this.tmpCanvas=null;
	this.r=255;
	this.b=255;
	this.g=255;
	this.white=true;
	this.color="rgb(255,255,255)"
	this.alpha=1;
	this.blend="source-over";
	this.ix=1;this.iy=0;
	this.jx=0;this.jy=1;
	this.tx=0;this.ty=0;
	this.tformed=false;
	this.scissorX=0;
	this.scissorY=0;
	this.scissorWidth=0;
	this.scissorHeight=0;
	this.clipped=false;
}

gxtkGraphics.prototype.BeginRender=function(){
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	if( !this.gc ) return 0;
	this.gc.save();
	if( this.game.GetLoading() ) return 2;
	return 1;
}

gxtkGraphics.prototype.EndRender=function(){
	if( this.gc ) this.gc.restore();
}

gxtkGraphics.prototype.Width=function(){
	return this.width;
}

gxtkGraphics.prototype.Height=function(){
	return this.height;
}

gxtkGraphics.prototype.LoadSurface=function( path ){
	var game=this.game;

	var ty=game.GetMetaData( path,"type" );
	if( ty.indexOf( "image/" )!=0 ) return null;
	
	function onloadfun(){
		game.DecLoading();
	}
	
	game.IncLoading();

	var image=new Image();
	image.onload=onloadfun;
	image.meta_width=parseInt( game.GetMetaData( path,"width" ) );
	image.meta_height=parseInt( game.GetMetaData( path,"height" ) );
	image.src=game.PathToUrl( path );

	return new gxtkSurface( image,this );
}

gxtkGraphics.prototype.CreateSurface=function( width,height ){
	var canvas=document.createElement( 'canvas' );
	
	canvas.width=width;
	canvas.height=height;
	canvas.meta_width=width;
	canvas.meta_height=height;
	canvas.complete=true;
	
	var surface=new gxtkSurface( canvas,this );
	
	surface.gc=canvas.getContext( '2d' );
	
	return surface;
}

gxtkGraphics.prototype.SetAlpha=function( alpha ){
	this.alpha=alpha;
	this.gc.globalAlpha=alpha;
}

gxtkGraphics.prototype.SetColor=function( r,g,b ){
	this.r=r;
	this.g=g;
	this.b=b;
	this.white=(r==255 && g==255 && b==255);
	this.color="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;
}

gxtkGraphics.prototype.SetBlend=function( blend ){
	switch( blend ){
	case 1:
		this.blend="lighter";
		break;
	default:
		this.blend="source-over";
	}
	this.gc.globalCompositeOperation=this.blend;
}

gxtkGraphics.prototype.SetScissor=function( x,y,w,h ){
	this.scissorX=x;
	this.scissorY=y;
	this.scissorWidth=w;
	this.scissorHeight=h;
	this.clipped=(x!=0 || y!=0 || w!=this.canvas.width || h!=this.canvas.height);
	this.gc.restore();
	this.gc.save();
	if( this.clipped ){
		this.gc.beginPath();
		this.gc.rect( x,y,w,h );
		this.gc.clip();
		this.gc.closePath();
	}
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;	
	this.gc.globalAlpha=this.alpha;	
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.SetMatrix=function( ix,iy,jx,jy,tx,ty ){
	this.ix=ix;this.iy=iy;
	this.jx=jx;this.jy=jy;
	this.tx=tx;this.ty=ty;
	this.gc.setTransform( ix,iy,jx,jy,tx,ty );
	this.tformed=(ix!=1 || iy!=0 || jx!=0 || jy!=1 || tx!=0 || ty!=0);
}

gxtkGraphics.prototype.Cls=function( r,g,b ){
	if( this.tformed ) this.gc.setTransform( 1,0,0,1,0,0 );
	this.gc.fillStyle="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.globalAlpha=1;
	this.gc.globalCompositeOperation="source-over";
	this.gc.fillRect( 0,0,this.canvas.width,this.canvas.height );
	this.gc.fillStyle=this.color;
	this.gc.globalAlpha=this.alpha;
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.DrawPoint=function( x,y ){
	if( this.tformed ){
		var px=x;
		x=px * this.ix + y * this.jx + this.tx;
		y=px * this.iy + y * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
		this.gc.fillRect( x,y,1,1 );
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
		this.gc.fillRect( x,y,1,1 );
	}
}

gxtkGraphics.prototype.DrawRect=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
	this.gc.fillRect( x,y,w,h );
}

gxtkGraphics.prototype.DrawLine=function( x1,y1,x2,y2 ){
	if( this.tformed ){
		var x1_t=x1 * this.ix + y1 * this.jx + this.tx;
		var y1_t=x1 * this.iy + y1 * this.jy + this.ty;
		var x2_t=x2 * this.ix + y2 * this.jx + this.tx;
		var y2_t=x2 * this.iy + y2 * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1_t,y1_t );
	  	this.gc.lineTo( x2_t,y2_t );
	  	this.gc.stroke();
	  	this.gc.closePath();
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1,y1 );
	  	this.gc.lineTo( x2,y2 );
	  	this.gc.stroke();
	  	this.gc.closePath();
	}
}

gxtkGraphics.prototype.DrawOval=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
  	var w2=w/2,h2=h/2;
	this.gc.save();
	this.gc.translate( x+w2,y+h2 );
	this.gc.scale( w2,h2 );
  	this.gc.beginPath();
	this.gc.arc( 0,0,1,0,Math.PI*2,false );
	this.gc.fill();
  	this.gc.closePath();
	this.gc.restore();
}

gxtkGraphics.prototype.DrawPoly=function( verts ){
	if( verts.length<2 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=2;i<verts.length;i+=2 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawPoly2=function( verts,surface,srx,srcy ){
	if( verts.length<4 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=4;i<verts.length;i+=4 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawSurface=function( surface,x,y ){
	if( !surface.image.complete ) return;
	
	if( this.white ){
		this.gc.drawImage( surface.image,x,y );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,0,0,surface.swidth,surface.sheight );
}

gxtkGraphics.prototype.DrawSurface2=function( surface,x,y,srcx,srcy,srcw,srch ){
	if( !surface.image.complete ) return;

	if( srcw<0 ){ srcx+=srcw;srcw=-srcw; }
	if( srch<0 ){ srcy+=srch;srch=-srch; }
	if( srcw<=0 || srch<=0 ) return;

	if( this.white ){
		this.gc.drawImage( surface.image,srcx,srcy,srcw,srch,x,y,srcw,srch );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,srcx,srcy,srcw,srch  );
}

gxtkGraphics.prototype.DrawImageTinted=function( image,dx,dy,sx,sy,sw,sh ){

	if( !this.tmpCanvas ){
		this.tmpCanvas=document.createElement( "canvas" );
	}

	if( sw>this.tmpCanvas.width || sh>this.tmpCanvas.height ){
		this.tmpCanvas.width=Math.max( sw,this.tmpCanvas.width );
		this.tmpCanvas.height=Math.max( sh,this.tmpCanvas.height );
	}
	
	var tmpGC=this.tmpCanvas.getContext( "2d" );
	tmpGC.globalCompositeOperation="copy";
	
	tmpGC.drawImage( image,sx,sy,sw,sh,0,0,sw,sh );
	
	var imgData=tmpGC.getImageData( 0,0,sw,sh );
	
	var p=imgData.data,sz=sw*sh*4,i;
	
	for( i=0;i<sz;i+=4 ){
		p[i]=p[i]*this.r/255;
		p[i+1]=p[i+1]*this.g/255;
		p[i+2]=p[i+2]*this.b/255;
	}
	
	tmpGC.putImageData( imgData,0,0 );
	
	this.gc.drawImage( this.tmpCanvas,0,0,sw,sh,dx,dy,sw,sh );
}

gxtkGraphics.prototype.ReadPixels=function( pixels,x,y,width,height,offset,pitch ){

	var imgData=this.gc.getImageData( x,y,width,height );
	
	var p=imgData.data,i=0,j=offset,px,py;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			pixels[j++]=(p[i+3]<<24)|(p[i]<<16)|(p[i+1]<<8)|p[i+2];
			i+=4;
		}
		j+=pitch-width;
	}
}

gxtkGraphics.prototype.WritePixels2=function( surface,pixels,x,y,width,height,offset,pitch ){

	if( !surface.gc ){
		if( !surface.image.complete ) return;
		var canvas=document.createElement( "canvas" );
		canvas.width=surface.swidth;
		canvas.height=surface.sheight;
		surface.gc=canvas.getContext( "2d" );
		surface.gc.globalCompositeOperation="copy";
		surface.gc.drawImage( surface.image,0,0 );
		surface.image=canvas;
	}

	var imgData=surface.gc.createImageData( width,height );

	var p=imgData.data,i=0,j=offset,px,py,argb;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			argb=pixels[j++];
			p[i]=(argb>>16) & 0xff;
			p[i+1]=(argb>>8) & 0xff;
			p[i+2]=argb & 0xff;
			p[i+3]=(argb>>24) & 0xff;
			i+=4;
		}
		j+=pitch-width;
	}
	
	surface.gc.putImageData( imgData,x,y );
}

//***** gxtkSurface class *****

function gxtkSurface( image,graphics ){
	this.image=image;
	this.graphics=graphics;
	this.swidth=image.meta_width;
	this.sheight=image.meta_height;
}

//***** GXTK API *****

gxtkSurface.prototype.Discard=function(){
	if( this.image ){
		this.image=null;
	}
}

gxtkSurface.prototype.Width=function(){
	return this.swidth;
}

gxtkSurface.prototype.Height=function(){
	return this.sheight;
}

gxtkSurface.prototype.Loaded=function(){
	return this.image.complete;
}

gxtkSurface.prototype.OnUnsafeLoadComplete=function(){
	return true;
}

//***** gxtkChannel class *****
function gxtkChannel(){
	this.sample=null;
	this.audio=null;
	this.volume=1;
	this.pan=0;
	this.rate=1;
	this.flags=0;
	this.state=0;
}

//***** gxtkAudio class *****
function gxtkAudio(){
	this.game=BBHtml5Game.Html5Game();
	this.okay=typeof(Audio)!="undefined";
	this.music=null;
	this.channels=new Array(33);
	for( var i=0;i<33;++i ){
		this.channels[i]=new gxtkChannel();
		if( !this.okay ) this.channels[i].state=-1;
	}
}

gxtkAudio.prototype.Suspend=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.pause();
	}
}

gxtkAudio.prototype.Resume=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ) chan.audio.play();
	}
}

gxtkAudio.prototype.LoadSample=function( path ){
	if( !this.okay ) return null;

	var audio=new Audio( this.game.PathToUrl( path ) );
	if( !audio ) return null;
	
	return new gxtkSample( audio );
}

gxtkAudio.prototype.PlaySample=function( sample,channel,flags ){
	if( !this.okay ) return;
	
	var chan=this.channels[channel];

	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
	
	for( var i=0;i<33;++i ){
		var chan2=this.channels[i];
		if( chan2.state==1 && chan2.audio.ended && !chan2.audio.loop ) chan.state=0;
		if( chan2.state==0 && chan2.sample ){
			chan2.sample.FreeAudio( chan2.audio );
			chan2.sample=null;
			chan2.audio=null;
		}
	}

	var audio=sample.AllocAudio();
	if( !audio ) return;

	audio.loop=(flags&1)!=0;
	audio.volume=chan.volume;
	audio.play();

	chan.sample=sample;
	chan.audio=audio;
	chan.flags=flags;
	chan.state=1;
}

gxtkAudio.prototype.StopChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
}

gxtkAudio.prototype.PauseChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==1 ){
		if( chan.audio.ended && !chan.audio.loop ){
			chan.state=0;
		}else{
			chan.audio.pause();
			chan.state=2;
		}
	}
}

gxtkAudio.prototype.ResumeChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==2 ){
		chan.audio.play();
		chan.state=1;
	}
}

gxtkAudio.prototype.ChannelState=function( channel ){
	var chan=this.channels[channel];
	if( chan.state==1 && chan.audio.ended && !chan.audio.loop ) chan.state=0;
	return chan.state;
}

gxtkAudio.prototype.SetVolume=function( channel,volume ){
	var chan=this.channels[channel];
	if( chan.state>0 ) chan.audio.volume=volume;
	chan.volume=volume;
}

gxtkAudio.prototype.SetPan=function( channel,pan ){
	var chan=this.channels[channel];
	chan.pan=pan;
}

gxtkAudio.prototype.SetRate=function( channel,rate ){
	var chan=this.channels[channel];
	chan.rate=rate;
}

gxtkAudio.prototype.PlayMusic=function( path,flags ){
	this.StopMusic();
	
	this.music=this.LoadSample( path );
	if( !this.music ) return;
	
	this.PlaySample( this.music,32,flags );
}

gxtkAudio.prototype.StopMusic=function(){
	this.StopChannel( 32 );

	if( this.music ){
		this.music.Discard();
		this.music=null;
	}
}

gxtkAudio.prototype.PauseMusic=function(){
	this.PauseChannel( 32 );
}

gxtkAudio.prototype.ResumeMusic=function(){
	this.ResumeChannel( 32 );
}

gxtkAudio.prototype.MusicState=function(){
	return this.ChannelState( 32 );
}

gxtkAudio.prototype.SetMusicVolume=function( volume ){
	this.SetVolume( 32,volume );
}

//***** gxtkSample class *****

function gxtkSample( audio ){
	this.audio=audio;
	this.free=new Array();
	this.insts=new Array();
}

gxtkSample.prototype.FreeAudio=function( audio ){
	this.free.push( audio );
}

gxtkSample.prototype.AllocAudio=function(){
	var audio;
	while( this.free.length ){
		audio=this.free.pop();
		try{
			audio.currentTime=0;
			return audio;
		}catch( ex ){
			print( "AUDIO ERROR1!" );
		}
	}
	
	//Max out?
	if( this.insts.length==8 ) return null;
	
	audio=new Audio( this.audio.src );
	
	//yucky loop handler for firefox!
	//
	audio.addEventListener( 'ended',function(){
		if( this.loop ){
			try{
				this.currentTime=0;
				this.play();
			}catch( ex ){
				print( "AUDIO ERROR2!" );
			}
		}
	},false );

	this.insts.push( audio );
	return audio;
}

gxtkSample.prototype.Discard=function(){
}

function BBThread(){
	this.running=false;
}

BBThread.prototype.Start=function(){
	this.running=true;
	this.Run__UNSAFE__();
}

BBThread.prototype.IsRunning=function(){
	return this.running;
}

BBThread.prototype.Run__UNSAFE__=function(){
	this.running=false;
}

function BBAsyncImageLoaderThread(){
	BBThread.call(this);
}

BBAsyncImageLoaderThread.prototype=extend_class( BBThread );

BBAsyncImageLoaderThread.prototype.Start=function(){

	var thread=this;

	var image=new Image();
	
	image.onload=function( e ){
		image.meta_width=image.width;
		image.meta_height=image.height;
		thread._surface=new gxtkSurface( image,thread._device )
		thread.running=false;
	}
	
	image.onerror=function( e ){
		thread._surface=null;
		thread.running=false;
	}
	
	thread.running=true;
	
	image.src=BBGame.Game().PathToUrl( thread._path );
}


function BBAsyncSoundLoaderThread(){
	BBThread.call(this);
}

BBAsyncSoundLoaderThread.prototype=extend_class( BBThread );

BBAsyncSoundLoaderThread.prototype.Start=function(){
	this._sample=this._device.LoadSample( this._path );
}
function c_App(){
	Object.call(this);
}
c_App.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<110>";
	if((bb_app__app)!=null){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<110>";
		error("App has already been created");
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<111>";
	bb_app__app=this;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<112>";
	bb_app__delegate=c_GameDelegate.m_new.call(new c_GameDelegate);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<113>";
	bb_app__game.SetDelegate(bb_app__delegate);
	pop_err();
	return this;
}
c_App.prototype.p_OnCreate=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnSuspend=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnResume=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnUpdate=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnLoading=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnRender=function(){
	push_err();
	pop_err();
	return 0;
}
c_App.prototype.p_OnClose=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<135>";
	bb_app_EndApp();
	pop_err();
	return 0;
}
c_App.prototype.p_OnBack=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<139>";
	this.p_OnClose();
	pop_err();
	return 0;
}
function c_MyApp(){
	c_App.call(this);
}
c_MyApp.prototype=extend_class(c_App);
c_MyApp.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<45>";
	c_App.m_new.call(this);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<45>";
	pop_err();
	return this;
}
c_MyApp.m_FPS=0;
c_MyApp.prototype.p_OnCreate=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<51>";
	bb_app_SetUpdateRate(c_MyApp.m_FPS);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<52>";
	bb_random_Seed=bb_app_Millisecs();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<53>";
	bb_pickel_dt=c_DeltaTimer.m_new.call(new c_DeltaTimer,60.0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<54>";
	bb_pickel_smallFontImg=bb_graphics_LoadImage2("fontsmall.png",38,50,64,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<55>";
	bb_pickel_fontImg=bb_graphics_LoadImage2("font.png",75,100,64,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<56>";
	bb_pickel_ooohImg=bb_graphics_LoadImage("oooh.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<57>";
	bb_pickel_baahImg=bb_graphics_LoadImage("baah.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<58>";
	bb_pickel_introImg=bb_graphics_LoadImage("intro.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<59>";
	bb_pickel_pointerImg=bb_graphics_LoadImage("pointer.png",3,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<60>";
	bb_pickel_pointerImg.p_SetHandle((bb_pickel_pointerImg.p_Width())*0.5,(bb_pickel_pointerImg.p_Height())*0.5);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<61>";
	bb_pickel_backgroundImg=bb_graphics_LoadImage("bg.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<62>";
	bb_pickel_blackheadsImg=bb_graphics_LoadImage("spots.png",3,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<63>";
	bb_pickel_particlesImg=bb_graphics_LoadImage("spotparticles.png",4,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<64>";
	bb_pickel_cubesImg=bb_graphics_LoadImage("cubes.png",12,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<65>";
	bb_pickel_DerHaseImg=bb_graphics_LoadImage("DerHase.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<66>";
	bb_pickel_blinkImg=bb_graphics_LoadImage("blink.png",1,c_Image.m_DefaultFlags);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<67>";
	bb_app_HideMouse();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<69>";
	bb_pickel_healSnd=bb_audio_LoadSound("heal.ogg");
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<70>";
	bb_pickel_plopSnd=bb_audio_LoadSound("plop.ogg");
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<71>";
	bb_audio_PlayMusic("pimpels.ogg",1);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<72>";
	pop_err();
	return 0;
}
c_MyApp.prototype.p_OnRender=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<76>";
	var t_1=bb_pickel_gameStatus;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<77>";
	if(t_1==3){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<79>";
		bb_graphics_DrawImage(bb_pickel_backgroundImg,0.0,0.0,0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<80>";
		if(bb_pickel_blink<0){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<81>";
			bb_graphics_DrawImage(bb_pickel_blinkImg,396.0,135.0,0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<83>";
		bb_pickel_blink=bb_pickel_blink-1;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<84>";
		if(bb_pickel_blink<=-10){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<85>";
			bb_pickel_blink=((bb_random_Rnd3(60.0)+150.0)|0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<89>";
		bb_pickel_timeline=bb_pickel_timeline+1;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<90>";
		if(bb_pickel_timeline>30 && bb_pickel_timeline<120){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<91>";
			bb_graphics_DrawText("I HEARD THAT FUNCTION HAS",23.0,23.0,0.0,0.0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<93>";
		if(bb_pickel_timeline>=120 && bb_pickel_timeline<210){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<94>";
			bb_graphics_DrawText("THE PRETTIEST GIRLS",250.0,23.0,0.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<95>";
			bb_graphics_DrawText("ON THE SCENE",523.0,140.0,0.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<96>";
			bb_graphics_DrawImage(bb_pickel_ooohImg,589.0,714.0,0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<98>";
		if(bb_pickel_timeline>=210 && bb_pickel_timeline<333){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<99>";
			bb_graphics_DrawImage(bb_pickel_ooohImg,589.0,714.0,0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<102>";
		if(bb_pickel_timeline>=333){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<103>";
			bb_graphics_DrawImage(bb_pickel_baahImg,589.0,714.0,0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<106>";
		if(bb_pickel_timeline>333){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<107>";
			bb_graphics_DrawText("OOOOOHH",740.0,23.0,0.0,0.0);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<110>";
		if(bb_pickel_timeline>=450){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<111>";
			bb_graphics_SetFont(bb_pickel_smallFontImg,32);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<112>";
			bb_pickel_blink=0;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<113>";
			bb_pickel_gameStatus=0;
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<116>";
		if(bb_pickel_timeline==222){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<117>";
			var t_d=null;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<118>";
			t_d=c_Sprite.m_new.call(new c_Sprite,bb_pickel_blackheadsImg,755.0,755.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<119>";
			dbg_object(t_d).m_scale=0.03;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<120>";
			dbg_object(t_d).m_speed=1.02;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<121>";
			dbg_object(t_d).m_frame=0;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<122>";
			dbg_object(t_d).m_alpha=1.0;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<123>";
			bb_pickel_listSpots.p_AddLast(t_d);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<125>";
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<125>";
		var t_=bb_pickel_listSpots.p_ObjectEnumerator();
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<125>";
		while(t_.p_HasNext()){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<125>";
			var t_d2=t_.p_NextObject();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<126>";
			t_d2.p_grow();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<127>";
			t_d2.p_plop();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<128>";
			if(dbg_object(t_d2).m_alpha<=0.01){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<129>";
				bb_pickel_listSpots.p_RemoveEach(t_d2);
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<131>";
			t_d2.p_draw();
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<133>";
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<133>";
		var t_2=bb_pickel_listParticles.p_ObjectEnumerator();
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<133>";
		while(t_2.p_HasNext()){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<133>";
			var t_d3=t_2.p_NextObject();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<135>";
			t_d3.p_draw();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<136>";
			t_d3.p_move();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<137>";
			if(dbg_object(t_d3).m_y>3000.0){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<138>";
				bb_pickel_listParticles.p_RemoveEach(t_d3);
			}
		}
	}else{
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<141>";
		if(t_1==0){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<143>";
			bb_graphics_DrawImage(bb_pickel_backgroundImg,0.0,0.0,0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<144>";
			if(bb_pickel_beauty<30){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<145>";
				bb_graphics_DrawImage(bb_pickel_baahImg,589.0,714.0,0);
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<147>";
			if(bb_pickel_blink<0){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<148>";
				bb_graphics_DrawImage(bb_pickel_blinkImg,396.0,135.0,0);
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<150>";
			bb_pickel_blink=bb_pickel_blink-1;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<151>";
			if(bb_pickel_blink<=-10){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<152>";
				bb_pickel_blink=((bb_random_Rnd3(60.0)+150.0)|0);
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<155>";
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<155>";
			var t_3=bb_pickel_listCubes.p_ObjectEnumerator();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<155>";
			while(t_3.p_HasNext()){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<155>";
				var t_d4=t_3.p_NextObject();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<157>";
				t_d4.p_doCube();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<158>";
				if(dbg_object(t_d4).m_alpha<=0.01){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<159>";
					bb_pickel_listCubes.p_RemoveEach(t_d4);
				}
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<165>";
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<165>";
			var t_4=bb_pickel_listSpots.p_ObjectEnumerator();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<165>";
			while(t_4.p_HasNext()){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<165>";
				var t_d5=t_4.p_NextObject();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<166>";
				t_d5.p_grow();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<167>";
				t_d5.p_plop();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<168>";
				if(dbg_object(t_d5).m_alpha<=0.01){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<169>";
					bb_pickel_listSpots.p_RemoveEach(t_d5);
				}
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<171>";
				t_d5.p_draw();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<173>";
				if(dbg_object(t_d5).m_speed==0.0){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<174>";
					bb_pickel_listSpots.p_RemoveEach(t_d5);
				}
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<179>";
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<179>";
			var t_5=bb_pickel_listParticles.p_ObjectEnumerator();
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<179>";
			while(t_5.p_HasNext()){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<179>";
				var t_d6=t_5.p_NextObject();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<181>";
				t_d6.p_draw();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<182>";
				t_d6.p_move();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<183>";
				if(dbg_object(t_d6).m_y>3000.0){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<184>";
					bb_pickel_listParticles.p_RemoveEach(t_d6);
				}
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<189>";
			bb_graphics_SetAlpha(1.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<195>";
			bb_graphics_SetBlend(1);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<199>";
			bb_graphics_DrawImage(bb_pickel_pointerImg,bb_input_TouchX(0),bb_input_TouchY(0),((bb_random_Rnd3(2.99))|0));
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<200>";
			bb_graphics_SetBlend(0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<201>";
			bb_graphics_DrawText("HI,SCORE.",10.0,10.0,0.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<203>";
			bb_graphics_DrawText(String(bb_pickel_hiscore),10.0,75.0,0.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<204>";
			bb_graphics_DrawText("SCORE.",1706.0,10.0,0.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<205>";
			bb_graphics_DrawText(String(bb_pickel_score),1910.0,75.0,1.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<206>";
			bb_graphics_DrawText("BEAUTY.",1934.0,935.0,1.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<207>";
			bb_graphics_DrawText(String(bb_pickel_beauty),1910.0,1000.0,1.0,0.0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<209>";
			if(bb_pickel_score>bb_pickel_hiscore){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<210>";
				bb_pickel_hiscore=bb_pickel_score;
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<213>";
			if(bb_pickel_beauty<=0){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<214>";
				bb_pickel_timeline=0;
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<215>";
				bb_pickel_spotrate=180.0;
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<216>";
				bb_graphics_SetFont(bb_pickel_fontImg,32);
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<217>";
				bb_pickel_gameStatus=4;
			}
		}else{
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<219>";
			if(t_1==1){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<220>";
				bb_graphics_SetColor(bb_random_Rnd2(150.0,255.0),0.0,0.0);
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<221>";
				bb_graphics_DrawRect(0.0,0.0,1920.0,1080.0);
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<222>";
				bb_graphics_SetColor(255.0,255.0,255.0);
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<223>";
				bb_graphics_DrawImage(bb_pickel_introImg,712.0,130.0,0);
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<225>";
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<225>";
				var t_6=bb_pickel_listParticles.p_ObjectEnumerator();
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<225>";
				while(t_6.p_HasNext()){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<225>";
					var t_d7=t_6.p_NextObject();
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<226>";
					t_d7.p_doDerHase();
				}
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<229>";
				if(bb_pickel_touch00>0){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<230>";
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<230>";
					var t_7=bb_pickel_listParticles.p_ObjectEnumerator();
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<230>";
					while(t_7.p_HasNext()){
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<230>";
						var t_d8=t_7.p_NextObject();
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<231>";
						bb_pickel_listParticles.p_RemoveEach(t_d8);
					}
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<233>";
					bb_pickel_gameStatus=3;
				}
			}else{
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<239>";
				if(t_1==2){
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<240>";
					bb_pickel_timeline=0;
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<241>";
					bb_pickel_score=0;
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<242>";
					bb_pickel_beauty=110;
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<243>";
					bb_graphics_SetFont(bb_pickel_fontImg,32);
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<244>";
					bb_pickel_createDerHase(bb_pickel_DerHaseImg);
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<245>";
					bb_pickel_gameStatus=1;
				}else{
					err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<247>";
					if(t_1==4){
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<248>";
						bb_graphics_DrawImage(bb_pickel_backgroundImg,0.0,0.0,0);
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<249>";
						if(bb_pickel_blink<0){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<250>";
							bb_graphics_DrawImage(bb_pickel_blinkImg,396.0,135.0,0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<254>";
						if(bb_pickel_timeline>=210){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<256>";
							bb_graphics_DrawImage(bb_pickel_ooohImg,589.0,714.0,0);
						}else{
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<258>";
							bb_graphics_DrawImage(bb_pickel_baahImg,589.0,714.0,0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<261>";
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<261>";
						var t_8=bb_pickel_listSpots.p_ObjectEnumerator();
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<261>";
						while(t_8.p_HasNext()){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<261>";
							var t_d9=t_8.p_NextObject();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<262>";
							t_d9.p_grow();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<263>";
							t_d9.p_plop();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<264>";
							if(dbg_object(t_d9).m_alpha<=0.01){
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<265>";
								bb_pickel_listSpots.p_RemoveEach(t_d9);
							}
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<267>";
							t_d9.p_draw();
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<271>";
						bb_graphics_SetAlpha(1.0);
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<273>";
						bb_pickel_blink=bb_pickel_blink-1;
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<274>";
						if(bb_pickel_blink<=-10){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<275>";
							bb_pickel_blink=((bb_random_Rnd3(60.0)+150.0)|0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<279>";
						bb_pickel_timeline=bb_pickel_timeline+1;
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<280>";
						if(bb_pickel_timeline>30 && bb_pickel_timeline<120){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<281>";
							bb_graphics_DrawText("BEAUTY OVER",597.0,500.0,0.0,0.0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<283>";
						if(bb_pickel_timeline>=120 && bb_pickel_timeline<210){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<284>";
							bb_graphics_DrawText("YOUR SCORE",597.0,500.0,0.0,0.0);
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<285>";
							bb_graphics_DrawText(String(bb_pickel_score),960.0,617.0,0.5,0.0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<287>";
						if(bb_pickel_timeline>=210 && bb_pickel_timeline<300){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<288>";
							bb_graphics_DrawText("I GO TO FUNCTION ANYWAY",960.0,23.0,0.5,0.0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<291>";
						if(bb_pickel_timeline>=300 && bb_pickel_timeline<390){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<292>";
							bb_graphics_DrawText("AND DRINK ALL YOUR",960.0,23.0,0.5,0.0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<295>";
						if(bb_pickel_timeline>=390 && bb_pickel_timeline<480){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<296>";
							bb_graphics_DrawText("VODKA AND BEER",960.0,23.0,0.5,0.0);
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<300>";
						if(bb_pickel_timeline>=555){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<301>";
							bb_graphics_SetFont(bb_pickel_smallFontImg,32);
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<302>";
							bb_pickel_gameStatus=2;
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<304>";
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<304>";
							var t_9=bb_pickel_listSpots.p_ObjectEnumerator();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<304>";
							while(t_9.p_HasNext()){
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<304>";
								var t_d10=t_9.p_NextObject();
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<305>";
								bb_pickel_listSpots.p_RemoveEach(t_d10);
							}
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<307>";
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<307>";
							var t_10=bb_pickel_listSpots.p_ObjectEnumerator();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<307>";
							while(t_10.p_HasNext()){
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<307>";
								var t_d11=t_10.p_NextObject();
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<308>";
								bb_pickel_listCubes.p_RemoveEach(t_d11);
							}
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<311>";
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<311>";
						var t_11=bb_pickel_listParticles.p_ObjectEnumerator();
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<311>";
						while(t_11.p_HasNext()){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<311>";
							var t_d12=t_11.p_NextObject();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<313>";
							t_d12.p_draw();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<314>";
							t_d12.p_move();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<315>";
							if(dbg_object(t_d12).m_y>3000.0){
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<316>";
								bb_pickel_listParticles.p_RemoveEach(t_d12);
							}
						}
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<320>";
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<320>";
						var t_12=bb_pickel_listCubes.p_ObjectEnumerator();
						err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<320>";
						while(t_12.p_HasNext()){
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<320>";
							var t_d13=t_12.p_NextObject();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<322>";
							t_d13.p_doCube();
							err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<323>";
							if(dbg_object(t_d13).m_alpha<=0.01){
								err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<324>";
								bb_pickel_listCubes.p_RemoveEach(t_d13);
							}
						}
					}
				}
			}
		}
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<332>";
	pop_err();
	return 0;
}
c_MyApp.prototype.p_OnUpdate=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<337>";
	bb_pickel_touch00=bb_input_TouchHit(0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<338>";
	var t_2=bb_pickel_gameStatus;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<339>";
	if(t_2==0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<342>";
		if(bb_pickel_spotrate>bb_random_Rnd3(3500.0)){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<343>";
			bb_pickel_createSpot(bb_pickel_blackheadsImg);
		}
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<345>";
		bb_pickel_spotrate=bb_pickel_spotrate+1.0/bb_pickel_spotrate*3.0;
	}else{
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<346>";
		if(t_2==1){
		}
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<349>";
	pop_err();
	return 0;
}
var bb_app__app=null;
function c_GameDelegate(){
	BBGameDelegate.call(this);
	this.m__graphics=null;
	this.m__audio=null;
	this.m__input=null;
}
c_GameDelegate.prototype=extend_class(BBGameDelegate);
c_GameDelegate.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<30>";
	pop_err();
	return this;
}
c_GameDelegate.prototype.StartGame=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<39>";
	this.m__graphics=(new gxtkGraphics);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<40>";
	bb_graphics_SetGraphicsDevice(this.m__graphics);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<41>";
	bb_graphics_SetFont(null,32);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<43>";
	this.m__audio=(new gxtkAudio);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<44>";
	bb_audio_SetAudioDevice(this.m__audio);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<46>";
	this.m__input=c_InputDevice.m_new.call(new c_InputDevice);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<47>";
	bb_input_SetInputDevice(this.m__input);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<49>";
	bb_app__app.p_OnCreate();
	pop_err();
}
c_GameDelegate.prototype.SuspendGame=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<53>";
	bb_app__app.p_OnSuspend();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<54>";
	this.m__audio.Suspend();
	pop_err();
}
c_GameDelegate.prototype.ResumeGame=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<58>";
	this.m__audio.Resume();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<59>";
	bb_app__app.p_OnResume();
	pop_err();
}
c_GameDelegate.prototype.UpdateGame=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<63>";
	this.m__input.p_BeginUpdate();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<64>";
	bb_app__app.p_OnUpdate();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<65>";
	this.m__input.p_EndUpdate();
	pop_err();
}
c_GameDelegate.prototype.RenderGame=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<69>";
	var t_mode=this.m__graphics.BeginRender();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<70>";
	if((t_mode)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<70>";
		bb_graphics_BeginRender();
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<71>";
	if(t_mode==2){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<71>";
		bb_app__app.p_OnLoading();
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<71>";
		bb_app__app.p_OnRender();
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<72>";
	if((t_mode)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<72>";
		bb_graphics_EndRender();
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<73>";
	this.m__graphics.EndRender();
	pop_err();
}
c_GameDelegate.prototype.KeyEvent=function(t_event,t_data){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<77>";
	this.m__input.p_KeyEvent(t_event,t_data);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<78>";
	if(t_event!=1){
		pop_err();
		return;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<79>";
	var t_1=t_data;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<80>";
	if(t_1==432){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<81>";
		bb_app__app.p_OnClose();
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<82>";
		if(t_1==416){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<83>";
			bb_app__app.p_OnBack();
		}
	}
	pop_err();
}
c_GameDelegate.prototype.MouseEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<88>";
	this.m__input.p_MouseEvent(t_event,t_data,t_x,t_y);
	pop_err();
}
c_GameDelegate.prototype.TouchEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<92>";
	this.m__input.p_TouchEvent(t_event,t_data,t_x,t_y);
	pop_err();
}
c_GameDelegate.prototype.MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<96>";
	this.m__input.p_MotionEvent(t_event,t_data,t_x,t_y,t_z);
	pop_err();
}
c_GameDelegate.prototype.DiscardGraphics=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<100>";
	this.m__graphics.DiscardGraphics();
	pop_err();
}
var bb_app__delegate=null;
var bb_app__game=null;
var bb_pickel_app=null;
function bbMain(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<40>";
	bb_pickel_app=c_MyApp.m_new.call(new c_MyApp);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<41>";
	pop_err();
	return 0;
}
var bb_graphics_device=null;
function bb_graphics_SetGraphicsDevice(t_dev){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<58>";
	bb_graphics_device=t_dev;
	pop_err();
	return 0;
}
function c_Image(){
	Object.call(this);
	this.m_surface=null;
	this.m_width=0;
	this.m_height=0;
	this.m_frames=[];
	this.m_flags=0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_source=null;
}
c_Image.m_DefaultFlags=0;
c_Image.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<65>";
	pop_err();
	return this;
}
c_Image.prototype.p_SetHandle=function(t_tx,t_ty){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<109>";
	dbg_object(this).m_tx=t_tx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<110>";
	dbg_object(this).m_ty=t_ty;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<111>";
	dbg_object(this).m_flags=dbg_object(this).m_flags&-2;
	pop_err();
	return 0;
}
c_Image.prototype.p_ApplyFlags=function(t_iflags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<184>";
	this.m_flags=t_iflags;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<186>";
	if((this.m_flags&2)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
		var t_=this.m_frames;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
		var t_2=0;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
		while(t_2<t_.length){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
			var t_f=dbg_array(t_,t_2)[dbg_index];
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<187>";
			t_2=t_2+1;
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<188>";
			dbg_object(t_f).m_x+=1;
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<190>";
		this.m_width-=2;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<193>";
	if((this.m_flags&4)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
		var t_3=this.m_frames;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
		var t_4=0;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
		while(t_4<t_3.length){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
			var t_f2=dbg_array(t_3,t_4)[dbg_index];
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<194>";
			t_4=t_4+1;
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<195>";
			dbg_object(t_f2).m_y+=1;
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<197>";
		this.m_height-=2;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<200>";
	if((this.m_flags&1)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<201>";
		this.p_SetHandle((this.m_width)/2.0,(this.m_height)/2.0);
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<204>";
	if(this.m_frames.length==1 && dbg_object(dbg_array(this.m_frames,0)[dbg_index]).m_x==0 && dbg_object(dbg_array(this.m_frames,0)[dbg_index]).m_y==0 && this.m_width==this.m_surface.Width() && this.m_height==this.m_surface.Height()){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<205>";
		this.m_flags|=65536;
	}
	pop_err();
	return 0;
}
c_Image.prototype.p_Init=function(t_surf,t_nframes,t_iflags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<142>";
	this.m_surface=t_surf;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<144>";
	this.m_width=((this.m_surface.Width()/t_nframes)|0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<145>";
	this.m_height=this.m_surface.Height();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<147>";
	this.m_frames=new_object_array(t_nframes);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<148>";
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<149>";
		dbg_array(this.m_frames,t_i)[dbg_index]=c_Frame.m_new.call(new c_Frame,t_i*this.m_width,0)
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<152>";
	this.p_ApplyFlags(t_iflags);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<153>";
	pop_err();
	return this;
}
c_Image.prototype.p_Grab=function(t_x,t_y,t_iwidth,t_iheight,t_nframes,t_iflags,t_source){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<157>";
	dbg_object(this).m_source=t_source;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<158>";
	this.m_surface=dbg_object(t_source).m_surface;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<160>";
	this.m_width=t_iwidth;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<161>";
	this.m_height=t_iheight;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<163>";
	this.m_frames=new_object_array(t_nframes);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<165>";
	var t_ix=t_x;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<165>";
	var t_iy=t_y;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<167>";
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<168>";
		if(t_ix+this.m_width>dbg_object(t_source).m_width){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<169>";
			t_ix=0;
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<170>";
			t_iy+=this.m_height;
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<172>";
		if(t_ix+this.m_width>dbg_object(t_source).m_width || t_iy+this.m_height>dbg_object(t_source).m_height){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<173>";
			error("Image frame outside surface");
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<175>";
		dbg_array(this.m_frames,t_i)[dbg_index]=c_Frame.m_new.call(new c_Frame,t_ix+dbg_object(dbg_array(dbg_object(t_source).m_frames,0)[dbg_index]).m_x,t_iy+dbg_object(dbg_array(dbg_object(t_source).m_frames,0)[dbg_index]).m_y)
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<176>";
		t_ix+=this.m_width;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<179>";
	this.p_ApplyFlags(t_iflags);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<180>";
	pop_err();
	return this;
}
c_Image.prototype.p_GrabImage=function(t_x,t_y,t_width,t_height,t_frames,t_flags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<104>";
	if(dbg_object(this).m_frames.length!=1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<104>";
		pop_err();
		return null;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<105>";
	var t_=(c_Image.m_new.call(new c_Image)).p_Grab(t_x,t_y,t_width,t_height,t_frames,t_flags,this);
	pop_err();
	return t_;
}
c_Image.prototype.p_Width=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<76>";
	pop_err();
	return this.m_width;
}
c_Image.prototype.p_Height=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<80>";
	pop_err();
	return this.m_height;
}
c_Image.prototype.p_Frames=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<88>";
	var t_=this.m_frames.length;
	pop_err();
	return t_;
}
function c_GraphicsContext(){
	Object.call(this);
	this.m_defaultFont=null;
	this.m_font=null;
	this.m_firstChar=0;
	this.m_matrixSp=0;
	this.m_ix=1.0;
	this.m_iy=.0;
	this.m_jx=.0;
	this.m_jy=1.0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_tformed=0;
	this.m_matDirty=0;
	this.m_color_r=.0;
	this.m_color_g=.0;
	this.m_color_b=.0;
	this.m_alpha=.0;
	this.m_blend=0;
	this.m_scissor_x=.0;
	this.m_scissor_y=.0;
	this.m_scissor_width=.0;
	this.m_scissor_height=.0;
	this.m_matrixStack=new_number_array(192);
}
c_GraphicsContext.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<24>";
	pop_err();
	return this;
}
c_GraphicsContext.prototype.p_Validate=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<35>";
	if((this.m_matDirty)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<36>";
		bb_graphics_renderDevice.SetMatrix(dbg_object(bb_graphics_context).m_ix,dbg_object(bb_graphics_context).m_iy,dbg_object(bb_graphics_context).m_jx,dbg_object(bb_graphics_context).m_jy,dbg_object(bb_graphics_context).m_tx,dbg_object(bb_graphics_context).m_ty);
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<37>";
		this.m_matDirty=0;
	}
	pop_err();
	return 0;
}
var bb_graphics_context=null;
function bb_data_FixDataPath(t_path){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<3>";
	var t_i=t_path.indexOf(":/",0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<4>";
	if(t_i!=-1 && t_path.indexOf("/",0)==t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<4>";
		pop_err();
		return t_path;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<5>";
	if(string_startswith(t_path,"./") || string_startswith(t_path,"/")){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<5>";
		pop_err();
		return t_path;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/data.monkey<6>";
	var t_="monkey://data/"+t_path;
	pop_err();
	return t_;
}
function c_Frame(){
	Object.call(this);
	this.m_x=0;
	this.m_y=0;
}
c_Frame.m_new=function(t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<18>";
	dbg_object(this).m_x=t_x;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<19>";
	dbg_object(this).m_y=t_y;
	pop_err();
	return this;
}
c_Frame.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<13>";
	pop_err();
	return this;
}
function bb_graphics_LoadImage(t_path,t_frameCount,t_flags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<234>";
	var t_surf=bb_graphics_device.LoadSurface(bb_data_FixDataPath(t_path));
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<235>";
	if((t_surf)!=null){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<235>";
		var t_=(c_Image.m_new.call(new c_Image)).p_Init(t_surf,t_frameCount,t_flags);
		pop_err();
		return t_;
	}
	pop_err();
	return null;
}
function bb_graphics_LoadImage2(t_path,t_frameWidth,t_frameHeight,t_frameCount,t_flags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<239>";
	var t_atlas=bb_graphics_LoadImage(t_path,1,0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<240>";
	if((t_atlas)!=null){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<240>";
		var t_=t_atlas.p_GrabImage(0,0,t_frameWidth,t_frameHeight,t_frameCount,t_flags);
		pop_err();
		return t_;
	}
	pop_err();
	return null;
}
function bb_graphics_SetFont(t_font,t_firstChar){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<541>";
	if(!((t_font)!=null)){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<542>";
		if(!((dbg_object(bb_graphics_context).m_defaultFont)!=null)){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<543>";
			dbg_object(bb_graphics_context).m_defaultFont=bb_graphics_LoadImage("mojo_font.png",96,2);
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<545>";
		t_font=dbg_object(bb_graphics_context).m_defaultFont;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<546>";
		t_firstChar=32;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<548>";
	dbg_object(bb_graphics_context).m_font=t_font;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<549>";
	dbg_object(bb_graphics_context).m_firstChar=t_firstChar;
	pop_err();
	return 0;
}
var bb_audio_device=null;
function bb_audio_SetAudioDevice(t_dev){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<18>";
	bb_audio_device=t_dev;
	pop_err();
	return 0;
}
function c_InputDevice(){
	Object.call(this);
	this.m__joyStates=new_object_array(4);
	this.m__keyDown=new_bool_array(512);
	this.m__keyHitPut=0;
	this.m__keyHitQueue=new_number_array(33);
	this.m__keyHit=new_number_array(512);
	this.m__charGet=0;
	this.m__charPut=0;
	this.m__charQueue=new_number_array(32);
	this.m__mouseX=.0;
	this.m__mouseY=.0;
	this.m__touchX=new_number_array(32);
	this.m__touchY=new_number_array(32);
	this.m__accelX=.0;
	this.m__accelY=.0;
	this.m__accelZ=.0;
}
c_InputDevice.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<22>";
	for(var t_i=0;t_i<4;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<23>";
		dbg_array(this.m__joyStates,t_i)[dbg_index]=c_JoyState.m_new.call(new c_JoyState)
	}
	pop_err();
	return this;
}
c_InputDevice.prototype.p_PutKeyHit=function(t_key){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<233>";
	if(this.m__keyHitPut==this.m__keyHitQueue.length){
		pop_err();
		return;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<234>";
	dbg_array(this.m__keyHit,t_key)[dbg_index]+=1
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<235>";
	dbg_array(this.m__keyHitQueue,this.m__keyHitPut)[dbg_index]=t_key
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<236>";
	this.m__keyHitPut+=1;
	pop_err();
}
c_InputDevice.prototype.p_BeginUpdate=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<185>";
	for(var t_i=0;t_i<4;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<186>";
		var t_state=dbg_array(this.m__joyStates,t_i)[dbg_index];
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<187>";
		if(!BBGame.Game().PollJoystick(t_i,dbg_object(t_state).m_joyx,dbg_object(t_state).m_joyy,dbg_object(t_state).m_joyz,dbg_object(t_state).m_buttons)){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<187>";
			break;
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<188>";
		for(var t_j=0;t_j<32;t_j=t_j+1){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<189>";
			var t_key=256+t_i*32+t_j;
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<190>";
			if(dbg_array(dbg_object(t_state).m_buttons,t_j)[dbg_index]){
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<191>";
				if(!dbg_array(this.m__keyDown,t_key)[dbg_index]){
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<192>";
					dbg_array(this.m__keyDown,t_key)[dbg_index]=true
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<193>";
					this.p_PutKeyHit(t_key);
				}
			}else{
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<196>";
				dbg_array(this.m__keyDown,t_key)[dbg_index]=false
			}
		}
	}
	pop_err();
}
c_InputDevice.prototype.p_EndUpdate=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<203>";
	for(var t_i=0;t_i<this.m__keyHitPut;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<204>";
		dbg_array(this.m__keyHit,dbg_array(this.m__keyHitQueue,t_i)[dbg_index])[dbg_index]=0
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<206>";
	this.m__keyHitPut=0;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<207>";
	this.m__charGet=0;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<208>";
	this.m__charPut=0;
	pop_err();
}
c_InputDevice.prototype.p_KeyEvent=function(t_event,t_data){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<107>";
	var t_1=t_event;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<108>";
	if(t_1==1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<109>";
		if(!dbg_array(this.m__keyDown,t_data)[dbg_index]){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<110>";
			dbg_array(this.m__keyDown,t_data)[dbg_index]=true
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<111>";
			this.p_PutKeyHit(t_data);
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<112>";
			if(t_data==1){
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<113>";
				dbg_array(this.m__keyDown,384)[dbg_index]=true
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<114>";
				this.p_PutKeyHit(384);
			}else{
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<115>";
				if(t_data==384){
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<116>";
					dbg_array(this.m__keyDown,1)[dbg_index]=true
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<117>";
					this.p_PutKeyHit(1);
				}
			}
		}
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<120>";
		if(t_1==2){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<121>";
			if(dbg_array(this.m__keyDown,t_data)[dbg_index]){
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<122>";
				dbg_array(this.m__keyDown,t_data)[dbg_index]=false
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<123>";
				if(t_data==1){
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<124>";
					dbg_array(this.m__keyDown,384)[dbg_index]=false
				}else{
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<125>";
					if(t_data==384){
						err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<126>";
						dbg_array(this.m__keyDown,1)[dbg_index]=false
					}
				}
			}
		}else{
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<129>";
			if(t_1==3){
				err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<130>";
				if(this.m__charPut<this.m__charQueue.length){
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<131>";
					dbg_array(this.m__charQueue,this.m__charPut)[dbg_index]=t_data
					err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<132>";
					this.m__charPut+=1;
				}
			}
		}
	}
	pop_err();
}
c_InputDevice.prototype.p_MouseEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<138>";
	var t_2=t_event;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<139>";
	if(t_2==4){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<140>";
		this.p_KeyEvent(1,1+t_data);
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<141>";
		if(t_2==5){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<142>";
			this.p_KeyEvent(2,1+t_data);
			pop_err();
			return;
		}else{
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<144>";
			if(t_2==6){
			}else{
				pop_err();
				return;
			}
		}
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<148>";
	this.m__mouseX=t_x;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<149>";
	this.m__mouseY=t_y;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<150>";
	dbg_array(this.m__touchX,0)[dbg_index]=t_x
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<151>";
	dbg_array(this.m__touchY,0)[dbg_index]=t_y
	pop_err();
}
c_InputDevice.prototype.p_TouchEvent=function(t_event,t_data,t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<155>";
	var t_3=t_event;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<156>";
	if(t_3==7){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<157>";
		this.p_KeyEvent(1,384+t_data);
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<158>";
		if(t_3==8){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<159>";
			this.p_KeyEvent(2,384+t_data);
			pop_err();
			return;
		}else{
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<161>";
			if(t_3==9){
			}else{
				pop_err();
				return;
			}
		}
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<165>";
	dbg_array(this.m__touchX,t_data)[dbg_index]=t_x
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<166>";
	dbg_array(this.m__touchY,t_data)[dbg_index]=t_y
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<167>";
	if(t_data==0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<168>";
		this.m__mouseX=t_x;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<169>";
		this.m__mouseY=t_y;
	}
	pop_err();
}
c_InputDevice.prototype.p_MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<174>";
	var t_4=t_event;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<175>";
	if(t_4==10){
	}else{
		pop_err();
		return;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<179>";
	this.m__accelX=t_x;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<180>";
	this.m__accelY=t_y;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<181>";
	this.m__accelZ=t_z;
	pop_err();
}
c_InputDevice.prototype.p_TouchX=function(t_index){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<73>";
	if(t_index>=0 && t_index<32){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<73>";
		var t_=dbg_array(this.m__touchX,t_index)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<74>";
	pop_err();
	return 0.0;
}
c_InputDevice.prototype.p_TouchY=function(t_index){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<78>";
	if(t_index>=0 && t_index<32){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<78>";
		var t_=dbg_array(this.m__touchY,t_index)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<79>";
	pop_err();
	return 0.0;
}
c_InputDevice.prototype.p_KeyHit=function(t_key){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<48>";
	if(t_key>0 && t_key<512){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<48>";
		var t_=dbg_array(this.m__keyHit,t_key)[dbg_index];
		pop_err();
		return t_;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<49>";
	pop_err();
	return 0;
}
function c_JoyState(){
	Object.call(this);
	this.m_joyx=new_number_array(2);
	this.m_joyy=new_number_array(2);
	this.m_joyz=new_number_array(2);
	this.m_buttons=new_bool_array(32);
}
c_JoyState.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/inputdevice.monkey<10>";
	pop_err();
	return this;
}
var bb_input_device=null;
function bb_input_SetInputDevice(t_dev){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/input.monkey<18>";
	bb_input_device=t_dev;
	pop_err();
	return 0;
}
var bb_graphics_renderDevice=null;
function bb_graphics_SetMatrix(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<307>";
	dbg_object(bb_graphics_context).m_ix=t_ix;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<308>";
	dbg_object(bb_graphics_context).m_iy=t_iy;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<309>";
	dbg_object(bb_graphics_context).m_jx=t_jx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<310>";
	dbg_object(bb_graphics_context).m_jy=t_jy;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<311>";
	dbg_object(bb_graphics_context).m_tx=t_tx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<312>";
	dbg_object(bb_graphics_context).m_ty=t_ty;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<313>";
	dbg_object(bb_graphics_context).m_tformed=((t_ix!=1.0 || t_iy!=0.0 || t_jx!=0.0 || t_jy!=1.0 || t_tx!=0.0 || t_ty!=0.0)?1:0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<314>";
	dbg_object(bb_graphics_context).m_matDirty=1;
	pop_err();
	return 0;
}
function bb_graphics_SetMatrix2(t_m){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<303>";
	bb_graphics_SetMatrix(dbg_array(t_m,0)[dbg_index],dbg_array(t_m,1)[dbg_index],dbg_array(t_m,2)[dbg_index],dbg_array(t_m,3)[dbg_index],dbg_array(t_m,4)[dbg_index],dbg_array(t_m,5)[dbg_index]);
	pop_err();
	return 0;
}
function bb_graphics_SetColor(t_r,t_g,t_b){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<249>";
	dbg_object(bb_graphics_context).m_color_r=t_r;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<250>";
	dbg_object(bb_graphics_context).m_color_g=t_g;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<251>";
	dbg_object(bb_graphics_context).m_color_b=t_b;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<252>";
	bb_graphics_renderDevice.SetColor(t_r,t_g,t_b);
	pop_err();
	return 0;
}
function bb_graphics_SetAlpha(t_alpha){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<266>";
	dbg_object(bb_graphics_context).m_alpha=t_alpha;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<267>";
	bb_graphics_renderDevice.SetAlpha(t_alpha);
	pop_err();
	return 0;
}
function bb_graphics_SetBlend(t_blend){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<275>";
	dbg_object(bb_graphics_context).m_blend=t_blend;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<276>";
	bb_graphics_renderDevice.SetBlend(t_blend);
	pop_err();
	return 0;
}
function bb_graphics_DeviceWidth(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<226>";
	var t_=bb_graphics_device.Width();
	pop_err();
	return t_;
}
function bb_graphics_DeviceHeight(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<230>";
	var t_=bb_graphics_device.Height();
	pop_err();
	return t_;
}
function bb_graphics_SetScissor(t_x,t_y,t_width,t_height){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<284>";
	dbg_object(bb_graphics_context).m_scissor_x=t_x;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<285>";
	dbg_object(bb_graphics_context).m_scissor_y=t_y;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<286>";
	dbg_object(bb_graphics_context).m_scissor_width=t_width;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<287>";
	dbg_object(bb_graphics_context).m_scissor_height=t_height;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<288>";
	bb_graphics_renderDevice.SetScissor(((t_x)|0),((t_y)|0),((t_width)|0),((t_height)|0));
	pop_err();
	return 0;
}
function bb_graphics_BeginRender(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<212>";
	bb_graphics_renderDevice=bb_graphics_device;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<213>";
	dbg_object(bb_graphics_context).m_matrixSp=0;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<214>";
	bb_graphics_SetMatrix(1.0,0.0,0.0,1.0,0.0,0.0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<215>";
	bb_graphics_SetColor(255.0,255.0,255.0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<216>";
	bb_graphics_SetAlpha(1.0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<217>";
	bb_graphics_SetBlend(0);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<218>";
	bb_graphics_SetScissor(0.0,0.0,(bb_graphics_DeviceWidth()),(bb_graphics_DeviceHeight()));
	pop_err();
	return 0;
}
function bb_graphics_EndRender(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<222>";
	bb_graphics_renderDevice=null;
	pop_err();
	return 0;
}
function c_BBGameEvent(){
	Object.call(this);
}
function bb_app_EndApp(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<192>";
	error("");
	pop_err();
	return 0;
}
var bb_app__updateRate=0;
function bb_app_SetUpdateRate(t_hertz){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<157>";
	bb_app__updateRate=t_hertz;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<158>";
	bb_app__game.SetUpdateRate(t_hertz);
	pop_err();
	return 0;
}
function bb_app_Millisecs(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<166>";
	var t_=bb_app__game.Millisecs();
	pop_err();
	return t_;
}
var bb_random_Seed=0;
function c_DeltaTimer(){
	Object.call(this);
	this.m_targetfps=30.0;
	this.m_lastticks=.0;
}
c_DeltaTimer.m_new=function(t_fps){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<595>";
	this.m_targetfps=t_fps;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<596>";
	this.m_lastticks=(bb_app_Millisecs());
	pop_err();
	return this;
}
c_DeltaTimer.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<586>";
	pop_err();
	return this;
}
var bb_pickel_dt=null;
var bb_pickel_smallFontImg=null;
var bb_pickel_fontImg=null;
var bb_pickel_ooohImg=null;
var bb_pickel_baahImg=null;
var bb_pickel_introImg=null;
var bb_pickel_pointerImg=null;
var bb_pickel_backgroundImg=null;
var bb_pickel_blackheadsImg=null;
var bb_pickel_particlesImg=null;
var bb_pickel_cubesImg=null;
var bb_pickel_DerHaseImg=null;
var bb_pickel_blinkImg=null;
function bb_app_HideMouse(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/app.monkey<184>";
	bb_app__game.SetMouseVisible(false);
	pop_err();
	return 0;
}
function c_Sound(){
	Object.call(this);
	this.m_sample=null;
}
c_Sound.m_new=function(t_sample){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<28>";
	dbg_object(this).m_sample=t_sample;
	pop_err();
	return this;
}
c_Sound.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<25>";
	pop_err();
	return this;
}
function bb_audio_LoadSound(t_path){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<43>";
	var t_sample=bb_audio_device.LoadSample(bb_data_FixDataPath(t_path));
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<44>";
	if((t_sample)!=null){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<44>";
		var t_=c_Sound.m_new.call(new c_Sound,t_sample);
		pop_err();
		return t_;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<45>";
	pop_err();
	return null;
}
var bb_pickel_healSnd=null;
var bb_pickel_plopSnd=null;
function bb_audio_PlayMusic(t_path,t_flags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<81>";
	var t_=bb_audio_device.PlayMusic(bb_data_FixDataPath(t_path),t_flags);
	pop_err();
	return t_;
}
var bb_pickel_gameStatus=0;
function bb_graphics_DebugRenderDevice(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<48>";
	if(!((bb_graphics_renderDevice)!=null)){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<48>";
		error("Rendering operations can only be performed inside OnRender");
	}
	pop_err();
	return 0;
}
function bb_graphics_DrawImage(t_image,t_x,t_y,t_frame){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<445>";
	bb_graphics_DebugRenderDevice();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<446>";
	if(t_frame<0 || t_frame>=dbg_object(t_image).m_frames.length){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<446>";
		error("Invalid image frame");
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<449>";
	var t_f=dbg_array(dbg_object(t_image).m_frames,t_frame)[dbg_index];
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<451>";
	bb_graphics_context.p_Validate();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<453>";
	if((dbg_object(t_image).m_flags&65536)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<454>";
		bb_graphics_renderDevice.DrawSurface(dbg_object(t_image).m_surface,t_x-dbg_object(t_image).m_tx,t_y-dbg_object(t_image).m_ty);
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<456>";
		bb_graphics_renderDevice.DrawSurface2(dbg_object(t_image).m_surface,t_x-dbg_object(t_image).m_tx,t_y-dbg_object(t_image).m_ty,dbg_object(t_f).m_x,dbg_object(t_f).m_y,dbg_object(t_image).m_width,dbg_object(t_image).m_height);
	}
	pop_err();
	return 0;
}
function bb_graphics_PushMatrix(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<328>";
	var t_sp=dbg_object(bb_graphics_context).m_matrixSp;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<329>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+0)[dbg_index]=dbg_object(bb_graphics_context).m_ix
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<330>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+1)[dbg_index]=dbg_object(bb_graphics_context).m_iy
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<331>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+2)[dbg_index]=dbg_object(bb_graphics_context).m_jx
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<332>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+3)[dbg_index]=dbg_object(bb_graphics_context).m_jy
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<333>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+4)[dbg_index]=dbg_object(bb_graphics_context).m_tx
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<334>";
	dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+5)[dbg_index]=dbg_object(bb_graphics_context).m_ty
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<335>";
	dbg_object(bb_graphics_context).m_matrixSp=t_sp+6;
	pop_err();
	return 0;
}
function bb_graphics_Transform(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<349>";
	var t_ix2=t_ix*dbg_object(bb_graphics_context).m_ix+t_iy*dbg_object(bb_graphics_context).m_jx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<350>";
	var t_iy2=t_ix*dbg_object(bb_graphics_context).m_iy+t_iy*dbg_object(bb_graphics_context).m_jy;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<351>";
	var t_jx2=t_jx*dbg_object(bb_graphics_context).m_ix+t_jy*dbg_object(bb_graphics_context).m_jx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<352>";
	var t_jy2=t_jx*dbg_object(bb_graphics_context).m_iy+t_jy*dbg_object(bb_graphics_context).m_jy;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<353>";
	var t_tx2=t_tx*dbg_object(bb_graphics_context).m_ix+t_ty*dbg_object(bb_graphics_context).m_jx+dbg_object(bb_graphics_context).m_tx;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<354>";
	var t_ty2=t_tx*dbg_object(bb_graphics_context).m_iy+t_ty*dbg_object(bb_graphics_context).m_jy+dbg_object(bb_graphics_context).m_ty;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<355>";
	bb_graphics_SetMatrix(t_ix2,t_iy2,t_jx2,t_jy2,t_tx2,t_ty2);
	pop_err();
	return 0;
}
function bb_graphics_Transform2(t_m){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<345>";
	bb_graphics_Transform(dbg_array(t_m,0)[dbg_index],dbg_array(t_m,1)[dbg_index],dbg_array(t_m,2)[dbg_index],dbg_array(t_m,3)[dbg_index],dbg_array(t_m,4)[dbg_index],dbg_array(t_m,5)[dbg_index]);
	pop_err();
	return 0;
}
function bb_graphics_Translate(t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<359>";
	bb_graphics_Transform(1.0,0.0,0.0,1.0,t_x,t_y);
	pop_err();
	return 0;
}
function bb_graphics_Rotate(t_angle){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<367>";
	bb_graphics_Transform(Math.cos((t_angle)*D2R),-Math.sin((t_angle)*D2R),Math.sin((t_angle)*D2R),Math.cos((t_angle)*D2R),0.0,0.0);
	pop_err();
	return 0;
}
function bb_graphics_Scale(t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<363>";
	bb_graphics_Transform(t_x,0.0,0.0,t_y,0.0,0.0);
	pop_err();
	return 0;
}
function bb_graphics_PopMatrix(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<339>";
	var t_sp=dbg_object(bb_graphics_context).m_matrixSp-6;
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<340>";
	bb_graphics_SetMatrix(dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+0)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+1)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+2)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+3)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+4)[dbg_index],dbg_array(dbg_object(bb_graphics_context).m_matrixStack,t_sp+5)[dbg_index]);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<341>";
	dbg_object(bb_graphics_context).m_matrixSp=t_sp;
	pop_err();
	return 0;
}
function bb_graphics_DrawImage2(t_image,t_x,t_y,t_rotation,t_scaleX,t_scaleY,t_frame){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<463>";
	bb_graphics_DebugRenderDevice();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<464>";
	if(t_frame<0 || t_frame>=dbg_object(t_image).m_frames.length){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<464>";
		error("Invalid image frame");
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<467>";
	var t_f=dbg_array(dbg_object(t_image).m_frames,t_frame)[dbg_index];
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<469>";
	bb_graphics_PushMatrix();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<471>";
	bb_graphics_Translate(t_x,t_y);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<472>";
	bb_graphics_Rotate(t_rotation);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<473>";
	bb_graphics_Scale(t_scaleX,t_scaleY);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<475>";
	bb_graphics_Translate(-dbg_object(t_image).m_tx,-dbg_object(t_image).m_ty);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<477>";
	bb_graphics_context.p_Validate();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<479>";
	if((dbg_object(t_image).m_flags&65536)!=0){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<480>";
		bb_graphics_renderDevice.DrawSurface(dbg_object(t_image).m_surface,0.0,0.0);
	}else{
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<482>";
		bb_graphics_renderDevice.DrawSurface2(dbg_object(t_image).m_surface,0.0,0.0,dbg_object(t_f).m_x,dbg_object(t_f).m_y,dbg_object(t_image).m_width,dbg_object(t_image).m_height);
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<485>";
	bb_graphics_PopMatrix();
	pop_err();
	return 0;
}
var bb_pickel_blink=0;
function bb_random_Rnd(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/random.monkey<21>";
	bb_random_Seed=bb_random_Seed*1664525+1013904223|0;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/random.monkey<22>";
	var t_=(bb_random_Seed>>8&16777215)/16777216.0;
	pop_err();
	return t_;
}
function bb_random_Rnd2(t_low,t_high){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/random.monkey<30>";
	var t_=bb_random_Rnd3(t_high-t_low)+t_low;
	pop_err();
	return t_;
}
function bb_random_Rnd3(t_range){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/random.monkey<26>";
	var t_=bb_random_Rnd()*t_range;
	pop_err();
	return t_;
}
var bb_pickel_timeline=0;
function bb_graphics_DrawText(t_text,t_x,t_y,t_xalign,t_yalign){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<570>";
	bb_graphics_DebugRenderDevice();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<572>";
	if(!((dbg_object(bb_graphics_context).m_font)!=null)){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<572>";
		pop_err();
		return 0;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<574>";
	var t_w=dbg_object(bb_graphics_context).m_font.p_Width();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<575>";
	var t_h=dbg_object(bb_graphics_context).m_font.p_Height();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<577>";
	t_x-=Math.floor((t_w*t_text.length)*t_xalign);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<578>";
	t_y-=Math.floor((t_h)*t_yalign);
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<580>";
	for(var t_i=0;t_i<t_text.length;t_i=t_i+1){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<581>";
		var t_ch=dbg_charCodeAt(t_text,t_i)-dbg_object(bb_graphics_context).m_firstChar;
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<582>";
		if(t_ch>=0 && t_ch<dbg_object(bb_graphics_context).m_font.p_Frames()){
			err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<583>";
			bb_graphics_DrawImage(dbg_object(bb_graphics_context).m_font,t_x+(t_i*t_w),t_y,t_ch);
		}
	}
	pop_err();
	return 0;
}
function c_Sprite(){
	Object.call(this);
	this.m_image=null;
	this.m_x=.0;
	this.m_y=.0;
	this.m_w=0;
	this.m_h=0;
	this.m_scale=.0;
	this.m_speed=.0;
	this.m_frame=0;
	this.m_alpha=.0;
	this.m_direction=0;
	this.m_maxXSpeed=.0;
	this.m_speedX=.0;
	this.m_speedY=.0;
	this.m_rotation=.0;
}
c_Sprite.m_new=function(t_img,t_x,t_y){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<374>";
	dbg_object(this).m_image=t_img;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<375>";
	dbg_object(this).m_x=t_x;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<376>";
	dbg_object(this).m_y=t_y;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<377>";
	dbg_object(this).m_w=t_img.p_Width();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<378>";
	dbg_object(this).m_h=t_img.p_Height();
	pop_err();
	return this;
}
c_Sprite.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<356>";
	pop_err();
	return this;
}
c_Sprite.prototype.p_grow=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<453>";
	if(dbg_object(this).m_scale<0.62){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<454>";
		dbg_object(this).m_scale=dbg_object(this).m_scale*dbg_object(this).m_speed;
	}else{
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<456>";
		dbg_object(this).m_alpha=dbg_object(this).m_alpha-0.0025;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<458>";
		if(dbg_object(this).m_frame!=2){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<459>";
			bb_pickel_createExplosion(bb_pickel_particlesImg,((dbg_object(this).m_x)|0),((dbg_object(this).m_y)|0),50,dbg_object(this).m_frame);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<460>";
			bb_pickel_beauty=bb_pickel_beauty-10;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<461>";
			bb_audio_PlaySound(bb_pickel_plopSnd,bb_pickel_channel,0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<462>";
			bb_pickel_channel=(bb_pickel_channel+1) % 7;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<463>";
			if(bb_pickel_beauty<0){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<464>";
				bb_pickel_beauty=0;
			}
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<466>";
			dbg_object(this).m_frame=2;
		}
	}
	pop_err();
}
c_Sprite.prototype.p_plop=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<437>";
	if(bb_pickel_touch00>0 && this.m_frame<2){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<438>";
		if(Math.sqrt(Math.pow(this.m_x-bb_input_TouchX(0),2.0)+Math.pow(this.m_y-bb_input_TouchY(0),2.0))<=45.0*this.m_scale+6.0){
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<439>";
			this.m_speed=0.0;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<440>";
			bb_pickel_createCube(bb_pickel_cubesImg,((dbg_object(this).m_x)|0),((dbg_object(this).m_y)|0),3);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<441>";
			bb_pickel_score=bb_pickel_score+500;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<442>";
			bb_audio_PlaySound(bb_pickel_healSnd,bb_pickel_channel,0);
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<443>";
			bb_pickel_channel=(bb_pickel_channel+1) % 7;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<444>";
			bb_pickel_beauty=bb_pickel_beauty+5;
			err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<445>";
			if(bb_pickel_beauty>100){
				err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<446>";
				bb_pickel_beauty=100;
			}
		}
	}
	pop_err();
}
c_Sprite.prototype.p_draw=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<430>";
	this.m_image.p_SetHandle((this.m_image.p_Width())*0.5,(this.m_image.p_Height())*0.5);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<431>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<432>";
	bb_graphics_DrawImage2(this.m_image,this.m_x,this.m_y,0.0,this.m_scale,this.m_scale,this.m_frame);
	pop_err();
}
c_Sprite.prototype.p_move=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<422>";
	dbg_object(this).m_x=dbg_object(this).m_x+dbg_object(this).m_speedX;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<423>";
	dbg_object(this).m_y=dbg_object(this).m_y+dbg_object(this).m_speedY;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<424>";
	dbg_object(this).m_speedY=dbg_object(this).m_speedY+1.5+dbg_object(this).m_scale;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<425>";
	dbg_object(this).m_scale=dbg_object(this).m_scale*dbg_object(this).m_speed;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<426>";
	dbg_object(this).m_alpha=dbg_object(this).m_alpha-0.015;
	pop_err();
}
c_Sprite.prototype.p_doCube=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<410>";
	this.m_image.p_SetHandle((this.m_image.p_Width())*0.5,(this.m_image.p_Height())*0.5);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<411>";
	bb_graphics_SetAlpha(dbg_object(this).m_alpha);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<412>";
	dbg_object(this).m_scale=dbg_object(this).m_scale*dbg_object(this).m_speed;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<413>";
	dbg_object(this).m_alpha=dbg_object(this).m_alpha-0.025;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<414>";
	bb_graphics_SetBlend(1);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<415>";
	dbg_object(this).m_frame=(dbg_object(this).m_frame+1) % 12;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<417>";
	bb_graphics_DrawImage2(this.m_image,this.m_x,this.m_y,0.0,this.m_scale,this.m_scale,this.m_frame);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<418>";
	bb_graphics_SetBlend(0);
	pop_err();
}
c_Sprite.prototype.p_doDerHase=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<389>";
	this.m_image.p_SetHandle((this.m_image.p_Width())*0.5,(this.m_image.p_Height())*0.5);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<394>";
	bb_graphics_PushMatrix();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<395>";
	bb_graphics_Translate(this.m_x,this.m_y);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<396>";
	bb_graphics_Rotate(this.m_rotation);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<397>";
	bb_graphics_DrawImage2(this.m_image,0.0,0.0,0.0,this.m_scale,this.m_scale,0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<398>";
	bb_graphics_PopMatrix();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<399>";
	this.m_rotation=(this.m_rotation+this.m_speed) % 360.0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<400>";
	this.m_x=this.m_x+this.m_speed;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<401>";
	if(this.m_x>2420.0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<402>";
		this.m_x=-500.0;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<403>";
		this.m_speed=bb_random_Rnd2(8.0,17.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<404>";
		this.m_scale=bb_random_Rnd2(0.2,1.0);
	}
	pop_err();
}
function c_List(){
	Object.call(this);
	this.m__head=(c_HeadNode.m_new.call(new c_HeadNode));
}
c_List.m_new=function(){
	push_err();
	pop_err();
	return this;
}
c_List.prototype.p_AddLast=function(t_data){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<106>";
	var t_=c_Node.m_new.call(new c_Node,this.m__head,dbg_object(this.m__head).m__pred,t_data);
	pop_err();
	return t_;
}
c_List.m_new2=function(t_data){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
	var t_=t_data;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
	var t_2=0;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
	while(t_2<t_.length){
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
		var t_t=dbg_array(t_,t_2)[dbg_index];
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<13>";
		t_2=t_2+1;
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<14>";
		this.p_AddLast(t_t);
	}
	pop_err();
	return this;
}
c_List.prototype.p_ObjectEnumerator=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<179>";
	var t_=c_Enumerator.m_new.call(new c_Enumerator,this);
	pop_err();
	return t_;
}
c_List.prototype.p_Equals=function(t_lhs,t_rhs){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<28>";
	var t_=t_lhs==t_rhs;
	pop_err();
	return t_;
}
c_List.prototype.p_RemoveEach=function(t_value){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<144>";
	var t_node=dbg_object(this.m__head).m__succ;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<145>";
	while(t_node!=this.m__head){
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<146>";
		var t_succ=dbg_object(t_node).m__succ;
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<147>";
		if(this.p_Equals(dbg_object(t_node).m__data,t_value)){
			err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<147>";
			t_node.p_Remove();
		}
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<148>";
		t_node=t_succ;
	}
	pop_err();
	return 0;
}
function c_Node(){
	Object.call(this);
	this.m__succ=null;
	this.m__pred=null;
	this.m__data=null;
}
c_Node.m_new=function(t_succ,t_pred,t_data){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<254>";
	this.m__succ=t_succ;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<255>";
	this.m__pred=t_pred;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<256>";
	dbg_object(this.m__succ).m__pred=this;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<257>";
	dbg_object(this.m__pred).m__succ=this;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<258>";
	this.m__data=t_data;
	pop_err();
	return this;
}
c_Node.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<251>";
	pop_err();
	return this;
}
c_Node.prototype.p_Remove=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<267>";
	if(dbg_object(this.m__succ).m__pred!=this){
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<267>";
		error("Illegal operation on removed node");
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<269>";
	dbg_object(this.m__succ).m__pred=this.m__pred;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<270>";
	dbg_object(this.m__pred).m__succ=this.m__succ;
	pop_err();
	return 0;
}
function c_HeadNode(){
	c_Node.call(this);
}
c_HeadNode.prototype=extend_class(c_Node);
c_HeadNode.m_new=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<303>";
	c_Node.m_new2.call(this);
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<304>";
	this.m__succ=(this);
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<305>";
	this.m__pred=(this);
	pop_err();
	return this;
}
var bb_pickel_listSpots=null;
function c_Enumerator(){
	Object.call(this);
	this.m__list=null;
	this.m__curr=null;
}
c_Enumerator.m_new=function(t_list){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<319>";
	this.m__list=t_list;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<320>";
	this.m__curr=dbg_object(dbg_object(t_list).m__head).m__succ;
	pop_err();
	return this;
}
c_Enumerator.m_new2=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<316>";
	pop_err();
	return this;
}
c_Enumerator.prototype.p_HasNext=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<324>";
	while(dbg_object(dbg_object(this.m__curr).m__succ).m__pred!=this.m__curr){
		err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<325>";
		this.m__curr=dbg_object(this.m__curr).m__succ;
	}
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<327>";
	var t_=this.m__curr!=dbg_object(this.m__list).m__head;
	pop_err();
	return t_;
}
c_Enumerator.prototype.p_NextObject=function(){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<331>";
	var t_data=dbg_object(this.m__curr).m__data;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<332>";
	this.m__curr=dbg_object(this.m__curr).m__succ;
	err_info="C:/Monkey/MonkeyPro70g/modules/monkey/list.monkey<333>";
	pop_err();
	return t_data;
}
var bb_pickel_listParticles=null;
function bb_pickel_createExplosion(t_image,t_x,t_y,t_amount,t_color){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<555>";
	for(var t_amount2=0;t_amount2<=100;t_amount2=t_amount2+1){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<556>";
		var t_d=null;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<557>";
		t_d=c_Sprite.m_new.call(new c_Sprite,t_image,(t_x)+bb_random_Rnd2(-40.0,40.0),(t_y)+bb_random_Rnd2(-40.0,40.0));
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<558>";
		dbg_object(t_d).m_scale=bb_random_Rnd2(0.1,0.3);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<559>";
		dbg_object(t_d).m_speed=bb_random_Rnd2(1.0,1.1);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<560>";
		dbg_object(t_d).m_direction=((bb_random_Rnd3(360.0))|0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<561>";
		dbg_object(t_d).m_maxXSpeed=bb_random_Rnd2(20.0,35.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<562>";
		dbg_object(t_d).m_speedX=dbg_object(t_d).m_maxXSpeed*Math.cos((dbg_object(t_d).m_direction)*D2R);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<563>";
		dbg_object(t_d).m_speedY=dbg_object(t_d).m_maxXSpeed*Math.sin((dbg_object(t_d).m_direction)*D2R);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<564>";
		dbg_object(t_d).m_frame=((bb_random_Rnd3(1.1)+(2*t_color))|0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<565>";
		dbg_object(t_d).m_alpha=1.0;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<566>";
		bb_pickel_listParticles.p_AddLast(t_d);
	}
	pop_err();
	return 0;
}
var bb_pickel_beauty=0;
var bb_pickel_channel=0;
function bb_audio_PlaySound(t_sound,t_channel,t_flags){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<49>";
	if(((t_sound)!=null) && ((dbg_object(t_sound).m_sample)!=null)){
		err_info="C:/Monkey/MonkeyPro70g/modules/mojo/audio.monkey<49>";
		bb_audio_device.PlaySample(dbg_object(t_sound).m_sample,t_channel,t_flags);
	}
	pop_err();
	return 0;
}
var bb_pickel_touch00=0;
function bb_input_TouchX(t_index){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/input.monkey<72>";
	var t_=bb_input_device.p_TouchX(t_index);
	pop_err();
	return t_;
}
function bb_input_TouchY(t_index){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/input.monkey<76>";
	var t_=bb_input_device.p_TouchY(t_index);
	pop_err();
	return t_;
}
var bb_pickel_listCubes=null;
function bb_pickel_createCube(t_image,t_x,t_y,t_amount){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<493>";
	var t_d=null;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<494>";
	t_d=c_Sprite.m_new.call(new c_Sprite,t_image,(t_x),(t_y));
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<495>";
	dbg_object(t_d).m_scale=0.1;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<496>";
	dbg_object(t_d).m_speed=1.2;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<497>";
	dbg_object(t_d).m_frame=((bb_random_Rnd2(0.0,11.0))|0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<498>";
	dbg_object(t_d).m_alpha=1.0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<499>";
	bb_pickel_listCubes.p_AddLast(t_d);
	pop_err();
	return 0;
}
var bb_pickel_score=0;
var bb_pickel_hiscore=0;
var bb_pickel_spotrate=0;
function bb_graphics_DrawRect(t_x,t_y,t_w,t_h){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<387>";
	bb_graphics_DebugRenderDevice();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<389>";
	bb_graphics_context.p_Validate();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/graphics.monkey<390>";
	bb_graphics_renderDevice.DrawRect(t_x,t_y,t_w,t_h);
	pop_err();
	return 0;
}
function bb_pickel_createDerHase(t_image){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<571>";
	for(var t_n=0;t_n<=20;t_n=t_n+1){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<572>";
		var t_d=null;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<573>";
		t_d=c_Sprite.m_new.call(new c_Sprite,t_image,bb_random_Rnd3(2920.0)-500.0,bb_random_Rnd3(1080.0));
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<574>";
		dbg_object(t_d).m_scale=bb_random_Rnd2(0.2,1.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<575>";
		dbg_object(t_d).m_speed=bb_random_Rnd2(8.0,17.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<576>";
		dbg_object(t_d).m_rotation=bb_random_Rnd3(360.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<577>";
		dbg_object(t_d).m_direction=((bb_random_Rnd3(360.0))|0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<578>";
		dbg_object(t_d).m_maxXSpeed=bb_random_Rnd2(20.0,35.0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<579>";
		dbg_object(t_d).m_speedX=dbg_object(t_d).m_maxXSpeed*Math.cos((dbg_object(t_d).m_direction)*D2R);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<580>";
		dbg_object(t_d).m_speedY=dbg_object(t_d).m_maxXSpeed*Math.sin((dbg_object(t_d).m_direction)*D2R);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<581>";
		bb_pickel_listParticles.p_AddLast(t_d);
	}
	pop_err();
	return 0;
}
function bb_input_TouchHit(t_index){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/modules/mojo/input.monkey<84>";
	var t_=bb_input_device.p_KeyHit(384+t_index);
	pop_err();
	return t_;
}
function bb_pickel_rectsOverlap(t_x0,t_y0,t_w0,t_h0,t_x2,t_y2,t_w2,t_h2){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<482>";
	if(t_x0>t_x2+t_w2 || t_x0+t_w0<t_x2){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<482>";
		pop_err();
		return 0;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<483>";
	if(t_y0>t_y2+t_h2 || t_y0+t_h0<t_y2){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<483>";
		pop_err();
		return 0;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<484>";
	pop_err();
	return 1;
}
function bb_pickel_createSpot(t_image){
	push_err();
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<504>";
	var t_d=null;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<505>";
	var t_xt=0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<506>";
	var t_yt=0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<507>";
	var t_c=0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<508>";
	t_c=0;
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<509>";
	t_xt=((bb_random_Rnd2(80.0,1840.0))|0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<510>";
	t_yt=((bb_random_Rnd2(80.0,1000.0))|0);
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<511>";
	if((bb_pickel_rectsOverlap(0.0,0.0,66.0,324.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<512>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<514>";
	if((bb_pickel_rectsOverlap(0.0,812.0,202.0,268.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<515>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<517>";
	if((bb_pickel_rectsOverlap(528.0,170.0,234.0,242.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<518>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<520>";
	if((bb_pickel_rectsOverlap(428.0,212.0,414.0,162.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<521>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<523>";
	if((bb_pickel_rectsOverlap(810.0,524.0,360.0,130.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<524>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<526>";
	if((bb_pickel_rectsOverlap(1152.0,222.0,388.0,160.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<527>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<529>";
	if((bb_pickel_rectsOverlap(1222.0,188.0,244.0,244.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<530>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<532>";
	if((bb_pickel_rectsOverlap(737.0,801.0,528.0,86.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<533>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<535>";
	if((bb_pickel_rectsOverlap(854.0,756.0,269.0,169.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<536>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<538>";
	if((bb_pickel_rectsOverlap(1856.0,0.0,65.0,323.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<539>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<541>";
	if((bb_pickel_rectsOverlap(1758.0,782.0,158.0,302.0,(t_xt-30),(t_yt-30),60.0,60.0))!=0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<542>";
		t_c=1;
	}
	err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<544>";
	if(t_c==0){
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<545>";
		t_d=c_Sprite.m_new.call(new c_Sprite,t_image,(t_xt),(t_yt));
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<546>";
		dbg_object(t_d).m_scale=0.03;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<547>";
		dbg_object(t_d).m_speed=bb_random_Rnd2(1.010,1.040);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<548>";
		dbg_object(t_d).m_frame=((bb_random_Rnd2(0.0,1.2))|0);
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<549>";
		dbg_object(t_d).m_alpha=1.0;
		err_info="C:/Monkey/MonkeyPro70g/projects/Pickel/pickel.monkey<550>";
		bb_pickel_listSpots.p_AddLast(t_d);
	}
	pop_err();
	return 0;
}
function bbInit(){
	bb_app__app=null;
	bb_app__delegate=null;
	bb_app__game=BBGame.Game();
	bb_pickel_app=null;
	bb_graphics_device=null;
	bb_graphics_context=c_GraphicsContext.m_new.call(new c_GraphicsContext);
	c_Image.m_DefaultFlags=0;
	bb_audio_device=null;
	bb_input_device=null;
	bb_graphics_renderDevice=null;
	c_MyApp.m_FPS=30;
	bb_app__updateRate=0;
	bb_random_Seed=1234;
	bb_pickel_dt=null;
	bb_pickel_smallFontImg=null;
	bb_pickel_fontImg=null;
	bb_pickel_ooohImg=null;
	bb_pickel_baahImg=null;
	bb_pickel_introImg=null;
	bb_pickel_pointerImg=null;
	bb_pickel_backgroundImg=null;
	bb_pickel_blackheadsImg=null;
	bb_pickel_particlesImg=null;
	bb_pickel_cubesImg=null;
	bb_pickel_DerHaseImg=null;
	bb_pickel_blinkImg=null;
	bb_pickel_healSnd=null;
	bb_pickel_plopSnd=null;
	bb_pickel_gameStatus=2;
	bb_pickel_blink=100;
	bb_pickel_timeline=0;
	bb_pickel_listSpots=c_List.m_new.call(new c_List);
	bb_pickel_listParticles=c_List.m_new.call(new c_List);
	bb_pickel_beauty=110;
	bb_pickel_channel=0;
	bb_pickel_touch00=0;
	bb_pickel_listCubes=c_List.m_new.call(new c_List);
	bb_pickel_score=0;
	bb_pickel_hiscore=1000;
	bb_pickel_spotrate=180.0;
}
//${TRANSCODE_END}
