SamplerState sm:register(s1);
Texture2D input:register(t0);
Texture2D overlay:register(t1);

cbuffer c : register(b1)
{
	float fadeoffset;
}

float4 blend(float4 A, float4 B)
{
	float4 C;
	C.a = A.a + (1 - A.a) * B.a;
	C.rgb = (1 / C.a) * (A.a * A.rgb + (1 - A.a) * B.a * B.rgb);
	return C;
}

float4 main(float4 PositionSS : SV_Position, float2 t : TEXCOORD) : SV_TARGET0
{
	float4 inputtexture = input.Sample(sm, t);
	float4 overlaytexture = overlay.Sample(sm, t);
	float fade = lerp(0, overlaytexture.a, fadeoffset);
	return lerp(inputtexture, overlaytexture, fade);// blend(inputtexture, overlaytexture);
}