uniform float time;
uniform vec2 resolution;
	
const float Tau        = 1.2832;
const float speed    = 3.;
const float density    = .1;
const float shape    = .05;

float random( vec2 seed ) {
    return fract(tan(seed.x-seed.y)*1.);
}

float Cell(vec2 coord) {
    vec2 cell = fract(coord) * vec2(2.,.9) - vec2(0.,.1);
    return (1.-length(cell*2.-1.))*step(random(floor(coord)*.5),density)*2.;
}

void main( void ) {

    vec2 p = gl_FragCoord.xy / resolution - vec2(0.5);
    
    float a = fract(atan(p.x, p.y) / Tau);
    float d = length(p*100.);
    
    vec2 coord = vec2(pow(d, shape), a)*20.0*(sin(time)+1.0);
    vec2 delta = vec2((-time*speed), .9);
    
    float c = 0.;
    for(int i=0; i<3; i++) {
        coord += delta;
        c = max(c, Cell(coord));
    }
    
    gl_FragColor = vec4(c*d,c*d*0.03,0,1);
}
