//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDe13cdf8d_b13c_4c61_8c11_72779d80b8ae
{
    public class Class_RGBANoise : FXImageFunction
    {
        //>>> _inputids
        private enum InputId
        {
            Code = 0,
            MinColorR = 1,
            MinColorG = 2,
            MinColorB = 3,
            MinColorA = 4,
            MaxColorR = 5,
            MaxColorG = 6,
            MaxColorB = 7,
            MaxColorA = 8,
            Seed = 9,
            Saturation = 10
        }
        //<<< _inputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Code = inputs[(int)InputId.Code].Eval(context).Text;
            var MinColorR = inputs[(int)InputId.MinColorR].Eval(context).Value;
            var MinColorG = inputs[(int)InputId.MinColorG].Eval(context).Value;
            var MinColorB = inputs[(int)InputId.MinColorB].Eval(context).Value;
            var MinColorA = inputs[(int)InputId.MinColorA].Eval(context).Value;
            var MinColor = new Color4(MinColorR, MinColorG, MinColorB, MinColorA);
            var MaxColorR = inputs[(int)InputId.MaxColorR].Eval(context).Value;
            var MaxColorG = inputs[(int)InputId.MaxColorG].Eval(context).Value;
            var MaxColorB = inputs[(int)InputId.MaxColorB].Eval(context).Value;
            var MaxColorA = inputs[(int)InputId.MaxColorA].Eval(context).Value;
            var MaxColor = new Color4(MaxColorR, MaxColorG, MaxColorB, MaxColorA);
            var Seed = inputs[(int)InputId.Seed].Eval(context).Value;
            var Saturation = inputs[(int)InputId.Saturation].Eval(context).Value;
            //<<< _params

            return PrepareAndEvalOnChange(context, () => {
                ClearRenderTarget(context, new SharpDX.Color4(0, 0, 0, 0));


                Seed %= 321; // Prevent artifacts for big seed values
                //>>> _setup
                {
                    _effect.GetVariableByName("RenderTargetSize").AsVector().Set(new Vector2(_usedViewport.Width, _usedViewport.Height));
                    _effect.GetVariableByName("MinColor").AsVector().Set(new Vector4(MinColorR, MinColorG, MinColorB, MinColorA));
                    _effect.GetVariableByName("MaxColor").AsVector().Set(new Vector4(MaxColorR, MaxColorG, MaxColorB, MaxColorA));
                    _effect.GetVariableByName("Seed").AsScalar().Set(Seed);
                    _effect.GetVariableByName("Saturation").AsScalar().Set(Saturation);
                //<<< _setup

                Render(context);

                //>>> _cleanup
                }
                //<<< _cleanup
            });
        }

    }
}



