// Monumentalne zabytki MMMMMMMDX 
    var video = true;

var fontName = "arial_bold.ttf";
var lightIntensity = {
    "ambient": 255*0.5,
    "diffuse": 255*0.3,
    "specular": 255,
    "direction": {"x":-0.5, "y":-1.0, "z":-0.5}
}
var views = [
//dick
{
    "camera": {
        "position":{"x":0,"y":0,"z":0.8}
        ,"target":{"x":0,"y":0,"z":-0.1}
    }
    ,"censor": {
        "scale":{"x":2,"y":2}
        ,"position":{"x":getScreenWidth()*0.28,"y":getScreenHeight()*0.66}
    }
},
// chest
{
    "camera": {
        "position":
             {"x":-0.4,"y":0.5,"z":0.8}
        ,"target":
            {"x":0.3,"y":0.8,"z":-0.1}
    }
    ,"censor": {
         "scale":{"x":3.5,"y":1}
        ,"position":{"x":getScreenWidth()*0.58,"y":getScreenHeight()*0.43}
    }
},
// right hand
{
    "camera": {
         "position":
             {"x":-0.7,"y":0.6,"z":0.78}
        ,"target":
            {"x":-0.7,"y":0.7,"z":-0.1}
    }
    ,"censor": {
         "scale":{"x":0,"y":0}
        ,"position":{"x":getScreenWidth()*1.0,"y":getScreenHeight()*1.0}
    }
},
// left hand
{
    "camera": {
        "position":
             {"x":0.1,"y":-0.1,"z":0.75}
        ,"target":
            {"x":0.9,"y":0,"z":-0.1}
    }
    ,"censor": {
         "scale":{"x":0,"y":0}
        ,"position":{"x":getScreenWidth()*1.0,"y":getScreenHeight()*1.0}
    }
},
// head
{
    "camera": {
         "position":
             {"x":-0.4,"y":1.0,"z":0.5}
        ,"target":
            {"x":0.3,"y":0.8,"z":-0.1}
    }
    ,"censor": {
         "scale":{"x":2,"y":1}
        ,"position":{"x":getScreenWidth()*0.9,"y":getScreenHeight()*0.8}
    }
},
// view reset
{
    "camera": {
        "position":
             {"x":0.0,"y":0.0,"z":2}
        ,"target":
            {"x":0.0,"y":0,"z":-0.1}
    }
    ,"censor": {
         "scale":{"x":0,"y":0}
        ,"position":{"x":getScreenWidth()*1.0,"y":getScreenHeight()*1.0}
    }
}

];

var activeView = {};

function calcLightIntensity() {
    activeView = views[Sync.getSyncValue('statueXview')];

    var p = Utils.clamp((Math.tan((new Timer()).getTimeInSeconds()*10.0)+1.0)/2.0)*0.3+0.7;
    var xDir = -0.5;
    var zDir = -0.5;
    //if (Sync.getSyncValue('flicker') > 0.0) {
        xDir = [-0.5,0.5,0.0][(Math.floor(Math.random()*30))%3];
        zDir = [-0.5,-0.5,-0.3][(Math.floor(Math.random()*30))%3];
        yDir = [-0.5,0.5,0.0][(Math.floor(Math.random()*30))%3];
        p = Utils.clamp((Math.tan((new Timer()).getTimeInSeconds()*10.0)+1.0)/2.0)*0.1+0.9;
    //}

    lightIntensity = {
        "ambient": 255*0.8*p,
        "diffuse": 255*0.4*p,
        "specular": 255*p,
        "direction": {"x":xDir, "y":yDir, "z":zDir}
    };
}
Demo.prototype.addLight = function(start, duration, layer)
{
    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"begin"}
        ,"lightType": Light.type.DIRECTIONAL
        ,"direction":[
             {"x":"{return lightIntensity.direction.x;}", "y":"{return lightIntensity.direction.y;}", "z":"{return lightIntensity.direction.z;}"}
        ]
        ,"generateShadowMap": false
        ,"specularColor":[
             {"r":"{return lightIntensity.specular;}", "g":"{return lightIntensity.specular;}", "b":"{return lightIntensity.specular;}", "a":255}
        ]
        ,"diffuseColor":[
             {"r":"{return lightIntensity.diffuse;}", "g":"{return lightIntensity.diffuse;}", "b":"{return lightIntensity.diffuse;}", "a":255}
        ]
        ,"ambientColor":[
             {"r":"{return lightIntensity.ambient;}", "g":"{return lightIntensity.ambient;}", "b":"{return lightIntensity.ambient;}", "a":255}
        ]
        ,"runFunction":"{calcLightIntensity();}"
    }]);
}


function getSignalScale(animation)
{
    return ((getSceneTimeFromStart()-animation.start)%animation.signalDuration)/animation.signalDuration*animation.signalScale;
}
function getSignalColor(animation)
{
    return (1-Math.cos((getSceneTimeFromStart()-animation.start)*3.469))/2*255;
}


var tunnelMesh = void null;
var tunnelMesh2 = void null;
var tunnelLineMesh = void null;
var tunnelMeshTexture = void null;
function initTunnel(animation) {
    tunnelMesh = meshNew();
    tunnelMesh2 = meshNew();
    tunnelLineMesh = meshNew();
    if (tunnelMesh2.ptr === void null || tunnelMesh.ptr === void null || tunnelLineMesh.ptr === void null) {
        loggerFatal("Could not initialize Mesh");
    }

    tunnelMeshTexture = imageLoadImage("blinds.png");
    meshMaterialSetTexture(tunnelMesh.ptr, tunnelMeshTexture.ptr, 0);
    meshMaterialSetTexture(tunnelMesh2.ptr, tunnelMeshTexture.ptr, 0);

    var precision = 24;

    meshSetFaceDrawType(tunnelMesh.ptr, TRIANGLES);
    meshSetFaceDrawType(tunnelMesh2.ptr, TRIANGLES);

    for(var j = 0; j < 160; j++) {
        var z1 = -j * 3;
        var z2 = z1-(2+Math.random()*2);
        for (var i=0; i < precision; i+=Math.floor(Math.random()*8))
        {
            var radius = 1.0 + Math.random()*5;
            var angle = (i+precision)*2*Math.PI/precision;
            var x1 = Math.cos(angle) * radius;
            var y1 = Math.sin(angle) * radius;
            angle = ((i+1)+precision)*2*Math.PI/precision;
            var x2 = Math.cos(angle) * radius;
            var y2 = Math.sin(angle) * radius;

            var uMin = 0.0;
            var uMax = 1.0;
            var vMin = 0.0;
            var vMax = 1.0;

            meshAddTexCoord(tunnelMesh.ptr, uMin, vMax);
            meshAddVertex(tunnelMesh.ptr, x1,y1,z2);
            meshAddTexCoord(tunnelMesh.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh.ptr, x1,y1,z1);

            meshAddTexCoord(tunnelMesh.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh.ptr, x1,y1,z1);
            meshAddTexCoord(tunnelMesh.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh.ptr, uMax, vMin);
            meshAddVertex(tunnelMesh.ptr, x2,y2,z1);
        }
    }

    for(var j = 0; j < 160; j++) {
        var z1 = -j * 3;
        var z2 = z1-(2+Math.random()*2);
        for (var i=0; i < precision; i+=Math.floor(Math.random()*8))
        {

            var radius = 1.0 + Math.random()*10.0-5.0;
            var x1 = radius;
            var y1 = radius;
            var x2 = radius;
            var y2 = radius;

            var pos = Math.floor(Math.random()*4);
            if (pos == 0) {
                // -X
                x1 *= -1;
                x2 = x1;
                y1 = 1.0 + Math.random()*10.0-5.0;
                y2 += 1.0;
            } else if (pos == 1) {
                // +X
                x2 = x1;
                y1 = 1.0 + Math.random()*10.0-5.0;
                y2 += 1.0;
            } else if (pos == 2) {
                // -Y
                y1 *= -1;
                y2 = y1;
                x1 = 1.0 + Math.random()*10.0-5.0;
                x2 += 1.0;
            } else {
                // +Y
                y = y1;
                x1 = 1.0 + Math.random()*10.0-5.0;
                x2 += 1.0;
            }

            var uMin = 0.0;
            var uMax = 1.0;
            var vMin = 0.0;
            var vMax = 1.0;

            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMax);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z1);

            meshAddTexCoord(tunnelMesh2.ptr, uMin, vMin);
            meshAddVertex(tunnelMesh2.ptr, x1,y1,z1);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMax);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z2);
            meshAddTexCoord(tunnelMesh2.ptr, uMax, vMin);
            meshAddVertex(tunnelMesh2.ptr, x2,y2,z1);
        }
    }

    meshGenerate(tunnelMesh.ptr);
    meshGenerate(tunnelMesh2.ptr);

    //glLineWidth(10);
    var lineMax = 480;
    meshSetFaceDrawType(tunnelLineMesh.ptr, LINE_STRIP);
    for(var i = 0; i < lineMax; i++) {
        var x = Math.cos(i/100*22)*2;
        var y = Math.sin(i/100*20)*2;
        var z = -i
        meshAddVertex(tunnelLineMesh.ptr, x,y,z);
    }
    for(var i = 0; i < lineMax; i++) {
        var x = Math.sin(i/100*20)*2;
        var y = Math.cos(i/100*10)*2;
        var z = -i
        meshAddVertex(tunnelLineMesh.ptr, x,y,z);
    }
    for(var i = 0; i < lineMax; i++) {
        var x = Math.sin(i/100*15)*2;
        var y = Math.cos(i/100*30)*2;
        var z = -i
        meshAddVertex(tunnelLineMesh.ptr, x,y,z);
    }
    for(var i = 0; i < lineMax; i++) {
        var x = Math.sin(i/100*10)*3;
        var y = Math.cos(i/100*10)*3;
        var z = -i
        meshAddVertex(tunnelLineMesh.ptr, x,y,z);
    }
    meshGenerate(tunnelLineMesh.ptr);

}

function deinitTunnel(animation) {
    meshDelete(tunnelMesh.ptr);
    meshDelete(tunnelMesh2.ptr);
    meshDelete(tunnelLineMesh.ptr);
    //texturedQuadDeinit(tunnelMeshTexture.ptr);
}

function drawTunnel(animation) {
    glPushMatrix();
    perspective2dEnd();
        
    //glTranslatef(0,0,-200 * ((getSceneStartTime()/animation.duration)));
    //glTranslatef(0,0,-0);
    if (animation.part === 1) {
        glTranslatef(-0.5,0,-20 + 20 * getSceneTimeFromStart()*0.5);
        glRotatef(getSceneTimeFromStart()*20,0,0,1);
        meshDraw(tunnelMesh2.ptr, 0.0, 1.0);
        glColor4f(1,1,1,(1+Math.sin(getSceneTimeFromStart()*70))/2)
        meshDraw(tunnelLineMesh.ptr, 0.0, Sync.getSyncValue('meshPercent'));
    } else if (animation.part === 2) {
        var c = Sync.getSyncValue('meshPercent');
        glColor4f(c,c,c,c);
        var time = getSceneTimeFromStart() - 73;
        glTranslatef(-0.5,0,-20 + 20 * time*0.05);
        glRotatef(time*10,0,0,1);
        meshDraw(tunnelMesh.ptr, 0.0, 1.0);
        glColor4f(1,1,1,(1+Math.sin(time*70))/2)
        meshDraw(tunnelLineMesh.ptr, 0.0, Sync.getSyncValue('meshPercent'));
    }

    glPopMatrix();
}

function getSpherePosition(animation, sphereI)
{
    var array = [0,0,0];
    var time = getSceneTimeFromStart()*10;

    if (sphereI == 1)
    {
        array[0] = Math.cos(time)*0.5+0.2;
        array[1] = Math.sin(time)*0.8+0.3;
        array[2] = Math.sin(time)*0.5;
    }
    else if (sphereI == 2)
    {
        array[0] = Math.sin(time)*0.5-0.5;
        array[1] = Math.cos(time)*0.5-0.25;
        array[2] = Math.sin(time)+0.5;
    }
    else if (sphereI == 3)
    {
        array[0] = Math.cos(time)*0.5-0.5;
        array[1] = Math.sin(time)*0.7-0.25;
        array[2] = Math.cos(time)*0.6+0.3;
    }
    else if (sphereI == 4)
    {
        array[0] = Math.cos(time)*0.8;
        array[1] = Math.sin(time)*0.4;
        array[2] = Math.cos(time)*0.8;
    }
    else if (sphereI == 5)
    {
        array[0] = Math.sin(time)*0.9;
        array[1] = Math.sin(time)*0.9;
        array[2] = Math.sin(time)*0.2;
    }

    return array;
}

function getSphereMasterScale(animation)
{
    var progress = Utils.calculateProgress(animation.start+animation.sphereStart, animation.sphereFade);
    if (progress >= 1.0)
    {
        progress = 1 - Utils.calculateProgress(animation.start+animation.sphereStart+animation.sphereDuration, animation.sphereFade);
    }
    return progress;
}


function getStaticNoiseResolution(animation) {
    var v1 = (1+Math.sin(getSceneTimeFromStart()*25))/2;
    return [1980*(v1), 1080*(v1)];
}

Demo.prototype.init = function()
{
    var start = 0;
    var duration = 134;
    var layer = 1; 

    Sync.addSync([
         {"name":"eyeXalpha","type":"rocket"}
        ,{"name":"qrXajna_alpha","type":"rocket"}
        ,{"name":"kaleidoscope:alpha","type":"rocket"}
        ,{"name":"ruinXpixel2","type":"rocket"}
        ,{"name":"ruinXluminance","type":"rocket"}
        ,{"name":"ruinXx","type":"rocket"}
        ,{"name":"ruinXy","type":"rocket"}
        ,{"name":"statueXview","type":"rocket"}
        ,{"name":"statueXcensorAlpha","type":"rocket"}
        ,{"name":"statueXangleX","type":"rocket"}
        ,{"name":"statueXangleY","type":"rocket"}
        ,{"name":"statueXangleZ","type":"rocket"}
        ,{"name":"statueXx","type":"rocket"}
        ,{"name":"statueXy","type":"rocket"}
        ,{"name":"statueXz","type":"rocket"}
        ,{"name":"meshPercent","type":"rocket"}
    ]);
    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"kaleidoscopeFbo","action":"begin","storeDepth":true}
        ,"shader":{"name":["plain.vs","plain.fs"]}
    }]);

    this.loader.addAnimation([{
         "start": start, "duration": duration
        ,"layer": layer
        ,"part": 1
        ,"initFunction": "{initTunnel(animation);}"
        ,"deinitFunction": "{deinitTunnel(animation);}"
        ,"runFunction": "{drawTunnel(animation);}"
        ,"shader":{"name":["plain.fs","plain.vs"]}
    }]);
    this.loader.addAnimation([{
         "start": 94, "duration": 20
        ,"layer": layer
        ,"part": 2
        ,"runFunction": "{drawTunnel(animation);}"
        ,"shader":{"name":["plain.fs","plain.vs"]}
    }]);

    this.loader.addAnimation(
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"kaleidoscopeFbo","action":"unbind"}
        ,"shader":{"name":["plain.vs","plain.fs"]}
    });
    this.loader.addAnimation ([
    {
    "start": start, "duration": duration
    ,"layer": layer
    ,"fbo":{"name":"fbodist","action":"begin"}
    ,"shader":{"name":["plain.vs","plain.fs"]}
    }
    ]);

    this.loader.addAnimation({
         "start": start+5, "duration":duration
        ,"layer": layer, "image": ["ruins01.png","ruins02.png","ruins03.png","ruins04.png"]
        ,"scale": [{"uniform2d":2.0}]
        ,"position":[{"x":"{return getScreenWidth()*Sync.getSyncValue('ruinXx');}","y":"{return getScreenHeight()*Sync.getSyncValue('ruinXy');}"}]
        ,"shader":{"name":"eclipse.fs"
            ,"variable":[
                 {"name":"animSpeed","value":[6.0]}
                ,{"name":"useNoise","type":"int","value":[0]}
                ,{"name":"useFillCircle","type":"int","value":[0]}
                ,{"name":"useWave","type":"int","value":[0]}
            ]}
    });
    this.loader.addAnimation({
         "start": start, "duration":40
        ,"layer": layer, "image": "qr_ajna.png"
        ,"shader":{"name":"noise.fs"
            ,"variable":[
                 {"name":"usePlasma","type":"int","value":[0]}

                //,{"name":"resolution","value":"{return getStaticNoiseResolution(animation);}"}
            ]
        } 
        ,"color":[{"a":"{return Sync.getSyncValue('qrXajna_alpha');}"}]
    });


    this.loader.addAnimation ([
    {
    "start": start, "duration": duration
    ,"layer": layer,"fbo":{"name":"fbodist","action":"unbind"}
    ,"shader":{"name":["plain.vs","plain.fs"]}
    }
    ]);

    this.loader.addAnimation({
         "start": 23, "duration": duration, "layer": layer
        ,"image": ["kaleidoscopeFbo.color.fbo","kaleidoscopeFbo.depth.fbo"]
        ,"shader":{
            "name":"kaleidoscope.fs"
        }
        ,"color":[{"a":"{return Sync.getSyncValue('kaleidoscope:alpha');}"}]
    });

    this.loader.addAnimation({
         "start": start, "duration":duration
        ,"scale": [{"uniform2d":3.1}]
        ,"layer": layer, "image": ["eclipse_01.png","eclipse_02.png","eclipse_03.png","eclipse_04.png"]
        ,"position":[{"x":getScreenWidth()*0.525,"y":getScreenHeight()*0.45}]
        ,"shader":{"name":"eclipse.fs"
            ,"variable":[
                 {"name":"animSpeed","value":[2.0]}
                ,{"name":"useNoise","type":"int","value":[0]}
            ]}
    });


    if (video) {
        this.loader.addAnimation({
             "start": 0, "duration":5
            ,"layer": layer, "image": {"name":"eye_03.ogv", "video":{"speed":.9} }
            ,"scale":[{"uniform2d":2.3}]
            ,"position":[{"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.52}]
            ,"color":[{"a":"{return Sync.getSyncValue('eyeXalpha');}"}]
            ,"shader":{"name":"roundFade.fs"}
       });

       this.loader.addAnimation({
             "start": 0, "duration":5
            ,"layer": layer, "image": {"name":"blast.ogv", "video":{"speed":1.0} }
            ,"scale":[{"x":5.0,"y":4.0}]
            ,"color":[{"a":150}]
            ,"shader":{"name":["plain.vs","plain.fs"]}
       });

        this.loader.addAnimation({
             "start": 17, "duration":24
            ,"layer": layer, "image": {"name":"eye_03.ogv", "video":{"speed":.9} }
            ,"scale":[{"uniform2d":2.3}]
            ,"position":[{"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.52}]
            ,"color":[{"a":"{return Sync.getSyncValue('eyeXalpha');}"}]
            ,"shader":{"name":"roundFade.fs"}
       });

        this.loader.addAnimation({
             "start": 94, "duration":35
            ,"layer": layer+1, "image": {"name":"eye_03.ogv", "video":{"speed":.5} }
            ,"scale":[{"uniform2d":3.3}]
            ,"position":[{"x":getScreenWidth()*0.51,"y":getScreenHeight()*0.52}]
            ,"color":[{"a":"{return Sync.getSyncValue('eyeXalpha');}"}]
            ,"shader":{"name":"roundFade.fs"}
       });
    }


    this.loader.addAnimation ([
    {
         "start": start+5, "duration": duration
        ,"image": "fbodist.color.fbo"
        ,"layer": layer
        ,"shader":{"name":"distortion2.fs",
            "variable":[
                 {"name":"timeMultiplier","value":[0.1]}
                ,{"name":"pixelSize","value":["{return 0.05-Math.random()*1;}","{return Sync.getSyncValue('ruinXpixel2');}"]}
                ,{"name":"noiseWaveSpeed","value":[100]}
                ,{"name":"noiseWaveSize","value":[0.01]}
                ,{"name":"noiseLuminance","value":["{return Sync.getSyncValue('ruinXluminance');}"]}
                ,{"name":"noiseAlpha","value":[0.2] }
                ,{"name":"colorComponentDistortionX","value":["{return Math.random()*0.1;}",0.001,0.001,0.001]}
                ,{"name":"colorComponentDistortionY","value":["{return Math.random()*0.1;}",0.001,0.001,0.001]}
            ]
            }
        ,"color":[{"a":200},{"duration":13},{"duration":1,"a":0}]
        }]);

    /*this.loader.addAnimation(
    {
         "start": 100, "duration": 2
        ,"layer": layer
        ,"initFunction":"{puzzleInit(animation);}"
        ,"runFunction":"{puzzleRun(animation);}"
        ,"deinitFunction":"{puzzleDeinit(animation);}"
    });*/

    this.loader.addAnimation([{
         "start": 94, "duration": 20
        ,"layer": layer
        ,"part": 2
        ,"runFunction": "{drawTunnel(animation);}"
        ,"shader":{"name":["plain.fs","plain.vs"]}
    }]);

    this.loader.addAnimation([
    {
         "start":50, "duration": 10
        ,"layer": layer, "text":{"name":fontName,"string":"Monumentalne Zabytki"}
        ,"scale": [{"uniform2d":5},{"duration":5,"uniform2d":4}]
        ,"color":[{"r":0,"g":0,"b":0,"a":0},{"duration":5,"a":50},{"duration":2},{"duration":2,"a":0}]
        ,"position":[{"x":getScreenWidth()/2,"y":getScreenHeight()/2}]
        ,"shader":{"name":["plain.vs","plain.fs"]}
    }]);
    this.loader.addAnimation([
    {
         "start":50, "duration": 14
        ,"layer": layer, "text":{"name":fontName,"string":"MMMMMMMDX"}
        ,"scale": [{"uniform2d":6}]
        ,"color":[{"r":0,"g":0,"b":0,"a":0},{"duration":5.0},{"duration":5,"a":50},{"duration":2},{"duration":2,"a":0}]
        ,"position":[{"x":getScreenWidth()/2,"y":getScreenHeight()/2}]
        ,"shader":{"name":["plain.vs","plain.fs"]}
    }]);

    this.loader.addAnimation([
    {
         "start": start, "duration": duration, "layer": layer
        ,"light":{"index":0, "action":"begin"}
        ,"lightType": Light.type.DIRECTIONAL
        ,"direction":[
             {"x":0, "y":0, "z":-1}
        ]
        ,"generateShadowMap": false
        ,"specularColor":[
             {"r":255, "g":255, "b":255, "a":255}
        ]
        ,"diffuseColor":[
             {"r":255, "g":255, "b":255, "a":255}
        ]
        ,"ambientColor":[
             {"r":255, "g":255, "b":255, "a":255}
        ]
        ,"runFunction":"{calcLightIntensity();}"
        ,"shader":{"name":["plain.vs","plain.fs"]}
    }]);


    var perspective = [{
         "near":0.01
        ,"far":1000.0
        ,"aspect":1.77
        ,"fov":45.0
    }];

    this.addLight(start, duration, layer);

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"camera": "dynamicCamera"
        ,"position":[
             {"x":"{return activeView.camera.position.x;}","y":"{return activeView.camera.position.y;}","z":"{return activeView.camera.position.z;}"}
        ]
        ,"target":[
            {"x":"{return activeView.camera.target.x;}","y":"{return activeView.camera.target.y;}","z":"{return activeView.camera.target.z;}"}
        ]
        ,"perspective": perspective
        ,"shader":{"name":["plain.vs","plain.fs"]}
    });
    this.loader.addAnimation({
         "start": start, "duration": duration
        ,"image": "censor.png"
        ,"layer": layer
        ,"scale":[{"x":"{return activeView.censor.scale.x;}","y":"{return activeView.censor.scale.y;}"}]
        ,"color":[{"a":"{return Sync.getSyncValue('statueXcensorAlpha');}"}]
        ,"position":[{"x":"{return activeView.censor.position.x;}","y":"{return activeView.censor.position.y;}"}]
        ,"shader":{"name":"noise.fs",
            "variable":[
                 {"name":"usePlasma","type":"int","value":[0]}
                //,{"name":"resolution","value":"{return getStaticNoiseResolution(animation);}"}
            ]
        }
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"object": "statue_smaller_patched.obj"
        ,"scale":[{"uniform3d":0.6}]
        //,"angle":[{"degreesX":90}]
        ,"angle":[{"degreesX":"{return Sync.getSyncValue('statueXangleX');}","degreesY":"{return Sync.getSyncValue('statueXangleY');}","degreesZ":"{return Sync.getSyncValue('statueXangleZ');}"}]
        ,"position":[{"x":"{return Sync.getSyncValue('statueXx');}","y":"{return Sync.getSyncValue('statueXy');}","z":"{return Sync.getSyncValue('statueXz');}"}]
        //,"shader":{"name":["statue.vs","statue.fs"]}
        //,"shader":{"name":["plain.vs","plain.fs"]}
        ,"shader":{"name":["DefaultPlain"]}
    });

    this.loader.addAnimation([
    {
         "start": 74, "duration": 30
        ,"image": "_embedded/defaultWhite.png"
        ,"perspective": "3d"
        ,"position":[{"z":-1,"x":-0.0,"y":0.05}]
        //,"angle":[{"degreesX":80,"degreesY":140}]
        //,"scale":[{"uniform2d":"{return ((getSceneTimeFromStart()-animation.start)%animation.signalDuration)*1/animation.signalDuration;}"}]
        ,"scale":[
            {"uniform2d":0},
            {"duration":2},
            {"signalDuration": 2.5, "signalScale":30, "uniform2d":"{return getSignalScale(animation);}"}
        ]
        //,"color": [{"a":200}]
        ,"shader":{"name":"signal.fs"}
        ,"layer": layer
    }]);

    this.loader.addAnimation(
    {
         "start": 74, "duration": 30, "layer": layer
        //,"image": "data/raym.png"
        ,"image": "fbodist.color.fbo"//"_embedded/defaultTransparent.png"
        //,"image": "data/satellite_point.png"
        //,"scale":[{"uniform2d":10}]
        ,"sphereStart":0
        ,"sphereFade":2
        ,"sphereDuration":16
        ,"shader":{"name":"raymarching.fs",
            "variable":[
                 {"name":"spherePos1","value":"{return getSpherePosition(animation, 1);}"}
                ,{"name":"spherePos2","value":"{return getSpherePosition(animation, 2);}"}
                ,{"name":"spherePos3","value":"{return getSpherePosition(animation, 3);}"}
                ,{"name":"spherePos4","value":"{return getSpherePosition(animation, 4);}"}
                ,{"name":"spherePos5","value":"{return getSpherePosition(animation, 5);}"}
                ,{"name":"masterScale","value":["{return getSphereMasterScale(animation);}"]}
            ]
        }
        ,"color":[{"a":0},{"duration":2,"a":255}]
    });

    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": layer
        ,"image": "old_layer.png"
        ,"color":[{"a":0}]
        ,"shader":{"name":["Default"],
            "variable":[
                {"name":"statueXnoiserator","value":[0.0]}
            ]
        }

    });
    this.loader.addAnimation(
    {
         "start": start, "duration": duration, "layer": 60000
        ,"image": "vignette.png"
        ,"shader":{"name":["Default"],
            "variable":[
                {"name":"statueXnoiserator","value":[0.0]}
            ]
        }

    });

}

var puzzle = {};
function puzzleInit(animation)
{
    //kaleidoscopeFbo.ref = fboInit("kaleidoscopeFbo");
    puzzle.fbo = new Fbo();
    puzzle.fbo.init("fbodist");
    puzzle.texture = puzzle.fbo.color;

    var xl = 10;
    var yl = 10;

    puzzle.meshes = new Array(xl*yl);

    for(var i = 0; i < puzzle.meshes.length; i++) {

        var xi = i%xl;
        var yi = Math.floor(i/xl); 
        var stepX1 = getScreenWidth()/xl*xi+50;
        var stepX2 = getScreenWidth()/xl*(xi+1)+50;
        var stepUvX1 = xi/xl;
        var stepUvX2 = (xi+1)/xl;

        var stepY1 = getScreenHeight()/yl*yi;
        var stepY2 = getScreenHeight()/yl*(yi+1);
        var stepUvY1 = yi/yl;
        var stepUvY2 = (yi+1)/yl;
        var mesh = new Mesh();
        mesh.setFaceDrawType(TRIANGLES);

        mesh.setMaterialTexture(puzzle.texture, 0);

        mesh.addVertex(stepX1,stepY1,0);
        mesh.addTexCoord(stepUvX1,stepUvY1);
        mesh.addVertex(stepX2,stepY2,0);
        mesh.addTexCoord(stepUvX2,stepUvY2);
        mesh.addVertex(stepX1,stepY2,0);
        mesh.addTexCoord(stepUvX1,stepUvY2);

        mesh.addVertex(stepX1,stepY1,0);
        mesh.addTexCoord(stepUvX1,stepUvY1);
        mesh.addVertex(stepX2,stepY1,0);
        mesh.addTexCoord(stepUvX2,stepUvY1);
        mesh.addVertex(stepX2,stepY2,0);
        mesh.addTexCoord(stepUvX2,stepUvY2);

        mesh.generate();

        puzzle.meshes[i] = {
             "x":0
            ,"y":0
            ,"z":0
            ,"mesh": mesh
        };
    }

}

function puzzleDeinit(animation)
{
    for(var i = 0; i < puzzle.meshes.length; i++) {
        puzzle.meshes[i].mesh.delete();
    }
}

function puzzleRun(animation)
{
    //glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    for(var i = 0; i < puzzle.meshes.length; i++) {
        perspective2dBegin(getScreenWidth(),getScreenHeight());
        //glPushMatrix();
        glTranslatef(Math.random()*100,Math.random()*100,0);
        puzzle.meshes[i].mesh.draw(0.0,1.0);
        //glPopMatrix();
        perspective2dEnd();
    }
}
