#version 330 core

#define MAX_LIGHTS 4

#define LIGHT_DIRECTIONAL 1
#define LIGHT_POINT 2
#define LIGHT_SPOT 3

layout(location = 0) in vec3 vertexPosition;
layout(location = 1) in vec2 vertexTexCoord;
layout(location = 2) in vec3 vertexNormal;
layout(location = 3) in vec4 vertexColor;

out vec4 shadowPosition;
out vec2 texCoord;
out vec4 vertexFragColor;
out vec3 normal;
out vec3 lightDirection;
out vec3 eye;

uniform mat4 mvp;
uniform mat4 shadowMvp;
uniform mat3 normalMatrix;
uniform mat4 view;
uniform mat4 model;
uniform mat4 projection;
uniform float time = 1.0;
uniform int activeLightCount = 0;

struct Camera {
    vec3 position;
};
uniform Camera camera = Camera(vec3(0.0,3.0,3.0));

struct Light {
    int type;
    vec3 position;
    vec3 direction;
    vec4 diffuse;
    vec4 ambient;
    vec4 specular;
};

uniform Light light[MAX_LIGHTS];

out LightCalc {
    vec4 diffuse;
    vec4 ambient;
    vec4 specular;
    vec3 toLight;
} lightOut;//[MAX_LIGHTS];
// FIXME: Legacy MacBook dislikes out array: "Interface block array not allowed as out in vertex shader"

uniform float statueXnoiserator = 0.0;
 
/*float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}*/

void main(void)
{
    vec4 position = vec4(vertexPosition, 1.0);


    gl_Position = mvp * position;
    /*if (statueXnoiserator > 0.0) {
        float noisy = rand(gl_Position.xy);
        gl_Position.x += noisy*statueXnoiserator;
        noisy = rand(gl_Position.xz);
        gl_Position.y += noisy*statueXnoiserator;
        noisy = rand(gl_Position.yz);
        gl_Position.z += noisy*statueXnoiserator;
    }*/
    /*if (gl_Position.x < -0.2) {
        gl_Position.y -= 2.0*(abs(gl_Position.x+0.2)/0.5);
    }*/
    shadowPosition = shadowMvp * position;

    texCoord = vertexTexCoord;
    vertexFragColor = vertexColor;

    if (activeLightCount > 0) {
        // position in world space
        vec4 worldPosition = model * position;

        // direction to camera
        eye = normalize(camera.position - worldPosition.xyz);

        // normal in world space
        normal = normalize(normalMatrix * vertexNormal);

        for (int i = 0; i < activeLightCount; i++) {
            switch(light[i].type) {
                case LIGHT_DIRECTIONAL:
                    lightOut/*[i]*/.toLight = vec3(normalize((-(view)) * vec4(-light[i].direction.x,light[i].direction.y,light[i].direction.z,0.0)));
                    break;

                case LIGHT_POINT:
                default:
                    lightOut/*[i]*/.toLight = normalize(vec3(light[i].position.x, light[i].position.y, light[i].position.z) - worldPosition.xyz);
                    break;
            }

            lightOut/*[i]*/.diffuse = light[i].diffuse;
            lightOut/*[i]*/.ambient = light[i].ambient;
            lightOut/*[i]*/.specular = light[i].specular;
        }
    }
} 
