' FIREWORK.BAS
' Written by Andy Goth at MAGFest 2019
' https://facebook.com/andygoth

' Default all variables to be integers
DEFINT A-Z

' Video configuration
CONST vid.mode = 12  ' Screen mode, use 12 or 13
CONST vid.w = 640, vid.h = 480 ' Uncomment for vid.mode=12
'CONST vid.w = 320, vid.h = 200 ' Uncomment for vid.mode=13

' Tunable parameters
' For vid.mode=12, max.burst*max.color<=15
' For vid.mode=13, max.burst*max.color<=255
CONST max.burst = 3   ' Maximum simultaneous bursts
CONST max.color = 5   ' Maximum number of colors per burst
CONST part.color = 3  ' Number of particles per color
CONST max.trail = 15  ' Number of trails per burst
CONST min.speed = 2   ' Minimum initial trail speed, pixels/frame
CONST max.speed = 5   ' Maximum initial trail speed, pixels/frame
CONST grav = .125     ' Downward acceleration, pixels/frame^2

' Non-tunable parameters
CONST max.part = part.color * (max.color - 1) + 1 ' Particles per burst
CONST pi = 3.141593                      ' Circumference divided by diameter
CONST two.pi = pi * 2                    ' Radians per revolution
CONST two.thirds.pi = two.pi / 3         ' One third of a revolution
CONST four.thirds.pi = two.thirds.pi * 2 ' Two thirds of a revolution

' Data structures
DIM Cr(1 TO max.burst, 1 TO max.color)                ' Red color
DIM Cg(1 TO max.burst, 1 TO max.color)                ' Green color
DIM Cb(1 TO max.burst, 1 TO max.color)                ' Blue color
DIM Ci(1 TO max.burst)                                ' Color index
DIM Cj(1 TO max.burst)                                ' Color divider
DIM Ri(1 TO max.burst)                                ' Ring index
DIM Px(1 TO max.burst, 1 TO max.trail) AS SINGLE      ' X position
DIM Py(1 TO max.burst, 1 TO max.trail) AS SINGLE      ' Y position
DIM Vx(1 TO max.burst, 1 TO max.trail) AS SINGLE      ' X velocity
DIM Vy(1 TO max.burst, 1 TO max.trail) AS SINGLE      ' Y velocity
DIM Hx(1 TO max.burst, 1 TO max.trail, 1 TO max.part) ' X history
DIM Hy(1 TO max.burst, 1 TO max.trail, 1 TO max.part) ' Y history

' Initialize video
CLS
SCREEN vid.mode

time = 70 * 15

' Main loop until a key is pressed
DO WHILE INKEY$ = "" AND time > 0
 time = time - 1

 ' Color of first burst
 c = 1

 ' Process each burst
 FOR b = 1 TO max.burst
  ' Test if burst is inactive
  IF Ri(b) = 0 THEN
   ' Create new burst
   Ri(b) = 1
   Ci(b) = c + max.color - 1
   Cj(b) = 1

   ' Pick center of burst
   x = RND * vid.w
   y = RND * vid.h
  
   ' Initialize each trail of the burst
   FOR t = 1 TO max.trail
    ' Pick angle and speed for the trail
    a! = RND * two.pi
    s! = RND * (max.speed - min.speed) + min.speed

    ' Store trail position and velocity
    Px(b, t) = x
    Py(b, t) = y
    Vx(b, t) = COS(a!) * s!
    Vy(b, t) = SIN(a!) * s!

    ' Initialize trail history
    FOR p = 1 TO max.part
     Hx(b, t, p) = x
     Hy(b, t, p) = y
    NEXT
   NEXT

   ' Pick color for the burst
   a! = RND * two.pi
   s! = RND
   Br! = 2 - (COS(a!) + 1) * s!
   Bg! = 2 - (COS(a! + two.thirds.pi) + 1) * s!
   Bb! = 2 - (COS(a! + four.thirds.pi) + 1) * s!
   dv! = 31 / max.color
   v! = 31
   FOR i = 1 TO max.color
    Cr(b, i) = Br! * v!
    Cg(b, i) = Bg! * v!
    Cb(b, i) = Bb! * v!
    v! = v! - dv!
   NEXT
  END IF

  ' Find indexes of current, oldest, and newest existing particles
  p = Ri(b)
  IF p = max.part THEN o = 1 ELSE o = p + 1
  IF p = 1 THEN n = max.part ELSE n = p - 1

  ' Process each trail slot in the burst, and check if burst is now expired
  live = 0
  FOR t = 1 TO max.trail
   ' Erase oldest particle if onscreen
   IF Hy(b, t, p) < vid.h THEN
    ' Draw over particle with black
    IF Hx(b, t, p) <> Hx(b, t, o) OR Hy(b, t, p) <> Hy(b, t, o) THEN
     LINE (Hx(b, t, p), Hy(b, t, p))-(Hx(b, t, o), Hy(b, t, o)), 0
    END IF

    ' The burst is still alive
    live = -1
   END IF

   ' Test if trail is active
   IF Py(b, t) < vid.h THEN
    ' Integrate trail velocity and position
    Vy(b, t) = Vy(b, t) + grav
    Px(b, t) = Px(b, t) + Vx(b, t)
    Py(b, t) = Py(b, t) + Vy(b, t)
    Hx(b, t, p) = Px(b, t)
    Hy(b, t, p) = Py(b, t)

    ' Draw new trail position
    LINE (Hx(b, t, n), Hy(b, t, n))-(Hx(b, t, p), Hy(b, t, p)), Ci(b)

    ' The burst is still alive
    live = -1
   ELSE
    ' If the trail is inactive, force its history offscreen
    Hy(b, t, p) = vid.h
   END IF
  NEXT

  ' Animate palette
  j = Ci(b)
  OUT &H3C8, j
  FOR i = 1 TO max.color
   OUT &H3C9, Cr(b, i)
   OUT &H3C9, Cg(b, i)
   OUT &H3C9, Cb(b, i)
   IF j < c + max.color - 1 THEN
    j = j + 1
   ELSE
    j = 1
    OUT &H3C8, c
   END IF
  NEXT

  ' Increment the ring buffer index, and mark expired bursts as such
  IF live THEN Ri(b) = o ELSE Ri(b) = 0

  ' Increment the color index
  IF Cj(b) < part.color THEN
   Cj(b) = Cj(b) + 1
  ELSE
   Cj(b) = 1
   IF Ci(b) > c THEN Ci(b) = Ci(b) - 1 ELSE Ci(b) = c + max.color - 1
  END IF
  
  ' Find color of next burst
  c = c + max.color
 NEXT
LOOP

CHAIN "matrix.bas"

