' program by Andy Goth <andrew.m.goth@gmail.com> http://facebook.com/andygoth

DEFINT A-Z
RANDOMIZE TIMER
SCREEN 0
CLS
WIDTH 80

CONST actmax = 4 ' maximum number of active columns
CONST cannum = 20 ' number of canned statements
DIM matrix(1 TO 40, 0 TO 22) AS INTEGER ' per-column ring buffers
DIM head(1 TO 40) AS INTEGER ' ring buffer head index
DIM blank(1 TO 40) AS INTEGER ' blank enable or inhibit
DIM active(1 TO actmax) AS INTEGER ' list of active columns
DIM count(1 TO actmax) AS INTEGER ' counts for each active column
DIM canidx(1 TO 40) AS INTEGER ' index of canned statement or 0 for random
DIM canpos(1 TO 40) AS INTEGER ' position into canned statement
DIM cantxt(1 TO cannum) AS STRING ' canned text

' load canned statements
FOR i = 1 TO cannum
   READ cantxt(i)
NEXT

' canned statements
DATA "The MAGFest has you"
DATA "All your base are belong to us"
DATA "Knock knock Neo"
DATA "Follow the white donut"
DATA "There is no spoon"
DATA "You are nerd"
DATA "I am error"
DATA "Dehumanize yourself and face to bloodshed"
DATA "WHOAAAAAARRRRGGGH"
DATA "Insert rupee to continue"
DATA "ocremix.org"
DATA "What a horrible night to have a MAGFest"
DATA "MAGFest museum"
DATA "Andy Goth"
DATA "Dom said to"
DATA "Brush your teeth"
DATA "Look both ways when crossing"
DATA "Skulls for the skull god, blood for the blood throne"
DATA "45 minutes from meal to swimming"
DATA "Help me"

' avoid short sequences at start of program
FOR i = 1 TO 40
   blank(i) = -3
NEXT

time = 70 * 15

' main loop
DO WHILE INKEY$ = "" AND time > 0
   time = time - 1

   ' wait for vertical retrace
   WAIT &H3DA, 8

   ' loop over each active column slot
   FOR k = 1 TO actmax
      ' column activation logic
      IF NOT active(k) AND INT(RND * 15) = 0 THEN
         active(k) = INT(RND * 40) + 1
         count(k) = INT(RND * 5) + 1
      END IF

      ' only consider active columns
      IF active(k) THEN
         ' column index and activation duration logic
         x = active(k)
         IF count(k) > 0 THEN
            count(k) = count(k) - 1
         ELSE
            active(k) = 0
         END IF

         ' character selection logic
         IF blank(x) > 0 THEN ' blank sequence
            c = 32 ' space
            IF blank(x) > 1 THEN ' continue blank sequence
               blank(x) = blank(x) - 1
            ELSEIF INT(RND * 4) = 0 THEN ' start canned statement
               canidx(x) = INT(RND * cannum) + 1
               canpos(x) = LEN(cantxt(canidx(x)))
               blank(x) = -LEN(cantxt(canidx(x)))
            ELSE ' start non-blank sequence
               blank(x) = -3
            END IF
         ELSEIF blank(x) = 0 AND INT(RND * 20) = 0 THEN ' start blank sequence
            c = 32
            blank(x) = INT(RND * 5) + 3
         ELSEIF canidx(x) THEN ' canned statement
            c = ASC(MID$(cantxt(canidx(x)), canpos(x), 1)) + 128
            IF canpos(x) = 1 THEN ' end canned statement
               canidx(x) = 0
               blank(x) = INT(RND * 5) + 3
            ELSE ' continue canned statement
               canpos(x) = canpos(x) - 1
               blank = blank(x) + 1
            END IF
         ELSE ' random characters
            c = INT(RND * 94 + 33)
            IF blank(x) < 0 THEN blank(x) = blank(x) + 1
         END IF

         ' store character in matrix
         i = head(x)
         matrix(x, i) = c
         IF i < 22 THEN head(x) = i + 1 ELSE head(x) = 0

         ' render column of text
         FOR y = 0 TO 22
            ' determine next index
            IF i > 0 THEN j = i - 1 ELSE j = 22

            ' stop loop at tail of matrix
            IF matrix(x, i) = 0 THEN EXIT FOR

            ' color logic
            IF matrix(x, i) AND 128 THEN ' canned statement
               IF matrix(x, j) > 32 THEN ' not first character
                  COLOR 6
               ELSE ' first character
                  COLOR 14
               END IF
            ELSE ' random characters
               IF matrix(x, j) > 32 THEN ' above non-blank
                  COLOR 2
               ELSE ' above blank
                  COLOR 10
               END IF
            END IF

            ' display character
            LOCATE y + 1, x + x - 1
            PRINT CHR$(matrix(x, i) AND 127)

            ' advance to next index
            i = j
         NEXT
      END IF
   NEXT
LOOP

