;; stars.s - print stars pattern - Nesu 2023
;; entry for Vintage Computing Christmas Challenge 2023
;; size: 27 bytes
;; loading:  memory&2A06:load"stars",&2A06:cls:call&2A06

.area _DATA
;; Firmware calls
TXT_SET_CURSOR=0xBB75     ;; Positions screen cursor at H,L
TXT_OUTPUT=0xBB5A         ;; Outputs character in A to screen

_main::
ld hl,#0x1513 ;; init cursor position
ld c,l     ;; C = 19
calcnextpoint:
ld a,h     ;; A = X-1 (previous point-1)
sub e      ;; A = X-1-6 (next point-1)
jr nc,next ;; no line change if not below 0
add c      ;; A = A+19 (fix position)
dec l      ;; next Y
ret z      ;; exit if no more lines remaining
next:
ld h,a     ;; save next X-1
printtwostars:
inc h      ;; H = (X-1)+1 = X
call TXT_SET_CURSOR ;; position cursor at XY, also H=X-1, L=Y-1
ld a,d     ;; A = '*'
call TXT_OUTPUT ;; print star
ld a,c     ;; A = 19
sub l      ;; A = 20-Y
ld l,a     ;; mirror Y coordinate
djnz printtwostars ;; repeat leaving XY unchanged (even number of times)
jr calcnextpoint ;; calculate next coordinates
