%s 3

#BLOB '*
#DIAM_WID 6
#DIAM_HGT 6
#MAX_DIAMS_X 3
#MAX_DIAMS_Y 3

#START_X ( DIAM_WID * ( MAX_DIAMS_X - 1 ) ) + ( DIAM_WID / 2 )
#START_Y ( DIAM_HGT * ( MAX_DIAMS_Y - 1 ) )

%m $10
	movs r3 START_Y

.nxt_row
	movs r2 START_X
	
.nxt_diam
	;display diamond shape at oper pos (r2, r3)
	push r2
	push r3
	
	;draw each of the 4 sides separately
	#SIDE_LEN ( DIAM_HGT / 2 )
	
	movs r4 SIDE_LEN
.side1
	callrs dsp_xy
	inc r3
	dec r2
	dec r4
	jmprs.nz side1

	movs r4 SIDE_LEN
.side2
	callrs dsp_xy
	inc r3
	inc r2
	dec r4
	jmprs.nz side2

	movs r4 SIDE_LEN
.side3
	callrs dsp_xy
	dec r3
	inc r2
	dec r4
	jmprs.nz side3

	movs r4 SIDE_LEN
.side4
	callrs dsp_xy
	dec r3
	dec r2
	dec r4
	jmprs.nz side4
	
	pop r3
	pop r2
	
	subs r2 DIAM_WID
	jmprs.nn nxt_diam
	subs r3 DIAM_HGT
	jmprs.nn nxt_row
	hlt
	
;------------------------------------------------------------
.dsp_xy
	;display blob at oper pos x,y
	;in: r2=x,r3=y
	
	;system calls
#OP_STAT				$2000	;Z=busy
#OP_SET_XY_RR		$2200	;Z=busy, R=$f=X/Y unchanged
#OP_WR_CH_R			$2400	;Z=busy

	;wait for oper to be ready
.dch_w
	sys OP_STAT
	jmprs.z dch_w

	sys OP_SET_XY_RR | $23	;position cursor
	mov r0 BLOB
	sys OP_WR_CH_R | $00		;display character
	ret
