
.include "fb32x32.inc"

.include "globals.inc"

.segment "DATA"

.define GURURED   $c0

myschedule:
   .word $0000, gurusetup
   .word $0001, gurublink
   .word $00ff, gurucheck;schedulenext

gurutext:
   .byte "GURU",0

.segment "CODE"

guru:
   lda   #<myschedule
   ldx   #>myschedule
   jmp   subschedule

gurusetup:
   lda   #FEAT_MUSIC       ; stop music
   trb   features

   stz   FB32X32_COLMAP

   ldx   #$3f
   lda   #GURURED
:
   sta   TMPBUFFER+$000,x
   stz   TMPBUFFER+$040,x
   dex
   bpl   :-

   jsr   clearfb
   jsr   setfbregs
   stz   FB32X32_COPYN

gurublink:
   lda   frmcnt
   and   #$20
   asl
   sta   FB32X32_SRC+0
   lda   #>TMPBUFFER
   sta   FB32X32_SRC+1

   lda   #<(FRAMEBUFFER+$066)
   ldx   #>(FRAMEBUFFER+$066)
   ldy   #GURURED
   jsr   text_setfb
   lda   #<gurutext
   ldx   #>gurutext
   jsr   text_draw

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_WIDTH
   lda   #$0c
   sta   FB32X32_HEIGHT
   stz   FB32X32_STEP

   stz   FB32X32_COPYN

   lda   #<(FRAMEBUFFER+$021)
   sta   FB32X32_SRC+0
   lda   #>(FRAMEBUFFER+$021)
   sta   FB32X32_SRC+1
   lda   #$01
   sta   FB32X32_DEST_X
   sta   FB32X32_DEST_Y

   lda   #$1d
   sta   FB32X32_WIDTH
   lda   #$0a
   sta   FB32X32_HEIGHT
   lda   #$1f
   sta   FB32X32_STEP

   stz   FB32X32_COPY

   rts

gurucheck:
   lda   #FEAT_GURU
   and   features
   beq   :+
   dec   partindex
:
   lda   #FEAT_LOOP
   and   features
   beq   :+
   stz   partindex
:
   jmp   schedulenext
