#version 450
#extension GL_EXT_debug_printf : enable

#include "common.glsl"

layout(location = 0) in vec3 inPos;
layout(location = 1) in vec3 inNormal;
layout(location = 2) in vec3 inUV;

layout(location = 0) out vec3 outPosition;
layout(location = 1) out vec3 outNormal;
layout(location = 2) out vec3 outColor;

#include "ubo_perframe.glsl"

layout (push_constant) uniform PushConstants {
    mat4 modelTransform;
    mat4 modelTransformIT;
};

void main() {
//    debugPrintfEXT("MVP is %f", mvpTransform[0][0]);

    vec4 worldPosition = modelTransform  * vec4(inPos, 1.0);
    gl_Position = u_viewProjMatrix * worldPosition;
    outPosition = worldPosition.xyz;
    outNormal = mat3(modelTransformIT) * inNormal; // world-space normal
  
    //outColor = inNormal * 0.5 + 0.5;  // debug normals

    float f = inNormal.y * 0.5 + 0.5;
    //outColor = vec3(f,f,f);
    outColor = mix(vec3(74.0f/255.0f,59.0f/255.0f,41.0f/255.0f)*0.15f, vec3(73.0f/255.0f,103.0f/255.0f,130.0f/255.0f)*1.0f, f) * 1.0f;
}
