; ============================================================================
; Singen68k - A 14 byte sine generator for M68k by Superogue / Marquee Design|
; ============================================================================
; Amiga OCS Example
; ============================================================================

	OPT O+,D-,X-

	; Amiga Includes
	incdir  "include"
	include "graphics/graphics_lib.i"
	include "intuition/screens.i"
	include "hardware/custom.i"
	include "hardware/dmabits.i"

SIZE	equ 256	

Main:
	lea  sintab(pc),a4

	; Sine generator (14/16 bytes)
	moveq #0,d1		;2b (can be removed if any reg is 0 at this point)
	moveq #127,d2		;2b 
singen:
	subq.l	#2,d2		;2b
	move.w	d1,(a4)+	;2b
	sub.w	d1,(SIZE-4,a4)	;4b
	add.l	d2,d1		;2b
	bne.b	singen		;2b

	; Amiga Intuition and Graphics Init 
	move.l  $170(a2),a6     ; intuitionbase from globvec
	move.l  ib_ActiveScreen(a6),a5
	move.l  $4.w,a6         ; execbase
	move.l  156(a6),a6      ; graphics.library
	lea     sc_ViewPort(a5),a0
	lea     sc_RastPort(a5),a1
    	jsr     _LVOClearScreen(a6)

	; Draw Sinewave
	lea  sintab(pc),a4
	move.w #255,d5
drawloop:	
	; Read sine value and scale back for plotting
	move.w (a4)+,d1	
	asr.w #6,d1	
	add.w #100,d1		

	; plot pixel
	move d5,d0
	add d0,d0
	jsr _LVOWritePixel(a6)
    dbra d5,drawloop
	
	; wait loop
	bra.s *

sintab:
