clrglobetext:
	movem.l	d0/a0-a3,-(sp)
	;clear first left half
	lea	spr0dat+8,a0	;skip first 2 lines
	lea	spr1dat+8,a1
	lea	spr2dat+8,a2
	lea	spr3dat+8,a3
	move.w	#32,d0
.l0		
	addq.w	#1,a0	;first byte untouched
	clr.b	(a0)+	;second byte cleared
	clr.w	(a0)+	;second word cleared
	clr.l	(a1)+	;this is simpler: clear a long (2 words)
	clr.l	(a2)+
	clr.l	(a3)+
	dbf	d0,.l0
	;clear right half
	lea	spr4dat+8,a0
	lea	spr5dat+8,a1
	lea	spr6dat+8,a2
	lea	spr7dat+8,a3
	move.w	#32,d0
.l1		
	clr.l	(a0)+
	clr.l	(a1)+
	clr.l	(a2)+
	clr.b	(a3)+
	adda.w	#1,a3	;skip last byte untouched
	clr.w	(a3)+	;clear last word
	dbf	d0,.l1
	movem.l	(sp)+,d0/a0-a3
	rts

;clrmem:		;CPU
;.l0
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+
;	clr.l	(a0)+	;unrolled a few, a bit faster
;	dbf	d0,.l0
;	rts

clrmemblit:
	;a0=dest
	;d0=WORDS hasta justo una linea mas abajo
	;3 bitplanes= (40 bytes/2)*3
	;2 bitplanes= (40 bytes/2)*2
	btst	#14,custom+dmaconr
.w	btst	#14,custom+dmaconr
	bne.s	.w
	move.l	a0,custom+bltdpt	;destination
	move.l	#$01000000,custom+bltcon0
	move.l	#0,custom+bltafwm
	move.w	#0,custom+bltdmod
	;move.w	#200*64+60,custom+bltsize
	;numero de lineas*64+(words hasta siguiente linea)
	;en este caso siguiente: 256lineas*64 + (3 bitplanes*20 words)
	;move.w	#256*64+60,custom+bltsize
	add.w	#256*64,d0
	move.w	d0,custom+bltsize
	rts

clrbufblit:	;borra uno de los 2 buffers de 128x128
	;a0=dest
	btst	#14,custom+dmaconr
.w	btst	#14,custom+dmaconr
	bne.s	.w
	move.l	a0,custom+bltdpt	;destination
	move.l	#$01000000,custom+bltcon0
	move.l	#0,custom+bltafwm
	move.w	#0,custom+bltdmod
	;move.w	#200*64+60,custom+bltsize
	;numero de lineas*64+(words hasta siguiente linea)
	;en este caso siguiente: 256lineas*64 + (3 bitplanes*20 words)
	;move.w	#256*64+60,custom+bltsize
	;move.w	#128*64+(2*8),d0	;128 alto, 2bpl*8 words
	;move.w	d0,custom+bltsize
	move.w	#128*64+(2*8),custom+bltsize
.tst		;have to wait the blit, 'cause first letter may be blank
		;specially if fastram is present
	btst	#14,custom+dmaconr
	bne.s	.tst
	rts


 
