; star.s - Draw A Star On The C64 Screen
; Joonas Viskari 2025-12-09
; Assembler: 64tass
; Entry for the Vintage Computing Christmas Challenge 2025
; https://logiker.com/Vintage-Computing-Christmas-Challenge-2025
; Description:
; This program draws a star pattern on the C64 screen using KERNAL routines.
; The star is drawn in quadrants and mirrored to create a full star shape.
; The program starts with a BASIC stub to run the assembly code.
; The star pattern is defined in the data section.
; The program uses KERNAL routines for screen manipulation and character output.
; The star is drawn row by row, expanding from the center.
; Finally, the star is mirrored vertically to complete the shape.
;   
;


; Data:        141 bytes   $0801-$088d   $008d



; Define KERNAL Routines and Variables

CHROUT          = $FFD2         ; KERNAL CHROUT Routine
PLOT            = $FFF0         ; KERNAL PLOT Routine
CLRSCR          = $E544         ; KERNAL Clear Screen Routine

SCRPTR          = $D1           ; KERNAL Screen Memory Pointer
TEMP            = $FC           ; Temporary Variable
ROW             = $FB           ; Current Row (Quandrants 1-2
ROW2            = $FA           ; Mirrored Row 
TOPSTAR         = $409          ; Location To Put The Top Star Character (9,0
BORDER          = $D020         ; VIC-II Border Color Register
BGCOLOR         = $D021         ; VIC-II Background Color Register


* = $801
start_basic:

; Basic Stub to Start The Program
; 1 SYS2061


                .byte           $0B, $08, $01, $00, $9E,  $32, $30, $36, $31, $00, $00, $00



; Main Code Starts Here
* = $80d
main_code:

                INC             ROW             ; row 0-->1      
                INC             $CC             ; cursor Off
                JSR             CLRSCR          ; Jump To Clear Screen Routine
EXPAND_NEXT_ROW:
                LDY             #1              ; Start Column
                LDX             ROW             ; Current Row
                LDA             Q1,X            ; Get Row Data For Quandrant
EXPAND:
                CLC                             ; Not Needed Here (saving A Byte)
                ROL
                BCC             NEXT
                PHA                             ; Save Mask
                JSR             PLOTCHR         ; Plot Q1
                STY             TEMP            ; Store Y Reg (column) To Temp Variable
                LDA             #18             ; Load Axis Value (2a)
                SEC                             ; Set Carry For Subtraction  (not Needed)
                SBC             TEMP            ; Compute 2a - X
                TAY                             ; Reflected X Back To Y
                JSR             PLOTCHR         ; Plot Q2
                LDY             TEMP            ; Restore Y Reg
                PLA                             ; Restore Mask
NEXT:
                INY                             ; Inc Column
                CPY             #9
                BNE             EXPAND
                                                ; Extra Star
                JSR             PLOTCHR
                INX                             ; Next Row
                STX             ROW
                CPX             #9
                BNE             EXPAND_NEXT_ROW
                                                ; Last Row
                LDY             #18
                STY             ROW2            ; Stash The Value For Mirroring...
-
                JSR             PLOTCHR
                DEY
                BPL             -
                LDA             #'*'
                STA             TOPSTAR

MIRROR:
                LDX             #0              ; Source Row 0..9
                STX             BGCOLOR
                STX             BORDER
                STX             ROW
ROW_LOOP:
                                                ; --- Get Source Pointer ---
                LDY             #0
CHAR_LOOP:
                LDX             ROW
                CPX             #9              ; Done All Rows?       
                BNE             +
                BEQ             *               ; Infinite Loop Here (Done)
 +        
                JSR             PLOT            ; X=row → Screenptr Points To Line Start
                LDA             (SCRPTR),y
                PHA
                LDX             ROW2
                JSR             PLOT            ; X=row → Screenptr Points To Line Start
                PLA
                STA             (SCRPTR),y
                INY
                CPY             #20
                BNE             CHAR_LOOP
                INC             ROW
                DEC             ROW2
                BPL             ROW_LOOP        ; Loop, For Sure Always Positive

PLOTCHR:
                                                ;Ldx            Row
                CLC
                JSR             PLOT
                LDA             #'*'
                JSR             CHROUT          ;Send Character
Q1:                                             ; Hack To Avoid Indexing From 0
                RTS


        
; Star Pattern Data For Quadrant 1 (Rows 1-9)
; Each Byte Represents One Row (Bits 7-0 = Cols 1-8
                .byte %00000010
                .byte %01010001
                .byte %00110000
                .byte %01110010
                .byte %00001001
                .byte %00000100
                .byte %10010010
                .byte %01001001
