; Submission for the Vintage Computing Christmas Challenge 2025
; by Sean Gugler
; completed 2025-12-23
;
; Compiler: ca65
; Linker: as65

	.include "basicstub.s"

dot = '*'

screen_page = $0400


; Screen size 40 x 25
; Image size 19 x 19

row_length = 40
image_size = 19

half_row = row_length / 2
half_image = image_size / 2

top_margin = row_length * 5
center = screen_page + top_margin + (row_length * half_image) + half_row

top_left     = center - (row_length * half_image) - half_image
bottom_right = center + (row_length * half_image) + half_image


; The target image has rotational symmetry.
; Take advantage of this by plotting twice during each loop iteration:
; X plots forward from top left
; Y plots backward from bottom right
;
; They always add up to FF to make sure they both
; cross page boundaries at the same time.
;
; Base pointers are aligned such that Y=16 when we
; reach the last data point in the table, which cleanly
; sets up the calculation for the middle row.

dst2 = center - (half_image-1) + $100
start_y = bottom_right - dst2
start_x = $FF - start_y
dst1 = top_left - start_x
dst3 = center - (half_image-1)


	ldx #start_x
	ldy #start_y
	lda #dot

plot:
	bne move
addr1:
	sta dst1,x
addr2:
	sta dst2,y
	inc countdown+1

move:
	dey
	inx
	bne countdown
	dec addr2+2
	inc addr1+2
	
countdown:
	dec table
	bpl plot

; Explicit code for the middle row takes fewer bytes
; than listing those 8 data points in the table

middle_row:
	sta dst3,y
	dey
	bpl middle_row

	rts


; Deltas between plot points, half image
; from top left
table:
	.byte $09
	.byte $26,$02,$02,$1F,$02,$04,$01,$01
	.byte $04,$02,$1B,$01,$05,$05,$01,$1B
	.byte $01,$01,$03,$02,$02,$03,$01,$01
	.byte $1D,$03,$01,$01,$03,$21,$03,$03
	.byte $1D,$03,$03,$02,$02,$03,$03,$19
	.byte $03,$03,$01,$01,$03,$03,$18,$00



;  2 bytes file header (load address)
; 12 bytes BASIC stub launcher
; 39 bytes code
; 49 bytes data
;---
;102 bytes total
