#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(depth_less) out float gl_FragDepth;

struct RaymarchParams
{
    vec3 function_scale;
    int show_bounding_box;
    vec3 function_origin;
    int clamp_to_volume;
    int use_instance_origin;
    int txt1_flip_y;
    int txt2_flip_y;
    int gradient_idx;
    vec4 near_far_plane;
    int trace_inside;
    int _pad0;
    int _pad1;
    int _pad2;
    vec4 camera_projection_params;
    vec2 frustum_shift;
    vec2 resolution;
    float animation_time;
    float prestep;
    float voxel_sampling_mip;
    float voxel_step_scale;
    float dithering;
    float param6;
    float param7;
    float param8;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct _1384
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 1, binding = 4, std140) uniform RaymarchParamsBuffer
{
    RaymarchParams raymarch_params;
} _131;

layout(set = 1, binding = 1, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 5, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _633;

layout(set = 1, binding = 2, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 6, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1153;

layout(set = 1, binding = 7, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1176;

layout(set = 1, binding = 3, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1186;

layout(set = 1, binding = 8) uniform sampler3D s_voxel_occupancy_filtered;
layout(set = 1, binding = 9) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 10) uniform sampler2D sDepth;

layout(location = 0) flat in uint instanceID;
layout(location = 1) in _1384 vtx_input;

float det(mat2 matrix)
{
    return (matrix[0].x * matrix[1].y) - (matrix[0].y * matrix[1].x);
}

mat3 transpose_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat3 result = mat3(vec3(vec3(row0.x, row1.x, row2.x)), vec3(vec3(row0.y, row1.y, row2.y)), vec3(vec3(row0.z, row1.z, row2.z)));
    return result;
}

mat3 inverse_mat3(mat3 matrix)
{
    vec3 row0 = matrix[0];
    vec3 row1 = matrix[1];
    vec3 row2 = matrix[2];
    mat2 param = mat2(vec2(row1.y, row1.z), vec2(row2.y, row2.z));
    mat2 param_1 = mat2(vec2(row1.z, row1.x), vec2(row2.z, row2.x));
    mat2 param_2 = mat2(vec2(row1.x, row1.y), vec2(row2.x, row2.y));
    vec3 minors0 = vec3(det(param), det(param_1), det(param_2));
    mat2 param_3 = mat2(vec2(row2.y, row2.z), vec2(row0.y, row0.z));
    mat2 param_4 = mat2(vec2(row2.z, row2.x), vec2(row0.z, row0.x));
    mat2 param_5 = mat2(vec2(row2.x, row2.y), vec2(row0.x, row0.y));
    vec3 minors1 = vec3(det(param_3), det(param_4), det(param_5));
    mat2 param_6 = mat2(vec2(row0.y, row0.z), vec2(row1.y, row1.z));
    mat2 param_7 = mat2(vec2(row0.z, row0.x), vec2(row1.z, row1.x));
    mat2 param_8 = mat2(vec2(row0.x, row0.y), vec2(row1.x, row1.y));
    vec3 minors2 = vec3(det(param_6), det(param_7), det(param_8));
    mat3 param_9 = mat3(vec3(minors0), vec3(minors1), vec3(minors2));
    mat3 adj = transpose_mat3(param_9);
    return adj * (1.0 / dot(row0, minors0));
}

float linearizeDepth(float d)
{
    return _131.raymarch_params.near_far_plane.z / (_131.raymarch_params.near_far_plane.y - (d * _131.raymarch_params.near_far_plane.w));
}

float sdBox(vec3 p, vec3 b)
{
    vec3 q = abs(p) - b;
    return length(max(q, vec3(0.0))) + min(max(q.x, max(q.y, q.z)), 0.0);
}

float raymarchBBox(vec3 ro, vec3 rd, vec3 function_scale)
{
    float h = 0.00200000009499490261077880859375;
    float t = 0.0;
    float res = -1.0;
    for (int i = 0; i < 48; i++)
    {
        if ((h < 0.001000000047497451305389404296875) || (t > 20000.0))
        {
            break;
        }
        vec3 param = ro + (rd * t);
        vec3 param_1 = vec3(1000.0);
        vec3 param_2 = ro + (rd * t);
        vec3 param_3 = (function_scale * 0.5) + vec3(0.00999999977648258209228515625);
        h = max(sdBox(param, param_1), -sdBox(param_2, param_3));
        t += h;
    }
    if (t < 20000.0)
    {
        res = t;
    }
    return res;
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_131.raymarch_params.frustum_shift * _131.raymarch_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_131.raymarch_params.camera_projection_params.z) + ((_131.raymarch_params.camera_projection_params.x * vd_pos.x) / _131.raymarch_params.resolution.x);
    view_direction.y = (-_131.raymarch_params.camera_projection_params.w) + ((_131.raymarch_params.camera_projection_params.y * vd_pos.y) / _131.raymarch_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float sample_voxelization_data_occupancy(vec3 world_position, float color_lod, float occupancy_lod)
{
    vec3 voxelizer_bbox_origin = in_bbox_data.bbox_voxelize_min.xyz;
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz * 256.0;
    vec3 source_voxel_position = (world_position - voxelizer_bbox_origin) / voxelizer_bbox_size;
    bool _224 = source_voxel_position.x < 0.0;
    bool _231;
    if (!_224)
    {
        _231 = source_voxel_position.y < 0.0;
    }
    else
    {
        _231 = _224;
    }
    bool _238;
    if (!_231)
    {
        _238 = source_voxel_position.z < 0.0;
    }
    else
    {
        _238 = _231;
    }
    bool _245;
    if (!_238)
    {
        _245 = source_voxel_position.x >= 1.0;
    }
    else
    {
        _245 = _238;
    }
    bool _252;
    if (!_245)
    {
        _252 = source_voxel_position.y >= 1.0;
    }
    else
    {
        _252 = _245;
    }
    bool _259;
    if (!_252)
    {
        _259 = source_voxel_position.z >= 1.0;
    }
    else
    {
        _259 = _252;
    }
    if (_259)
    {
        return 0.0;
    }
    float voxel_occupancy = textureLod(s_voxel_occupancy_filtered, source_voxel_position, occupancy_lod).x;
    return voxel_occupancy;
}

float hash(inout vec3 p)
{
    p = fract((p * 0.31830990314483642578125) + vec3(0.10999999940395355224609375, 0.17000000178813934326171875, 0.12999999523162841796875)) * 17.0;
    return fract(((p.x * p.y) * p.z) * ((p.x + p.y) + p.z));
}

float sdBase(vec3 p)
{
    vec3 i = floor(p);
    vec3 f = fract(p);
    vec3 param = i + vec3(0.0);
    float _425 = hash(param);
    vec3 param_1 = i + vec3(0.0);
    float _429 = hash(param_1);
    vec3 param_2 = i + vec3(0.0, 0.0, 1.0);
    float _441 = hash(param_2);
    vec3 param_3 = i + vec3(0.0, 0.0, 1.0);
    float _445 = hash(param_3);
    vec3 param_4 = i + vec3(0.0, 1.0, 0.0);
    float _457 = hash(param_4);
    vec3 param_5 = i + vec3(0.0, 1.0, 0.0);
    float _461 = hash(param_5);
    vec3 param_6 = i + vec3(0.0, 1.0, 1.0);
    float _472 = hash(param_6);
    vec3 param_7 = i + vec3(0.0, 1.0, 1.0);
    float _476 = hash(param_7);
    vec3 param_8 = i + vec3(1.0, 0.0, 0.0);
    float _489 = hash(param_8);
    vec3 param_9 = i + vec3(1.0, 0.0, 0.0);
    float _493 = hash(param_9);
    vec3 param_10 = i + vec3(1.0, 0.0, 1.0);
    float _504 = hash(param_10);
    vec3 param_11 = i + vec3(1.0, 0.0, 1.0);
    float _508 = hash(param_11);
    vec3 param_12 = i + vec3(1.0, 1.0, 0.0);
    float _520 = hash(param_12);
    vec3 param_13 = i + vec3(1.0, 1.0, 0.0);
    float _524 = hash(param_13);
    vec3 param_14 = i + vec3(1.0);
    float _535 = hash(param_14);
    vec3 param_15 = i + vec3(1.0);
    float _539 = hash(param_15);
    return min(min(min(length(f - vec3(0.0)) - ((_425 * _429) * 0.699999988079071044921875), length(f - vec3(0.0, 0.0, 1.0)) - ((_441 * _445) * 0.699999988079071044921875)), min(length(f - vec3(0.0, 1.0, 0.0)) - ((_457 * _461) * 0.699999988079071044921875), length(f - vec3(0.0, 1.0, 1.0)) - ((_472 * _476) * 0.699999988079071044921875))), min(min(length(f - vec3(1.0, 0.0, 0.0)) - ((_489 * _493) * 0.699999988079071044921875), length(f - vec3(1.0, 0.0, 1.0)) - ((_504 * _508) * 0.699999988079071044921875)), min(length(f - vec3(1.0, 1.0, 0.0)) - ((_520 * _524) * 0.699999988079071044921875), length(f - vec3(1.0)) - ((_535 * _539) * 0.699999988079071044921875))));
}

float smax(float a, float b, float k)
{
    float h = max(k - abs(a - b), 0.0);
    return max(a, b) + (((h * h) * 0.25) / k);
}

vec2 subtractiveFBM(inout vec3 p, inout float d)
{
    p *= 0.250999987125396728515625;
    float t = 0.0;
    float s = 1.0;
    for (int i = 0; i < 6; i++)
    {
        vec3 param = p;
        float n = s * sdBase(param);
        float param_1 = d;
        float param_2 = -n;
        float param_3 = 0.1500000059604644775390625 * s;
        d = smax(param_1, param_2, param_3);
        t += d;
        p = mat3(vec3(0.0, 1.60000002384185791015625, 1.2000000476837158203125), vec3(-1.60000002384185791015625, 0.7200000286102294921875, -0.959999978542327880859375), vec3(-1.2000000476837158203125, -0.959999978542327880859375, 1.2799999713897705078125)) * p;
        s = 0.550000011920928955078125 * s;
    }
    return vec2(d, t);
}

vec2 sdFbm(vec3 pos, float d)
{
    vec3 param = pos;
    float param_1 = d;
    vec2 _608 = subtractiveFBM(param, param_1);
    return _608;
}

float map(vec3 pos)
{
    vec3 param = pos;
    float param_1 = -0.0040000001899898052215576171875;
    return sdFbm(param, param_1).x;
}

float fun(vec3 pos)
{
    vec3 world_pos = pos;
    world_pos -= _131.raymarch_params.function_origin;
    world_pos /= _131.raymarch_params.function_scale;
    vec3 param = world_pos;
    mat4 param_1 = _633.transform_params.mModel;
    vec3 _640 = vector_transform_by_mat43(param, param_1);
    world_pos = _640;
    vec3 param_2 = world_pos;
    float param_3 = 1.0;
    float param_4 = _131.raymarch_params.voxel_sampling_mip;
    float voxel_occupancy = sample_voxelization_data_occupancy(param_2, param_3, param_4);
    float d = voxel_occupancy;
    if (d > 0.0)
    {
        float zero_point = 0.25;
        d = min(1.0, d * (1.0 / (1.0 - zero_point)));
        float d_base = d;
    }
    d = 1.0 - d;
    d = (d * _131.raymarch_params.voxel_step_scale) * min(min(_131.raymarch_params.function_scale.x, _131.raymarch_params.function_scale.y), _131.raymarch_params.function_scale.z);
    SPIRV_CROSS_BRANCH
    if (voxel_occupancy > 0.0)
    {
        vec3 param_5 = pos;
        float d2 = map(param_5);
        d = max(d, d2);
    }
    return d;
}

vec4 raymarch(vec3 ro, vec3 rd, float max_t, out float intersection)
{
    vec4 sum = vec4(0.0);
    vec3 voxelizer_bbox_size = in_bbox_data.grid_size_voxelize.xyz / vec3(256.0);
    float t = 0.0;
    intersection = -1.0;
    float t_step = 0.100000001490116119384765625;
    float dither = texelFetch(s_BlueNoise, ivec3(ivec2(uvec2(gl_FragCoord.xy) % uvec2(128u)), 0), 0).x;
    t += (_131.raymarch_params.dithering * dither);
    for (int i = 0; i < 32; i++)
    {
        float trace_t = t;
        if (trace_t >= max_t)
        {
            break;
        }
        vec3 pos = ro + (rd * trace_t);
        vec3 world_pos = pos;
        world_pos -= _131.raymarch_params.function_origin;
        world_pos /= _131.raymarch_params.function_scale;
        vec3 param = world_pos;
        mat4 param_1 = _633.transform_params.mModel;
        vec3 _775 = vector_transform_by_mat43(param, param_1);
        world_pos = _775;
        vec3 param_2 = world_pos;
        float param_3 = 1.0;
        float param_4 = _131.raymarch_params.voxel_sampling_mip + 1.0;
        float voxel_occupancy = sample_voxelization_data_occupancy(param_2, param_3, param_4);
        if (voxel_occupancy > 0.0)
        {
            break;
        }
        t += (t_step * _131.raymarch_params.prestep);
    }
    for (int i_1 = 0; i_1 < 8; i_1++)
    {
        float trace_t_1 = t;
        vec3 pos_1 = ro + (rd * trace_t_1);
        if (trace_t_1 >= max_t)
        {
            break;
        }
        vec3 param_5 = pos_1;
        float dt = fun(param_5);
        if (dt < (9.9999997473787516355514526367188e-05 * min(min(_131.raymarch_params.function_scale.x, _131.raymarch_params.function_scale.y), _131.raymarch_params.function_scale.z)))
        {
            intersection = min(max_t, t);
            return vec4(1.0099999904632568359375, 1.0099999904632568359375, 1.0099999904632568359375, 0.0);
        }
        vec2 d = vec2(dt, 0.0040000001899898052215576171875);
        vec3 world_pos_1 = pos_1;
        world_pos_1 -= _131.raymarch_params.function_origin;
        world_pos_1 /= _131.raymarch_params.function_scale;
        vec3 param_6 = world_pos_1;
        mat4 param_7 = _633.transform_params.mModel;
        vec3 _864 = vector_transform_by_mat43(param_6, param_7);
        world_pos_1 = _864;
        vec3 _872 = vec3(fract(world_pos_1 * 0.10119999945163726806640625));
        sum.x = _872.x;
        sum.y = _872.y;
        sum.z = _872.z;
        t += d.x;
    }
    sum.w = sum.x;
    if (t >= max_t)
    {
        sum.x = 0.0;
        sum.y = 0.0;
        sum.z = 0.0;
    }
    intersection = 0.0;
    return vec4(max(vec3(0.0), sum.xyz), sum.w);
}

float calcIntersection(vec3 ro, vec3 rd, float max_t, out vec4 color)
{
    vec3 param = ro;
    vec3 param_1 = rd;
    float param_2 = max_t;
    float param_3;
    vec4 _918 = raymarch(param, param_1, param_2, param_3);
    float intersection = param_3;
    color = _918;
    return intersection;
}

void main()
{
    MaterialPropertiesGPU _1161;
    _1161.diffuse = materials.material_properties[_1153.materialIndex].diffuse;
    _1161.transparency = materials.material_properties[_1153.materialIndex].transparency;
    _1161.emissive = materials.material_properties[_1153.materialIndex].emissive;
    _1161.roughness = materials.material_properties[_1153.materialIndex].roughness;
    _1161.triplanar_factor = materials.material_properties[_1153.materialIndex].triplanar_factor;
    _1161.refraction = materials.material_properties[_1153.materialIndex].refraction;
    _1161.normal_factor = materials.material_properties[_1153.materialIndex].normal_factor;
    _1161.emissive_factor = materials.material_properties[_1153.materialIndex].emissive_factor;
    _1161.temporal_accumulation_factor = materials.material_properties[_1153.materialIndex].temporal_accumulation_factor;
    _1161.shadowmap_bias = materials.material_properties[_1153.materialIndex].shadowmap_bias;
    _1161.metalness = materials.material_properties[_1153.materialIndex].metalness;
    _1161.albedo_sampler = materials.material_properties[_1153.materialIndex].albedo_sampler;
    _1161.emissive_sampler = materials.material_properties[_1153.materialIndex].emissive_sampler;
    _1161.normal_sampler = materials.material_properties[_1153.materialIndex].normal_sampler;
    _1161.metalic_roughness_sampler = materials.material_properties[_1153.materialIndex].metalic_roughness_sampler;
    _1161.flags = materials.material_properties[_1153.materialIndex].flags;
    _1161._pad0 = materials.material_properties[_1153.materialIndex]._pad0;
    _1161._pad1 = materials.material_properties[_1153.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1161;
    vec4 outAlbedo = vec4(1.0);
    mat4 mat_instance_model;
    mat_instance_model[0] = vec4(1.0, 0.0, 0.0, 0.0);
    mat_instance_model[1] = vec4(0.0, 1.0, 0.0, 0.0);
    mat_instance_model[2] = vec4(0.0, 0.0, 1.0, 0.0);
    mat_instance_model[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (_1176.instance_params.stride > 0)
    {
        vec4 inst_m0 = _1186.instance_transform[(instanceID * uint(_1176.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1186.instance_transform[(instanceID * uint(_1176.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1186.instance_transform[(instanceID * uint(_1176.instance_params.stride)) + 2u];
        vec3 _1221 = vec3(inst_m0.x, inst_m1.x, inst_m2.x);
        mat_instance_model[0].x = _1221.x;
        mat_instance_model[0].y = _1221.y;
        mat_instance_model[0].z = _1221.z;
        vec3 _1234 = vec3(inst_m0.y, inst_m1.y, inst_m2.y);
        mat_instance_model[1].x = _1234.x;
        mat_instance_model[1].y = _1234.y;
        mat_instance_model[1].z = _1234.z;
        vec3 _1247 = vec3(inst_m0.z, inst_m1.z, inst_m2.z);
        mat_instance_model[2].x = _1247.x;
        mat_instance_model[2].y = _1247.y;
        mat_instance_model[2].z = _1247.z;
        vec3 _1260 = vec3(inst_m0.w, inst_m1.w, inst_m2.w);
        mat_instance_model[3].x = _1260.x;
        mat_instance_model[3].y = _1260.y;
        mat_instance_model[3].z = _1260.z;
    }
    vec3 instance_function_origin = _131.raymarch_params.function_origin;
    if (_131.raymarch_params.use_instance_origin != 0)
    {
        instance_function_origin = (mat_instance_model * vec4(_131.raymarch_params.function_origin, 1.0)).xyz * 0.001000000047497451305389404296875;
    }
    mat_instance_model = _633.transform_params.mModel * mat_instance_model;
    mat4 mat_instance_model_inv = mat_instance_model;
    mat3 param = mat3(mat_instance_model_inv[0].xyz, mat_instance_model_inv[1].xyz, mat_instance_model_inv[2].xyz);
    mat3 inv = inverse_mat3(param);
    mat_instance_model_inv[0].x = inv[0].x;
    mat_instance_model_inv[0].y = inv[0].y;
    mat_instance_model_inv[0].z = inv[0].z;
    mat_instance_model_inv[1].x = inv[1].x;
    mat_instance_model_inv[1].y = inv[1].y;
    mat_instance_model_inv[1].z = inv[1].z;
    mat_instance_model_inv[2].x = inv[2].x;
    mat_instance_model_inv[2].y = inv[2].y;
    mat_instance_model_inv[2].z = inv[2].z;
    mat_instance_model_inv[3].x = -(((inv[0].x * mat_instance_model[3].x) + (inv[1].x * mat_instance_model[3].y)) + (inv[2].x * mat_instance_model[3].z));
    mat_instance_model_inv[3].y = -(((inv[0].y * mat_instance_model[3].x) + (inv[1].y * mat_instance_model[3].y)) + (inv[2].y * mat_instance_model[3].z));
    mat_instance_model_inv[3].z = -(((inv[0].z * mat_instance_model[3].x) + (inv[1].z * mat_instance_model[3].y)) + (inv[2].z * mat_instance_model[3].z));
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 ro = (mat_instance_model_inv * vec4(vtx_input.vCameraRelativeWorldPos + _633.transform_params.vCameraPosition, 1.0)).xyz;
    vec3 rd = (mat_instance_model_inv * vec4(_633.transform_params.vCameraPosition, 1.0)).xyz;
    rd = normalize(ro - rd);
    if (_131.raymarch_params.trace_inside != 0)
    {
        ro = (mat_instance_model_inv * vec4(_633.transform_params.vCameraPosition, 1.0)).xyz;
    }
    ro *= _131.raymarch_params.function_scale;
    vec3 ro_bounding_volume = ro;
    ro += instance_function_origin;
    float raw_depth = texelFetch(sDepth, ivec2(gl_FragCoord.xy), 0).x;
    float param_1 = raw_depth;
    float max_depth = linearizeDepth(param_1);
    vec4 color = vec4(1.0);
    float bounding_volume_intersection = 100000.0;
    if (_131.raymarch_params.clamp_to_volume != 0)
    {
        vec3 param_2 = ro_bounding_volume;
        vec3 param_3 = rd;
        vec3 param_4 = _131.raymarch_params.function_scale;
        bounding_volume_intersection = raymarchBBox(param_2, param_3, param_4);
    }
    bounding_volume_intersection = max_depth;
    vec2 param_5 = vec2(gl_FragCoord.xy);
    vec3 view_direction = get_view_direction(param_5);
    vec3 world = (_633.transform_params.mViewInv * vec4(view_direction * max_depth, 1.0)).xyz;
    float d = length((_633.transform_params.mModelInv * vec4(world - _633.transform_params.vCameraPosition, 0.0)).xyz);
    bounding_volume_intersection = d * _131.raymarch_params.function_scale.z;
    vec3 param_6 = ro;
    vec3 param_7 = rd;
    float param_8 = bounding_volume_intersection;
    vec4 param_9;
    float _1525 = calcIntersection(param_6, param_7, param_8, param_9);
    color = param_9;
    float intersection = _1525;
    if (intersection > 0.0)
    {
        vec3 ri = ro + (rd * intersection);
        ri -= instance_function_origin;
        ri /= _131.raymarch_params.function_scale;
        ri = ((_633.transform_params.mView * mat_instance_model) * vec4(ri, 1.0)).xyz;
        outAlbedo.x = material.diffuse.x;
        outAlbedo.y = material.diffuse.y;
        outAlbedo.z = material.diffuse.z;
        outAlbedo.w = 1.0 - color.w;
        vec2 param_10 = vec2(gl_FragCoord.xy);
        vec3 view_direction_1 = get_view_direction(param_10);
        vec3 world_1 = (_633.transform_params.mViewInv * vec4(view_direction_1 * max_depth, 1.0)).xyz;
        float d_1 = length(_633.transform_params.vCameraPosition - world_1);
        float near = -1.0;
        float far = 1.0;
        float depth = (_633.transform_params.mProjection * vec4(ri, 1.0)).z / (_633.transform_params.mProjection * vec4(ri, 1.0)).w;
        depth = ((((far - near) * depth) + near) + far) / 2.0;
        gl_FragDepth = depth;
    }
    else
    {
        if (_131.raymarch_params.show_bounding_box != 0)
        {
            if (intersection == (-1.0))
            {
                outAlbedo = vec4(0.4000000059604644775390625, 0.20000000298023223876953125, 0.0, 1.0);
            }
            else
            {
                outAlbedo = vec4(5.0, 0.0, 0.0, 1.0);
            }
            vec3 _1649 = fract(vtx_input.vCoords * 0.00999999977648258209228515625);
            outAlbedo.x = _1649.x;
            outAlbedo.y = _1649.y;
            outAlbedo.z = _1649.z;
        }
        else
        {
            outAlbedo.x = 1.0;
            outAlbedo.y = 0.0;
            outAlbedo.z = 0.0;
            outAlbedo.w = 1.0;
            discard;
        }
    }
}

 