#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryCopyDeformParams
{
    int surfaces_num;
    int surface_idx;
    int attribute_mask;
    int create_copy;
    int export_factor_as_custom0;
    int _pad0;
    int _pad1;
    int _pad2;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _149;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 13, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _264;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 14, std140) uniform VM0
{
    VertexModifierDisplaceParams VM0_params;
} _482;

layout(set = 0, binding = 15, std140) uniform GeometryCopyDeformParamsBuffer
{
    GeometryCopyDeformParams geometry_copy_deform_params;
} _513;

layout(set = 0, binding = 12, std430) buffer VertexCopyFlagBuffer
{
    uint data[];
} vtx_copy_flag_data;

uint get_idx(inout uint idx)
{
    idx += _264.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _149.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _264.input_geometry_information.attributes[0].stride;
    idx += _264.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _264.input_geometry_information.attributes[1].stride;
    idx += _264.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _264.input_geometry_information.attributes[2].stride;
    idx += _264.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

uint get_custom0(inout uint idx)
{
    idx *= _264.input_geometry_information.attributes[6].stride;
    idx += _264.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

VertexInput apply_vertex_modifier_for_vtx(uint i0, inout VertexInput vtx_input, out float factor)
{
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_instance_model;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = i0;
    modifier_factor.id = i0;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    if ((_264.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
    {
        uint param = i0;
        uint _453 = get_custom0(param);
        modifier_factor.custom0 = _453;
    }
    if ((_264.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
    {
        uint param_1 = i0;
        vec3 _464 = get_albedo(param_1);
        modifier_factor.color.x = _464.x;
        modifier_factor.color.y = _464.y;
        modifier_factor.color.z = _464.z;
    }
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    VertexModifierDisplaceParams _487;
    _487.displace_normal = _482.VM0_params.displace_normal;
    _487.displace_normal_modifier_factor = _482.VM0_params.displace_normal_modifier_factor;
    _487.displace_base = _482.VM0_params.displace_base;
    _487.displace_base_modifier_factor = _482.VM0_params.displace_base_modifier_factor;
    _487.influence_scope = _482.VM0_params.influence_scope;
    VertexModifierDisplaceParams param_2 = _487;
    ModifierFactor param_3 = modifier_factor;
    VertexInput param_4 = vtx_input;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    vertex_modifier_displace_apply(param_2, param_3, param_4, param_5);
    modifier_factor = param_3;
    vtx_input = param_4;
    factor = modifier_factor.factor;
    return vtx_input;
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _149.output_geometry_information.attributes[0].stride;
    idx += _149.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _149.output_geometry_information.attributes[1].stride;
    idx += _149.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _149.output_geometry_information.attributes[2].stride;
    idx += _149.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _149.output_geometry_information.attributes[6].stride;
    idx += _149.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_513.geometry_copy_deform_params.surface_idx);
    uint src_faces_num = _264.input_geometry_information.faces_num_per_surface[surface_idx];
    for (uint src_face_idx = thread_idx; src_face_idx < src_faces_num; src_face_idx += 131072u)
    {
        uint param = (src_face_idx * 3u) + 0u;
        uint _538 = get_idx(param);
        uint i0 = _538;
        uint param_1 = (src_face_idx * 3u) + 1u;
        uint _544 = get_idx(param_1);
        uint i1 = _544;
        uint param_2 = (src_face_idx * 3u) + 2u;
        uint _550 = get_idx(param_2);
        uint i2 = _550;
        uint dst_face_idx = src_face_idx;
        uint param_3 = (dst_face_idx * 3u) + 0u;
        uint param_4 = i0;
        put_idx(param_3, param_4);
        uint param_5 = (dst_face_idx * 3u) + 1u;
        uint param_6 = i1;
        put_idx(param_5, param_6);
        uint param_7 = (dst_face_idx * 3u) + 2u;
        uint param_8 = i2;
        put_idx(param_7, param_8);
    }
    _149.output_geometry_information.faces_num_per_surface[surface_idx] = src_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num = _264.input_geometry_information.vtx_num;
        VertexInput vtx_input;
        float param_15;
        for (uint src_vtx_idx = thread_idx; src_vtx_idx < src_vtx_num; src_vtx_idx += 131072u)
        {
            uint i0_1 = src_vtx_idx;
            uint i0_remapped = vtx_copy_flag_data.data[i0_1];
            bool i0_copy = i0_remapped != 0u;
            i0_remapped--;
            if (i0_copy)
            {
                uint param_9 = i0_1;
                vec3 _618 = get_coords(param_9);
                vec3 v0_coords = _618;
                vec3 v0_normal = vec3(0.0, 0.0, 1.0);
                if ((_264.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    uint param_10 = i0_1;
                    vec3 _629 = get_normal(param_10);
                    v0_normal = _629;
                }
                vec3 v0_albedo = vec3(1.0);
                if ((_264.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
                {
                    uint param_11 = i0_1;
                    vec3 _640 = get_albedo(param_11);
                    v0_albedo = _640;
                }
                uint v0_custom0 = 0u;
                if ((_264.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint param_12 = i0_1;
                    uint _650 = get_custom0(param_12);
                    v0_custom0 = _650;
                }
                vtx_input.pos = v0_coords;
                vtx_input.norm = v0_normal;
                vtx_input.color.x = v0_albedo.x;
                vtx_input.color.y = v0_albedo.y;
                vtx_input.color.z = v0_albedo.z;
                uint param_13 = i0_1;
                VertexInput param_14 = vtx_input;
                VertexInput _669 = apply_vertex_modifier_for_vtx(param_13, param_14, param_15);
                float modifier_factor = param_15;
                vtx_input = _669;
                if (_513.geometry_copy_deform_params.export_factor_as_custom0 != 0)
                {
                    v0_custom0 = floatBitsToUint(modifier_factor);
                }
                uint param_16 = i0_remapped;
                vec3 param_17 = vtx_input.pos;
                put_coords(param_16, param_17);
                if ((_149.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
                {
                    uint param_18 = i0_remapped;
                    vec3 param_19 = vtx_input.norm;
                    put_normal(param_18, param_19);
                }
                if ((_149.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
                {
                    uint param_20 = i0_remapped;
                    vec3 param_21 = v0_albedo;
                    put_albedo(param_20, param_21);
                }
                if ((_149.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
                {
                    uint param_22 = i0_remapped;
                    uint param_23 = v0_custom0;
                    put_custom0(param_22, param_23);
                }
            }
        }
    }
}

 