#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VM3Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _395;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _426;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _449;

layout(set = 0, binding = 6, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1111;

layout(set = 0, binding = 7, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _1321;

layout(set = 0, binding = 4, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _1395;

layout(set = 0, binding = 8, std140) uniform VM1
{
    ParticleModifierCurl_Params VM1_params;
} _1429;

layout(set = 0, binding = 9, std140) uniform VM2
{
    ParticleModifierCurl_Params VM2_params;
} _1455;

layout(set = 0, binding = 10, std140) uniform VM3
{
    VM3Params VM3_params;
} _1476;

layout(set = 0, binding = 5, std430) buffer VM4
{
    ParticleModifierSwirl_Params VM4_params;
} _1501;

layout(set = 0, binding = 11) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_449.prt_prev_positions[(id * 3u) + 0u], _449.prt_prev_positions[(id * 3u) + 1u], _449.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _401;
    _401.life_time = _395.prt_states[id].life_time;
    _401.life_span = _395.prt_states[id].life_span;
    _401.generation_id = _395.prt_states[id].generation_id;
    _401.color = _395.prt_states[id].color;
    ParticleState _400 = _401;
    return _400;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _408;
    _408.life_time = state.life_time;
    _408.life_span = state.life_span;
    _408.generation_id = state.generation_id;
    _408.color = state.color;
    _395.prt_states[id] = _408;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _489 = color_convert_rgb_float3_uint(param);
    uint v = _489;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _941 = vector_transform_by_mat43(param_6, param_7);
    pos = _941;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1111.globals.time, _1111.globals.time * 0.3014999926090240478515625, (-_1111.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1133 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1133 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _375 = hash(param);
    uint param_1 = _375;
    float _377 = floatConstruct(param_1);
    return _377;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (lifecycle_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad * modifier_factor.factor;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(lifecycle_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _426.prt_positions[(id * 3u) + 0u] = p.x;
    _426.prt_positions[(id * 3u) + 1u] = p.y;
    _426.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _449.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _449.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _449.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_1321.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _1321.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _1366;
    if (prt_is_alive(param_6))
    {
        _1366 = p.pos;
    }
    else
    {
        _1366 = vec3(0.0);
    }
    modifier_factor.position = _1366;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _1399 = atomicAdd(_1395.VM0_params.pending, -1);
        int pending = _1399;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _1408;
            _1408.transform = _1395.VM0_params.transform;
            _1408.particle_color = _1395.VM0_params.particle_color;
            _1408.primitive_size = _1395.VM0_params.primitive_size;
            _1408.perimeter_only = _1395.VM0_params.perimeter_only;
            _1408.primitive_type = _1395.VM0_params.primitive_type;
            _1408.particle_lifetime = _1395.VM0_params.particle_lifetime;
            _1408.particle_lifetime_randomness = _1395.VM0_params.particle_lifetime_randomness;
            _1408.rate = _1395.VM0_params.rate;
            _1408.seed = _1395.VM0_params.seed;
            _1408.pending = _1395.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_8 = _1408;
            ParticleLifecycleParams _1413;
            _1413.time_step = _1321.lifecycle_params.time_step;
            _1413.life_time_step = _1321.lifecycle_params.life_time_step;
            _1413.max_lifetime = _1321.lifecycle_params.max_lifetime;
            _1413.reset = _1321.lifecycle_params.reset;
            _1413.capacity = _1321.lifecycle_params.capacity;
            _1413.has_previous = _1321.lifecycle_params.has_previous;
            ParticleLifecycleParams param_9 = _1413;
            Particle param_10 = p;
            uint param_11 = id;
            particle_emitter_primitive_emit(param_8, param_9, param_10, param_11);
            p = param_10;
        }
    }
    ParticleState param_12 = p.state;
    if (prt_is_alive(param_12))
    {
        ParticleModifierCurl_Params _1434;
        _1434.position = _1429.VM1_params.position;
        _1434.falloff_mode = _1429.VM1_params.falloff_mode;
        _1434.radius = _1429.VM1_params.radius;
        _1434.falloff_inverse = _1429.VM1_params.falloff_inverse;
        _1434.noise_strength = _1429.VM1_params.noise_strength;
        _1434.noise_speed = _1429.VM1_params.noise_speed;
        _1434.noise_scale = _1429.VM1_params.noise_scale;
        ParticleModifierCurl_Params param_13 = _1434;
        ParticleLifecycleParams _1438;
        _1438.time_step = _1321.lifecycle_params.time_step;
        _1438.life_time_step = _1321.lifecycle_params.life_time_step;
        _1438.max_lifetime = _1321.lifecycle_params.max_lifetime;
        _1438.reset = _1321.lifecycle_params.reset;
        _1438.capacity = _1321.lifecycle_params.capacity;
        _1438.has_previous = _1321.lifecycle_params.has_previous;
        ParticleLifecycleParams param_14 = _1438;
        ModifierFactor param_15 = modifier_factor;
        Particle param_16 = p;
        uint param_17 = id;
        particle_modifier_curl(param_13, param_14, param_15, param_16, param_17);
        p = param_16;
    }
    ParticleState param_18 = p.state;
    if (prt_is_alive(param_18))
    {
        ParticleModifierCurl_Params _1459;
        _1459.position = _1455.VM2_params.position;
        _1459.falloff_mode = _1455.VM2_params.falloff_mode;
        _1459.radius = _1455.VM2_params.radius;
        _1459.falloff_inverse = _1455.VM2_params.falloff_inverse;
        _1459.noise_strength = _1455.VM2_params.noise_strength;
        _1459.noise_speed = _1455.VM2_params.noise_speed;
        _1459.noise_scale = _1455.VM2_params.noise_scale;
        ParticleModifierCurl_Params param_19 = _1459;
        ParticleLifecycleParams _1463;
        _1463.time_step = _1321.lifecycle_params.time_step;
        _1463.life_time_step = _1321.lifecycle_params.life_time_step;
        _1463.max_lifetime = _1321.lifecycle_params.max_lifetime;
        _1463.reset = _1321.lifecycle_params.reset;
        _1463.capacity = _1321.lifecycle_params.capacity;
        _1463.has_previous = _1321.lifecycle_params.has_previous;
        ParticleLifecycleParams param_20 = _1463;
        ModifierFactor param_21 = modifier_factor;
        Particle param_22 = p;
        uint param_23 = id;
        particle_modifier_curl(param_19, param_20, param_21, param_22, param_23);
        p = param_22;
    }
    vec3 modifier_position = _1476.VM3_params.position;
    p.pos += ((_1476.VM3_params.velocity * _1321.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_24 = p.state;
    if (prt_is_alive(param_24))
    {
        ParticleModifierSwirl_Params _1506;
        _1506.position = _1501.VM4_params.position;
        _1506.falloff_curve_idx = _1501.VM4_params.falloff_curve_idx;
        _1506.radius = _1501.VM4_params.radius;
        _1506.falloff_inverse = _1501.VM4_params.falloff_inverse;
        _1506.velocity = _1501.VM4_params.velocity;
        _1506.velocity_randomness = _1501.VM4_params.velocity_randomness;
        _1506.time_step = _1501.VM4_params.time_step;
        _1506.axis_randomness = _1501.VM4_params.axis_randomness;
        _1506.axis = _1501.VM4_params.axis;
        _1506._pad0 = _1501.VM4_params._pad0;
        _1506.scale = _1501.VM4_params.scale;
        _1506._pad1 = _1501.VM4_params._pad1;
        ParticleModifierSwirl_Params param_25 = _1506;
        ParticleLifecycleParams _1510;
        _1510.time_step = _1321.lifecycle_params.time_step;
        _1510.life_time_step = _1321.lifecycle_params.life_time_step;
        _1510.max_lifetime = _1321.lifecycle_params.max_lifetime;
        _1510.reset = _1321.lifecycle_params.reset;
        _1510.capacity = _1321.lifecycle_params.capacity;
        _1510.has_previous = _1321.lifecycle_params.has_previous;
        ParticleLifecycleParams param_26 = _1510;
        ModifierFactor param_27 = modifier_factor;
        Particle param_28 = p;
        uint param_29 = id;
        particle_modifier_swirl(param_25, param_26, param_27, param_28, param_29);
        p = param_28;
    }
    ParticleState param_30 = p.state;
    float param_31 = _1321.lifecycle_params.life_time_step;
    float param_32 = _1321.lifecycle_params.max_lifetime;
    prt_advance_life(param_30, param_31, param_32);
    p.state = param_30;
    uint param_33 = id;
    ParticleState param_34 = p.state;
    prt_set_state(param_33, param_34);
    uint param_35 = id;
    vec3 param_36 = p.pos;
    prt_set_position(param_35, param_36);
    bool _1545 = _1321.lifecycle_params.has_previous != 0u;
    bool _1552;
    if (_1545)
    {
        _1552 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _1552 = _1545;
    }
    if (_1552)
    {
        uint param_37 = id;
        vec3 param_38 = p.pos;
        prt_set_prev_position(param_37, param_38);
    }
}

 