#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(triangles, cw, fractional_odd_spacing) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 4, binding = 3, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _306;

layout(set = 4, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _324;

layout(set = 4, binding = 4, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _420;

layout(set = 4, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _520;

layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_outputs;

layout(location = 1) in Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_inputs[32];

layout(location = 0) in uint instanceID[];

vec3 interpolate_bc(vec3 v1, vec3 v2, vec3 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec4 interpolate_bc(vec4 v1, vec4 v2, vec4 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec2 interpolate_bc(vec2 v1, vec2 v2, vec2 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    vec3 param = vtx_inputs[0].vCoords;
    vec3 param_1 = vtx_inputs[1].vCoords;
    vec3 param_2 = vtx_inputs[2].vCoords;
    vec3 param_3 = gl_TessCoord;
    vtx_outputs.vCoords = interpolate_bc(param, param_1, param_2, param_3);
    vec3 param_4 = vtx_inputs[0].vNorm;
    vec3 param_5 = vtx_inputs[1].vNorm;
    vec3 param_6 = vtx_inputs[2].vNorm;
    vec3 param_7 = gl_TessCoord;
    vtx_outputs.vNorm = interpolate_bc(param_4, param_5, param_6, param_7);
    vec3 param_8 = vtx_inputs[0].vLocalPos;
    vec3 param_9 = vtx_inputs[1].vLocalPos;
    vec3 param_10 = vtx_inputs[2].vLocalPos;
    vec3 param_11 = gl_TessCoord;
    vtx_outputs.vLocalPos = interpolate_bc(param_8, param_9, param_10, param_11);
    vec4 param_12 = vtx_inputs[0].vColor;
    vec4 param_13 = vtx_inputs[1].vColor;
    vec4 param_14 = vtx_inputs[2].vColor;
    vec3 param_15 = gl_TessCoord;
    vtx_outputs.vColor = interpolate_bc(param_12, param_13, param_14, param_15);
    vec2 param_16 = vtx_inputs[0].vUV0;
    vec2 param_17 = vtx_inputs[1].vUV0;
    vec2 param_18 = vtx_inputs[2].vUV0;
    vec3 param_19 = gl_TessCoord;
    vtx_outputs.vUV0 = interpolate_bc(param_16, param_17, param_18, param_19);
    VertexInput vtx_input;
    vtx_input.id = uint(gl_PrimitiveID);
    vtx_input.pos = vtx_outputs.vLocalPos;
    vtx_input.norm = vtx_outputs.vNorm;
    vtx_input.color = vtx_outputs.vColor;
    vtx_input.uv0 = vtx_outputs.vUV0;
    if (_306.instance_params.stride > 0)
    {
        uint instance_idx = instanceID[0];
        vec4 inst_m0 = _324.instance_transform[(instance_idx * uint(_306.instance_params.stride)) + 0u];
        vec4 inst_m1 = _324.instance_transform[(instance_idx * uint(_306.instance_params.stride)) + 1u];
        vec4 inst_m2 = _324.instance_transform[(instance_idx * uint(_306.instance_params.stride)) + 2u];
        vec3 param_20 = vtx_input.norm;
        mat4 param_21 = mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_20, param_21));
    }
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_identity();
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_PrimitiveID);
    modifier_factor.id = uint(gl_PrimitiveID);
    modifier_factor.instance_id = instanceID[0];
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    modifier_factor.uv0 = vtx_input.uv0;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _420.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _420.transform_params.mModelInv;
    if (_306.instance_params.stride > 0)
    {
        uint instance_idx_1 = instanceID[0];
        vec4 inst_m0_1 = _324.instance_transform[(instance_idx_1 * uint(_306.instance_params.stride)) + 0u];
        vec4 inst_m1_1 = _324.instance_transform[(instance_idx_1 * uint(_306.instance_params.stride)) + 1u];
        vec4 inst_m2_1 = _324.instance_transform[(instance_idx_1 * uint(_306.instance_params.stride)) + 2u];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_22 = vtx_input.norm;
        mat4 param_23 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_22, param_23));
        vec2 _527 = unpackHalf2x16(_520.instance_color[(instance_idx_1 * 2u) + 0u]);
        vec4 inst_c;
        inst_c.x = _527.x;
        inst_c.y = _527.y;
        vec2 _537 = unpackHalf2x16(_520.instance_color[(instance_idx_1 * 2u) + 1u]);
        inst_c.z = _537.x;
        inst_c.w = _537.y;
        vec4 _543 = vtx_input.color;
        vec3 _547 = _543.xyz * inst_c.xyz;
        vtx_input.color.x = _547.x;
        vtx_input.color.y = _547.y;
        vtx_input.color.z = _547.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_24 = vtx_input.pos;
    mat4 param_25 = _420.transform_params.mModel;
    vec3 _567 = vector_transform_by_mat43(param_24, param_25);
    vec3 vPosModel = _567;
    vec3 param_26 = vPosModel;
    mat4 param_27 = _420.transform_params.mView;
    vec3 _574 = vector_transform_by_mat43(param_26, param_27);
    vec3 vPosModelView = _574;
    vtx_outputs.vLocalPos = vtx_input.pos;
    vtx_outputs.vCoords = vPosModelView;
    vtx_outputs.vCameraRelativeWorldPos = vPosModel - _420.transform_params.vCameraPosition;
    vtx_outputs.vNorm = vtx_input.norm;
    vec3 param_28 = vtx_input.norm;
    mat4 param_29 = _420.transform_params.mModelNormal;
    vtx_outputs.vWorldNorm = vector_transform_by_mat33(param_28, param_29);
    vtx_outputs.vColor = vtx_input.color;
    vtx_outputs.vUV0 = vtx_input.uv0;
    vec3 param_30 = vtx_outputs.vCoords;
    mat4 param_31 = _420.transform_params.mProjection;
    vec4 _613 = vector_transform_by_mat_projection(param_30, param_31);
    gl_Position = _613;
}

 