#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleEmitterPrimitive_Params
{
    mat4 transform;
    vec4 particle_color;
    vec3 primitive_size;
    int perimeter_only;
    int primitive_type;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleModifierAttractor_Params
{
    vec3 position;
    float radius;
    float velocity;
};

struct ParticleModifierSwirl_Params
{
    vec3 position;
    int falloff_curve_idx;
    vec3 radius;
    int falloff_inverse;
    float velocity;
    float velocity_randomness;
    float time_step;
    float axis_randomness;
    vec3 axis;
    float _pad0;
    vec3 scale;
    float _pad1;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ModifierFactorMeshProximity_Params
{
    uint modifier_function;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float factor_multiplier;
    int normalize_range;
    int inverse_factor;
    float normalize_max_range;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct VM8Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _513;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _544;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _567;

layout(set = 0, binding = 10, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _1229;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _2049;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _2070;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _2129;

layout(set = 0, binding = 11, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _2500;

layout(set = 0, binding = 7, std430) buffer VM0
{
    layout(row_major) ParticleEmitterPrimitive_Params VM0_params;
} _2572;

layout(set = 0, binding = 12, std140) uniform VM1
{
    ParticleModifierCurl_Params VM1_params;
} _2605;

layout(set = 0, binding = 13, std140) uniform VM2
{
    layout(row_major) ModifierFactorNoise_Params VM2_params;
} _2635;

layout(set = 0, binding = 14, std140) uniform VM3
{
    ParticleModifierCurl_Params VM3_params;
} _2655;

layout(set = 0, binding = 8, std430) buffer VM4
{
    ParticleModifierAttractor_Params VM4_params;
} _2681;

layout(set = 0, binding = 9, std430) buffer VM5
{
    ParticleModifierSwirl_Params VM5_params;
} _2708;

layout(set = 0, binding = 15, std140) uniform VM6
{
    layout(row_major) ModifierFactorNoise_Params VM6_params;
} _2737;

layout(set = 0, binding = 16, std140) uniform VM7
{
    ModifierFactorMeshProximity_Params VM7_params;
} _2751;

layout(set = 0, binding = 17, std140) uniform VM8
{
    VM8Params VM8_params;
} _2767;

layout(set = 0, binding = 18) uniform sampler2D s_Curves;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_567.prt_prev_positions[(id * 3u) + 0u], _567.prt_prev_positions[(id * 3u) + 1u], _567.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _519;
    _519.life_time = _513.prt_states[id].life_time;
    _519.life_span = _513.prt_states[id].life_span;
    _519.generation_id = _513.prt_states[id].generation_id;
    _519.color = _513.prt_states[id].color;
    ParticleState _518 = _519;
    return _518;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _526;
    _526.life_time = state.life_time;
    _526.life_span = state.life_span;
    _526.generation_id = state.generation_id;
    _526.color = state.color;
    _513.prt_states[id] = _526;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

float particle_emitter_primitive_rand(float n)
{
    return fract(sin(n) * 43758.546875);
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _607 = color_convert_rgb_float3_uint(param);
    uint v = _607;
    state.color = v;
}

void particle_emitter_primitive_emit(ParticleEmitterPrimitive_Params emitter_params, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * particle_emitter_primitive_rand(param)));
    ParticleState param_1 = p.state;
    float param_2 = lifetime;
    prt_spawn(param_1, param_2);
    p.state = param_1;
    float param_3 = fid * 0.0130000002682209014892578125;
    float param_4 = (fid * 0.112999998033046722412109375) + 132.1410064697265625;
    float param_5 = (fid * 0.3129999935626983642578125) - 43.120998382568359375;
    vec3 pos = (vec3(particle_emitter_primitive_rand(param_3), particle_emitter_primitive_rand(param_4), particle_emitter_primitive_rand(param_5)) * 2.0) - vec3(1.0);
    if (emitter_params.primitive_type == 0)
    {
        float l = length(pos);
        if (l > 1.0)
        {
            pos /= vec3(l);
        }
        pos *= emitter_params.primitive_size;
    }
    else
    {
        if (emitter_params.primitive_type == 1)
        {
            pos *= emitter_params.primitive_size;
        }
    }
    vec3 param_6 = pos;
    mat4 param_7 = emitter_params.transform;
    vec3 _1059 = vector_transform_by_mat43(param_6, param_7);
    pos = _1059;
    p.pos = pos;
    ParticleState param_8 = p.state;
    vec3 param_9 = emitter_params.particle_color.xyz;
    prt_set_color(param_8, param_9);
    p.state = param_8;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_1229.globals.time, _1229.globals.time * 0.3014999926090240478515625, (-_1229.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _1251 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_1251 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _1789 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _1789;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1807 = vector_transform_by_mat43(param, param_1);
        coords = _1807;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1814 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1814;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _493 = hash(param);
    uint param_1 = _493;
    float _495 = floatConstruct(param_1);
    return _495;
}

void particle_modifier_attractor(ParticleModifierAttractor_Params modifier_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    vec3 pos = p.pos;
    vec3 dir = normalize(modifier_params.position - pos);
    vec3 up = vec3(0.0, 1.0, 0.0);
    float param = float(id) * 0.3172299861907958984375;
    vec3 right = (cross(dir, up) * modifier_params.radius) * (random(param) - 0.5);
    dir = normalize((modifier_params.position + right) - pos);
    pos += (((dir * lifecycle_params.time_step) * modifier_params.velocity) * modifier_factor.factor);
    p.pos = pos;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

vec4 quaternion_from_axis_angle(vec3 axis, float angle_in_radians)
{
    vec4 v = vec4((-axis) * sin(angle_in_radians * 0.5), cos(angle_in_radians * 0.5));
    return v;
}

vec3 vector_rotate_by_quaternion(vec3 v, vec4 q)
{
    vec3 u = q.xyz;
    float s = q.w;
    return ((u * (2.0 * dot(u, v))) + (v * ((s * s) - dot(u, u)))) + (cross(u, v) * (2.0 * s));
}

void particle_modifier_swirl(ParticleModifierSwirl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 influence_pos = p.pos;
    float influence = length((influence_pos - modifier_position) / (modifier_params.radius * 0.5));
    if (influence > 1.0)
    {
        influence = 1.0;
    }
    if (modifier_params.falloff_inverse == 0)
    {
        influence = 1.0 - influence;
    }
    influence = 1.0 - influence;
    int param = modifier_params.falloff_curve_idx;
    float param_1 = influence;
    influence = clamp(curve_sample(param, param_1), 0.0, 1.0);
    vec3 axis = modifier_params.axis;
    float param_2 = float(id) * 0.012470000423491001129150390625;
    float randomness_1 = random(param_2);
    float param_3 = float(id) * 0.1031199991703033447265625;
    float randomness_2 = random(param_3);
    axis.x += (randomness_1 * modifier_params.axis_randomness);
    axis.y -= (randomness_1 * modifier_params.axis_randomness);
    axis.z += (randomness_2 * modifier_params.axis_randomness);
    axis = normalize(axis);
    float angle_rad = modifier_params.velocity * (1.0 + (randomness_1 * modifier_params.velocity_randomness));
    angle_rad *= (lifecycle_params.time_step * influence);
    vec3 param_4 = axis;
    float param_5 = angle_rad * modifier_factor.factor;
    vec4 q = quaternion_from_axis_angle(param_4, param_5);
    vec3 pos = p.pos - modifier_params.position;
    vec3 param_6 = pos;
    vec4 param_7 = q;
    pos = vector_rotate_by_quaternion(param_6, param_7);
    vec3 pos_scaled = pos * modifier_params.scale;
    pos = mix(pos, pos_scaled, vec3(lifecycle_params.time_step * influence));
    pos += modifier_params.position;
    p.pos = pos;
}

uint modifier_factor_mesh_proximity_get_first_face_idx(ModifierFactorMeshProximity_Params params)
{
    uint tdl_idx = uint(params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _2129.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint modifier_factor_mesh_proximity_get_last_face_idx(ModifierFactorMeshProximity_Params params)
{
    uint tdl_idx = uint((params.transformed_data_location_idx + params.transformed_data_location_num) - 1);
    return _2129.transformed_data_location[tdl_idx].last_face_idx;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _2070.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _2070.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _2070.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_2049.in_vtx_data[coord_offset + 0u], _2049.in_vtx_data[coord_offset + 1u], _2049.in_vtx_data[coord_offset + 2u]);
    return p;
}

float modifier_factor_mesh_proximity_pointSegmentDistanceSquared(vec3 p, vec3 a, vec3 b)
{
    vec3 ab = b - a;
    float t = dot(p - a, ab) / dot(ab, ab);
    t = clamp(t, 0.0, 1.0);
    vec3 projection = a + (ab * t);
    return dot(p - projection, p - projection);
}

float modifier_factor_mesh_proximity_point_triangle_distance_squared(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 ab = b - a;
    vec3 ac = c - a;
    vec3 normal = normalize(cross(ab, ac));
    float distanceToPlane = dot(p - a, normal);
    vec3 projected = p - (normal * distanceToPlane);
    vec3 ap = projected - a;
    float d00 = dot(ab, ab);
    float d01 = dot(ab, ac);
    float d11 = dot(ac, ac);
    float d20 = dot(ap, ab);
    float d21 = dot(ap, ac);
    float denom = (d00 * d11) - (d01 * d01);
    float v = ((d11 * d20) - (d01 * d21)) / denom;
    float w = ((d00 * d21) - (d01 * d20)) / denom;
    float u = (1.0 - v) - w;
    if (((u >= 0.0) && (v >= 0.0)) && (w >= 0.0))
    {
        return abs(distanceToPlane * distanceToPlane);
    }
    else
    {
        vec3 param = p;
        vec3 param_1 = a;
        vec3 param_2 = b;
        float d1 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param, param_1, param_2);
        vec3 param_3 = p;
        vec3 param_4 = b;
        vec3 param_5 = c;
        float d2 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param_3, param_4, param_5);
        vec3 param_6 = p;
        vec3 param_7 = c;
        vec3 param_8 = a;
        float d3 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param_6, param_7, param_8);
        return min(min(d1, d2), d3);
    }
}

int modifier_factor_mesh_proximity_find_closest_face(ModifierFactorMeshProximity_Params params, vec3 p)
{
    ModifierFactorMeshProximity_Params param = params;
    int f0 = int(modifier_factor_mesh_proximity_get_first_face_idx(param));
    ModifierFactorMeshProximity_Params param_1 = params;
    int f1 = int(modifier_factor_mesh_proximity_get_last_face_idx(param_1));
    float closest_d = 0.0;
    int closest_fi = -1;
    for (int fi = f0; fi <= f1; fi++)
    {
        uint param_2 = uint(fi);
        RTFace rt_face = rt_get_face(param_2);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_3 = p0_idx;
        vec3 p0 = rt_get_vertex(param_3);
        uint param_4 = p1_idx;
        vec3 p1 = rt_get_vertex(param_4);
        uint param_5 = p2_idx;
        vec3 p2 = rt_get_vertex(param_5);
        vec3 param_6 = p;
        vec3 param_7 = p0;
        vec3 param_8 = p1;
        vec3 param_9 = p2;
        float d = modifier_factor_mesh_proximity_point_triangle_distance_squared(param_6, param_7, param_8, param_9);
        if (d >= 0.0)
        {
            if ((d < closest_d) || (closest_fi == (-1)))
            {
                closest_fi = fi;
                closest_d = d;
            }
        }
    }
    return closest_fi;
}

void modifier_factor_mesh_proximity(ModifierFactorMeshProximity_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    if (modifier_params.transformed_data_location_num == 0)
    {
        return;
    }
    ModifierFactorMeshProximity_Params param = modifier_params;
    vec3 param_1 = modifier_factor.position;
    int fi = modifier_factor_mesh_proximity_find_closest_face(param, param_1);
    if (fi == (-1))
    {
        return;
    }
    uint param_2 = uint(fi);
    RTFace rt_face = rt_get_face(param_2);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    vec3 param_6 = modifier_factor.position;
    vec3 param_7 = p0;
    vec3 param_8 = p1;
    vec3 param_9 = p2;
    float d = modifier_factor_mesh_proximity_point_triangle_distance_squared(param_6, param_7, param_8, param_9);
    d = sqrt(d);
    if (modifier_params.normalize_range != 0)
    {
        d /= modifier_params.normalize_max_range;
        d = min(1.0, d);
        if (modifier_params.inverse_factor != 0)
        {
            d = 1.0 - d;
        }
    }
    float v = d * modifier_params.factor_multiplier;
    ModifierFactor param_10 = modifier_factor;
    uint param_11 = modifier_params.modifier_function;
    float param_12 = v;
    modifier_process_modifier_factor(param_10, param_11, param_12);
    modifier_factor = param_10;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _544.prt_positions[(id * 3u) + 0u] = p.x;
    _544.prt_positions[(id * 3u) + 1u] = p.y;
    _544.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _567.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _567.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _567.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_2500.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _2500.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _2545;
    if (prt_is_alive(param_6))
    {
        _2545 = p.pos;
    }
    else
    {
        _2545 = vec3(0.0);
    }
    modifier_factor.position = _2545;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _2575 = atomicAdd(_2572.VM0_params.pending, -1);
        int pending = _2575;
        if (pending > 0)
        {
            ParticleEmitterPrimitive_Params _2584;
            _2584.transform = _2572.VM0_params.transform;
            _2584.particle_color = _2572.VM0_params.particle_color;
            _2584.primitive_size = _2572.VM0_params.primitive_size;
            _2584.perimeter_only = _2572.VM0_params.perimeter_only;
            _2584.primitive_type = _2572.VM0_params.primitive_type;
            _2584.particle_lifetime = _2572.VM0_params.particle_lifetime;
            _2584.particle_lifetime_randomness = _2572.VM0_params.particle_lifetime_randomness;
            _2584.rate = _2572.VM0_params.rate;
            _2584.seed = _2572.VM0_params.seed;
            _2584.pending = _2572.VM0_params.pending;
            ParticleEmitterPrimitive_Params param_8 = _2584;
            ParticleLifecycleParams _2589;
            _2589.time_step = _2500.lifecycle_params.time_step;
            _2589.life_time_step = _2500.lifecycle_params.life_time_step;
            _2589.max_lifetime = _2500.lifecycle_params.max_lifetime;
            _2589.reset = _2500.lifecycle_params.reset;
            _2589.capacity = _2500.lifecycle_params.capacity;
            _2589.has_previous = _2500.lifecycle_params.has_previous;
            ParticleLifecycleParams param_9 = _2589;
            Particle param_10 = p;
            uint param_11 = id;
            particle_emitter_primitive_emit(param_8, param_9, param_10, param_11);
            p = param_10;
        }
    }
    ParticleState param_12 = p.state;
    if (prt_is_alive(param_12))
    {
        ParticleModifierCurl_Params _2610;
        _2610.position = _2605.VM1_params.position;
        _2610.falloff_mode = _2605.VM1_params.falloff_mode;
        _2610.radius = _2605.VM1_params.radius;
        _2610.falloff_inverse = _2605.VM1_params.falloff_inverse;
        _2610.noise_strength = _2605.VM1_params.noise_strength;
        _2610.noise_speed = _2605.VM1_params.noise_speed;
        _2610.noise_scale = _2605.VM1_params.noise_scale;
        ParticleModifierCurl_Params param_13 = _2610;
        ParticleLifecycleParams _2614;
        _2614.time_step = _2500.lifecycle_params.time_step;
        _2614.life_time_step = _2500.lifecycle_params.life_time_step;
        _2614.max_lifetime = _2500.lifecycle_params.max_lifetime;
        _2614.reset = _2500.lifecycle_params.reset;
        _2614.capacity = _2500.lifecycle_params.capacity;
        _2614.has_previous = _2500.lifecycle_params.has_previous;
        ParticleLifecycleParams param_14 = _2614;
        ModifierFactor param_15 = modifier_factor;
        Particle param_16 = p;
        uint param_17 = id;
        particle_modifier_curl(param_13, param_14, param_15, param_16, param_17);
        p = param_16;
    }
    ParticleState param_18 = p.state;
    if (prt_is_alive(param_18))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorNoise_Params _2640;
    _2640.transform_local_to_gizmo = _2635.VM2_params.transform_local_to_gizmo;
    _2640.noise_domain_scale = _2635.VM2_params.noise_domain_scale;
    _2640.modifier_function = _2635.VM2_params.modifier_function;
    _2640.noise_domain_offset = _2635.VM2_params.noise_domain_offset;
    _2640.noise_value_scale = _2635.VM2_params.noise_value_scale;
    _2640.noise_value_offset = _2635.VM2_params.noise_value_offset;
    _2640.influence_scope = _2635.VM2_params.influence_scope;
    _2640._pad0 = _2635.VM2_params._pad0;
    _2640._pad1 = _2635.VM2_params._pad1;
    ModifierFactorNoise_Params param_19 = _2640;
    ModifierFactor param_20 = modifier_factor;
    CoordinateSystemTrasforms param_21 = cs_transforms;
    modifier_factor_noise_simplex2(param_19, param_20, param_21);
    modifier_factor = param_20;
    ParticleState param_22 = p.state;
    if (prt_is_alive(param_22))
    {
        ParticleModifierCurl_Params _2659;
        _2659.position = _2655.VM3_params.position;
        _2659.falloff_mode = _2655.VM3_params.falloff_mode;
        _2659.radius = _2655.VM3_params.radius;
        _2659.falloff_inverse = _2655.VM3_params.falloff_inverse;
        _2659.noise_strength = _2655.VM3_params.noise_strength;
        _2659.noise_speed = _2655.VM3_params.noise_speed;
        _2659.noise_scale = _2655.VM3_params.noise_scale;
        ParticleModifierCurl_Params param_23 = _2659;
        ParticleLifecycleParams _2663;
        _2663.time_step = _2500.lifecycle_params.time_step;
        _2663.life_time_step = _2500.lifecycle_params.life_time_step;
        _2663.max_lifetime = _2500.lifecycle_params.max_lifetime;
        _2663.reset = _2500.lifecycle_params.reset;
        _2663.capacity = _2500.lifecycle_params.capacity;
        _2663.has_previous = _2500.lifecycle_params.has_previous;
        ParticleLifecycleParams param_24 = _2663;
        ModifierFactor param_25 = modifier_factor;
        Particle param_26 = p;
        uint param_27 = id;
        particle_modifier_curl(param_23, param_24, param_25, param_26, param_27);
        p = param_26;
    }
    ParticleState param_28 = p.state;
    if (prt_is_alive(param_28))
    {
        ParticleModifierAttractor_Params _2686;
        _2686.position = _2681.VM4_params.position;
        _2686.radius = _2681.VM4_params.radius;
        _2686.velocity = _2681.VM4_params.velocity;
        ParticleModifierAttractor_Params param_29 = _2686;
        ModifierFactor param_30 = modifier_factor;
        ParticleLifecycleParams _2692;
        _2692.time_step = _2500.lifecycle_params.time_step;
        _2692.life_time_step = _2500.lifecycle_params.life_time_step;
        _2692.max_lifetime = _2500.lifecycle_params.max_lifetime;
        _2692.reset = _2500.lifecycle_params.reset;
        _2692.capacity = _2500.lifecycle_params.capacity;
        _2692.has_previous = _2500.lifecycle_params.has_previous;
        ParticleLifecycleParams param_31 = _2692;
        Particle param_32 = p;
        uint param_33 = id;
        particle_modifier_attractor(param_29, param_30, param_31, param_32, param_33);
        p = param_32;
    }
    ParticleState param_34 = p.state;
    if (prt_is_alive(param_34))
    {
        ParticleModifierSwirl_Params _2713;
        _2713.position = _2708.VM5_params.position;
        _2713.falloff_curve_idx = _2708.VM5_params.falloff_curve_idx;
        _2713.radius = _2708.VM5_params.radius;
        _2713.falloff_inverse = _2708.VM5_params.falloff_inverse;
        _2713.velocity = _2708.VM5_params.velocity;
        _2713.velocity_randomness = _2708.VM5_params.velocity_randomness;
        _2713.time_step = _2708.VM5_params.time_step;
        _2713.axis_randomness = _2708.VM5_params.axis_randomness;
        _2713.axis = _2708.VM5_params.axis;
        _2713._pad0 = _2708.VM5_params._pad0;
        _2713.scale = _2708.VM5_params.scale;
        _2713._pad1 = _2708.VM5_params._pad1;
        ParticleModifierSwirl_Params param_35 = _2713;
        ParticleLifecycleParams _2717;
        _2717.time_step = _2500.lifecycle_params.time_step;
        _2717.life_time_step = _2500.lifecycle_params.life_time_step;
        _2717.max_lifetime = _2500.lifecycle_params.max_lifetime;
        _2717.reset = _2500.lifecycle_params.reset;
        _2717.capacity = _2500.lifecycle_params.capacity;
        _2717.has_previous = _2500.lifecycle_params.has_previous;
        ParticleLifecycleParams param_36 = _2717;
        ModifierFactor param_37 = modifier_factor;
        Particle param_38 = p;
        uint param_39 = id;
        particle_modifier_swirl(param_35, param_36, param_37, param_38, param_39);
        p = param_38;
    }
    ParticleState param_40 = p.state;
    if (prt_is_alive(param_40))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorNoise_Params _2741;
    _2741.transform_local_to_gizmo = _2737.VM6_params.transform_local_to_gizmo;
    _2741.noise_domain_scale = _2737.VM6_params.noise_domain_scale;
    _2741.modifier_function = _2737.VM6_params.modifier_function;
    _2741.noise_domain_offset = _2737.VM6_params.noise_domain_offset;
    _2741.noise_value_scale = _2737.VM6_params.noise_value_scale;
    _2741.noise_value_offset = _2737.VM6_params.noise_value_offset;
    _2741.influence_scope = _2737.VM6_params.influence_scope;
    _2741._pad0 = _2737.VM6_params._pad0;
    _2741._pad1 = _2737.VM6_params._pad1;
    ModifierFactorNoise_Params param_41 = _2741;
    ModifierFactor param_42 = modifier_factor;
    CoordinateSystemTrasforms param_43 = cs_transforms;
    modifier_factor_noise_simplex2(param_41, param_42, param_43);
    modifier_factor = param_42;
    ModifierFactorMeshProximity_Params _2756;
    _2756.modifier_function = _2751.VM7_params.modifier_function;
    _2756.transformed_data_location_idx = _2751.VM7_params.transformed_data_location_idx;
    _2756.transformed_data_location_num = _2751.VM7_params.transformed_data_location_num;
    _2756.factor_multiplier = _2751.VM7_params.factor_multiplier;
    _2756.normalize_range = _2751.VM7_params.normalize_range;
    _2756.inverse_factor = _2751.VM7_params.inverse_factor;
    _2756.normalize_max_range = _2751.VM7_params.normalize_max_range;
    ModifierFactorMeshProximity_Params param_44 = _2756;
    ModifierFactor param_45 = modifier_factor;
    CoordinateSystemTrasforms param_46 = cs_transforms;
    modifier_factor_mesh_proximity(param_44, param_45, param_46);
    modifier_factor = param_45;
    vec3 modifier_position = _2767.VM8_params.position;
    p.pos += ((_2767.VM8_params.velocity * _2500.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_47 = p.state;
    float param_48 = _2500.lifecycle_params.life_time_step;
    float param_49 = _2500.lifecycle_params.max_lifetime;
    prt_advance_life(param_47, param_48, param_49);
    p.state = param_47;
    uint param_50 = id;
    ParticleState param_51 = p.state;
    prt_set_state(param_50, param_51);
    uint param_52 = id;
    vec3 param_53 = p.pos;
    prt_set_position(param_52, param_53);
    bool _2809 = _2500.lifecycle_params.has_previous != 0u;
    bool _2816;
    if (_2809)
    {
        _2816 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _2816 = _2809;
    }
    if (_2816)
    {
        uint param_54 = id;
        vec3 param_55 = p.pos;
        prt_set_prev_position(param_54, param_55);
    }
}

 