#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct AngularInfo
{
    float NdotL;
    float NdotV;
    float NdotH;
    float LdotH;
    float VdotH;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct LTCRect
{
    vec3 center;
    vec3 dirx;
    vec3 diry;
    float halfx;
    float halfy;
    vec4 plane;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    vec2 frustum_shift;
    vec2 resolution;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float volumetric_fog_luminance_ceiling;
    uint volumetric_fog_blend_function;
    float _pad1;
    float _pad2;
    vec4 volumetric_fog_tint;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float volumetric_light_strength;
    float volumetric_light_fog_density;
    float volumetric_light_fog_height;
    vec2 taa_jitter;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

layout(set = 1, binding = 2, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _721;

layout(set = 1, binding = 3, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _1134;

layout(set = 1, binding = 4, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _2146;

layout(set = 1, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 5, scalar) uniform LightPropertiesBuffer
{
    layout(row_major) LightProperties light_properties[16];
} lights;

layout(set = 1, binding = 6, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _3011;

layout(set = 1, binding = 7) uniform sampler2D s_Gradients;
layout(set = 1, binding = 8) uniform sampler2DArray s_BlueNoise;
layout(set = 1, binding = 9) uniform sampler2D s_LTC2;
layout(set = 1, binding = 10) uniform sampler2D sAlbedo;
layout(set = 1, binding = 11) uniform usampler2D sNormalMaterial;
layout(set = 1, binding = 12) uniform sampler2D sDepth;
layout(set = 1, binding = 13) uniform usampler2D sMetalnessRoughnessMaterialTags;
layout(set = 1, binding = 14) uniform sampler2D sEmissive;
layout(set = 1, binding = 15) uniform sampler2D LightShadowmapSamplers[16];
layout(set = 1, binding = 31) uniform sampler2DShadow LightShadowmapCmpSamplers[16];
layout(set = 1, binding = 47) uniform sampler2D LightProjectorSamplers[16];
layout(set = 1, binding = 63) uniform sampler2D s_LTC1;
layout(set = 1, binding = 64) uniform sampler2D sRaytrace;
layout(set = 1, binding = 65) uniform sampler2D sIBL;

layout(location = 0) out vec4 outColor;
layout(location = 0) in vec2 vTexcoord0;
bool twoSided;
bool clipless;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _301;
    if (nor.x > 0.0)
    {
        _301 = -t;
    }
    else
    {
        _301 = t;
    }
    nor.x += _301;
    float _316;
    if (nor.y > 0.0)
    {
        _316 = -t;
    }
    else
    {
        _316 = t;
    }
    nor.y += _316;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _1134.basic_params.camera_near_far_plane.z / (_1134.basic_params.camera_near_far_plane.y - (d * _1134.basic_params.camera_near_far_plane.w));
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_2146.render_lights_params.frustum_shift * _2146.render_lights_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_1134.basic_params.camera_projection_params.z) + ((_1134.basic_params.camera_projection_params.x * vd_pos.x) / _2146.render_lights_params.resolution.x);
    view_direction.y = (-_1134.basic_params.camera_projection_params.w) + ((_1134.basic_params.camera_projection_params.y * vd_pos.y) / _2146.render_lights_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

vec3 saturate(vec3 a)
{
    return max(vec3(0.0), min(vec3(1.0), a));
}

AngularInfo getAngularInfo(vec3 normalized_point_to_light, vec3 normal, vec3 normalized_view)
{
    vec3 n = normal;
    vec3 v = normalized_view;
    vec3 l = normalized_point_to_light;
    vec3 h = normalize(l + v);
    float NdotL = dot(n, l);
    float NdotV = dot(n, v);
    float NdotH = clamp(dot(n, h), 0.0, 1.0);
    float LdotH = clamp(dot(l, h), 0.0, 1.0);
    float VdotH = clamp(dot(v, h), 0.0, 1.0);
    AngularInfo angularInfo = AngularInfo(NdotL, NdotV, NdotH, LdotH, VdotH);
    return angularInfo;
}

vec3 specularReflection(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    return materialInfo.reflectance0 + ((materialInfo.reflectance90 - materialInfo.reflectance0) * pow(clamp(1.0 - angularInfo.VdotH, 0.0, 1.0), 5.0));
}

float visibilityOcclusion(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float NdotL = clamp(angularInfo.NdotL, 0.0, 1.0);
    float NdotV = clamp(angularInfo.NdotV, 0.0, 1.0);
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float GGXV = NdotL * sqrt(((NdotV * NdotV) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGXL = NdotV * sqrt(((NdotL * NdotL) * (1.0 - alphaRoughnessSq)) + alphaRoughnessSq);
    float GGX = GGXV + GGXL;
    if (GGX > 0.0)
    {
        return 0.5 / GGX;
    }
    return 0.0;
}

float microfacetDistribution(MaterialInfo materialInfo, AngularInfo angularInfo)
{
    float alphaRoughnessSq = materialInfo.alphaRoughness * materialInfo.alphaRoughness;
    float f = (((angularInfo.NdotH * alphaRoughnessSq) - angularInfo.NdotH) * angularInfo.NdotH) + 1.0;
    return alphaRoughnessSq / (((3.1415927410125732421875 * f) * f) + 9.9999999747524270787835121154785e-07);
}

vec3 diffuse(MaterialInfo materialInfo)
{
    return materialInfo.diffuseColor / vec3(3.1415927410125732421875);
}

vec3 getPointShade(vec3 normalized_point_to_light, MaterialInfo materialInfo, vec3 normal, vec3 normalized_view)
{
    vec3 param = normalized_point_to_light;
    vec3 param_1 = normal;
    vec3 param_2 = normalized_view;
    AngularInfo angularInfo = getAngularInfo(param, param_1, param_2);
    bool _1080 = angularInfo.NdotL > 0.0;
    bool _1087;
    if (!_1080)
    {
        _1087 = angularInfo.NdotV > 0.0;
    }
    else
    {
        _1087 = _1080;
    }
    if (_1087)
    {
        MaterialInfo param_3 = materialInfo;
        AngularInfo param_4 = angularInfo;
        vec3 F = specularReflection(param_3, param_4);
        MaterialInfo param_5 = materialInfo;
        AngularInfo param_6 = angularInfo;
        float Vis = visibilityOcclusion(param_5, param_6);
        MaterialInfo param_7 = materialInfo;
        AngularInfo param_8 = angularInfo;
        float D = microfacetDistribution(param_7, param_8);
        MaterialInfo param_9 = materialInfo;
        vec3 diffuseContrib = (vec3(1.0) - F) * diffuse(param_9);
        vec3 specContrib = (F * Vis) * D;
        return (diffuseContrib + specContrib) * clamp(angularInfo.NdotL, 0.0, 1.0);
    }
    return vec3(0.0);
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 light_calculate_spot_attenuation_color(LightProperties light, vec3 pos)
{
    float cutoff = light.cutoff;
    float light_distance = length(light.position - pos);
    float angle_falloff = dot(light.direction, (pos - light.position) / vec3(light_distance));
    vec3 attenuation_color = vec3(0.0);
    bool _819 = angle_falloff > cutoff;
    bool _826;
    if (_819)
    {
        _826 = light_distance < light.range;
    }
    else
    {
        _826 = _819;
    }
    if (_826)
    {
        float angle_cos = 1.0 - ((1.0 - angle_falloff) / (1.0 - cutoff));
        attenuation_color = vec3(1.0);
        if (light.angular_falloff_color_gradient_idx != (-1))
        {
            int param = light.angular_falloff_color_gradient_idx;
            float param_1 = 1.0 - angle_cos;
            attenuation_color = gradient_sample(param, param_1).xyz;
        }
        float angle_attenuation = pow(angle_cos, light.angular_falloff_power);
        float distance_attenuation = 1.0 - (light_distance / light.range);
        attenuation_color *= ((angle_attenuation * distance_attenuation) * distance_attenuation);
    }
    return attenuation_color;
}

float light_calculate_point_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0;
        attenuation *= (1.0 - (light_distance / light.range));
        attenuation = pow(attenuation, light.angular_falloff_power);
    }
    return attenuation;
}

vec2 VogelDiskSample(int sampleIndex, int samplesCount, float phi)
{
    float GoldenAngle = 2.400000095367431640625;
    float r = sqrt(float(sampleIndex) + 0.5) / sqrt(float(samplesCount));
    float theta = (float(sampleIndex) * GoldenAngle) + phi;
    float sine = sin(theta);
    float cosine = cos(theta);
    return vec2(r * cosine, r * sine);
}

float AvgBlockersDepthToPenumbra(float light_size, float z_shadowMapView, float avgBlockersDepth)
{
    float penumbra = (light_size * (z_shadowMapView - avgBlockersDepth)) / avgBlockersDepth;
    return penumbra;
}

float PenumbraFromOccluderSearch(sampler2D smpl, float light_size, vec2 hash, vec4 coords, float sampling_range, int samplesCount, float shadowmap_bias)
{
    float avgBlockersDepth = 0.0;
    float blockersCount = 0.0;
    float penumbraFilterMaxSize = sampling_range;
    bool _464 = coords.x < (-coords.w);
    bool _473;
    if (!_464)
    {
        _473 = coords.x > coords.w;
    }
    else
    {
        _473 = _464;
    }
    bool _483;
    if (!_473)
    {
        _483 = coords.y < (-coords.w);
    }
    else
    {
        _483 = _473;
    }
    bool _492;
    if (!_483)
    {
        _492 = coords.y > coords.w;
    }
    else
    {
        _492 = _483;
    }
    bool _499;
    if (!_492)
    {
        _499 = coords.z < 0.0;
    }
    else
    {
        _499 = _492;
    }
    if (_499)
    {
        return 0.0;
    }
    vec2 shadowMapUV = ((coords.xy / vec2(coords.w)) * 0.5) + vec2(0.5);
    shadowMapUV.y = 1.0 - shadowMapUV.y;
    float z_shadowMapView = coords.z / coords.w;
    SPIRV_CROSS_LOOP
    for (int i = 0; i < samplesCount; i++)
    {
        int param = i;
        int param_1 = samplesCount;
        float param_2 = (hash.y * 3.1415927410125732421875) * 2.0;
        vec2 sampleUV = VogelDiskSample(param, param_1, param_2) * 0.5;
        sampleUV = shadowMapUV + (sampleUV * penumbraFilterMaxSize);
        vec4 sampleDepth = textureGather(smpl, sampleUV);
        if (sampleDepth.x < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.x;
            blockersCount += 1.0;
        }
        if (sampleDepth.y < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.y;
            blockersCount += 1.0;
        }
        if (sampleDepth.z < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.z;
            blockersCount += 1.0;
        }
        if (sampleDepth.w < z_shadowMapView)
        {
            avgBlockersDepth += sampleDepth.w;
            blockersCount += 1.0;
        }
    }
    if (blockersCount > 0.0)
    {
        avgBlockersDepth /= blockersCount;
        float param_3 = light_size;
        float param_4 = z_shadowMapView;
        float param_5 = avgBlockersDepth;
        return AvgBlockersDepthToPenumbra(param_3, param_4, param_5);
    }
    else
    {
        return 0.0;
    }
}

float sampleShadowPCFNoiseOffset(sampler2DShadow smpl, inout vec4 coords, ivec2 noise_offset, out float in_frustum, int samples, float sampling_range, float shadowmap_bias)
{
    float fact = 0.0;
    in_frustum = 0.0;
    if (coords.w <= 0.0)
    {
        return 1.0;
    }
    bool _634 = coords.x < (-coords.w);
    bool _643;
    if (!_634)
    {
        _643 = coords.x > coords.w;
    }
    else
    {
        _643 = _634;
    }
    bool _653;
    if (!_643)
    {
        _653 = coords.y < (-coords.w);
    }
    else
    {
        _653 = _643;
    }
    bool _662;
    if (!_653)
    {
        _662 = coords.y > coords.w;
    }
    else
    {
        _662 = _653;
    }
    bool _669;
    if (!_662)
    {
        _669 = coords.z < 0.0;
    }
    else
    {
        _669 = _662;
    }
    if (_669)
    {
        return 1.0;
    }
    in_frustum = 1.0;
    vec4 _673 = coords;
    float _678 = coords.w;
    vec2 _680 = (_673.xy * vec2(0.5)) + (vec2(0.5) * _678);
    coords.x = _680.x;
    coords.y = _680.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    float bias = shadowmap_bias;
    float bias2 = 0.300000011920928955078125;
    int taken_samples = 0;
    int h_samples = samples;
    vec3 hash = texelFetch(s_BlueNoise, ivec3(noise_offset & ivec2(127), _721.globals.monotonic & 15), 0).xyz;
    SPIRV_CROSS_LOOP
    for (int n = 0; n < h_samples; n++)
    {
        int param = n;
        int param_1 = h_samples;
        float param_2 = (hash.x * 3.1415927410125732421875) * 2.0;
        vec2 xy = VogelDiskSample(param, param_1, param_2) * 0.5;
        vec4 jittered_coords = coords + vec4((xy.x * sampling_range) * coords.w, (xy.y * sampling_range) * coords.w, bias, 0.0);
        vec4 _776 = jittered_coords;
        vec4 _779 = _776;
        _779.z = _776.w;
        float shadow = textureProjLod(smpl, vec4(_779.xy, _776.z, _779.z), 0.0);
        fact += shadow;
        taken_samples++;
    }
    return fact * (1.0 / float(h_samples));
}

vec4 sampleProjectorTexture(sampler2D smpl, inout vec4 coords)
{
    vec4 color = vec4(0.0);
    if (coords.w <= 0.0)
    {
        return color;
    }
    bool _1168 = coords.x < (-coords.w);
    bool _1177;
    if (!_1168)
    {
        _1177 = coords.x > coords.w;
    }
    else
    {
        _1177 = _1168;
    }
    bool _1187;
    if (!_1177)
    {
        _1187 = coords.y < (-coords.w);
    }
    else
    {
        _1187 = _1177;
    }
    bool _1196;
    if (!_1187)
    {
        _1196 = coords.y > coords.w;
    }
    else
    {
        _1196 = _1187;
    }
    if (_1196)
    {
        return color;
    }
    vec4 _1201 = coords;
    float _1205 = coords.w;
    vec2 _1207 = (_1201.xy * vec2(0.5)) + (vec2(0.5) * _1205);
    coords.x = _1207.x;
    coords.y = _1207.y;
    coords.y /= coords.w;
    coords.y = 1.0 - coords.y;
    coords.y *= coords.w;
    vec3 samp = coords.xyz / vec3(coords.w);
    color = texture(smpl, coords.xy / vec2(coords.w));
    return color;
}

void InitRect(LightProperties light, inout LTCRect rect)
{
    rect.dirx = -light.right;
    rect.diry = light.up;
    rect.center = light.position;
    rect.halfx = 0.5 * light.dimensions.x;
    rect.halfy = 0.5 * light.dimensions.y;
    vec3 rectNormal = cross(rect.dirx, rect.diry);
    rect.plane = vec4(rectNormal, -dot(rectNormal, rect.center));
}

void InitRectPoints(LTCRect rect, inout vec3 points[4])
{
    vec3 ex = rect.dirx * rect.halfx;
    vec3 ey = rect.diry * rect.halfy;
    points[0] = (rect.center - ex) - ey;
    points[1] = (rect.center + ex) - ey;
    points[2] = (rect.center + ex) + ey;
    points[3] = (rect.center - ex) + ey;
}

mat3 mul(mat3 m1, mat3 m2)
{
    return m1 * m2;
}

vec3 mul(mat3 m, vec3 v)
{
    return m * v;
}

vec3 IntegrateEdgeVec(vec3 v1, vec3 v2)
{
    float x = dot(v1, v2);
    float y = abs(x);
    float a = 0.8543984889984130859375 + ((0.4965155124664306640625 + (0.01452060043811798095703125 * y)) * y);
    float b = 3.41759395599365234375 + ((4.1616725921630859375 + y) * y);
    float v = a / b;
    float _1288;
    if (x > 0.0)
    {
        _1288 = v;
    }
    else
    {
        _1288 = (0.5 * inversesqrt(max(1.0 - (x * x), 1.0000000116860974230803549289703e-07))) - v;
    }
    float theta_sintheta = _1288;
    return cross(v1, v2) * theta_sintheta;
}

void ClipQuadToHorizon(inout vec3 L[5], inout int n)
{
    int config = 0;
    if (L[0].z > 0.0)
    {
        config++;
    }
    if (L[1].z > 0.0)
    {
        config += 2;
    }
    if (L[2].z > 0.0)
    {
        config += 4;
    }
    if (L[3].z > 0.0)
    {
        config += 8;
    }
    n = 0;
    if (config == 0)
    {
    }
    else
    {
        if (config == 1)
        {
            n = 3;
            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
            L[2] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
        }
        else
        {
            if (config == 2)
            {
                n = 3;
                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
            }
            else
            {
                if (config == 3)
                {
                    n = 4;
                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                    L[3] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                }
                else
                {
                    if (config == 4)
                    {
                        n = 3;
                        L[0] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                    }
                    else
                    {
                        if (config == 5)
                        {
                            n = 0;
                        }
                        else
                        {
                            if (config == 6)
                            {
                                n = 4;
                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                            }
                            else
                            {
                                if (config == 7)
                                {
                                    n = 5;
                                    L[4] = (L[0] * (-L[3].z)) + (L[3] * L[0].z);
                                    L[3] = (L[2] * (-L[3].z)) + (L[3] * L[2].z);
                                }
                                else
                                {
                                    if (config == 8)
                                    {
                                        n = 3;
                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                        L[1] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        L[2] = L[3];
                                    }
                                    else
                                    {
                                        if (config == 9)
                                        {
                                            n = 4;
                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                            L[2] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                        }
                                        else
                                        {
                                            if (config == 10)
                                            {
                                                n = 0;
                                            }
                                            else
                                            {
                                                if (config == 11)
                                                {
                                                    n = 5;
                                                    L[4] = L[3];
                                                    L[3] = (L[3] * (-L[2].z)) + (L[2] * L[3].z);
                                                    L[2] = (L[1] * (-L[2].z)) + (L[2] * L[1].z);
                                                }
                                                else
                                                {
                                                    if (config == 12)
                                                    {
                                                        n = 4;
                                                        L[1] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                        L[0] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                    }
                                                    else
                                                    {
                                                        if (config == 13)
                                                        {
                                                            n = 5;
                                                            L[4] = L[3];
                                                            L[3] = L[2];
                                                            L[2] = (L[2] * (-L[1].z)) + (L[1] * L[2].z);
                                                            L[1] = (L[0] * (-L[1].z)) + (L[1] * L[0].z);
                                                        }
                                                        else
                                                        {
                                                            if (config == 14)
                                                            {
                                                                n = 5;
                                                                L[4] = (L[3] * (-L[0].z)) + (L[0] * L[3].z);
                                                                L[0] = (L[1] * (-L[0].z)) + (L[0] * L[1].z);
                                                            }
                                                            else
                                                            {
                                                                if (config == 15)
                                                                {
                                                                    n = 4;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    if (n == 3)
    {
        L[3] = L[0];
    }
    if (n == 4)
    {
        L[4] = L[0];
    }
}

float IntegrateEdge(vec3 v1, vec3 v2)
{
    vec3 param = v1;
    vec3 param_1 = v2;
    return IntegrateEdgeVec(param, param_1).z;
}

vec3 LTC_Evaluate(vec3 N, vec3 V, vec3 P, inout mat3 Minv, vec3 points[4], bool twoSided_1)
{
    vec3 T1 = normalize(V - (N * dot(V, N)));
    vec3 T2 = cross(N, T1);
    mat3 param = Minv;
    mat3 param_1 = transpose(mat3(vec3(T1), vec3(T2), vec3(N)));
    Minv = mul(param, param_1);
    mat3 param_2 = Minv;
    vec3 param_3 = points[0] - P;
    vec3 L[5];
    L[0] = mul(param_2, param_3);
    mat3 param_4 = Minv;
    vec3 param_5 = points[1] - P;
    L[1] = mul(param_4, param_5);
    mat3 param_6 = Minv;
    vec3 param_7 = points[2] - P;
    L[2] = mul(param_6, param_7);
    mat3 param_8 = Minv;
    vec3 param_9 = points[3] - P;
    L[3] = mul(param_8, param_9);
    float sum = 0.0;
    if (clipless)
    {
        vec3 dir = points[0] - P;
        vec3 lightNormal = cross(points[1] - points[0], points[3] - points[0]);
        bool behind = dot(dir, lightNormal) < 0.0;
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        vec3 vsum = vec3(0.0);
        vec3 param_10 = L[0];
        vec3 param_11 = L[1];
        vsum += IntegrateEdgeVec(param_10, param_11);
        vec3 param_12 = L[1];
        vec3 param_13 = L[2];
        vsum += IntegrateEdgeVec(param_12, param_13);
        vec3 param_14 = L[2];
        vec3 param_15 = L[3];
        vsum += IntegrateEdgeVec(param_14, param_15);
        vec3 param_16 = L[3];
        vec3 param_17 = L[0];
        vsum += IntegrateEdgeVec(param_16, param_17);
        float len = length(vsum);
        float z = vsum.z / len;
        if (behind)
        {
            z = -z;
        }
        vec2 uv = vec2((z * 0.5) + 0.5, len);
        uv = (uv * 0.984375) + vec2(0.0078125);
        float scale = texture(s_LTC2, uv).w;
        sum = len * scale;
        if (behind && (!twoSided_1))
        {
            sum = 0.0;
        }
    }
    else
    {
        vec3 param_18[5] = L;
        int param_19;
        ClipQuadToHorizon(param_18, param_19);
        L = param_18;
        int n = param_19;
        if (n == 0)
        {
            return vec3(0.0);
        }
        L[0] = normalize(L[0]);
        L[1] = normalize(L[1]);
        L[2] = normalize(L[2]);
        L[3] = normalize(L[3]);
        L[4] = normalize(L[4]);
        vec3 param_20 = L[0];
        vec3 param_21 = L[1];
        sum += IntegrateEdge(param_20, param_21);
        vec3 param_22 = L[1];
        vec3 param_23 = L[2];
        sum += IntegrateEdge(param_22, param_23);
        vec3 param_24 = L[2];
        vec3 param_25 = L[3];
        sum += IntegrateEdge(param_24, param_25);
        if (n >= 4)
        {
            vec3 param_26 = L[3];
            vec3 param_27 = L[4];
            sum += IntegrateEdge(param_26, param_27);
        }
        if (n == 5)
        {
            vec3 param_28 = L[4];
            vec3 param_29 = L[0];
            sum += IntegrateEdge(param_28, param_29);
        }
        float _2049;
        if (twoSided_1)
        {
            _2049 = abs(sum);
        }
        else
        {
            _2049 = max(0.0, sum);
        }
        sum = _2049;
    }
    vec3 Lo_i = vec3(sum, sum, sum);
    return Lo_i;
}

float light_calculate_area_attenuation(LightProperties light, vec3 pos)
{
    float light_distance = length(light.position - pos);
    float attenuation = 0.0;
    if (light_distance < light.range)
    {
        attenuation = 1.0 - clamp(light_distance / light.range, 0.0, 1.0);
        attenuation = pow(attenuation, 2.0);
    }
    return attenuation;
}

void main()
{
    twoSided = false;
    clipless = false;
    ivec2 screen_pos = ivec2(gl_FragCoord.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 _2217 = decode_normal(param);
    vec3 vNorm = _2217;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec2 param_3 = vec2(screen_pos);
    vec3 view_direction = get_view_direction(param_3);
    vec3 param_4 = view_direction;
    float param_5 = depth;
    vec3 world = (_1134.basic_params.mModel * vec4(positionFromDepth(param_4, param_5), 1.0)).xyz;
    outColor = vec4(0.0);
    uvec4 param_6 = texelFetch(sMetalnessRoughnessMaterialTags, screen_pos, 0);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        outColor = base_color;
        outColor.w = 0.0;
        return;
    }
    vec3 base_emissive = texelFetch(sEmissive, screen_pos, 0).xyz * materials.material_properties[material].emissive;
    bool is_background = (materialId & 1) == 1;
    bool is_raytraced = (material_flags & 1u) != 0u;
    bool is_particle = (material_flags & 8192u) != 0u;
    if (is_particle == false)
    {
    }
    else
    {
        outColor = base_color;
        outColor.w = 0.0;
        base_color.x = materials.material_properties[material].diffuse.x;
        base_color.y = materials.material_properties[material].diffuse.y;
        base_color.z = materials.material_properties[material].diffuse.z;
    }
    if (false)
    {
        if (is_raytraced)
        {
            float color_magnitude = length(base_color.xyz);
            if (color_magnitude > 1.0)
            {
                vec3 emissive_from_base_color = base_color.xyz - (base_color.xyz / vec3(color_magnitude));
                vec4 _2368 = base_color;
                vec3 _2370 = _2368.xyz - emissive_from_base_color;
                base_color.x = _2370.x;
                base_color.y = _2370.y;
                base_color.z = _2370.z;
                base_emissive += emissive_from_base_color;
            }
            vec3 param_7 = base_color.xyz;
            vec3 _2383 = saturate(param_7);
            base_color.x = _2383.x;
            base_color.y = _2383.y;
            base_color.z = _2383.z;
        }
    }
    vec3 f0 = vec3(0.039999999105930328369140625);
    vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
    float alphaRoughness = roughness * roughness;
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    vec3 view = normalize(_1134.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    if (is_particle == false)
    {
        int _2659;
        float param_24;
        LTCRect param_30;
        vec3 param_32[4];
        for (int light_idx = 0; light_idx < _2146.render_lights_params.lights_num; light_idx++)
        {
            LightProperties _2473;
            _2473.diffuse = lights.light_properties[light_idx].diffuse;
            _2473.direction = lights.light_properties[light_idx].direction;
            _2473.position = lights.light_properties[light_idx].position;
            _2473.up = lights.light_properties[light_idx].up;
            _2473.right = lights.light_properties[light_idx].right;
            _2473.dimensions = lights.light_properties[light_idx].dimensions;
            _2473.lighting_exclusion_tags = lights.light_properties[light_idx].lighting_exclusion_tags;
            _2473.intensity = lights.light_properties[light_idx].intensity;
            _2473.range = lights.light_properties[light_idx].range;
            _2473.cutoff = lights.light_properties[light_idx].cutoff;
            _2473.roughness_modifier = lights.light_properties[light_idx].roughness_modifier;
            _2473.is_area = lights.light_properties[light_idx].is_area;
            _2473.type = lights.light_properties[light_idx].type;
            _2473.projector_sampler = lights.light_properties[light_idx].projector_sampler;
            _2473.projector_intensity = lights.light_properties[light_idx].projector_intensity;
            _2473.downsampled_shadowmap_sampler = lights.light_properties[light_idx].downsampled_shadowmap_sampler;
            _2473.shadowmap_sampler0 = lights.light_properties[light_idx].shadowmap_sampler0;
            _2473.shadowmap_sampler1 = lights.light_properties[light_idx].shadowmap_sampler1;
            _2473.shadowmap_sampler2 = lights.light_properties[light_idx].shadowmap_sampler2;
            _2473.shadowmap_sampler3 = lights.light_properties[light_idx].shadowmap_sampler3;
            _2473.cascade_distance0 = lights.light_properties[light_idx].cascade_distance0;
            _2473.cascade_distance1 = lights.light_properties[light_idx].cascade_distance1;
            _2473.cascade_distance2 = lights.light_properties[light_idx].cascade_distance2;
            _2473.cascade_distance3 = lights.light_properties[light_idx].cascade_distance3;
            _2473.angular_falloff_power = lights.light_properties[light_idx].angular_falloff_power;
            _2473.angular_falloff_color_gradient_idx = lights.light_properties[light_idx].angular_falloff_color_gradient_idx;
            _2473.mat_shadow_mv = lights.light_properties[light_idx].mat_shadow_mv;
            _2473.mat_shadow_p[0] = lights.light_properties[light_idx].mat_shadow_p[0];
            _2473.mat_shadow_p[1] = lights.light_properties[light_idx].mat_shadow_p[1];
            _2473.mat_shadow_p[2] = lights.light_properties[light_idx].mat_shadow_p[2];
            _2473.mat_shadow_p[3] = lights.light_properties[light_idx].mat_shadow_p[3];
            _2473.mat_shadow_mvp[0] = lights.light_properties[light_idx].mat_shadow_mvp[0];
            _2473.mat_shadow_mvp[1] = lights.light_properties[light_idx].mat_shadow_mvp[1];
            _2473.mat_shadow_mvp[2] = lights.light_properties[light_idx].mat_shadow_mvp[2];
            _2473.mat_shadow_mvp[3] = lights.light_properties[light_idx].mat_shadow_mvp[3];
            LightProperties light = _2473;
            if ((light.lighting_exclusion_tags & metalness_roughness_material_tags.component_tags) != 0u)
            {
                continue;
            }
            vec3 light_color = vec3(0.0);
            vec3 pointToLight = light.position - world;
            if ((light.type & 1) != 0)
            {
                pointToLight = -light.direction;
            }
            pointToLight = normalize(pointToLight);
            float NdotL = dot(vNorm, pointToLight);
            if ((materialId & 1) == 1)
            {
                NdotL = 1.0;
            }
            vec3 param_8 = pointToLight;
            MaterialInfo param_9 = materialInfo;
            vec3 param_10 = vNorm;
            vec3 param_11 = view;
            light_color = (getPointShade(param_8, param_9, param_10, param_11) * light.intensity) * light.diffuse.xyz;
            float shadow = 0.0;
            bool _2530 = (material_flags & 512u) != 0u;
            bool _2537;
            if (_2530)
            {
                _2537 = (light.type & 8) != 0;
            }
            else
            {
                _2537 = _2530;
            }
            bool calculate_shadows = _2537;
            if (is_background)
            {
                shadow = 0.0;
                light_color = vec3(0.0);
                calculate_shadows = false;
            }
            vec3 light_attenuation_color = vec3(1.0);
            if ((light.type & 130) == 130)
            {
                LightProperties param_12 = light;
                vec3 param_13 = world;
                light_attenuation_color = light_calculate_spot_attenuation_color(param_12, param_13);
            }
            else
            {
                if ((light.type & 132) == 132)
                {
                    LightProperties param_14 = light;
                    vec3 param_15 = world;
                    light_attenuation_color = vec3(light_calculate_point_attenuation(param_14, param_15));
                }
            }
            if (((light.type & 256) != 0) && calculate_shadows)
            {
                shadow = texelFetch(LightShadowmapSamplers[light.shadowmap_sampler0], ivec2(screen_pos), 0).x;
                calculate_shadows = false;
            }
            if (((light.type & 3) != 0) && calculate_shadows)
            {
                vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                float in_frustum = 0.0;
                vec2 penumbraHash = texelFetch(s_BlueNoise, ivec3(screen_pos & ivec2(127), (_721.globals.monotonic + light_idx) & 15), 0).xy;
                float light_size = length(light.dimensions);
                int penumbra_iterations = max(8, min(10, int(light_size * 0.0024999999441206455230712890625)));
                float penumbra = light.roughness_modifier / 1024.0;
                if ((light.type & 2) != 0)
                {
                    if (true)
                    {
                        float search_radius = max(0.25, light_size * 0.20000000298023223876953125) / 1024.0;
                        if (true)
                        {
                            _2659 = light.downsampled_shadowmap_sampler;
                        }
                        else
                        {
                            _2659 = light.shadowmap_sampler0;
                        }
                        float param_16 = light_size;
                        vec2 param_17 = penumbraHash;
                        vec4 param_18 = vShadowCoords;
                        float param_19 = search_radius;
                        int param_20 = penumbra_iterations;
                        float param_21 = materials.material_properties[material].shadowmap_bias;
                        penumbra = PenumbraFromOccluderSearch(LightShadowmapSamplers[_2659], param_16, param_17, param_18, param_19, param_20, param_21);
                        penumbra = max(0.02500000037252902984619140625, penumbra);
                    }
                    else
                    {
                        penumbra = 0.0;
                    }
                }
                int light_iterations = max(4, min(12, int((penumbra * light.roughness_modifier) * 0.25)));
                vec4 param_22 = vShadowCoords;
                ivec2 param_23 = screen_pos;
                int param_25 = light_iterations;
                float param_26 = max(0.25, penumbra * light.roughness_modifier) / 1024.0;
                float param_27 = materials.material_properties[material].shadowmap_bias;
                float _2722 = sampleShadowPCFNoiseOffset(LightShadowmapCmpSamplers[light.shadowmap_sampler0], param_22, param_23, param_24, param_25, param_26, param_27);
                in_frustum = param_24;
                shadow = _2722;
                if (NdotL <= 0.0)
                {
                    shadow = max(shadow, smoothstep(0.0, -0.0500000007450580596923828125, NdotL));
                }
            }
            light_color *= (light_attenuation_color * (1.0 - shadow));
            if ((light.type & 16) != 0)
            {
                vec4 vShadowCoords_1 = light.mat_shadow_mvp[0] * vec4(world, 1.0);
                vec4 param_28 = vShadowCoords_1;
                vec4 _2761 = sampleProjectorTexture(LightProjectorSamplers[light.projector_sampler], param_28);
                vec3 projector_color = _2761.xyz * light.projector_intensity;
                light_color *= projector_color;
            }
            SPIRV_CROSS_BRANCH
            if (light.is_area != 0)
            {
                if ((materialId & 1) == 1)
                {
                }
                else
                {
                    LightProperties param_29 = light;
                    InitRect(param_29, param_30);
                    LTCRect rect = param_30;
                    LTCRect param_31 = rect;
                    InitRectPoints(param_31, param_32);
                    vec3 points[4] = param_32;
                    float ltc_roughness = roughness;
                    float ltc_intensity = light.intensity;
                    vec3 dcol = light.diffuse.xyz;
                    vec3 scol = dcol;
                    vec3 col = vec3(0.0);
                    vec3 pos = world;
                    vec3 N = vNorm;
                    vec3 V = normalize(_1134.basic_params.camera_position - world);
                    float ndotv = clamp(dot(N, V), 0.0500000007450580596923828125, 1.0);
                    vec2 uv = vec2(ltc_roughness, sqrt(1.0 - ndotv));
                    uv = (uv * 0.984375) + vec2(0.0078125);
                    vec4 t1 = texture(s_LTC1, uv);
                    vec4 t2 = texture(s_LTC2, uv);
                    mat3 Minv = mat3(vec3(vec3(t1.x, 0.0, t1.y)), vec3(0.0, 1.0, 0.0), vec3(vec3(t1.z, 0.0, t1.w)));
                    vec3 param_33 = N;
                    vec3 param_34 = V;
                    vec3 param_35 = pos;
                    mat3 param_36 = Minv;
                    vec3 param_37[4] = points;
                    bool param_38 = twoSided;
                    vec3 _2877 = LTC_Evaluate(param_33, param_34, param_35, param_36, param_37, param_38);
                    vec3 spec = _2877;
                    spec *= ((scol * t2.x) + ((vec3(1.0) - scol) * t2.y));
                    vec3 param_39 = N;
                    vec3 param_40 = V;
                    vec3 param_41 = pos;
                    mat3 param_42 = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0));
                    vec3 param_43[4] = points;
                    bool param_44 = twoSided;
                    vec3 _2906 = LTC_Evaluate(param_39, param_40, param_41, param_42, param_43, param_44);
                    vec3 diff = _2906;
                    col = ((spec * specularColor) + ((dcol * diff) * diffuseColor)) * ltc_intensity;
                    light_color = col;
                }
                if ((light.type & 128) == 128)
                {
                    LightProperties param_45 = light;
                    vec3 param_46 = world;
                    float attenuation = light_calculate_area_attenuation(param_45, param_46);
                    light_color *= attenuation;
                }
            }
            outLightColor += light_color;
        }
        if (false)
        {
            if (is_raytraced)
            {
                vec2 p = vTexcoord0 * _2146.render_lights_params.raytrace_scaling_factor;
                vec4 raytraceColor = texture(sRaytrace, p);
                vec4 _2959 = raytraceColor;
                vec3 _2961 = _2959.xyz * _2146.render_lights_params.raytrace_strength;
                raytraceColor.x = _2961.x;
                raytraceColor.y = _2961.y;
                raytraceColor.z = _2961.z;
                outLightColor += ((specularColor * raytraceColor.xyz) * (1.0 - roughness));
                outLightColor = mix(outLightColor, raytraceColor.xyz, vec3(raytraceColor.w));
            }
        }
    }
    outLightColor += base_emissive;
    if (is_background == false)
    {
        vec4 ibl_occlusion = texelFetch(sIBL, screen_pos, 0);
        vec3 ibl = ibl_occlusion.xyz;
        float occlusion = ibl_occlusion.w;
        outLightColor += ibl;
        outLightColor *= vec3(1.0 - (pow(occlusion, 0.25) * _3011.composite_setup.occlusion_base_strength));
    }
    vec4 _3020 = outColor;
    vec3 _3022 = _3020.xyz + outLightColor;
    outColor.x = _3022.x;
    outColor.y = _3022.y;
    outColor.z = _3022.z;
    if (is_background == false)
    {
        vec4 _3045 = outColor;
        vec3 _3047 = _3045.xyz * (((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz) + vec3(1.0));
        outColor.x = _3047.x;
        outColor.y = _3047.y;
        outColor.z = _3047.z;
        vec4 _3064 = outColor;
        vec3 _3066 = _3064.xyz + ((materials.material_properties[material].emissive * materials.material_properties[material].emissive_factor) * base_color.xyz);
        outColor.x = _3066.x;
        outColor.y = _3066.y;
        outColor.z = _3066.z;
    }
    vec3 noisyColor = outColor.xyz - outLightColor;
    if (false)
    {
        float f = texelFetch(sDepth, screen_pos, 0).x;
        if (f < 0.00999999977648258209228515625)
        {
            outColor = vec4(1.0);
        }
        else
        {
            outColor = vec4(0.0);
        }
    }
}

 