#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct InstanceModifierLookAt_Params
{
    vec3 ref_position;
    int look_away;
    int axis;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct ProcessInstanceModifiersParams
{
    int buffer_capacity;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 5, std140) uniform ProcessInstanceModifiersParamsBuffer
{
    ProcessInstanceModifiersParams process_modifiers_params;
} _686;

layout(set = 0, binding = 6, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _699;

layout(set = 0, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _711;

layout(set = 0, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _734;

layout(set = 0, binding = 3, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _759;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _767;

layout(set = 0, binding = 7, std140) uniform VM0
{
    InstanceModifierLookAt_Params VM0_params;
} _804;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

vec4 _mat3ToQuaternion(mat3 r)
{
    float trace = (r[0].x + r[1].y) + r[2].z;
    vec4 q;
    if (trace > 0.0)
    {
        float s = sqrt(trace + 1.0) * 2.0;
        q.w = 0.25 * s;
        q.x = (r[2].y - r[1].z) / s;
        q.y = (r[0].z - r[2].x) / s;
        q.z = (r[1].x - r[0].y) / s;
    }
    else
    {
        bool _161 = r[0].x > r[1].y;
        bool _169;
        if (_161)
        {
            _169 = r[0].x > r[2].z;
        }
        else
        {
            _169 = _161;
        }
        if (_169)
        {
            float s_1 = sqrt(((1.0 + r[0].x) - r[1].y) - r[2].z) * 2.0;
            q.w = (r[2].y - r[1].z) / s_1;
            q.x = 0.25 * s_1;
            q.y = (r[0].y + r[1].x) / s_1;
            q.z = (r[0].z + r[2].x) / s_1;
        }
        else
        {
            if (r[1].y > r[2].z)
            {
                float s_2 = sqrt(((1.0 + r[1].y) - r[0].x) - r[2].z) * 2.0;
                q.w = (r[0].z - r[2].x) / s_2;
                q.x = (r[0].y + r[1].x) / s_2;
                q.y = 0.25 * s_2;
                q.z = (r[1].z + r[2].y) / s_2;
            }
            else
            {
                float s_3 = sqrt(((1.0 + r[2].z) - r[0].x) - r[1].y) * 2.0;
                q.w = (r[1].x - r[0].y) / s_3;
                q.x = (r[0].z + r[2].x) / s_3;
                q.y = (r[1].z + r[2].y) / s_3;
                q.z = 0.25 * s_3;
            }
        }
    }
    return q;
}

vec4 _slerp(inout vec4 q1, inout vec4 q2, float t)
{
    q1 = normalize(q1);
    q2 = normalize(q2);
    float _dot = dot(q1, q2);
    if (_dot < 0.0)
    {
        q2 = -q2;
        _dot = -_dot;
    }
    if (_dot > 0.999499976634979248046875)
    {
        vec4 result = mix(q1, q2, vec4(t));
        return normalize(result);
    }
    float theta_0 = acos(_dot);
    float theta = theta_0 * t;
    float sin_theta = sin(theta);
    float sin_theta_0 = sin(theta_0);
    float s1 = cos(theta) - ((_dot * sin_theta) / sin_theta_0);
    float s2 = sin_theta / sin_theta_0;
    return (q1 * s1) + (q2 * s2);
}

mat3 _quaternionToMat3(inout vec4 q)
{
    q = normalize(q);
    float xx = q.x * q.x;
    float yy = q.y * q.y;
    float zz = q.z * q.z;
    float xy = q.x * q.y;
    float xz = q.x * q.z;
    float yz = q.y * q.z;
    float wx = q.w * q.x;
    float wy = q.w * q.y;
    float wz = q.w * q.z;
    mat3 m;
    m[0].x = 1.0 - (2.0 * (yy + zz));
    m[0].y = 2.0 * (xy - wz);
    m[0].z = 2.0 * (xz + wy);
    m[1].x = 2.0 * (xy + wz);
    m[1].y = 1.0 - (2.0 * (xx + zz));
    m[1].z = 2.0 * (yz - wx);
    m[2].x = 2.0 * (xz - wy);
    m[2].y = 2.0 * (yz + wx);
    m[2].z = 1.0 - (2.0 * (xx + yy));
    return m;
}

void instance_modifier_look_at(InstanceModifierLookAt_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    vec3 ref_position = modifier_params.ref_position;
    vec3 pos = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    vec3 nx = vec3(instance.m0.x, instance.m1.x, instance.m2.x);
    vec3 ny = vec3(instance.m0.y, instance.m1.y, instance.m2.y);
    vec3 nz = vec3(instance.m0.z, instance.m1.z, instance.m2.z);
    vec3 dir = normalize(pos - ref_position);
    if (modifier_params.look_away != 0)
    {
        dir *= (-1.0);
    }
    vec3 nnx;
    vec3 nny;
    vec3 nnz;
    if (modifier_params.axis == 0)
    {
        nnx = dir;
        nny = normalize(ny);
        nnz = normalize(cross(nnx, nny));
        nny = cross(nnx, nnz);
    }
    else
    {
        if (modifier_params.axis == 1)
        {
            nny = dir;
            nnx = normalize(nx);
            nnz = normalize(cross(nny, nnx));
            nnx = cross(nny, nnz);
        }
        else
        {
            nnz = dir;
            nnx = normalize(nx);
            nny = normalize(cross(nnz, nnx));
            nnx = cross(nny, nnz);
        }
    }
    float nx_length = length(nx);
    float ny_length = length(ny);
    float nz_length = length(nz);
    mat3 m_src;
    m_src[0] = nx / vec3(nx_length);
    m_src[1] = ny / vec3(ny_length);
    m_src[2] = nz / vec3(nz_length);
    mat3 m_dst;
    m_dst[0] = nnx;
    m_dst[1] = nny;
    m_dst[2] = nnz;
    mat3 param = m_src;
    vec4 q_src = _mat3ToQuaternion(param);
    mat3 param_1 = m_dst;
    vec4 q_dst = _mat3ToQuaternion(param_1);
    vec4 param_2 = q_src;
    vec4 param_3 = q_dst;
    float param_4 = modifier_factor.factor;
    vec4 _616 = _slerp(param_2, param_3, param_4);
    vec4 q_slerp = _616;
    vec4 param_5 = q_slerp;
    mat3 _620 = _quaternionToMat3(param_5);
    mat3 m_slerp = _620;
    m_slerp[0] *= nx_length;
    m_slerp[1] *= ny_length;
    m_slerp[2] *= nz_length;
    vec3 _642 = vec3(m_slerp[0].x, m_slerp[1].x, m_slerp[2].x);
    instance.m0.x = _642.x;
    instance.m0.y = _642.y;
    instance.m0.z = _642.z;
    vec3 _655 = vec3(m_slerp[0].y, m_slerp[1].y, m_slerp[2].y);
    instance.m1.x = _655.x;
    instance.m1.y = _655.y;
    instance.m1.z = _655.z;
    vec3 _668 = vec3(m_slerp[0].z, m_slerp[1].z, m_slerp[2].z);
    instance.m2.x = _668.x;
    instance.m2.y = _668.y;
    instance.m2.z = _668.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (id >= uint(_686.process_modifiers_params.buffer_capacity))
    {
        return;
    }
    if (id >= uint(_699.instance_params.instance_count))
    {
        return;
    }
    Instance instance;
    instance.m0 = _711.instance_transform[(id * 3u) + 0u];
    instance.m1 = _711.instance_transform[(id * 3u) + 1u];
    instance.m2 = _711.instance_transform[(id * 3u) + 2u];
    vec2 _741 = unpackHalf2x16(_734.instance_color[(id * 2u) + 0u]);
    instance.c.x = _741.x;
    instance.c.y = _741.y;
    vec2 _751 = unpackHalf2x16(_734.instance_color[(id * 2u) + 1u]);
    instance.c.z = _751.x;
    instance.c.w = _751.y;
    instance.flipbook_card = _759.instance_flipbook_card[id];
    instance.hash = _767.instance_hash[id];
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = instance.hash;
    modifier_factor.id = id;
    modifier_factor.position = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
    modifier_factor.is_spawned = false;
    modifier_factor.instance_id = id;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    InstanceModifierLookAt_Params _809;
    _809.ref_position = _804.VM0_params.ref_position;
    _809.look_away = _804.VM0_params.look_away;
    _809.axis = _804.VM0_params.axis;
    InstanceModifierLookAt_Params param = _809;
    ModifierFactor param_1 = modifier_factor;
    Instance param_2 = instance;
    uint param_3 = id;
    instance_modifier_look_at(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    instance = param_2;
    _711.instance_transform[(id * 3u) + 0u] = instance.m0;
    _711.instance_transform[(id * 3u) + 1u] = instance.m1;
    _711.instance_transform[(id * 3u) + 2u] = instance.m2;
    _734.instance_color[(id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _734.instance_color[(id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _759.instance_flipbook_card[id] = instance.flipbook_card;
}

 