#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct BasicDeferredParams
{
    mat4 mModel;
    mat4 mModelview;
    mat4 mCameraModelview;
    mat4 mProjection;
    vec4 camera_projection_params;
    vec4 camera_near_far_plane;
    vec3 camera_position;
};

struct DeferredRenderLightsParams
{
    vec2 frustum_shift;
    vec2 resolution;
    int lights_num;
    float env_map_intensity;
    float raytrace_scaling_factor;
    float raytrace_strength;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialInfo
{
    float perceptualRoughness;
    vec3 reflectance0;
    float alphaRoughness;
    vec3 diffuseColor;
    vec3 reflectance90;
    vec3 specularColor;
};

struct DeferredCompositeSetup
{
    vec4 ambient_color;
    vec4 fill_color;
    vec4 fog_color;
    float fog_range;
    float fog_height;
    float fog_height_density;
    float occlusion_strength;
    float occlusion_specular_from_diffuse;
    float global_illumination_strength;
    float global_illumination_base_strength;
    float occlusion_base_strength;
    float ssr_strength;
    float sso_strength;
    float volumetric_fog_strength;
    float volumetric_fog_intensity;
    float volumetric_fog_luminance_ceiling;
    uint volumetric_fog_blend_function;
    float _pad1;
    float _pad2;
    vec4 volumetric_fog_tint;
    float rt_strength;
    float ibl_intensity;
    uint transparency_blend;
    float taa_blend;
    float taa_gamma;
    float volumetric_light_strength;
    float volumetric_light_fog_density;
    float volumetric_light_fog_height;
    vec2 taa_jitter;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 2, std140) uniform BasicDeferredParamsBuffer
{
    layout(row_major) BasicDeferredParams basic_params;
} _269;

layout(set = 0, binding = 3, std140) uniform DeferredRenderLightsParamsBuffer
{
    DeferredRenderLightsParams render_lights_params;
} _297;

layout(set = 0, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 4, std140) uniform DeferredCompositeSetupBuffer
{
    DeferredCompositeSetup composite_setup;
} _606;

layout(set = 0, binding = 9) uniform sampler2D sAlbedo;
layout(set = 0, binding = 10) uniform usampler2D sNormalMaterial;
layout(set = 0, binding = 11) uniform sampler2D sDepth;
layout(set = 0, binding = 5, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 12) uniform sampler2D sEmissive;
layout(set = 0, binding = 13) uniform sampler2D sIBL;
layout(set = 0, binding = 6, rgba32f) uniform readonly image2D imHitDirectionPrimitiveIDReflection;
layout(set = 0, binding = 7, rgba32f) uniform readonly image2D imHitDirectionPrimitiveIDTransparency;
layout(set = 0, binding = 14) uniform sampler2D sRaytraceReflection;
layout(set = 0, binding = 15) uniform sampler2D sRaytraceTransparency;
layout(set = 0, binding = 8, rgba16f) uniform image2D imTarget;

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _138;
    if (nor.x > 0.0)
    {
        _138 = -t;
    }
    else
    {
        _138 = t;
    }
    nor.x += _138;
    float _153;
    if (nor.y > 0.0)
    {
        _153 = -t;
    }
    else
    {
        _153 = t;
    }
    nor.y += _153;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

float linearizeDepth(float d)
{
    return _269.basic_params.camera_near_far_plane.z / ((_269.basic_params.camera_near_far_plane.y + _269.basic_params.camera_near_far_plane.x) - (d * _269.basic_params.camera_near_far_plane.w));
}

vec3 get_view_direction(vec2 screen_pos)
{
    vec2 vd_pos = screen_pos - ((_297.render_lights_params.frustum_shift * _297.render_lights_params.resolution) * vec2(0.5, -0.5));
    vec3 view_direction;
    view_direction.x = (-_269.basic_params.camera_projection_params.z) + ((_269.basic_params.camera_projection_params.x * vd_pos.x) / _297.render_lights_params.resolution.x);
    view_direction.y = (-_269.basic_params.camera_projection_params.w) + ((_269.basic_params.camera_projection_params.y * vd_pos.y) / _297.render_lights_params.resolution.y);
    view_direction.z = 1.0;
    view_direction.y = -view_direction.y;
    return view_direction;
}

vec3 positionFromDepth(vec3 vDirection, float depth)
{
    return vDirection * depth;
}

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 schlick_fresnel(vec3 F0, float HdotV, float specular_factor)
{
    vec3 F = F0 + ((vec3(1.0) - F0) * pow(1.0 - HdotV, 5.0));
    F *= specular_factor;
    F = clamp(F, vec3(0.0), vec3(1.0));
    return F;
}

vec3 evaluate_reflection_factor(float roughness, float transparency, vec3 fresnel)
{
    return (vec3(1.0) - ((vec3(1.0) - fresnel) * transparency)) * (1.0 - roughness);
}

vec3 evaluate_transparency_factor(float roughness, float transparency, vec3 fresnel)
{
    return (vec3(1.0) - fresnel) * transparency;
}

void main()
{
    ivec2 tile_pos = ivec2(gl_WorkGroupID.xy);
    ivec2 screen_pos = (tile_pos * ivec2(8)) + ivec2(gl_LocalInvocationID.xy);
    vec4 base_color = texelFetch(sAlbedo, screen_pos, 0);
    uint encoded_normal_material = texelFetch(sNormalMaterial, screen_pos, 0).x;
    uint param = encoded_normal_material;
    vec3 _402 = decode_normal(param);
    vec3 N = _402;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    float param_2 = texelFetch(sDepth, screen_pos, 0).x;
    float depth = linearizeDepth(param_2);
    vec2 param_3 = vec2(screen_pos);
    vec3 view_direction = get_view_direction(param_3);
    vec3 param_4 = view_direction;
    float param_5 = depth;
    vec3 world = (_269.basic_params.mModel * vec4(positionFromDepth(param_4, param_5), 1.0)).xyz;
    uvec4 param_6 = imageLoad(imMetalnessRoughnessMaterialTags, screen_pos);
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param_6);
    float metalness = metalness_roughness_material_tags.metalness;
    float roughness = metalness_roughness_material_tags.roughness;
    uint material = metalness_roughness_material_tags.material_index;
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    if ((material_flags & 4096u) != 0u)
    {
        return;
    }
    vec3 base_emissive = texelFetch(sEmissive, screen_pos, 0).xyz * materials.material_properties[material].emissive;
    bool is_background = (materialId & 1) == 1;
    bool is_raytraced = (material_flags & 1u) != 0u;
    bool is_particle = (material_flags & 8192u) != 0u;
    if (is_particle == false)
    {
    }
    else
    {
        base_color.x = materials.material_properties[material].diffuse.x;
        base_color.y = materials.material_properties[material].diffuse.y;
        base_color.z = materials.material_properties[material].diffuse.z;
    }
    vec3 f0 = vec3(0.039999999105930328369140625);
    vec3 diffuseColor = (base_color.xyz * (vec3(1.0) - f0)) * (1.0 - metalness);
    vec3 specularColor = mix(f0, base_color.xyz, vec3(metalness));
    float alphaRoughness = roughness * roughness;
    vec3 specularEnvironmentR0 = specularColor;
    float reflectance = max(max(specularColor.x, specularColor.y), specularColor.z);
    vec3 specularEnvironmentR90 = vec3(1.0) * clamp(reflectance * 25.0, 0.0, 1.0);
    MaterialInfo materialInfo = MaterialInfo(roughness, specularEnvironmentR0, alphaRoughness, diffuseColor, specularEnvironmentR90, specularColor);
    vec3 V = normalize(_269.basic_params.camera_position - world);
    vec3 outLightColor = vec3(0.0);
    if (is_background == false)
    {
        vec4 ibl_occlusion = texelFetch(sIBL, screen_pos, 0);
        float occlusion = ibl_occlusion.w;
        occlusion = 1.0 - (pow(occlusion, 0.25) * _606.composite_setup.occlusion_base_strength);
        float transparency = materials.material_properties[material].transparency;
        transparency = 1.0 - ((1.0 - transparency) * base_color.w);
        vec4 hit_direction_primitiveID_reflection = imageLoad(imHitDirectionPrimitiveIDReflection, screen_pos);
        vec4 hit_direction_primitiveID_transparency = imageLoad(imHitDirectionPrimitiveIDTransparency, screen_pos);
        vec4 rt_reflection = vec4(0.0);
        vec4 rt_transparency = vec4(0.0);
        float param_7 = hit_direction_primitiveID_reflection.w;
        if (asuint(param_7) != 4294967295u)
        {
            rt_reflection = texelFetch(sRaytraceReflection, screen_pos, 0);
        }
        float param_8 = hit_direction_primitiveID_transparency.w;
        if (asuint(param_8) != 4294967295u)
        {
            rt_transparency = texelFetch(sRaytraceTransparency, screen_pos, 0);
        }
        vec3 f0_1 = vec3(0.039999999105930328369140625);
        vec3 param_9 = f0_1;
        float param_10 = dot(N, V);
        float param_11 = 1.0;
        vec3 fresnel = schlick_fresnel(param_9, param_10, param_11);
        vec4 _673 = rt_reflection;
        float _676 = rt_reflection.w;
        vec3 _680 = (_673.xyz * (1.0 - _676)) * occlusion;
        rt_reflection.x = _680.x;
        rt_reflection.y = _680.y;
        rt_reflection.z = _680.z;
        vec4 _687 = rt_transparency;
        float _690 = rt_transparency.w;
        vec3 _694 = (_687.xyz * (1.0 - _690)) * occlusion;
        rt_transparency.x = _694.x;
        rt_transparency.y = _694.y;
        rt_transparency.z = _694.z;
        vec4 _703 = rt_reflection;
        vec3 _705 = _703.xyz * _297.render_lights_params.raytrace_strength;
        rt_reflection.x = _705.x;
        rt_reflection.y = _705.y;
        rt_reflection.z = _705.z;
        vec4 _714 = rt_transparency;
        vec3 _716 = _714.xyz * _297.render_lights_params.raytrace_strength;
        rt_transparency.x = _716.x;
        rt_transparency.y = _716.y;
        rt_transparency.z = _716.z;
        vec4 _723 = rt_reflection;
        float param_12 = roughness;
        float param_13 = transparency;
        vec3 param_14 = fresnel;
        vec3 _732 = _723.xyz * evaluate_reflection_factor(param_12, param_13, param_14);
        rt_reflection.x = _732.x;
        rt_reflection.y = _732.y;
        rt_reflection.z = _732.z;
        vec4 _739 = rt_transparency;
        float param_15 = roughness;
        float param_16 = transparency;
        vec3 param_17 = fresnel;
        vec3 _748 = _739.xyz * evaluate_transparency_factor(param_15, param_16, param_17);
        rt_transparency.x = _748.x;
        rt_transparency.y = _748.y;
        rt_transparency.z = _748.z;
        vec4 base = imageLoad(imTarget, screen_pos);
        vec4 _762 = base;
        float param_18 = roughness;
        float param_19 = transparency;
        vec3 param_20 = fresnel;
        vec3 _775 = (_762.xyz * (vec3(1.0) - evaluate_transparency_factor(param_18, param_19, param_20))) + rt_transparency.xyz;
        base.x = _775.x;
        base.y = _775.y;
        base.z = _775.z;
        vec4 _784 = base;
        vec3 _786 = _784.xyz + rt_reflection.xyz;
        base.x = _786.x;
        base.y = _786.y;
        base.z = _786.z;
        imageStore(imTarget, screen_pos, base);
    }
}

 