#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GeometryInstantiateParams
{
    int surfaces_num;
    int surface_idx;
    int _pad0;
    int _pad1;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

layout(set = 0, binding = 1, std430) buffer OutGeometryInformationBuffer
{
    GeometryInformation output_geometry_information;
} _79;

layout(set = 0, binding = 2, std430) buffer OutIndexBuffer
{
    uint data[];
} out_idx_data;

layout(set = 0, binding = 3, std430) buffer OutVTXCoords
{
    float data[];
} out_vtx_coords;

layout(set = 0, binding = 4, std430) buffer OutVTXNormals
{
    float data[];
} out_vtx_normals;

layout(set = 0, binding = 5, std430) buffer OutVTXAlbedo
{
    float data[];
} out_vtx_albedo;

layout(set = 0, binding = 6, std430) buffer OutVTXCustom0
{
    uint data[];
} out_vtx_custom0;

layout(set = 0, binding = 14, scalar) uniform InGeometryInformationBuffer
{
    GeometryInformation input_geometry_information;
} _203;

layout(set = 0, binding = 7, std430) readonly buffer InIndexBuffer
{
    uint data[];
} in_idx_data;

layout(set = 0, binding = 8, std430) readonly buffer InVTXCoords
{
    float data[];
} in_vtx_coords;

layout(set = 0, binding = 9, std430) readonly buffer InVTXNormals
{
    float data[];
} in_vtx_normals;

layout(set = 0, binding = 10, std430) readonly buffer InVTXAlbedo
{
    float data[];
} in_vtx_albedo;

layout(set = 0, binding = 11, std430) readonly buffer InVTXCustom0
{
    uint data[];
} in_vtx_custom0;

layout(set = 0, binding = 15, std140) uniform GeometryInstantiateParamsBuffer
{
    GeometryInstantiateParams geometry_instantiate_params;
} _328;

layout(set = 0, binding = 16, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _346;

layout(set = 0, binding = 12, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _504;

layout(set = 0, binding = 13, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _585;

uint get_idx(inout uint idx)
{
    idx += _203.input_geometry_information.idx_buffer_offset;
    return in_idx_data.data[idx];
}

void put_idx(inout uint idx, uint v)
{
    idx += _79.output_geometry_information.idx_buffer_offset;
    out_idx_data.data[idx] = v;
}

vec3 get_coords(inout uint idx)
{
    idx *= _203.input_geometry_information.attributes[0].stride;
    idx += _203.input_geometry_information.attributes[0].offset;
    return vec3(in_vtx_coords.data[idx + 0u], in_vtx_coords.data[idx + 1u], in_vtx_coords.data[idx + 2u]);
}

vec3 get_normal(inout uint idx)
{
    idx *= _203.input_geometry_information.attributes[1].stride;
    idx += _203.input_geometry_information.attributes[1].offset;
    return vec3(in_vtx_normals.data[idx + 0u], in_vtx_normals.data[idx + 1u], in_vtx_normals.data[idx + 2u]);
}

vec3 get_albedo(inout uint idx)
{
    idx *= _203.input_geometry_information.attributes[2].stride;
    idx += _203.input_geometry_information.attributes[2].offset;
    return vec3(in_vtx_albedo.data[idx + 0u], in_vtx_albedo.data[idx + 1u], in_vtx_albedo.data[idx + 2u]);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

uint get_custom0(inout uint idx)
{
    idx *= _203.input_geometry_information.attributes[6].stride;
    idx += _203.input_geometry_information.attributes[6].offset;
    return in_vtx_custom0.data[idx + 0u];
}

void put_coords(inout uint idx, vec3 v)
{
    idx *= _79.output_geometry_information.attributes[0].stride;
    idx += _79.output_geometry_information.attributes[0].offset;
    out_vtx_coords.data[idx + 0u] = v.x;
    out_vtx_coords.data[idx + 1u] = v.y;
    out_vtx_coords.data[idx + 2u] = v.z;
}

void put_normal(inout uint idx, vec3 v)
{
    idx *= _79.output_geometry_information.attributes[1].stride;
    idx += _79.output_geometry_information.attributes[1].offset;
    out_vtx_normals.data[idx + 0u] = v.x;
    out_vtx_normals.data[idx + 1u] = v.y;
    out_vtx_normals.data[idx + 2u] = v.z;
}

void put_albedo(inout uint idx, vec3 v)
{
    idx *= _79.output_geometry_information.attributes[2].stride;
    idx += _79.output_geometry_information.attributes[2].offset;
    out_vtx_albedo.data[idx + 0u] = v.x;
    out_vtx_albedo.data[idx + 1u] = v.y;
    out_vtx_albedo.data[idx + 2u] = v.z;
}

void put_custom0(inout uint idx, uint v)
{
    idx *= _79.output_geometry_information.attributes[6].stride;
    idx += _79.output_geometry_information.attributes[6].offset;
    out_vtx_custom0.data[idx + 0u] = v;
}

void main()
{
    uint thread_idx = gl_GlobalInvocationID.x;
    uint surface_idx = uint(_328.geometry_instantiate_params.surface_idx);
    uint src_vtx_num = _203.input_geometry_information.vtx_num;
    uint src_faces_num = _203.input_geometry_information.faces_num_per_surface[surface_idx];
    uint dst_faces_num = src_faces_num * uint(_346.instance_params.instance_count);
    for (uint face_idx = thread_idx; face_idx < dst_faces_num; face_idx += 131072u)
    {
        uint instance_idx = face_idx / src_faces_num;
        uint src_face_idx = face_idx - (instance_idx * src_faces_num);
        uint param = (src_face_idx * 3u) + 0u;
        uint _379 = get_idx(param);
        uint i0 = _379;
        uint param_1 = (src_face_idx * 3u) + 1u;
        uint _385 = get_idx(param_1);
        uint i1 = _385;
        uint param_2 = (src_face_idx * 3u) + 2u;
        uint _391 = get_idx(param_2);
        uint i2 = _391;
        uint param_3 = (face_idx * 3u) + 0u;
        uint param_4 = i0 + (instance_idx * src_vtx_num);
        put_idx(param_3, param_4);
        uint param_5 = (face_idx * 3u) + 1u;
        uint param_6 = i1 + (instance_idx * src_vtx_num);
        put_idx(param_5, param_6);
        uint param_7 = (face_idx * 3u) + 2u;
        uint param_8 = i2 + (instance_idx * src_vtx_num);
        put_idx(param_7, param_8);
    }
    _79.output_geometry_information.faces_num_per_surface[surface_idx] = dst_faces_num;
    if (surface_idx == 0u)
    {
        uint src_vtx_num_1 = _203.input_geometry_information.vtx_num;
        uint dst_vtx_num = src_vtx_num_1 * uint(_346.instance_params.instance_count);
        vec4 inst_c;
        for (uint vtx_idx = thread_idx; vtx_idx < dst_vtx_num; vtx_idx += 131072u)
        {
            uint instance_idx_1 = vtx_idx / src_vtx_num_1;
            uint src_vtx_idx = vtx_idx - (instance_idx_1 * src_vtx_num_1);
            uint i0_1 = src_vtx_idx;
            uint param_9 = i0_1;
            vec3 _469 = get_coords(param_9);
            vec3 v0_coords = _469;
            vec3 v0_normal = vec3(0.0, 0.0, 1.0);
            if ((_203.input_geometry_information.builtin_attribute_mask & 2u) != 0u)
            {
                uint param_10 = i0_1;
                vec3 _481 = get_normal(param_10);
                v0_normal = _481;
            }
            vec3 v0_albedo = vec3(1.0);
            if ((_203.input_geometry_information.builtin_attribute_mask & 4u) != 0u)
            {
                uint param_11 = i0_1;
                vec3 _493 = get_albedo(param_11);
                v0_albedo = _493;
            }
            if (_346.instance_params.stride > 0)
            {
                vec4 inst_m0 = _504.instance_transform[(instance_idx_1 * uint(_346.instance_params.stride)) + 0u];
                vec4 inst_m1 = _504.instance_transform[(instance_idx_1 * uint(_346.instance_params.stride)) + 1u];
                vec4 inst_m2 = _504.instance_transform[(instance_idx_1 * uint(_346.instance_params.stride)) + 2u];
                vec4 v = vec4(v0_coords, 1.0);
                v0_coords.x = dot(inst_m0, v);
                v0_coords.y = dot(inst_m1, v);
                v0_coords.z = dot(inst_m2, v);
                vec3 param_12 = v0_normal;
                mat4 param_13 = transpose(mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0)));
                v0_normal = normalize(vector_transform_by_mat33(param_12, param_13));
                vec2 _592 = unpackHalf2x16(_585.instance_color[(instance_idx_1 * 2u) + 0u]);
                inst_c.x = _592.x;
                inst_c.y = _592.y;
                vec2 _602 = unpackHalf2x16(_585.instance_color[(instance_idx_1 * 2u) + 1u]);
                inst_c.z = _602.x;
                inst_c.w = _602.y;
                v0_albedo *= inst_c.xyz;
            }
            uint v0_custom0 = 0u;
            if ((_203.input_geometry_information.builtin_attribute_mask & 64u) != 0u)
            {
                uint param_14 = i0_1;
                uint _620 = get_custom0(param_14);
                v0_custom0 = _620;
            }
            uint param_15 = vtx_idx;
            vec3 param_16 = v0_coords;
            put_coords(param_15, param_16);
            if ((_79.output_geometry_information.builtin_attribute_mask & 2u) != 0u)
            {
                uint param_17 = vtx_idx;
                vec3 param_18 = v0_normal;
                put_normal(param_17, param_18);
            }
            if ((_79.output_geometry_information.builtin_attribute_mask & 4u) != 0u)
            {
                uint param_19 = vtx_idx;
                vec3 param_20 = v0_albedo;
                put_albedo(param_19, param_20);
            }
            if ((_79.output_geometry_information.builtin_attribute_mask & 64u) != 0u)
            {
                uint param_21 = vtx_idx;
                uint param_22 = v0_custom0;
                put_custom0(param_21, param_22);
            }
        }
    }
}

 