#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 2, rgba16ui) uniform readonly uimage2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 3, r32ui) uniform readonly uimage2D imNormalMaterial;
layout(set = 0, binding = 4, rgba16f) uniform readonly image2D imRaytraceGlassReflection;
layout(set = 0, binding = 5, rgba16f) uniform readonly image2D imRaytrace;
layout(set = 0, binding = 6, rgba16f) uniform writeonly image2D imTarget;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

int decode_material(uint data)
{
    return int(data >> 31u);
}

void main()
{
    uvec2 tile_pos = gl_WorkGroupID.xy;
    uvec2 pixel_pos = (tile_pos * uvec2(8u)) + gl_LocalInvocationID.xy;
    uvec4 param = imageLoad(imMetalnessRoughnessMaterialTags, ivec2(pixel_pos));
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
    uint material = metalness_roughness_material_tags.material_index;
    bool is_background = true;
    uint encoded_normal_material = imageLoad(imNormalMaterial, ivec2(pixel_pos)).x;
    uint param_1 = encoded_normal_material;
    int materialId = decode_material(param_1);
    if ((materialId & 1) != 1)
    {
        is_background = false;
    }
    uint material_flags = materials.material_properties[material].flags;
    if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
    {
        material_flags &= 4294967280u;
        material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
    }
    bool is_raytraced = (material_flags & 1u) != 0u;
    vec4 color = vec4(0.0);
    if ((is_background == false) && is_raytraced)
    {
        vec4 rt_glass_reflection = imageLoad(imRaytraceGlassReflection, ivec2(pixel_pos));
        vec4 rt = imageLoad(imRaytrace, ivec2(pixel_pos));
        vec3 _215 = mix(rt.xyz, rt_glass_reflection.xyz, vec3(rt_glass_reflection.w));
        color.x = _215.x;
        color.y = _215.y;
        color.z = _215.z;
        color.w = rt.w;
    }
    imageStore(imTarget, ivec2(pixel_pos), color);
}

 