#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct RTFace
{
    uint v0;
    uint v1;
    uint v2;
    uint material_flags;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ParticleEmitterGeometry_Params
{
    int constrained;
    int debug_counter;
    int debug_counter2;
    int debug_counter3;
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    float surface_distance;
    int pending;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    int alpha_to_modifier_factor;
};

struct Particle
{
    vec3 pos;
    ParticleState state;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ParticleEmitterParticles_Params
{
    vec4 particle_color;
    float particle_lifetime;
    float particle_lifetime_randomness;
    float rate;
    float seed;
    int pending;
    float modifier_factor_threshold;
    float min_elapsed_lifetime;
    float min_remaining_lifetime;
};

struct ParticleLifecycleParams
{
    float time_step;
    float life_time_step;
    float max_lifetime;
    uint reset;
    uint capacity;
    uint has_previous;
};

struct ModifierFactorFromParticleProperty_Params
{
    uint property;
    uint modifier_function;
    float property_scale;
    int _pad2;
};

struct ModifierFactorWaveTransfer_Params
{
    int type;
    int modulate;
    float frequency;
    float phase_shift;
    float amplitude;
    float base;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorMeshProximity_Params
{
    uint modifier_function;
    int transformed_data_location_idx;
    int transformed_data_location_num;
    float factor_multiplier;
    int normalize_range;
    int inverse_factor;
    float normalize_max_range;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct ParticleModifierCurl_Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 noise_strength;
    float noise_speed;
    vec3 noise_scale;
};

struct ParticleModifierColorize_Params
{
    vec4 color;
    int mode;
    int blend_mode;
    int color_gradient_idx;
    float randomness;
    float blend_from_previous;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct VM6Params
{
    vec3 position;
    int falloff_mode;
    vec3 radius;
    int falloff_inverse;
    vec3 velocity;
    float time_step;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _560;

layout(set = 0, binding = 2, std430) buffer ParticlePositionsData
{
    float prt_positions[];
} _591;

layout(set = 0, binding = 3, std430) buffer ParticlePrevPositionsData
{
    float prt_prev_positions[];
} _632;

layout(set = 0, binding = 4, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _1058;

layout(set = 0, binding = 5, std430) buffer TransformedDataIndexBuffer
{
    uint transformed_data_indices[];
} _1112;

layout(set = 0, binding = 9, std140) uniform VM0_0
{
    layout(row_major) ModifierFactorDistancePlane_Params VM0_0_params;
} _1250;

layout(set = 0, binding = 6, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _1280;

layout(set = 0, binding = 10, std140) uniform VM1_0
{
    layout(row_major) ModifierFactorNoise_Params VM1_0_params;
} _2226;

layout(set = 0, binding = 11, std140) uniform VM1_1
{
    layout(row_major) ModifierFactorDistancePlane_Params VM1_1_params;
} _2240;

layout(set = 0, binding = 12, std140) uniform GlobalVariablesBuffer
{
    GlobalVariables globals;
} _3088;

layout(set = 0, binding = 13, std140) uniform ParticleLifecycleParamsBuffer
{
    ParticleLifecycleParams lifecycle_params;
} _3236;

layout(set = 0, binding = 7, std430) buffer VM0
{
    ParticleEmitterGeometry_Params VM0_params;
} _3376;

layout(set = 0, binding = 8, std430) buffer VM1
{
    ParticleEmitterParticles_Params VM1_params;
} _3413;

layout(set = 0, binding = 14, std140) uniform VM2
{
    ModifierFactorFromParticleProperty_Params VM2_params;
} _3450;

layout(set = 0, binding = 15, std140) uniform VM3
{
    ModifierFactorWaveTransfer_Params VM3_params;
} _3465;

layout(set = 0, binding = 16, std140) uniform VM4
{
    ModifierFactorFromParticleProperty_Params VM4_params;
} _3477;

layout(set = 0, binding = 17, std140) uniform VM5
{
    ModifierFactorClamp_Params VM5_params;
} _3491;

layout(set = 0, binding = 18, std140) uniform VM6
{
    VM6Params VM6_params;
} _3505;

layout(set = 0, binding = 19, std140) uniform VM7
{
    ModifierFactorMeshProximity_Params VM7_params;
} _3533;

layout(set = 0, binding = 20, std140) uniform VM8
{
    ModifierFactorCurveTransfer_Params VM8_params;
} _3548;

layout(set = 0, binding = 21, std140) uniform VM9
{
    ModifierFactorFromParticleProperty_Params VM9_params;
} _3560;

layout(set = 0, binding = 22, std140) uniform VM10
{
    ModifierFactorClamp_Params VM10_params;
} _3573;

layout(set = 0, binding = 23, std140) uniform VM11
{
    ParticleModifierCurl_Params VM11_params;
} _3591;

layout(set = 0, binding = 24, std140) uniform VM12
{
    layout(row_major) ModifierFactorNoise_Params VM12_params;
} _3620;

layout(set = 0, binding = 25, std140) uniform VM13
{
    ParticleModifierCurl_Params VM13_params;
} _3639;

layout(set = 0, binding = 26, std140) uniform VM14
{
    ModifierFactorWaveTransfer_Params VM14_params;
} _3667;

layout(set = 0, binding = 27, std140) uniform VM15
{
    ParticleModifierColorize_Params VM15_params;
} _3685;

layout(set = 0, binding = 28) uniform sampler2D s_Curves;
layout(set = 0, binding = 29) uniform sampler2D s_Gradients;

vec3 prt_get_prev_position(uint id)
{
    return vec3(_632.prt_prev_positions[(id * 3u) + 0u], _632.prt_prev_positions[(id * 3u) + 1u], _632.prt_prev_positions[(id * 3u) + 2u]);
}

ParticleState prt_get_state(uint id)
{
    ParticleState _566;
    _566.life_time = _560.prt_states[id].life_time;
    _566.life_span = _560.prt_states[id].life_span;
    _566.generation_id = _560.prt_states[id].generation_id;
    _566.color = _560.prt_states[id].color;
    ParticleState _565 = _566;
    return _565;
}

void prt_kill(inout ParticleState state)
{
    state.life_time = state.life_span;
}

void prt_set_state(uint id, ParticleState state)
{
    ParticleState _573;
    _573.life_time = state.life_time;
    _573.life_span = state.life_span;
    _573.generation_id = state.generation_id;
    _573.color = state.color;
    _560.prt_states[id] = _573;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

bool prt_is_alive(ParticleState state)
{
    return state.life_time < state.life_span;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

uint particle_emitter_geometry_get_first_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint(emitter_params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1280.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint particle_emitter_geometry_get_last_face_idx(ParticleEmitterGeometry_Params emitter_params)
{
    uint tdl_idx = uint((emitter_params.transformed_data_location_idx + emitter_params.transformed_data_location_num) - 1);
    return _1280.transformed_data_location[tdl_idx].last_face_idx;
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _540 = hash(param);
    uint param_1 = _540;
    float _542 = floatConstruct(param_1);
    return _542;
}

RTFace rt_get_face(uint face_idx)
{
    uint v0 = _1112.transformed_data_indices[(face_idx * 3u) + 0u];
    uint v1 = _1112.transformed_data_indices[(face_idx * 3u) + 1u];
    uint v2 = _1112.transformed_data_indices[(face_idx * 3u) + 2u];
    uint flags0 = v0 >> uint(24);
    uint flags1 = v1 >> uint(24);
    RTFace f;
    f.v0 = v0 & 16777215u;
    f.v1 = v1 & 16777215u;
    f.v2 = v2;
    f.material_flags = flags0 | (flags1 << uint(8));
    return f;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_1058.in_vtx_data[coord_offset + 0u], _1058.in_vtx_data[coord_offset + 1u], _1058.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec4 rt_get_vertex_color(uint idx)
{
    uint color_offset = (idx * 1u) + 70000000u;
    uint packed_color = floatBitsToUint(_1058.in_vtx_data[color_offset + 0u]);
    vec4 p = vec4(float((packed_color >> uint(24)) & 255u), float((packed_color >> uint(16)) & 255u), float((packed_color >> uint(8)) & 255u), float((packed_color >> uint(0)) & 255u)) * 0.0039215688593685626983642578125;
    return p;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1187 = vector_transform_by_mat43(param, param_1);
        coords = _1187;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1194 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1194;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

ModifierFactor particle_emitter_geometry_emit_evaluate_modifier_VM0(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorDistancePlane_Params _1255;
    _1255.transform_local_to_gizmo = _1250.VM0_0_params.transform_local_to_gizmo;
    _1255.falloff_curve_idx = _1250.VM0_0_params.falloff_curve_idx;
    _1255.falloff_inverse = _1250.VM0_0_params.falloff_inverse;
    _1255.domain_mirror = _1250.VM0_0_params.domain_mirror;
    _1255.domain_repeat = _1250.VM0_0_params.domain_repeat;
    _1255.influence_scope = _1250.VM0_0_params.influence_scope;
    _1255.modifier_function = _1250.VM0_0_params.modifier_function;
    ModifierFactorDistancePlane_Params param = _1255;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_distance_plane(param, param_1, param_2);
    modifier_factor = param_1;
    return modifier_factor;
}

uint color_convert_rgb_float3_uint(inout vec3 v)
{
    float v_mag = ceil(length(v));
    v /= vec3(v_mag);
    v_mag = min(255.0, v_mag);
    uint vi = (uint(v.x * 255.0) | (uint(v.y * 255.0) << uint(8))) | (uint(v.z * 255.0) << uint(16));
    vi |= (uint(v_mag) * 16777216u);
    return vi;
}

void prt_set_color(inout ParticleState state, vec3 c)
{
    vec3 param = c;
    uint _686 = color_convert_rgb_float3_uint(param);
    uint v = _686;
    state.color = v;
}

void prt_spawn(inout ParticleState state, float life_span)
{
    state.life_time = 0.0;
    state.life_span = life_span;
    float generation_id = state.generation_id + 1.0;
    if (generation_id > 65536.0)
    {
        generation_id = 0.0;
    }
    state.generation_id = generation_id;
}

void particle_emitter_geometry_emit_VM0(ParticleEmitterGeometry_Params emitter_params, inout ModifierFactor modifier_factor, inout Particle p, uint id, uint pending_id)
{
    ParticleEmitterGeometry_Params param = emitter_params;
    uint first_face_idx = particle_emitter_geometry_get_first_face_idx(param);
    ParticleEmitterGeometry_Params param_1 = emitter_params;
    uint last_face_idx = particle_emitter_geometry_get_last_face_idx(param_1);
    if (first_face_idx == last_face_idx)
    {
        return;
    }
    float seed = emitter_params.seed;
    bool emitted = false;
    vec3 bc;
    for (int iteration = 0; iteration < 5; iteration++)
    {
        float fid = float((id + uint(iteration * 45827)) & 16777215u);
        float fid_seed = ((fid * 0.0131700001657009124755859375) + seed) * 0.00113200000487267971038818359375;
        float param_2 = fid_seed * 5.131999969482421875;
        float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param_2)));
        float param_3 = fid_seed;
        uint face_idx = uint(float((last_face_idx - first_face_idx) - 1u) * random(param_3));
        face_idx += first_face_idx;
        uint param_4 = face_idx;
        RTFace rt_face = rt_get_face(param_4);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_5 = p0_idx;
        vec3 p0 = rt_get_vertex(param_5);
        uint param_6 = p1_idx;
        vec3 p1 = rt_get_vertex(param_6);
        uint param_7 = p2_idx;
        vec3 p2 = rt_get_vertex(param_7);
        uint param_8 = p0_idx;
        vec4 c0 = rt_get_vertex_color(param_8);
        uint param_9 = p1_idx;
        vec4 c1 = rt_get_vertex_color(param_9);
        uint param_10 = p2_idx;
        vec4 c2 = rt_get_vertex_color(param_10);
        float param_11 = fid_seed * 0.34130001068115234375;
        bc.x = random(param_11);
        float param_12 = fid_seed * 0.1412999927997589111328125;
        bc.y = random(param_12);
        if ((bc.x + bc.y) >= 1.0)
        {
            bc.x = 1.0 - bc.x;
            bc.y = 1.0 - bc.y;
        }
        vec3 pos = ((p0 * bc.x) + (p1 * bc.y)) + (p2 * ((1.0 - bc.x) - bc.y));
        vec4 color = ((c0 * bc.x) + (c1 * bc.y)) + (c2 * ((1.0 - bc.x) - bc.y));
        ModifierFactor local_modifier_factor = modifier_factor_defaults();
        local_modifier_factor.factor = 1.0;
        local_modifier_factor.hash = floatBitsToUint(fid_seed);
        local_modifier_factor.id = id;
        local_modifier_factor.position = pos;
        local_modifier_factor.is_spawned = true;
        local_modifier_factor.color = color;
        ModifierFactor param_13 = local_modifier_factor;
        ModifierFactor _1492 = particle_emitter_geometry_emit_evaluate_modifier_VM0(param_13);
        local_modifier_factor = _1492;
        if (local_modifier_factor.factor <= 9.9999997473787516355514526367188e-05)
        {
            continue;
        }
        float particle_emitter_dist = length((emitter_params.position - pos) / (emitter_params.radius * 0.5));
        if ((emitter_params.constrained == 0) || (particle_emitter_dist <= 1.0))
        {
            if (emitter_params.surface_distance > 0.0)
            {
                vec3 n = normalize(cross(p0 - p1, p0 - p2));
                pos += (n * emitter_params.surface_distance);
            }
            if (pos.x == 1234566.0)
            {
                pos += vec3(fid_seed);
            }
            if (pos.x == 1234567.0)
            {
                pos += vec3(fid_seed * 5.131999969482421875);
            }
            p.pos = pos;
            ParticleState param_14 = p.state;
            vec3 param_15 = emitter_params.particle_color.xyz;
            prt_set_color(param_14, param_15);
            p.state = param_14;
            ParticleState param_16 = p.state;
            float param_17 = lifetime;
            prt_spawn(param_16, param_17);
            p.state = param_16;
            if (emitter_params.alpha_to_modifier_factor != 0)
            {
                modifier_factor.factor = color.w;
            }
            emitted = true;
            break;
        }
    }
}

vec3 prt_get_position(uint id)
{
    return vec3(_591.prt_positions[(id * 3u) + 0u], _591.prt_positions[(id * 3u) + 1u], _591.prt_positions[(id * 3u) + 2u]);
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _2131 = vector_transform_by_mat43(param, param_1);
        coords = _2131;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _2138 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _2138;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

ModifierFactor particle_emitter_particles_emit_evaluate_modifier_VM1(inout ModifierFactor modifier_factor)
{
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorNoise_Params _2231;
    _2231.transform_local_to_gizmo = _2226.VM1_0_params.transform_local_to_gizmo;
    _2231.noise_domain_scale = _2226.VM1_0_params.noise_domain_scale;
    _2231.modifier_function = _2226.VM1_0_params.modifier_function;
    _2231.noise_domain_offset = _2226.VM1_0_params.noise_domain_offset;
    _2231.noise_value_scale = _2226.VM1_0_params.noise_value_scale;
    _2231.noise_value_offset = _2226.VM1_0_params.noise_value_offset;
    _2231.influence_scope = _2226.VM1_0_params.influence_scope;
    _2231._pad0 = _2226.VM1_0_params._pad0;
    _2231._pad1 = _2226.VM1_0_params._pad1;
    ModifierFactorNoise_Params param = _2231;
    ModifierFactor param_1 = modifier_factor;
    CoordinateSystemTrasforms param_2 = cs_transforms;
    modifier_factor_noise_default(param, param_1, param_2);
    modifier_factor = param_1;
    ModifierFactorDistancePlane_Params _2244;
    _2244.transform_local_to_gizmo = _2240.VM1_1_params.transform_local_to_gizmo;
    _2244.falloff_curve_idx = _2240.VM1_1_params.falloff_curve_idx;
    _2244.falloff_inverse = _2240.VM1_1_params.falloff_inverse;
    _2244.domain_mirror = _2240.VM1_1_params.domain_mirror;
    _2244.domain_repeat = _2240.VM1_1_params.domain_repeat;
    _2244.influence_scope = _2240.VM1_1_params.influence_scope;
    _2244.modifier_function = _2240.VM1_1_params.modifier_function;
    ModifierFactorDistancePlane_Params param_3 = _2244;
    ModifierFactor param_4 = modifier_factor;
    CoordinateSystemTrasforms param_5 = cs_transforms;
    modifier_factor_distance_plane(param_3, param_4, param_5);
    modifier_factor = param_4;
    return modifier_factor;
}

void particle_emitter_particles_emit_VM1(ParticleEmitterParticles_Params emitter_params, ModifierFactor modifier_factor, ParticleLifecycleParams lifecycle_params, inout Particle p, uint id)
{
    float fid = float(id);
    float param = fid * 5.131999969482421875;
    float lifetime = emitter_params.particle_lifetime * (1.0 + (emitter_params.particle_lifetime_randomness * random(param)));
    SPIRV_CROSS_LOOP
    for (int iteration = 0; iteration < 4; iteration++)
    {
        float param_1 = (fid * 0.01200000010430812835693359375) + ((emitter_params.seed + float(iteration)) * 0.017200000584125518798828125);
        float f = random(param_1);
        uint source_id = uint(int(f * float(lifecycle_params.capacity)));
        uint param_2 = source_id;
        ParticleState state = prt_get_state(param_2);
        uint param_3 = source_id;
        vec3 pos = prt_get_position(param_3);
        ParticleState param_4 = state;
        bool _2310 = prt_is_alive(param_4);
        bool _2318;
        if (_2310)
        {
            _2318 = state.life_time > emitter_params.min_elapsed_lifetime;
        }
        else
        {
            _2318 = _2310;
        }
        bool _2329;
        if (_2318)
        {
            _2329 = (state.life_span - state.life_time) > emitter_params.min_remaining_lifetime;
        }
        else
        {
            _2329 = _2318;
        }
        if (_2329)
        {
            ModifierFactor local_modifier_factor = modifier_factor_defaults();
            local_modifier_factor.factor = modifier_factor.factor;
            local_modifier_factor.hash = source_id;
            local_modifier_factor.id = source_id;
            local_modifier_factor.instance_id = source_id;
            local_modifier_factor.position = pos;
            local_modifier_factor.is_spawned = true;
            ModifierFactor param_5 = local_modifier_factor;
            ModifierFactor _2348 = particle_emitter_particles_emit_evaluate_modifier_VM1(param_5);
            local_modifier_factor = _2348;
            if (local_modifier_factor.factor >= emitter_params.modifier_factor_threshold)
            {
                p.pos = pos;
                ParticleState param_6 = p.state;
                float param_7 = lifetime;
                prt_spawn(param_6, param_7);
                p.state = param_6;
                ParticleState param_8 = p.state;
                vec3 param_9 = emitter_params.particle_color.xyz;
                prt_set_color(param_8, param_9);
                p.state = param_8;
                p.state.generation_id = (p.state.generation_id + state.generation_id) + 1.0;
                break;
            }
        }
    }
}

void modifier_factor_from_particle_property(ModifierFactorFromParticleProperty_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    uint id = modifier_factor.id;
    uint param = id;
    ParticleState state = prt_get_state(param);
    ParticleState param_1 = state;
    if (prt_is_alive(param_1) == false)
    {
        return;
    }
    float v = 0.0;
    if (modifier_params.property == 0u)
    {
        v = state.life_time;
    }
    else
    {
        if (modifier_params.property == 1u)
        {
            v = max(0.0, state.life_span - state.life_time);
        }
        else
        {
            if (modifier_params.property == 2u)
            {
                v = state.generation_id;
            }
        }
    }
    v *= modifier_params.property_scale;
    ModifierFactor param_2 = modifier_factor;
    uint param_3 = modifier_params.modifier_function;
    float param_4 = v;
    modifier_process_modifier_factor(param_2, param_3, param_4);
    modifier_factor = param_2;
}

void modifier_factor_wave_transfer(ModifierFactorWaveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.frequency) + modifier_params.phase_shift;
    if (modifier_params.type == 0)
    {
        v = sin((v * 3.1415927410125732421875) * 2.0);
    }
    else
    {
        if (modifier_params.type == 1)
        {
            float phase = mod(v, 1.0) - 0.5;
            v = (abs(2.0 * (phase - floor(phase + 0.5))) * 2.0) - 1.0;
        }
        else
        {
            if (modifier_params.type == 2)
            {
                float phase_1 = mod(v, 1.0) - 0.5;
                v = sign(phase_1);
            }
        }
    }
    if (modifier_params.modulate != 0)
    {
        v = modifier_factor.factor * ((v * modifier_params.amplitude) + modifier_params.base);
    }
    else
    {
        v = (v * modifier_params.amplitude) + modifier_params.base;
    }
    modifier_factor.factor = v;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

uint modifier_factor_mesh_proximity_get_first_face_idx(ModifierFactorMeshProximity_Params params)
{
    uint tdl_idx = uint(params.transformed_data_location_idx);
    if (tdl_idx > 0u)
    {
        return _1280.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

uint modifier_factor_mesh_proximity_get_last_face_idx(ModifierFactorMeshProximity_Params params)
{
    uint tdl_idx = uint((params.transformed_data_location_idx + params.transformed_data_location_num) - 1);
    return _1280.transformed_data_location[tdl_idx].last_face_idx;
}

float modifier_factor_mesh_proximity_pointSegmentDistanceSquared(vec3 p, vec3 a, vec3 b)
{
    vec3 ab = b - a;
    float t = dot(p - a, ab) / dot(ab, ab);
    t = clamp(t, 0.0, 1.0);
    vec3 projection = a + (ab * t);
    return dot(p - projection, p - projection);
}

float modifier_factor_mesh_proximity_point_triangle_distance_squared(vec3 p, vec3 a, vec3 b, vec3 c)
{
    vec3 ab = b - a;
    vec3 ac = c - a;
    vec3 normal = normalize(cross(ab, ac));
    float distanceToPlane = dot(p - a, normal);
    vec3 projected = p - (normal * distanceToPlane);
    vec3 ap = projected - a;
    float d00 = dot(ab, ab);
    float d01 = dot(ab, ac);
    float d11 = dot(ac, ac);
    float d20 = dot(ap, ab);
    float d21 = dot(ap, ac);
    float denom = (d00 * d11) - (d01 * d01);
    float v = ((d11 * d20) - (d01 * d21)) / denom;
    float w = ((d00 * d21) - (d01 * d20)) / denom;
    float u = (1.0 - v) - w;
    if (((u >= 0.0) && (v >= 0.0)) && (w >= 0.0))
    {
        return abs(distanceToPlane * distanceToPlane);
    }
    else
    {
        vec3 param = p;
        vec3 param_1 = a;
        vec3 param_2 = b;
        float d1 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param, param_1, param_2);
        vec3 param_3 = p;
        vec3 param_4 = b;
        vec3 param_5 = c;
        float d2 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param_3, param_4, param_5);
        vec3 param_6 = p;
        vec3 param_7 = c;
        vec3 param_8 = a;
        float d3 = modifier_factor_mesh_proximity_pointSegmentDistanceSquared(param_6, param_7, param_8);
        return min(min(d1, d2), d3);
    }
}

int modifier_factor_mesh_proximity_find_closest_face(ModifierFactorMeshProximity_Params params, vec3 p)
{
    ModifierFactorMeshProximity_Params param = params;
    int f0 = int(modifier_factor_mesh_proximity_get_first_face_idx(param));
    ModifierFactorMeshProximity_Params param_1 = params;
    int f1 = int(modifier_factor_mesh_proximity_get_last_face_idx(param_1));
    float closest_d = 0.0;
    int closest_fi = -1;
    for (int fi = f0; fi <= f1; fi++)
    {
        uint param_2 = uint(fi);
        RTFace rt_face = rt_get_face(param_2);
        uint p0_idx = rt_face.v0;
        uint p1_idx = rt_face.v1;
        uint p2_idx = rt_face.v2;
        uint param_3 = p0_idx;
        vec3 p0 = rt_get_vertex(param_3);
        uint param_4 = p1_idx;
        vec3 p1 = rt_get_vertex(param_4);
        uint param_5 = p2_idx;
        vec3 p2 = rt_get_vertex(param_5);
        vec3 param_6 = p;
        vec3 param_7 = p0;
        vec3 param_8 = p1;
        vec3 param_9 = p2;
        float d = modifier_factor_mesh_proximity_point_triangle_distance_squared(param_6, param_7, param_8, param_9);
        if (d >= 0.0)
        {
            if ((d < closest_d) || (closest_fi == (-1)))
            {
                closest_fi = fi;
                closest_d = d;
            }
        }
    }
    return closest_fi;
}

void modifier_factor_mesh_proximity(ModifierFactorMeshProximity_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    if (modifier_params.transformed_data_location_num == 0)
    {
        return;
    }
    ModifierFactorMeshProximity_Params param = modifier_params;
    vec3 param_1 = modifier_factor.position;
    int fi = modifier_factor_mesh_proximity_find_closest_face(param, param_1);
    if (fi == (-1))
    {
        return;
    }
    uint param_2 = uint(fi);
    RTFace rt_face = rt_get_face(param_2);
    uint p0_idx = rt_face.v0;
    uint p1_idx = rt_face.v1;
    uint p2_idx = rt_face.v2;
    uint param_3 = p0_idx;
    vec3 p0 = rt_get_vertex(param_3);
    uint param_4 = p1_idx;
    vec3 p1 = rt_get_vertex(param_4);
    uint param_5 = p2_idx;
    vec3 p2 = rt_get_vertex(param_5);
    vec3 param_6 = modifier_factor.position;
    vec3 param_7 = p0;
    vec3 param_8 = p1;
    vec3 param_9 = p2;
    float d = modifier_factor_mesh_proximity_point_triangle_distance_squared(param_6, param_7, param_8, param_9);
    d = sqrt(d);
    if (modifier_params.normalize_range != 0)
    {
        d /= modifier_params.normalize_max_range;
        d = min(1.0, d);
        if (modifier_params.inverse_factor != 0)
        {
            d = 1.0 - d;
        }
    }
    float v = d * modifier_params.factor_multiplier;
    ModifierFactor param_10 = modifier_factor;
    uint param_11 = modifier_params.modifier_function;
    float param_12 = v;
    modifier_process_modifier_factor(param_10, param_11, param_12);
    modifier_factor = param_10;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

vec3 pm_curl_snoiseVec3(vec3 x)
{
    vec3 param = vec3(x);
    float s = snoise(param);
    vec3 param_1 = vec3(x.y - 19.1000003814697265625, x.z + 33.40000152587890625, x.x + 47.200000762939453125);
    float s1 = snoise(param_1);
    vec3 param_2 = vec3(x.z + 74.1999969482421875, x.x - 124.5, x.y + 99.40000152587890625);
    float s2 = snoise(param_2);
    vec3 c = vec3(s, s1, s2);
    return c;
}

vec3 pm_curl_curlNoise(vec3 p, out vec3 gradient, out float out_scale)
{
    vec3 dx = vec3(0.100000001490116119384765625, 0.0, 0.0);
    vec3 dy = vec3(0.0, 0.100000001490116119384765625, 0.0);
    vec3 dz = vec3(0.0, 0.0, 0.100000001490116119384765625);
    vec3 param = p - dx;
    vec3 p_x0 = pm_curl_snoiseVec3(param);
    vec3 param_1 = p + dx;
    vec3 p_x1 = pm_curl_snoiseVec3(param_1);
    vec3 param_2 = p - dy;
    vec3 p_y0 = pm_curl_snoiseVec3(param_2);
    vec3 param_3 = p + dy;
    vec3 p_y1 = pm_curl_snoiseVec3(param_3);
    vec3 param_4 = p - dz;
    vec3 p_z0 = pm_curl_snoiseVec3(param_4);
    vec3 param_5 = p + dz;
    vec3 p_z1 = pm_curl_snoiseVec3(param_5);
    float x = ((p_y1.z - p_y0.z) - p_z1.y) + p_z0.y;
    float y = ((p_z1.x - p_z0.x) - p_x1.z) + p_x0.z;
    float z = ((p_x1.y - p_x0.y) - p_y1.x) + p_y0.x;
    gradient = vec3(p_x0.x, p_y0.y, p_z0.z) * 3.1400001049041748046875;
    out_scale = p_x0.x;
    return normalize(vec3(x, y, z));
}

void particle_modifier_curl(ParticleModifierCurl_Params modifier_params, ParticleLifecycleParams lifecycle_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    vec3 modifier_position = modifier_params.position;
    vec3 param = (p.pos * modifier_params.noise_scale) + (vec3(_3088.globals.time, _3088.globals.time * 0.3014999926090240478515625, (-_3088.globals.time) * 0.3129999935626983642578125) * modifier_params.noise_speed);
    vec3 param_1;
    float param_2;
    vec3 _3111 = pm_curl_curlNoise(param, param_1, param_2);
    vec3 gradient = param_1;
    float out_scale = param_2;
    p.pos += (((_3111 * modifier_params.noise_strength) * modifier_factor.factor) * lifecycle_params.time_step);
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash_1 = _permute(param_2);
    vec4 theta = hash_1 * 3.883222103118896484375;
    vec4 sz = (hash_1 * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash_1 * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _2113 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _2113;
    return n;
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _2180 = vector_transform_by_mat43(param, param_1);
        coords = _2180;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _2187 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _2187;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(ParticleState state)
{
    vec4 c = vec4(1.0);
    uint param = state.color;
    vec3 _673 = color_convert_uint_to_float3(param);
    c.x = _673.x;
    c.y = _673.y;
    c.z = _673.z;
    return c;
}

void particle_modifier_colorize(ParticleModifierColorize_Params modifier_params, ModifierFactor modifier_factor, inout Particle p, uint id)
{
    float v = 0.0;
    if (uint(modifier_params.mode) == 0u)
    {
        v = float(id) * modifier_params.randomness;
    }
    if (uint(modifier_params.mode) == 1u)
    {
        vec3 param = p.pos * modifier_params.randomness;
        v = snoise(param);
    }
    if (uint(modifier_params.mode) == 2u)
    {
        if (p.state.life_time == 0.0)
        {
            vec3 param_1 = p.pos * modifier_params.randomness;
            v = snoise(param_1);
        }
        else
        {
            return;
        }
    }
    if (uint(modifier_params.mode) == 3u)
    {
        v = 1.0;
    }
    v = fract(v);
    vec3 color;
    if (modifier_params.color_gradient_idx != (-1))
    {
        int param_2 = modifier_params.color_gradient_idx;
        float param_3 = v;
        color = gradient_sample(param_2, param_3).xyz * modifier_params.color.xyz;
    }
    else
    {
        color = modifier_params.color.xyz;
    }
    if (uint(modifier_params.blend_mode) == 0u)
    {
        ParticleState param_4 = p.state;
        vec4 color_previous = prt_get_color(param_4);
        color = mix(color_previous.xyz, color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3236.lifecycle_params.time_step));
    }
    else
    {
        if (uint(modifier_params.blend_mode) == 2u)
        {
            color = mix(vec3(1.0), color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3236.lifecycle_params.time_step));
        }
        else
        {
            if (uint(modifier_params.blend_mode) == 1u)
            {
                color = mix(vec3(0.0), color, vec3((modifier_params.blend_from_previous * modifier_factor.factor) * _3236.lifecycle_params.time_step));
            }
        }
    }
    ParticleState param_5 = p.state;
    vec3 param_6 = color;
    prt_set_color(param_5, param_6);
    p.state = param_5;
}

void prt_advance_life(inout ParticleState state, float time_step, float max_lifespan)
{
    state.life_time += time_step;
    state.life_span = min(state.life_span, max_lifespan);
}

void prt_set_position(uint id, vec3 p)
{
    _591.prt_positions[(id * 3u) + 0u] = p.x;
    _591.prt_positions[(id * 3u) + 1u] = p.y;
    _591.prt_positions[(id * 3u) + 2u] = p.z;
}

void prt_set_prev_position(uint id, vec3 p)
{
    _632.prt_prev_positions[(id * 3u) + 0u] = p.x;
    _632.prt_prev_positions[(id * 3u) + 1u] = p.y;
    _632.prt_prev_positions[(id * 3u) + 2u] = p.z;
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    uint param = id;
    Particle p;
    p.pos = prt_get_prev_position(param);
    uint param_1 = id;
    p.state = prt_get_state(param_1);
    float prev_generation_id = p.state.generation_id;
    if (_3236.lifecycle_params.reset != 0u)
    {
        ParticleState param_2 = p.state;
        prt_kill(param_2);
        p.state = param_2;
    }
    if (id >= _3236.lifecycle_params.capacity)
    {
        ParticleState param_3 = p.state;
        prt_kill(param_3);
        p.state = param_3;
        uint param_4 = id;
        ParticleState param_5 = p.state;
        prt_set_state(param_4, param_5);
        return;
    }
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    ParticleState param_6 = p.state;
    vec3 _3349;
    if (prt_is_alive(param_6))
    {
        _3349 = p.pos;
    }
    else
    {
        _3349 = vec3(0.0);
    }
    modifier_factor.position = _3349;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ParticleState param_7 = p.state;
    if (!prt_is_alive(param_7))
    {
        int _3380 = atomicAdd(_3376.VM0_params.pending, -1);
        int pending = _3380;
        if (pending > 0)
        {
            ParticleEmitterGeometry_Params _3391;
            _3391.constrained = _3376.VM0_params.constrained;
            _3391.debug_counter = _3376.VM0_params.debug_counter;
            _3391.debug_counter2 = _3376.VM0_params.debug_counter2;
            _3391.debug_counter3 = _3376.VM0_params.debug_counter3;
            _3391.position = _3376.VM0_params.position;
            _3391.falloff_mode = _3376.VM0_params.falloff_mode;
            _3391.radius = _3376.VM0_params.radius;
            _3391.falloff_inverse = _3376.VM0_params.falloff_inverse;
            _3391.particle_color = _3376.VM0_params.particle_color;
            _3391.particle_lifetime = _3376.VM0_params.particle_lifetime;
            _3391.particle_lifetime_randomness = _3376.VM0_params.particle_lifetime_randomness;
            _3391.rate = _3376.VM0_params.rate;
            _3391.seed = _3376.VM0_params.seed;
            _3391.surface_distance = _3376.VM0_params.surface_distance;
            _3391.pending = _3376.VM0_params.pending;
            _3391.transformed_data_location_idx = _3376.VM0_params.transformed_data_location_idx;
            _3391.transformed_data_location_num = _3376.VM0_params.transformed_data_location_num;
            _3391.alpha_to_modifier_factor = _3376.VM0_params.alpha_to_modifier_factor;
            ParticleEmitterGeometry_Params param_8 = _3391;
            ModifierFactor param_9 = modifier_factor;
            Particle param_10 = p;
            uint param_11 = id;
            uint param_12 = uint(pending);
            particle_emitter_geometry_emit_VM0(param_8, param_9, param_10, param_11, param_12);
            modifier_factor = param_9;
            p = param_10;
        }
    }
    ParticleState param_13 = p.state;
    if (!prt_is_alive(param_13))
    {
        int _3415 = atomicAdd(_3413.VM1_params.pending, -1);
        int pending_1 = _3415;
        if (pending_1 > 0)
        {
            ParticleEmitterParticles_Params _3424;
            _3424.particle_color = _3413.VM1_params.particle_color;
            _3424.particle_lifetime = _3413.VM1_params.particle_lifetime;
            _3424.particle_lifetime_randomness = _3413.VM1_params.particle_lifetime_randomness;
            _3424.rate = _3413.VM1_params.rate;
            _3424.seed = _3413.VM1_params.seed;
            _3424.pending = _3413.VM1_params.pending;
            _3424.modifier_factor_threshold = _3413.VM1_params.modifier_factor_threshold;
            _3424.min_elapsed_lifetime = _3413.VM1_params.min_elapsed_lifetime;
            _3424.min_remaining_lifetime = _3413.VM1_params.min_remaining_lifetime;
            ParticleEmitterParticles_Params param_14 = _3424;
            ModifierFactor param_15 = modifier_factor;
            ParticleLifecycleParams _3431;
            _3431.time_step = _3236.lifecycle_params.time_step;
            _3431.life_time_step = _3236.lifecycle_params.life_time_step;
            _3431.max_lifetime = _3236.lifecycle_params.max_lifetime;
            _3431.reset = _3236.lifecycle_params.reset;
            _3431.capacity = _3236.lifecycle_params.capacity;
            _3431.has_previous = _3236.lifecycle_params.has_previous;
            ParticleLifecycleParams param_16 = _3431;
            Particle param_17 = p;
            uint param_18 = id;
            particle_emitter_particles_emit_VM1(param_14, param_15, param_16, param_17, param_18);
            p = param_17;
        }
    }
    ParticleState param_19 = p.state;
    if (prt_is_alive(param_19))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorFromParticleProperty_Params _3455;
    _3455.property = _3450.VM2_params.property;
    _3455.modifier_function = _3450.VM2_params.modifier_function;
    _3455.property_scale = _3450.VM2_params.property_scale;
    _3455._pad2 = _3450.VM2_params._pad2;
    ModifierFactorFromParticleProperty_Params param_20 = _3455;
    ModifierFactor param_21 = modifier_factor;
    CoordinateSystemTrasforms param_22 = cs_transforms;
    modifier_factor_from_particle_property(param_20, param_21, param_22);
    modifier_factor = param_21;
    ModifierFactorWaveTransfer_Params _3470;
    _3470.type = _3465.VM3_params.type;
    _3470.modulate = _3465.VM3_params.modulate;
    _3470.frequency = _3465.VM3_params.frequency;
    _3470.phase_shift = _3465.VM3_params.phase_shift;
    _3470.amplitude = _3465.VM3_params.amplitude;
    _3470.base = _3465.VM3_params.base;
    ModifierFactorWaveTransfer_Params param_23 = _3470;
    ModifierFactor param_24 = modifier_factor;
    modifier_factor_wave_transfer(param_23, param_24);
    modifier_factor = param_24;
    ModifierFactorFromParticleProperty_Params _3481;
    _3481.property = _3477.VM4_params.property;
    _3481.modifier_function = _3477.VM4_params.modifier_function;
    _3481.property_scale = _3477.VM4_params.property_scale;
    _3481._pad2 = _3477.VM4_params._pad2;
    ModifierFactorFromParticleProperty_Params param_25 = _3481;
    ModifierFactor param_26 = modifier_factor;
    CoordinateSystemTrasforms param_27 = cs_transforms;
    modifier_factor_from_particle_property(param_25, param_26, param_27);
    modifier_factor = param_26;
    ModifierFactorClamp_Params _3496;
    _3496.clamp_min = _3491.VM5_params.clamp_min;
    _3496.clamp_max = _3491.VM5_params.clamp_max;
    _3496.clamp_min_enable = _3491.VM5_params.clamp_min_enable;
    _3496.clamp_max_enable = _3491.VM5_params.clamp_max_enable;
    ModifierFactorClamp_Params param_28 = _3496;
    ModifierFactor param_29 = modifier_factor;
    modifier_factor_clamp(param_28, param_29);
    modifier_factor = param_29;
    vec3 modifier_position = _3505.VM6_params.position;
    p.pos += ((_3505.VM6_params.velocity * _3236.lifecycle_params.time_step) * modifier_factor.factor);
    ParticleState param_30 = p.state;
    if (prt_is_alive(param_30))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorMeshProximity_Params _3538;
    _3538.modifier_function = _3533.VM7_params.modifier_function;
    _3538.transformed_data_location_idx = _3533.VM7_params.transformed_data_location_idx;
    _3538.transformed_data_location_num = _3533.VM7_params.transformed_data_location_num;
    _3538.factor_multiplier = _3533.VM7_params.factor_multiplier;
    _3538.normalize_range = _3533.VM7_params.normalize_range;
    _3538.inverse_factor = _3533.VM7_params.inverse_factor;
    _3538.normalize_max_range = _3533.VM7_params.normalize_max_range;
    ModifierFactorMeshProximity_Params param_31 = _3538;
    ModifierFactor param_32 = modifier_factor;
    CoordinateSystemTrasforms param_33 = cs_transforms;
    modifier_factor_mesh_proximity(param_31, param_32, param_33);
    modifier_factor = param_32;
    ModifierFactorCurveTransfer_Params _3553;
    _3553.curve_idx = _3548.VM8_params.curve_idx;
    _3553.input_range_min = _3548.VM8_params.input_range_min;
    _3553.input_range_max = _3548.VM8_params.input_range_max;
    _3553.amplitude = _3548.VM8_params.amplitude;
    _3553.base = _3548.VM8_params.base;
    ModifierFactorCurveTransfer_Params param_34 = _3553;
    ModifierFactor param_35 = modifier_factor;
    modifier_factor_curve_transfer(param_34, param_35);
    modifier_factor = param_35;
    ModifierFactorFromParticleProperty_Params _3564;
    _3564.property = _3560.VM9_params.property;
    _3564.modifier_function = _3560.VM9_params.modifier_function;
    _3564.property_scale = _3560.VM9_params.property_scale;
    _3564._pad2 = _3560.VM9_params._pad2;
    ModifierFactorFromParticleProperty_Params param_36 = _3564;
    ModifierFactor param_37 = modifier_factor;
    CoordinateSystemTrasforms param_38 = cs_transforms;
    modifier_factor_from_particle_property(param_36, param_37, param_38);
    modifier_factor = param_37;
    ModifierFactorClamp_Params _3577;
    _3577.clamp_min = _3573.VM10_params.clamp_min;
    _3577.clamp_max = _3573.VM10_params.clamp_max;
    _3577.clamp_min_enable = _3573.VM10_params.clamp_min_enable;
    _3577.clamp_max_enable = _3573.VM10_params.clamp_max_enable;
    ModifierFactorClamp_Params param_39 = _3577;
    ModifierFactor param_40 = modifier_factor;
    modifier_factor_clamp(param_39, param_40);
    modifier_factor = param_40;
    ParticleState param_41 = p.state;
    if (prt_is_alive(param_41))
    {
        ParticleModifierCurl_Params _3596;
        _3596.position = _3591.VM11_params.position;
        _3596.falloff_mode = _3591.VM11_params.falloff_mode;
        _3596.radius = _3591.VM11_params.radius;
        _3596.falloff_inverse = _3591.VM11_params.falloff_inverse;
        _3596.noise_strength = _3591.VM11_params.noise_strength;
        _3596.noise_speed = _3591.VM11_params.noise_speed;
        _3596.noise_scale = _3591.VM11_params.noise_scale;
        ParticleModifierCurl_Params param_42 = _3596;
        ParticleLifecycleParams _3600;
        _3600.time_step = _3236.lifecycle_params.time_step;
        _3600.life_time_step = _3236.lifecycle_params.life_time_step;
        _3600.max_lifetime = _3236.lifecycle_params.max_lifetime;
        _3600.reset = _3236.lifecycle_params.reset;
        _3600.capacity = _3236.lifecycle_params.capacity;
        _3600.has_previous = _3236.lifecycle_params.has_previous;
        ParticleLifecycleParams param_43 = _3600;
        ModifierFactor param_44 = modifier_factor;
        Particle param_45 = p;
        uint param_46 = id;
        particle_modifier_curl(param_42, param_43, param_44, param_45, param_46);
        p = param_45;
    }
    ParticleState param_47 = p.state;
    if (prt_is_alive(param_47))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorNoise_Params _3624;
    _3624.transform_local_to_gizmo = _3620.VM12_params.transform_local_to_gizmo;
    _3624.noise_domain_scale = _3620.VM12_params.noise_domain_scale;
    _3624.modifier_function = _3620.VM12_params.modifier_function;
    _3624.noise_domain_offset = _3620.VM12_params.noise_domain_offset;
    _3624.noise_value_scale = _3620.VM12_params.noise_value_scale;
    _3624.noise_value_offset = _3620.VM12_params.noise_value_offset;
    _3624.influence_scope = _3620.VM12_params.influence_scope;
    _3624._pad0 = _3620.VM12_params._pad0;
    _3624._pad1 = _3620.VM12_params._pad1;
    ModifierFactorNoise_Params param_48 = _3624;
    ModifierFactor param_49 = modifier_factor;
    CoordinateSystemTrasforms param_50 = cs_transforms;
    modifier_factor_noise_simplex2(param_48, param_49, param_50);
    modifier_factor = param_49;
    ParticleState param_51 = p.state;
    if (prt_is_alive(param_51))
    {
        ParticleModifierCurl_Params _3643;
        _3643.position = _3639.VM13_params.position;
        _3643.falloff_mode = _3639.VM13_params.falloff_mode;
        _3643.radius = _3639.VM13_params.radius;
        _3643.falloff_inverse = _3639.VM13_params.falloff_inverse;
        _3643.noise_strength = _3639.VM13_params.noise_strength;
        _3643.noise_speed = _3639.VM13_params.noise_speed;
        _3643.noise_scale = _3639.VM13_params.noise_scale;
        ParticleModifierCurl_Params param_52 = _3643;
        ParticleLifecycleParams _3647;
        _3647.time_step = _3236.lifecycle_params.time_step;
        _3647.life_time_step = _3236.lifecycle_params.life_time_step;
        _3647.max_lifetime = _3236.lifecycle_params.max_lifetime;
        _3647.reset = _3236.lifecycle_params.reset;
        _3647.capacity = _3236.lifecycle_params.capacity;
        _3647.has_previous = _3236.lifecycle_params.has_previous;
        ParticleLifecycleParams param_53 = _3647;
        ModifierFactor param_54 = modifier_factor;
        Particle param_55 = p;
        uint param_56 = id;
        particle_modifier_curl(param_52, param_53, param_54, param_55, param_56);
        p = param_55;
    }
    ParticleState param_57 = p.state;
    if (prt_is_alive(param_57))
    {
        modifier_factor.position = p.pos;
    }
    ModifierFactorWaveTransfer_Params _3671;
    _3671.type = _3667.VM14_params.type;
    _3671.modulate = _3667.VM14_params.modulate;
    _3671.frequency = _3667.VM14_params.frequency;
    _3671.phase_shift = _3667.VM14_params.phase_shift;
    _3671.amplitude = _3667.VM14_params.amplitude;
    _3671.base = _3667.VM14_params.base;
    ModifierFactorWaveTransfer_Params param_58 = _3671;
    ModifierFactor param_59 = modifier_factor;
    modifier_factor_wave_transfer(param_58, param_59);
    modifier_factor = param_59;
    ParticleState param_60 = p.state;
    if (prt_is_alive(param_60))
    {
        ParticleModifierColorize_Params _3690;
        _3690.color = _3685.VM15_params.color;
        _3690.mode = _3685.VM15_params.mode;
        _3690.blend_mode = _3685.VM15_params.blend_mode;
        _3690.color_gradient_idx = _3685.VM15_params.color_gradient_idx;
        _3690.randomness = _3685.VM15_params.randomness;
        _3690.blend_from_previous = _3685.VM15_params.blend_from_previous;
        ParticleModifierColorize_Params param_61 = _3690;
        ModifierFactor param_62 = modifier_factor;
        Particle param_63 = p;
        uint param_64 = id;
        particle_modifier_colorize(param_61, param_62, param_63, param_64);
        modifier_factor = param_62;
        p = param_63;
    }
    ParticleState param_65 = p.state;
    float param_66 = _3236.lifecycle_params.life_time_step;
    float param_67 = _3236.lifecycle_params.max_lifetime;
    prt_advance_life(param_65, param_66, param_67);
    p.state = param_65;
    uint param_68 = id;
    ParticleState param_69 = p.state;
    prt_set_state(param_68, param_69);
    uint param_70 = id;
    vec3 param_71 = p.pos;
    prt_set_position(param_70, param_71);
    bool _3726 = _3236.lifecycle_params.has_previous != 0u;
    bool _3733;
    if (_3726)
    {
        _3733 = p.state.generation_id != prev_generation_id;
    }
    else
    {
        _3733 = _3726;
    }
    if (_3733)
    {
        uint param_72 = id;
        vec3 param_73 = p.pos;
        prt_set_prev_position(param_72, param_73);
    }
}

 