#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(triangles, cw, fractional_odd_spacing) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct VertexModifierDisplaceParams
{
    vec3 displace_normal;
    float displace_normal_modifier_factor;
    vec3 displace_base;
    float displace_base_modifier_factor;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct VertexModifierColorizeParams
{
    vec3 color;
    float alpha;
    int use_gradient;
    float color_blend;
    float alpha_blend;
    int color_gradient_idx;
    int mixing_mode;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 4, binding = 3, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1215;

layout(set = 4, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1233;

layout(set = 4, binding = 4, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1327;

layout(set = 4, binding = 5, std140) uniform VM7
{
    layout(row_major) ModifierFactorNoise_Params VM7_params;
} _1340;

layout(set = 4, binding = 6, std140) uniform VM8
{
    layout(row_major) ModifierFactorNoise_Params VM8_params;
} _1354;

layout(set = 4, binding = 7, std140) uniform VM9
{
    VertexModifierDisplaceParams VM9_params;
} _1368;

layout(set = 4, binding = 8, std140) uniform VM10
{
    ModifierFactorCurveTransfer_Params VM10_params;
} _1389;

layout(set = 4, binding = 9, std140) uniform VM11
{
    VertexModifierColorizeParams VM11_params;
} _1402;

layout(set = 4, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1505;

layout(set = 4, binding = 10) uniform sampler2D s_NoiseRGBA;
layout(set = 4, binding = 11) uniform sampler2D s_Curves;
layout(set = 4, binding = 12) uniform sampler2D s_Gradients;

layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_outputs;

layout(location = 1) in Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_inputs[32];

layout(location = 0) in uint instanceID[];

vec3 interpolate_bc(vec3 v1, vec3 v2, vec3 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec4 interpolate_bc(vec4 v1, vec4 v2, vec4 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec2 interpolate_bc(vec2 v1, vec2 v2, vec2 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    for (int k = -1; k <= 1; k++)
    {
        for (int j = -1; j <= 1; j++)
        {
            for (int i = -1; i <= 1; i++)
            {
                vec3 b = vec3(float(i), float(j), float(k));
                vec3 param = p + b;
                vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                float d = dot(r, r);
                if (d < res.x)
                {
                    id = dot(p + b, vec3(1.0, 57.0, 113.0));
                    res = vec2(d, res.x);
                }
                else
                {
                    if (d < res.y)
                    {
                        res.y = d;
                    }
                }
            }
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _821 = vector_transform_by_mat43(param, param_1);
        coords = _821;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _828 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _828;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _772 = vector_transform_by_mat43(param, param_1);
        coords = _772;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _779 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _779;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void _vertex_modifier_displace_apply(VertexModifierDisplaceParams params, ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    float influence = modifier_factor.factor;
    if (influence != 0.0)
    {
        vec3 n = vtx.norm;
        vec3 p = vtx.pos;
        p += ((params.displace_base * params.displace_base_modifier_factor) * influence);
        p += (((n * params.displace_normal) * params.displace_normal_modifier_factor) * influence);
        vtx.pos = p;
    }
}

void vertex_modifier_displace_apply(VertexModifierDisplaceParams params, inout ModifierFactor modifier_factor, inout VertexInput vtx, CoordinateSystemTrasforms cs_transforms)
{
    VertexModifierDisplaceParams param = params;
    ModifierFactor param_1 = modifier_factor;
    VertexInput param_2 = vtx;
    CoordinateSystemTrasforms param_3 = cs_transforms;
    _vertex_modifier_displace_apply(param, param_1, param_2, param_3);
    modifier_factor = param_1;
    vtx = param_2;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

vec4 gradient_sample(int idx, float t)
{
    return textureLod(s_Gradients, vec2(t, (float(idx) + 0.5) / 256.0), 0.0);
}

void vertex_modifier_colorize_apply(VertexModifierColorizeParams modifier_params, ModifierFactor modifier_factor, inout VertexInput vtx)
{
    vec3 c = vec3(1.0);
    float a = modifier_params.alpha;
    if (modifier_params.use_gradient != 0)
    {
        int param = modifier_params.color_gradient_idx;
        float param_1 = modifier_factor.factor;
        c = gradient_sample(param, param_1).xyz;
        c *= modifier_params.color;
    }
    else
    {
        c = modifier_params.color;
    }
    if (modifier_params.mixing_mode == 0)
    {
        if (modifier_params.use_gradient == 0)
        {
            c *= modifier_factor.factor;
        }
        a *= modifier_factor.factor;
    }
    if (modifier_params.mixing_mode == 1)
    {
        c = mix(vtx.color.xyz, c, vec3(modifier_factor.factor));
        a = mix(vtx.color.w, a, modifier_factor.factor);
    }
    if (modifier_params.mixing_mode == 2)
    {
        c = vtx.color.xyz + (c * modifier_factor.factor);
        a = vtx.color.w + (a * modifier_factor.factor);
    }
    vec4 _1046 = vtx.color;
    vec3 _1052 = mix(_1046.xyz, c, vec3(modifier_params.color_blend));
    vtx.color.x = _1052.x;
    vtx.color.y = _1052.y;
    vtx.color.z = _1052.z;
    vtx.color.w = mix(vtx.color.w, a, modifier_params.alpha_blend);
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    vec3 param = vtx_inputs[0].vCoords;
    vec3 param_1 = vtx_inputs[1].vCoords;
    vec3 param_2 = vtx_inputs[2].vCoords;
    vec3 param_3 = gl_TessCoord;
    vtx_outputs.vCoords = interpolate_bc(param, param_1, param_2, param_3);
    vec3 param_4 = vtx_inputs[0].vNorm;
    vec3 param_5 = vtx_inputs[1].vNorm;
    vec3 param_6 = vtx_inputs[2].vNorm;
    vec3 param_7 = gl_TessCoord;
    vtx_outputs.vNorm = interpolate_bc(param_4, param_5, param_6, param_7);
    vec3 param_8 = vtx_inputs[0].vLocalPos;
    vec3 param_9 = vtx_inputs[1].vLocalPos;
    vec3 param_10 = vtx_inputs[2].vLocalPos;
    vec3 param_11 = gl_TessCoord;
    vtx_outputs.vLocalPos = interpolate_bc(param_8, param_9, param_10, param_11);
    vec4 param_12 = vtx_inputs[0].vColor;
    vec4 param_13 = vtx_inputs[1].vColor;
    vec4 param_14 = vtx_inputs[2].vColor;
    vec3 param_15 = gl_TessCoord;
    vtx_outputs.vColor = interpolate_bc(param_12, param_13, param_14, param_15);
    vec2 param_16 = vtx_inputs[0].vUV0;
    vec2 param_17 = vtx_inputs[1].vUV0;
    vec2 param_18 = vtx_inputs[2].vUV0;
    vec3 param_19 = gl_TessCoord;
    vtx_outputs.vUV0 = interpolate_bc(param_16, param_17, param_18, param_19);
    VertexInput vtx_input;
    vtx_input.id = uint(gl_PrimitiveID);
    vtx_input.pos = vtx_outputs.vLocalPos;
    vtx_input.norm = vtx_outputs.vNorm;
    vtx_input.color = vtx_outputs.vColor;
    vtx_input.uv0 = vtx_outputs.vUV0;
    if (_1215.instance_params.stride > 0)
    {
        uint instance_idx = instanceID[0];
        vec4 inst_m0 = _1233.instance_transform[(instance_idx * uint(_1215.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1233.instance_transform[(instance_idx * uint(_1215.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1233.instance_transform[(instance_idx * uint(_1215.instance_params.stride)) + 2u];
        vec3 param_20 = vtx_input.norm;
        mat4 param_21 = mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_20, param_21));
    }
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_identity();
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_PrimitiveID);
    modifier_factor.id = uint(gl_PrimitiveID);
    modifier_factor.instance_id = instanceID[0];
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    modifier_factor.uv0 = vtx_input.uv0;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1327.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1327.transform_params.mModelInv;
    ModifierFactorNoise_Params _1345;
    _1345.transform_local_to_gizmo = _1340.VM7_params.transform_local_to_gizmo;
    _1345.noise_domain_scale = _1340.VM7_params.noise_domain_scale;
    _1345.modifier_function = _1340.VM7_params.modifier_function;
    _1345.noise_domain_offset = _1340.VM7_params.noise_domain_offset;
    _1345.noise_value_scale = _1340.VM7_params.noise_value_scale;
    _1345.noise_value_offset = _1340.VM7_params.noise_value_offset;
    _1345.influence_scope = _1340.VM7_params.influence_scope;
    _1345._pad0 = _1340.VM7_params._pad0;
    _1345._pad1 = _1340.VM7_params._pad1;
    ModifierFactorNoise_Params param_22 = _1345;
    ModifierFactor param_23 = modifier_factor;
    CoordinateSystemTrasforms param_24 = cs_transforms;
    modifier_factor_noise_voronoi(param_22, param_23, param_24);
    modifier_factor = param_23;
    ModifierFactorNoise_Params _1358;
    _1358.transform_local_to_gizmo = _1354.VM8_params.transform_local_to_gizmo;
    _1358.noise_domain_scale = _1354.VM8_params.noise_domain_scale;
    _1358.modifier_function = _1354.VM8_params.modifier_function;
    _1358.noise_domain_offset = _1354.VM8_params.noise_domain_offset;
    _1358.noise_value_scale = _1354.VM8_params.noise_value_scale;
    _1358.noise_value_offset = _1354.VM8_params.noise_value_offset;
    _1358.influence_scope = _1354.VM8_params.influence_scope;
    _1358._pad0 = _1354.VM8_params._pad0;
    _1358._pad1 = _1354.VM8_params._pad1;
    ModifierFactorNoise_Params param_25 = _1358;
    ModifierFactor param_26 = modifier_factor;
    CoordinateSystemTrasforms param_27 = cs_transforms;
    modifier_factor_noise_default(param_25, param_26, param_27);
    modifier_factor = param_26;
    VertexModifierDisplaceParams _1373;
    _1373.displace_normal = _1368.VM9_params.displace_normal;
    _1373.displace_normal_modifier_factor = _1368.VM9_params.displace_normal_modifier_factor;
    _1373.displace_base = _1368.VM9_params.displace_base;
    _1373.displace_base_modifier_factor = _1368.VM9_params.displace_base_modifier_factor;
    _1373.influence_scope = _1368.VM9_params.influence_scope;
    VertexModifierDisplaceParams param_28 = _1373;
    ModifierFactor param_29 = modifier_factor;
    VertexInput param_30 = vtx_input;
    CoordinateSystemTrasforms param_31 = cs_transforms;
    vertex_modifier_displace_apply(param_28, param_29, param_30, param_31);
    modifier_factor = param_29;
    vtx_input = param_30;
    modifier_factor.position = vtx_input.pos;
    ModifierFactorCurveTransfer_Params _1394;
    _1394.curve_idx = _1389.VM10_params.curve_idx;
    _1394.input_range_min = _1389.VM10_params.input_range_min;
    _1394.input_range_max = _1389.VM10_params.input_range_max;
    _1394.amplitude = _1389.VM10_params.amplitude;
    _1394.base = _1389.VM10_params.base;
    ModifierFactorCurveTransfer_Params param_32 = _1394;
    ModifierFactor param_33 = modifier_factor;
    modifier_factor_curve_transfer(param_32, param_33);
    modifier_factor = param_33;
    VertexModifierColorizeParams _1407;
    _1407.color = _1402.VM11_params.color;
    _1407.alpha = _1402.VM11_params.alpha;
    _1407.use_gradient = _1402.VM11_params.use_gradient;
    _1407.color_blend = _1402.VM11_params.color_blend;
    _1407.alpha_blend = _1402.VM11_params.alpha_blend;
    _1407.color_gradient_idx = _1402.VM11_params.color_gradient_idx;
    _1407.mixing_mode = _1402.VM11_params.mixing_mode;
    VertexModifierColorizeParams param_34 = _1407;
    ModifierFactor param_35 = modifier_factor;
    VertexInput param_36 = vtx_input;
    vertex_modifier_colorize_apply(param_34, param_35, param_36);
    modifier_factor = param_35;
    vtx_input = param_36;
    if (_1215.instance_params.stride > 0)
    {
        uint instance_idx_1 = instanceID[0];
        vec4 inst_m0_1 = _1233.instance_transform[(instance_idx_1 * uint(_1215.instance_params.stride)) + 0u];
        vec4 inst_m1_1 = _1233.instance_transform[(instance_idx_1 * uint(_1215.instance_params.stride)) + 1u];
        vec4 inst_m2_1 = _1233.instance_transform[(instance_idx_1 * uint(_1215.instance_params.stride)) + 2u];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_37 = vtx_input.norm;
        mat4 param_38 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_37, param_38));
        vec2 _1512 = unpackHalf2x16(_1505.instance_color[(instance_idx_1 * 2u) + 0u]);
        vec4 inst_c;
        inst_c.x = _1512.x;
        inst_c.y = _1512.y;
        vec2 _1522 = unpackHalf2x16(_1505.instance_color[(instance_idx_1 * 2u) + 1u]);
        inst_c.z = _1522.x;
        inst_c.w = _1522.y;
        vec4 _1528 = vtx_input.color;
        vec3 _1532 = _1528.xyz * inst_c.xyz;
        vtx_input.color.x = _1532.x;
        vtx_input.color.y = _1532.y;
        vtx_input.color.z = _1532.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_39 = vtx_input.pos;
    mat4 param_40 = _1327.transform_params.mModel;
    vec3 _1552 = vector_transform_by_mat43(param_39, param_40);
    vec3 vPosModel = _1552;
    vec3 param_41 = vPosModel;
    mat4 param_42 = _1327.transform_params.mView;
    vec3 _1559 = vector_transform_by_mat43(param_41, param_42);
    vec3 vPosModelView = _1559;
    vtx_outputs.vLocalPos = vtx_input.pos;
    vtx_outputs.vCoords = vPosModelView;
    vtx_outputs.vCameraRelativeWorldPos = vPosModel - _1327.transform_params.vCameraPosition;
    vtx_outputs.vNorm = vtx_input.norm;
    vec3 param_43 = vtx_input.norm;
    mat4 param_44 = _1327.transform_params.mModelNormal;
    vtx_outputs.vWorldNorm = vector_transform_by_mat33(param_43, param_44);
    vtx_outputs.vColor = vtx_input.color;
    vtx_outputs.vUV0 = vtx_input.uv0;
    vec3 param_45 = vtx_outputs.vCoords;
    mat4 param_46 = _1327.transform_params.mProjection;
    vec4 _1598 = vector_transform_by_mat_projection(param_45, param_46);
    gl_Position = _1598;
}

 