#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(triangles, cw, fractional_odd_spacing) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorCurveTransfer_Params
{
    int curve_idx;
    float input_range_min;
    float input_range_max;
    float amplitude;
    float base;
};

struct VertexModifierNoiseParams
{
    mat4 transform_world_to_local;
    mat4 transform_local_to_world;
    mat4 transform_local;
    mat4 transform_local_inv;
    mat4 transform_parent;
    mat4 transform_parent_inv;
    vec4 noise_phase;
    vec3 noise_scale;
    int falloff_curve_idx;
    vec3 strength;
    int falloff_inverse;
    vec3 position;
    int noise_relative_to_modifier;
    vec3 radius;
    int displacement_mode;
    float noise_value_base;
    int noise_value_absolute;
    int influence_scope;
};

struct VertexInput
{
    uint id;
    vec3 pos;
    vec3 norm;
    vec4 color;
    vec2 uv0;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 4, binding = 3, std140) uniform InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1623;

layout(set = 4, binding = 1, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _1641;

layout(set = 4, binding = 4, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1735;

layout(set = 4, binding = 5, std140) uniform VM0
{
    layout(row_major) ModifierFactorNoise_Params VM0_params;
} _1748;

layout(set = 4, binding = 6, std140) uniform VM1
{
    ModifierFactorCurveTransfer_Params VM1_params;
} _1763;

layout(set = 4, binding = 7, std140) uniform VM2
{
    layout(row_major) VertexModifierNoiseParams VM2_params;
} _1776;

layout(set = 4, binding = 8, std140) uniform VM3
{
    layout(row_major) VertexModifierNoiseParams VM3_params;
} _1793;

layout(set = 4, binding = 2, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _1897;

layout(set = 4, binding = 9) uniform sampler2D s_Curves;

layout(location = 1) out Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_outputs;

layout(location = 1) in Vertex
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
} vtx_inputs[32];

layout(location = 0) in uint instanceID[];

vec3 interpolate_bc(vec3 v1, vec3 v2, vec3 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec4 interpolate_bc(vec4 v1, vec4 v2, vec4 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec2 interpolate_bc(vec2 v1, vec2 v2, vec2 v3, vec3 bc)
{
    return ((v1 * bc.x) + (v2 * bc.y)) + (v3 * bc.z);
}

vec3 vector_transform_by_mat33(vec3 v, mat4 m)
{
    return (m * vec4(v, 0.0)).xyz;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _630 = vector_transform_by_mat43(param, param_1);
        coords = _630;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _637 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _637;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_curve_transfer(ModifierFactorCurveTransfer_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v - modifier_params.input_range_min) / (modifier_params.input_range_max - modifier_params.input_range_min);
    v = clamp(v, 0.0, 1.0);
    int param = modifier_params.curve_idx;
    float param_1 = v;
    v = curve_sample(param, param_1);
    v = (v * modifier_params.amplitude) + modifier_params.base;
    modifier_factor.factor = v;
}

mat4 mat_mul_affine(mat4 ma, mat4 mb)
{
    return ma * mb;
}

float snoise_grad(vec3 v, inout vec3 gradient)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.60000002384185791015625) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    vec4 m2 = m * m;
    vec4 m4 = m2 * m2;
    vec4 pdotx = vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3));
    vec4 temp = (m2 * m) * pdotx;
    gradient = ((((x0 * temp.x) + (x1 * temp.y)) + (x2 * temp.z)) + (x3 * temp.w)) * (-8.0);
    gradient += ((((p0 * m4.x) + (p1 * m4.y)) + (p2 * m4.z)) + (p3 * m4.w));
    gradient *= 42.0;
    return 42.0 * dot(m4, pdotx);
}

void vertex_modifier_noise_apply(VertexModifierNoiseParams params, ModifierFactor modifier_factor, inout VertexInput vtx_input, CoordinateSystemTrasforms cs_transforms)
{
    vec3 modifier_position = vec3(0.0);
    vec3 base_pos = vtx_input.pos;
    mat4 mat_local_to_model = cs_transforms.mat_local_to_model;
    if (params.influence_scope == 1)
    {
        mat4 param = mat_local_to_model;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        mat_local_to_model = mat_mul_affine(param, param_1);
    }
    vec3 param_2 = vtx_input.pos;
    mat4 param_3 = (params.transform_parent_inv * params.transform_local_inv) * mat_local_to_model;
    vec3 _1102 = vector_transform_by_mat43(param_2, param_3);
    vec3 influence_pos = _1102;
    vec3 noise_pos = influence_pos;
    if (params.noise_relative_to_modifier == 0)
    {
        vec3 param_4 = noise_pos;
        mat4 param_5 = params.transform_local;
        vec3 _1115 = vector_transform_by_mat43(param_4, param_5);
        noise_pos = _1115;
    }
    vec3 rel_coords = base_pos;
    vec3 influence_rel_coords = influence_pos;
    float influence = length((influence_rel_coords - modifier_position) / params.radius);
    SPIRV_CROSS_BRANCH
    if (influence <= 1.0)
    {
        if (params.falloff_inverse == 0)
        {
            influence = 1.0 - influence;
        }
        int param_6 = params.falloff_curve_idx;
        float param_7 = influence;
        influence = clamp(curve_sample(param_6, param_7), 0.0, 1.0);
        influence *= modifier_factor.factor;
        vec3 ni = noise_pos * params.noise_scale;
        vec3 n1_grad = vec3(0.0);
        vec3 n2_grad = vec3(0.0);
        vec3 param_8 = (ni + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.01229999959468841552734375);
        vec3 param_9;
        float _1173 = snoise_grad(param_8, param_9);
        n1_grad = param_9;
        float n1 = _1173;
        vec3 param_10 = ((ni * 0.5) + (params.noise_phase.xyz * 0.100000001490116119384765625)) + vec3(params.noise_phase.w * 0.02170000039041042327880859375);
        vec3 param_11;
        float _1191 = snoise_grad(param_10, param_11);
        n2_grad = param_11;
        float n2 = _1191;
        n1_grad *= params.noise_scale;
        n2_grad *= (params.noise_scale * 0.5);
        n2 *= 0.5;
        n2_grad *= 0.5;
        float d = 1.0;
        float n = (params.noise_value_base + n1) + n2;
        float n_dx = (((params.noise_value_base + n1) + (n1_grad.x * d)) + n2) + (n2_grad.x * d);
        float n_dy = (((params.noise_value_base + n1) + (n1_grad.y * d)) + n2) + (n2_grad.y * d);
        float n_dz = (((params.noise_value_base + n1) + (n1_grad.z * d)) + n2) + (n2_grad.z * d);
        if (params.noise_value_absolute != 0)
        {
            n = abs(n);
            n_dx = abs(n_dx);
            n_dy = abs(n_dy);
            n_dz = abs(n_dz);
        }
        vec3 scale = params.strength;
        vec3 local_norm = vtx_input.norm;
        if (params.displacement_mode == 1)
        {
            vec3 param_12 = modifier_position;
            mat4 param_13 = params.transform_local;
            vec3 _1298 = vector_transform_by_mat43(param_12, param_13);
            local_norm = normalize(base_pos - _1298);
        }
        else
        {
            local_norm = normalize(local_norm);
        }
        vec3 new_pos = base_pos + ((local_norm * n) * scale);
        vec3 new_pos_dx = (base_pos + vec3(d, 0.0, 0.0)) + ((local_norm * n_dx) * scale);
        vec3 new_pos_dy = (base_pos + vec3(0.0, d, 0.0)) + ((local_norm * n_dy) * scale);
        vec3 new_pos_dz = (base_pos + vec3(0.0, 0.0, d)) + ((local_norm * n_dz) * scale);
        new_pos = mix(base_pos, new_pos, vec3(influence));
        new_pos_dx = mix(base_pos + vec3(d, 0.0, 0.0), new_pos_dx, vec3(influence));
        new_pos_dy = mix(base_pos + vec3(0.0, d, 0.0), new_pos_dy, vec3(influence));
        new_pos_dz = mix(base_pos + vec3(0.0, 0.0, d), new_pos_dz, vec3(influence));
        vec3 dx = new_pos_dx - new_pos;
        vec3 dy = new_pos_dy - new_pos;
        vec3 dz = new_pos_dz - new_pos;
        vec3 new_norm = vec3(1.0);
        bool _1394 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.y);
        bool _1404;
        if (_1394)
        {
            _1404 = abs(vtx_input.norm.x) >= abs(vtx_input.norm.z);
        }
        else
        {
            _1404 = _1394;
        }
        if (_1404)
        {
            dy = normalize(dy);
            dz = normalize(dz);
            dx = cross(dy, dz);
        }
        else
        {
            bool _1421 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.x);
            bool _1431;
            if (_1421)
            {
                _1431 = abs(vtx_input.norm.y) >= abs(vtx_input.norm.z);
            }
            else
            {
                _1431 = _1421;
            }
            if (_1431)
            {
                dx = normalize(dx);
                dz = normalize(dz);
                dy = cross(dz, dx);
            }
            else
            {
                dx = normalize(dx);
                dy = normalize(dy);
                dz = cross(dx, dy);
            }
        }
        new_norm = mat3(vec3(dx), vec3(dy), vec3(dz)) * vtx_input.norm;
        vtx_input.pos = new_pos;
        vtx_input.norm = normalize(new_norm);
    }
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    vec3 param = vtx_inputs[0].vCoords;
    vec3 param_1 = vtx_inputs[1].vCoords;
    vec3 param_2 = vtx_inputs[2].vCoords;
    vec3 param_3 = gl_TessCoord;
    vtx_outputs.vCoords = interpolate_bc(param, param_1, param_2, param_3);
    vec3 param_4 = vtx_inputs[0].vNorm;
    vec3 param_5 = vtx_inputs[1].vNorm;
    vec3 param_6 = vtx_inputs[2].vNorm;
    vec3 param_7 = gl_TessCoord;
    vtx_outputs.vNorm = interpolate_bc(param_4, param_5, param_6, param_7);
    vec3 param_8 = vtx_inputs[0].vLocalPos;
    vec3 param_9 = vtx_inputs[1].vLocalPos;
    vec3 param_10 = vtx_inputs[2].vLocalPos;
    vec3 param_11 = gl_TessCoord;
    vtx_outputs.vLocalPos = interpolate_bc(param_8, param_9, param_10, param_11);
    vec4 param_12 = vtx_inputs[0].vColor;
    vec4 param_13 = vtx_inputs[1].vColor;
    vec4 param_14 = vtx_inputs[2].vColor;
    vec3 param_15 = gl_TessCoord;
    vtx_outputs.vColor = interpolate_bc(param_12, param_13, param_14, param_15);
    vec2 param_16 = vtx_inputs[0].vUV0;
    vec2 param_17 = vtx_inputs[1].vUV0;
    vec2 param_18 = vtx_inputs[2].vUV0;
    vec3 param_19 = gl_TessCoord;
    vtx_outputs.vUV0 = interpolate_bc(param_16, param_17, param_18, param_19);
    VertexInput vtx_input;
    vtx_input.id = uint(gl_PrimitiveID);
    vtx_input.pos = vtx_outputs.vLocalPos;
    vtx_input.norm = vtx_outputs.vNorm;
    vtx_input.color = vtx_outputs.vColor;
    vtx_input.uv0 = vtx_outputs.vUV0;
    if (_1623.instance_params.stride > 0)
    {
        uint instance_idx = instanceID[0];
        vec4 inst_m0 = _1641.instance_transform[(instance_idx * uint(_1623.instance_params.stride)) + 0u];
        vec4 inst_m1 = _1641.instance_transform[(instance_idx * uint(_1623.instance_params.stride)) + 1u];
        vec4 inst_m2 = _1641.instance_transform[(instance_idx * uint(_1623.instance_params.stride)) + 2u];
        vec3 param_20 = vtx_input.norm;
        mat4 param_21 = mat4(vec4(inst_m0), vec4(inst_m1), vec4(inst_m2), vec4(0.0, 0.0, 0.0, 1.0));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_20, param_21));
    }
    mat4 mat_instance_model = mat_identity();
    mat4 mat_instance_model_inv = mat_identity();
    VertexInput vtx_modifier_input_base = vtx_input;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = uint(gl_PrimitiveID);
    modifier_factor.id = uint(gl_PrimitiveID);
    modifier_factor.instance_id = instanceID[0];
    modifier_factor.position = vtx_input.pos;
    modifier_factor.normal = vtx_input.norm;
    modifier_factor.color = vtx_input.color;
    modifier_factor.uv0 = vtx_input.uv0;
    modifier_factor.is_spawned = false;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1735.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_instance_model;
    cs_transforms.mat_local_to_model_inv = _1735.transform_params.mModelInv;
    ModifierFactorNoise_Params _1753;
    _1753.transform_local_to_gizmo = _1748.VM0_params.transform_local_to_gizmo;
    _1753.noise_domain_scale = _1748.VM0_params.noise_domain_scale;
    _1753.modifier_function = _1748.VM0_params.modifier_function;
    _1753.noise_domain_offset = _1748.VM0_params.noise_domain_offset;
    _1753.noise_value_scale = _1748.VM0_params.noise_value_scale;
    _1753.noise_value_offset = _1748.VM0_params.noise_value_offset;
    _1753.influence_scope = _1748.VM0_params.influence_scope;
    _1753._pad0 = _1748.VM0_params._pad0;
    _1753._pad1 = _1748.VM0_params._pad1;
    ModifierFactorNoise_Params param_22 = _1753;
    ModifierFactor param_23 = modifier_factor;
    CoordinateSystemTrasforms param_24 = cs_transforms;
    modifier_factor_noise_default(param_22, param_23, param_24);
    modifier_factor = param_23;
    ModifierFactorCurveTransfer_Params _1768;
    _1768.curve_idx = _1763.VM1_params.curve_idx;
    _1768.input_range_min = _1763.VM1_params.input_range_min;
    _1768.input_range_max = _1763.VM1_params.input_range_max;
    _1768.amplitude = _1763.VM1_params.amplitude;
    _1768.base = _1763.VM1_params.base;
    ModifierFactorCurveTransfer_Params param_25 = _1768;
    ModifierFactor param_26 = modifier_factor;
    modifier_factor_curve_transfer(param_25, param_26);
    modifier_factor = param_26;
    VertexModifierNoiseParams _1781;
    _1781.transform_world_to_local = _1776.VM2_params.transform_world_to_local;
    _1781.transform_local_to_world = _1776.VM2_params.transform_local_to_world;
    _1781.transform_local = _1776.VM2_params.transform_local;
    _1781.transform_local_inv = _1776.VM2_params.transform_local_inv;
    _1781.transform_parent = _1776.VM2_params.transform_parent;
    _1781.transform_parent_inv = _1776.VM2_params.transform_parent_inv;
    _1781.noise_phase = _1776.VM2_params.noise_phase;
    _1781.noise_scale = _1776.VM2_params.noise_scale;
    _1781.falloff_curve_idx = _1776.VM2_params.falloff_curve_idx;
    _1781.strength = _1776.VM2_params.strength;
    _1781.falloff_inverse = _1776.VM2_params.falloff_inverse;
    _1781.position = _1776.VM2_params.position;
    _1781.noise_relative_to_modifier = _1776.VM2_params.noise_relative_to_modifier;
    _1781.radius = _1776.VM2_params.radius;
    _1781.displacement_mode = _1776.VM2_params.displacement_mode;
    _1781.noise_value_base = _1776.VM2_params.noise_value_base;
    _1781.noise_value_absolute = _1776.VM2_params.noise_value_absolute;
    _1781.influence_scope = _1776.VM2_params.influence_scope;
    VertexModifierNoiseParams param_27 = _1781;
    ModifierFactor param_28 = modifier_factor;
    VertexInput param_29 = vtx_input;
    CoordinateSystemTrasforms param_30 = cs_transforms;
    vertex_modifier_noise_apply(param_27, param_28, param_29, param_30);
    modifier_factor = param_28;
    vtx_input = param_29;
    VertexModifierNoiseParams _1797;
    _1797.transform_world_to_local = _1793.VM3_params.transform_world_to_local;
    _1797.transform_local_to_world = _1793.VM3_params.transform_local_to_world;
    _1797.transform_local = _1793.VM3_params.transform_local;
    _1797.transform_local_inv = _1793.VM3_params.transform_local_inv;
    _1797.transform_parent = _1793.VM3_params.transform_parent;
    _1797.transform_parent_inv = _1793.VM3_params.transform_parent_inv;
    _1797.noise_phase = _1793.VM3_params.noise_phase;
    _1797.noise_scale = _1793.VM3_params.noise_scale;
    _1797.falloff_curve_idx = _1793.VM3_params.falloff_curve_idx;
    _1797.strength = _1793.VM3_params.strength;
    _1797.falloff_inverse = _1793.VM3_params.falloff_inverse;
    _1797.position = _1793.VM3_params.position;
    _1797.noise_relative_to_modifier = _1793.VM3_params.noise_relative_to_modifier;
    _1797.radius = _1793.VM3_params.radius;
    _1797.displacement_mode = _1793.VM3_params.displacement_mode;
    _1797.noise_value_base = _1793.VM3_params.noise_value_base;
    _1797.noise_value_absolute = _1793.VM3_params.noise_value_absolute;
    _1797.influence_scope = _1793.VM3_params.influence_scope;
    VertexModifierNoiseParams param_31 = _1797;
    ModifierFactor param_32 = modifier_factor;
    VertexInput param_33 = vtx_input;
    CoordinateSystemTrasforms param_34 = cs_transforms;
    vertex_modifier_noise_apply(param_31, param_32, param_33, param_34);
    modifier_factor = param_32;
    vtx_input = param_33;
    if (_1623.instance_params.stride > 0)
    {
        uint instance_idx_1 = instanceID[0];
        vec4 inst_m0_1 = _1641.instance_transform[(instance_idx_1 * uint(_1623.instance_params.stride)) + 0u];
        vec4 inst_m1_1 = _1641.instance_transform[(instance_idx_1 * uint(_1623.instance_params.stride)) + 1u];
        vec4 inst_m2_1 = _1641.instance_transform[(instance_idx_1 * uint(_1623.instance_params.stride)) + 2u];
        vec4 v = vec4(vtx_input.pos, 1.0);
        vtx_input.pos.x = dot(inst_m0_1, v);
        vtx_input.pos.y = dot(inst_m1_1, v);
        vtx_input.pos.z = dot(inst_m2_1, v);
        vec3 param_35 = vtx_input.norm;
        mat4 param_36 = transpose(mat4(vec4(inst_m0_1), vec4(inst_m1_1), vec4(inst_m2_1), vec4(0.0, 0.0, 0.0, 1.0)));
        vtx_input.norm = normalize(vector_transform_by_mat33(param_35, param_36));
        vec2 _1904 = unpackHalf2x16(_1897.instance_color[(instance_idx_1 * 2u) + 0u]);
        vec4 inst_c;
        inst_c.x = _1904.x;
        inst_c.y = _1904.y;
        vec2 _1914 = unpackHalf2x16(_1897.instance_color[(instance_idx_1 * 2u) + 1u]);
        inst_c.z = _1914.x;
        inst_c.w = _1914.y;
        vec4 _1920 = vtx_input.color;
        vec3 _1924 = _1920.xyz * inst_c.xyz;
        vtx_input.color.x = _1924.x;
        vtx_input.color.y = _1924.y;
        vtx_input.color.z = _1924.z;
        vtx_input.color.w *= inst_c.w;
    }
    vec3 param_37 = vtx_input.pos;
    mat4 param_38 = _1735.transform_params.mModel;
    vec3 _1944 = vector_transform_by_mat43(param_37, param_38);
    vec3 vPosModel = _1944;
    vec3 param_39 = vPosModel;
    mat4 param_40 = _1735.transform_params.mView;
    vec3 _1951 = vector_transform_by_mat43(param_39, param_40);
    vec3 vPosModelView = _1951;
    vtx_outputs.vLocalPos = vtx_input.pos;
    vtx_outputs.vCoords = vPosModelView;
    vtx_outputs.vCameraRelativeWorldPos = vPosModel - _1735.transform_params.vCameraPosition;
    vtx_outputs.vNorm = vtx_input.norm;
    vec3 param_41 = vtx_input.norm;
    mat4 param_42 = _1735.transform_params.mModelNormal;
    vtx_outputs.vWorldNorm = vector_transform_by_mat33(param_41, param_42);
    vtx_outputs.vColor = vtx_input.color;
    vtx_outputs.vUV0 = vtx_input.uv0;
    vec3 param_43 = vtx_outputs.vCoords;
    mat4 param_44 = _1735.transform_params.mProjection;
    vec4 _1990 = vector_transform_by_mat_projection(param_43, param_44);
    gl_Position = _1990;
}

 