#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 64, local_size_y = 1, local_size_z = 1) in;

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorMulAdd_Params
{
    float multiply_value;
    float add_value;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorRangeRemap_Params
{
    float input_min;
    float input_max;
    float output_min;
    float output_max;
    int min_out_of_bounds_mode;
    int max_out_of_bounds_mode;
};

struct ModifierFactorDistanceRadial_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_repeat_x;
    int domain_repeat_y;
    int domain_repeat_z;
    int influence_scope;
    int modifier_function;
};

struct ModifierFactorFrustumCull_Params
{
    mat4 transform_local_to_gizmo;
    mat4 transform_world_to_view;
    mat4 transform_projection;
    float instance_radius;
};

struct InstanceModifierRandomizerV2_Params
{
    int replace_previous_rotation_scale;
    int randomness_seed;
    int replace_previous_position;
    int randomization_input;
    vec3 position_modifier_base;
    float position_modifier_base_modifier_factor;
    vec3 position_modifier_range;
    float position_modifier_range_modifier_factor;
    vec3 rotation_modifier_base;
    float rotation_modifier_base_modifier_factor;
    vec3 rotation_modifier_range;
    float rotation_modifier_range_modifier_factor;
    vec3 scale_modifier_base;
    float scale_modifier_base_modifier_factor;
    vec3 scale_modifier_range;
    float scale_modifier_range_modifier_factor;
};

struct Instance
{
    vec4 m0;
    vec4 m1;
    vec4 m2;
    vec4 c;
    uint hash;
    uint flipbook_card;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct InstancingGeneratorParams
{
    uvec3 resolution;
    vec3 bbox_position;
    vec3 bbox_dimensions;
    vec3 instance_scale_base;
    vec3 instance_scale_factor;
    float function_scale;
    float function_threshold;
    float orientation_blend;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer InstanceParamsBuffer
{
    InstanceParams instance_params;
} _1667;

layout(set = 0, binding = 6, scalar) uniform InstancingGeneratorParamsBuffer
{
    InstancingGeneratorParams instancing_generator_params;
} _1684;

layout(set = 0, binding = 7, std140) uniform VM0
{
    ModifierFactorMulAdd_Params VM0_params;
} _1758;

layout(set = 0, binding = 8, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1771;

layout(set = 0, binding = 9, std140) uniform VM2
{
    layout(row_major) ModifierFactorDistancePlane_Params VM2_params;
} _1786;

layout(set = 0, binding = 10, std140) uniform VM3
{
    ModifierFactorRangeRemap_Params VM3_params;
} _1801;

layout(set = 0, binding = 11, std140) uniform VM4
{
    layout(row_major) ModifierFactorDistanceRadial_Params VM4_params;
} _1814;

layout(set = 0, binding = 12, std140) uniform VM5
{
    layout(row_major) ModifierFactorFrustumCull_Params VM5_params;
} _1829;

layout(set = 0, binding = 13, std140) uniform VM6
{
    InstanceModifierRandomizerV2_Params VM6_params;
} _2212;

layout(set = 0, binding = 2, std430) buffer InstanceTransformBuffer
{
    vec4 instance_transform[];
} _2268;

layout(set = 0, binding = 3, std430) buffer InstanceColorBuffer
{
    uint instance_color[];
} _2291;

layout(set = 0, binding = 4, std430) buffer InstanceHashBuffer
{
    uint instance_hash[];
} _2312;

layout(set = 0, binding = 5, std430) buffer InstanceFlipbookCardBuffer
{
    uint instance_flipbook_card[];
} _2320;

layout(set = 0, binding = 14) uniform sampler2D s_Curves;

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void modifier_factor_mul_add(ModifierFactorMulAdd_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    v = (v * modifier_params.multiply_value) + modifier_params.add_value;
    modifier_factor.factor = v;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 _permute(vec4 x)
{
    vec4 xm = mod(x, vec4(289.0));
    return mod(((xm * 34.0) + vec4(10.0)) * xm, vec4(289.0));
}

float psrdnoise(vec3 x, vec3 period, float alpha, out vec3 gradient)
{
    vec3 uvw = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * x;
    vec3 i0 = floor(uvw);
    vec3 f0 = fract(uvw);
    vec3 g_ = step(f0.xyx, f0.yzz);
    vec3 l_ = vec3(1.0) - g_;
    vec3 g = vec3(l_.z, g_.xy);
    vec3 l = vec3(l_.xy, g_.z);
    vec3 o1 = min(g, l);
    vec3 o2 = max(g, l);
    vec3 i1 = i0 + o1;
    vec3 i2 = i0 + o2;
    vec3 i3 = i0 + vec3(1.0);
    vec3 v0 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i0;
    vec3 v1 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i1;
    vec3 v2 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i2;
    vec3 v3 = mat3(vec3(-0.5, 0.5, 0.5), vec3(0.5, -0.5, 0.5), vec3(0.5, 0.5, -0.5)) * i3;
    vec3 x0 = x - v0;
    vec3 x1 = x - v1;
    vec3 x2 = x - v2;
    vec3 x3 = x - v3;
    if (any(greaterThan(period, vec3(0.0))))
    {
        vec4 vx = vec4(v0.x, v1.x, v2.x, v3.x);
        vec4 vy = vec4(v0.y, v1.y, v2.y, v3.y);
        vec4 vz = vec4(v0.z, v1.z, v2.z, v3.z);
        if (period.x > 0.0)
        {
            vx = mod(vx, vec4(period.x));
        }
        if (period.y > 0.0)
        {
            vy = mod(vy, vec4(period.y));
        }
        if (period.z > 0.0)
        {
            vz = mod(vz, vec4(period.z));
        }
        i0 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.x, vy.x, vz.x);
        i1 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.y, vy.y, vz.y);
        i2 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.z, vy.z, vz.z);
        i3 = mat3(vec3(0.0, 1.0, 1.0), vec3(1.0, 0.0, 1.0), vec3(1.0, 1.0, 0.0)) * vec3(vx.w, vy.w, vz.w);
        i0 = floor(i0 + vec3(0.5));
        i1 = floor(i1 + vec3(0.5));
        i2 = floor(i2 + vec3(0.5));
        i3 = floor(i3 + vec3(0.5));
    }
    vec4 param = vec4(i0.z, i1.z, i2.z, i3.z);
    vec4 param_1 = _permute(param) + vec4(i0.y, i1.y, i2.y, i3.y);
    vec4 param_2 = _permute(param_1) + vec4(i0.x, i1.x, i2.x, i3.x);
    vec4 hash = _permute(param_2);
    vec4 theta = hash * 3.883222103118896484375;
    vec4 sz = (hash * (-0.006920414976775646209716796875)) + vec4(0.996539771556854248046875);
    vec4 psi = hash * 0.10870562493801116943359375;
    vec4 Ct = cos(theta);
    vec4 St = sin(theta);
    vec4 sz_prime = sqrt(vec4(1.0) - (sz * sz));
    vec4 gx;
    vec4 gy;
    vec4 gz;
    if (alpha != 0.0)
    {
        vec4 Sp = sin(psi);
        vec4 Cp = cos(psi);
        vec4 px = Ct * sz_prime;
        vec4 py = St * sz_prime;
        vec4 pz = sz;
        vec4 Ctp = (St * Sp) - (Ct * Cp);
        vec4 qx = mix(Ctp * St, Sp, sz);
        vec4 qy = mix((-Ctp) * Ct, Cp, sz);
        vec4 qz = -((py * Cp) + (px * Sp));
        vec4 Sa = vec4(sin(alpha));
        vec4 Ca = vec4(cos(alpha));
        gx = (Ca * px) + (Sa * qx);
        gy = (Ca * py) + (Sa * qy);
        gz = (Ca * pz) + (Sa * qz);
    }
    else
    {
        gx = Ct * sz_prime;
        gy = St * sz_prime;
        gz = sz;
    }
    vec3 g0 = vec3(gx.x, gy.x, gz.x);
    vec3 g1 = vec3(gx.y, gy.y, gz.y);
    vec3 g2 = vec3(gx.z, gy.z, gz.z);
    vec3 g3 = vec3(gx.w, gy.w, gz.w);
    vec4 w = vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3));
    w = max(w, vec4(0.0));
    vec4 w2 = w * w;
    vec4 w3 = w2 * w;
    vec4 gdotx = vec4(dot(g0, x0), dot(g1, x1), dot(g2, x2), dot(g3, x3));
    float n = dot(w3, gdotx);
    vec4 dw = (w2 * (-6.0)) * gdotx;
    vec3 dn0 = (g0 * w3.x) + (x0 * dw.x);
    vec3 dn1 = (g1 * w3.y) + (x1 * dw.y);
    vec3 dn2 = (g2 * w3.z) + (x2 * dw.z);
    vec3 dn3 = (g3 * w3.w) + (x3 * dw.w);
    gradient = (((dn0 + dn1) + dn2) + dn3) * 39.5;
    return 39.5 * n;
}

float modifier_factor_noise_snoise_simplex2(vec3 v)
{
    vec3 param = v;
    vec3 param_1 = vec3(0.0);
    float param_2 = 0.0;
    vec3 param_3;
    float _876 = psrdnoise(param, param_1, param_2, param_3);
    vec3 gradient = param_3;
    float n = _876;
    return n;
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_simplex2(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _894 = vector_transform_by_mat43(param, param_1);
        coords = _894;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _901 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _901;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = modifier_factor_noise_snoise_simplex2(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _961 = vector_transform_by_mat43(param, param_1);
        coords = _961;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _968 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _968;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

void modifier_factor_range_remap(ModifierFactorRangeRemap_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    bool set_const = false;
    float set_const_value = 0.0;
    float t = (v - modifier_params.input_min) / (modifier_params.input_max - modifier_params.input_min);
    if (t < 0.0)
    {
        if (modifier_params.min_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 0)
        {
            t = 0.0;
        }
        if (modifier_params.min_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.min_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    if (t > 1.0)
    {
        if (modifier_params.max_out_of_bounds_mode == 3)
        {
            set_const = true;
            set_const_value = 0.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 4)
        {
            set_const = true;
            set_const_value = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 0)
        {
            t = 1.0;
        }
        if (modifier_params.max_out_of_bounds_mode == 1)
        {
            t = fract(t);
        }
        if (modifier_params.max_out_of_bounds_mode == 2)
        {
            set_const = true;
            set_const_value = v;
        }
    }
    v = modifier_params.output_min + (t * (modifier_params.output_max - modifier_params.output_min));
    if (set_const)
    {
        v = set_const_value;
    }
    modifier_factor.factor = v;
}

void modifier_factor_distance_radial(ModifierFactorDistanceRadial_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_factor.has_world_position == false)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_model;
        vec3 _1125 = vector_transform_by_mat43(param, param_1);
        coords = _1125;
        if (modifier_params.influence_scope == 1)
        {
            vec3 param_2 = coords;
            mat4 param_3 = cs_transforms.mat_local_to_instance;
            vec3 _1136 = vector_transform_by_mat43(param_2, param_3);
            coords = _1136;
        }
    }
    else
    {
        coords = modifier_factor.world_position;
    }
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1146 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1146;
    if (modifier_params.domain_repeat_x != 0)
    {
        rel_coords.x = (fract(rel_coords.x * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_y != 0)
    {
        rel_coords.y = (fract(rel_coords.y * 2.0) - 0.5) * 2.0;
    }
    if (modifier_params.domain_repeat_z != 0)
    {
        rel_coords.z = (fract(rel_coords.z * 2.0) - 0.5) * 2.0;
    }
    float influence = length(rel_coords);
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_6 = modifier_params.falloff_curve_idx;
    float param_7 = influence;
    influence = curve_sample(param_6, param_7);
    float v = influence;
    ModifierFactor param_8 = modifier_factor;
    uint param_9 = uint(modifier_params.modifier_function);
    float param_10 = v;
    modifier_process_modifier_factor(param_8, param_9, param_10);
    modifier_factor = param_8;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void modifier_factor_frustum_cull(ModifierFactorFrustumCull_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    vec3 param = coords;
    mat4 param_1 = cs_transforms.mat_local_to_model;
    vec3 _1223 = vector_transform_by_mat43(param, param_1);
    coords = _1223;
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_world_to_view;
    vec3 _1229 = vector_transform_by_mat43(param_2, param_3);
    coords = _1229;
    vec3 param_4 = coords;
    mat4 param_5 = modifier_params.transform_local_to_gizmo;
    vec3 _1236 = vector_transform_by_mat43(param_4, param_5);
    vec3 rel_coords = _1236;
    vec3 param_6 = rel_coords;
    mat4 param_7 = modifier_params.transform_projection;
    vec4 _1243 = vector_transform_by_mat_projection(param_6, param_7);
    vec4 projected = _1243;
    float margin = 0.100000001490116119384765625;
    vec4 _1248 = projected;
    vec2 _1250 = _1248.xy * (1.0 - margin);
    projected.x = _1250.x;
    projected.y = _1250.y;
    bool _1260 = projected.x < (-projected.w);
    bool _1269;
    if (!_1260)
    {
        _1269 = projected.x > projected.w;
    }
    else
    {
        _1269 = _1260;
    }
    bool _1279;
    if (!_1269)
    {
        _1279 = projected.y < (-projected.w);
    }
    else
    {
        _1279 = _1269;
    }
    bool _1288;
    if (!_1279)
    {
        _1288 = projected.y > projected.w;
    }
    else
    {
        _1288 = _1279;
    }
    bool _1297;
    if (!_1288)
    {
        _1297 = projected.z < (-margin);
    }
    else
    {
        _1297 = _1288;
    }
    if (_1297)
    {
        modifier_factor.is_discarded = true;
    }
}

uint hash(inout uint x)
{
    x += (x << 10u);
    x ^= (x >> 6u);
    x += (x << 3u);
    x ^= (x >> 11u);
    x += (x << 15u);
    return x;
}

uint hash(uvec3 v)
{
    uint param = v.y;
    uint _298 = hash(param);
    uint param_1 = v.z;
    uint _303 = hash(param_1);
    uint param_2 = (v.x ^ _298) ^ _303;
    uint _306 = hash(param_2);
    return _306;
}

float floatConstruct(inout uint m)
{
    m &= 8388607u;
    m |= 1065353216u;
    float f = uintBitsToFloat(m);
    return f - 1.0;
}

float random(vec3 v)
{
    uvec3 param = floatBitsToUint(v);
    uint param_1 = hash(param);
    float _335 = floatConstruct(param_1);
    return _335;
}

float random(float x)
{
    uint param = floatBitsToUint(x);
    uint _325 = hash(param);
    uint param_1 = _325;
    float _327 = floatConstruct(param_1);
    return _327;
}

void instance_modifier_randomizer_v2(InstanceModifierRandomizerV2_Params modifier_params, ModifierFactor modifier_factor, inout Instance instance, uint id)
{
    float influence = modifier_factor.factor;
    float fid = float(id);
    if (modifier_params.randomization_input == 0)
    {
        fid = float(id);
    }
    if (modifier_params.randomization_input == 1)
    {
        vec3 param = vec3(instance.m0.w, instance.m1.w, instance.m2.w);
        fid = random(param);
    }
    if (modifier_params.randomization_input == 2)
    {
        float param_1 = uintBitsToFloat(instance.hash);
        fid = random(param_1);
    }
    float param_2 = fid;
    vec3 angles;
    angles.x = random(param_2);
    float param_3 = fid + 123.3000030517578125;
    angles.y = random(param_3);
    float param_4 = (fid * 2.131700038909912109375) + 13.4137096405029296875;
    angles.z = random(param_4);
    if (modifier_params.randomization_input == 3)
    {
        angles = vec3(1.0);
    }
    angles = (modifier_params.rotation_modifier_base * (modifier_params.rotation_modifier_base_modifier_factor * influence)) + ((angles * modifier_params.rotation_modifier_range) * (modifier_params.rotation_modifier_range_modifier_factor * influence));
    float param_5 = fid;
    vec3 scales;
    scales.x = random(param_5);
    scales.y = scales.x;
    scales.z = scales.x;
    if (modifier_params.randomization_input == 3)
    {
        scales = vec3(1.0);
    }
    scales = mix(vec3(1.0), modifier_params.scale_modifier_base, vec3(modifier_params.scale_modifier_base_modifier_factor * influence)) + ((scales * modifier_params.scale_modifier_range) * (modifier_params.scale_modifier_range_modifier_factor * influence));
    float param_6 = fid;
    vec3 translations;
    translations.x = random(param_6);
    float param_7 = fid + 123.73169708251953125;
    translations.y = random(param_7);
    float param_8 = (fid * 2.131700038909912109375) + 13.71000003814697265625;
    translations.z = random(param_8);
    if (modifier_params.randomization_input == 3)
    {
        translations = vec3(1.0);
    }
    else
    {
        translations = normalize(translations);
    }
    translations = (modifier_params.position_modifier_base * (modifier_params.position_modifier_base_modifier_factor * influence)) + ((translations * modifier_params.position_modifier_range) * (modifier_params.position_modifier_range_modifier_factor * influence));
    float cosb = cos(angles.z);
    float sinb = sin(angles.z);
    float cosp = cos(angles.x);
    float sinp = sin(angles.x);
    float _cosh = cos(angles.y);
    float _sinh = sin(angles.y);
    vec3 mx;
    mx.x = (_cosh * cosb) + ((_sinh * sinp) * sinb);
    mx.y = ((_sinh * sinp) * cosb) - (_cosh * sinb);
    mx.z = _sinh * cosp;
    vec3 my;
    my.x = cosp * sinb;
    my.y = cosp * cosb;
    my.z = -sinp;
    vec3 mz;
    mz.x = ((_cosh * sinp) * sinb) - (_sinh * cosb);
    mz.y = (_sinh * sinb) + ((_cosh * sinp) * cosb);
    mz.z = _cosh * cosp;
    mat4 tm_rot;
    tm_rot[0] = vec4(mx.x, my.x, mz.x, translations.x);
    tm_rot[1] = vec4(mx.y, my.y, mz.y, translations.y);
    tm_rot[2] = vec4(mx.z, my.z, mz.z, translations.z);
    tm_rot[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 tm_sc;
    tm_sc[0] = vec4(scales.x, 0.0, 0.0, 0.0);
    tm_sc[1] = vec4(0.0, scales.y, 0.0, 0.0);
    tm_sc[2] = vec4(0.0, 0.0, scales.z, 0.0);
    tm_sc[3] = vec4(0.0, 0.0, 0.0, 1.0);
    mat4 m;
    m[0] = instance.m0;
    m[1] = instance.m1;
    m[2] = instance.m2;
    m[3] = vec4(0.0, 0.0, 0.0, 1.0);
    if (modifier_params.replace_previous_rotation_scale == 0)
    {
        m = (tm_sc * tm_rot) * m;
    }
    else
    {
        mat4 lm = tm_sc * tm_rot;
        m = (tm_sc * tm_rot) * m;
        m[0].x = lm[0].xyz.x;
        m[0].y = lm[0].xyz.y;
        m[0].z = lm[0].xyz.z;
        m[1].x = lm[1].xyz.x;
        m[1].y = lm[1].xyz.y;
        m[1].z = lm[1].xyz.z;
        m[2].x = lm[2].xyz.x;
        m[2].y = lm[2].xyz.y;
        m[2].z = lm[2].xyz.z;
    }
    instance.m0 = m[0];
    instance.m1 = m[1];
    instance.m2 = m[2];
}

void main()
{
    uint id = gl_GlobalInvocationID.x;
    if (_1667.instance_params.instance_count >= _1667.instance_params.buffer_capacity)
    {
        return;
    }
    uint instance_position_id = id;
    uvec3 instance_position_int;
    instance_position_int.z = instance_position_id / (_1684.instancing_generator_params.resolution.x * _1684.instancing_generator_params.resolution.y);
    instance_position_id -= (instance_position_int.z * (_1684.instancing_generator_params.resolution.x * _1684.instancing_generator_params.resolution.y));
    instance_position_int.y = instance_position_id / _1684.instancing_generator_params.resolution.x;
    instance_position_id -= (instance_position_int.y * _1684.instancing_generator_params.resolution.x);
    instance_position_int.x = instance_position_id;
    vec3 instancing_bbox_origin = _1684.instancing_generator_params.bbox_position;
    vec3 instancing_bbox_size = _1684.instancing_generator_params.bbox_dimensions;
    vec3 instance_position = ((vec3(instance_position_int) / vec3(_1684.instancing_generator_params.resolution)) * instancing_bbox_size) + instancing_bbox_origin;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = id;
    modifier_factor.id = id;
    modifier_factor.instance_id = id;
    modifier_factor.position = instance_position;
    modifier_factor.is_spawned = true;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = mat_identity();
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = mat_identity();
    ModifierFactorMulAdd_Params _1763;
    _1763.multiply_value = _1758.VM0_params.multiply_value;
    _1763.add_value = _1758.VM0_params.add_value;
    ModifierFactorMulAdd_Params param = _1763;
    ModifierFactor param_1 = modifier_factor;
    modifier_factor_mul_add(param, param_1);
    modifier_factor = param_1;
    ModifierFactorNoise_Params _1776;
    _1776.transform_local_to_gizmo = _1771.VM1_params.transform_local_to_gizmo;
    _1776.noise_domain_scale = _1771.VM1_params.noise_domain_scale;
    _1776.modifier_function = _1771.VM1_params.modifier_function;
    _1776.noise_domain_offset = _1771.VM1_params.noise_domain_offset;
    _1776.noise_value_scale = _1771.VM1_params.noise_value_scale;
    _1776.noise_value_offset = _1771.VM1_params.noise_value_offset;
    _1776.influence_scope = _1771.VM1_params.influence_scope;
    _1776._pad0 = _1771.VM1_params._pad0;
    _1776._pad1 = _1771.VM1_params._pad1;
    ModifierFactorNoise_Params param_2 = _1776;
    ModifierFactor param_3 = modifier_factor;
    CoordinateSystemTrasforms param_4 = cs_transforms;
    modifier_factor_noise_simplex2(param_2, param_3, param_4);
    modifier_factor = param_3;
    ModifierFactorDistancePlane_Params _1791;
    _1791.transform_local_to_gizmo = _1786.VM2_params.transform_local_to_gizmo;
    _1791.falloff_curve_idx = _1786.VM2_params.falloff_curve_idx;
    _1791.falloff_inverse = _1786.VM2_params.falloff_inverse;
    _1791.domain_mirror = _1786.VM2_params.domain_mirror;
    _1791.domain_repeat = _1786.VM2_params.domain_repeat;
    _1791.influence_scope = _1786.VM2_params.influence_scope;
    _1791.modifier_function = _1786.VM2_params.modifier_function;
    ModifierFactorDistancePlane_Params param_5 = _1791;
    ModifierFactor param_6 = modifier_factor;
    CoordinateSystemTrasforms param_7 = cs_transforms;
    modifier_factor_distance_plane(param_5, param_6, param_7);
    modifier_factor = param_6;
    ModifierFactorRangeRemap_Params _1806;
    _1806.input_min = _1801.VM3_params.input_min;
    _1806.input_max = _1801.VM3_params.input_max;
    _1806.output_min = _1801.VM3_params.output_min;
    _1806.output_max = _1801.VM3_params.output_max;
    _1806.min_out_of_bounds_mode = _1801.VM3_params.min_out_of_bounds_mode;
    _1806.max_out_of_bounds_mode = _1801.VM3_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_8 = _1806;
    ModifierFactor param_9 = modifier_factor;
    modifier_factor_range_remap(param_8, param_9);
    modifier_factor = param_9;
    ModifierFactorDistanceRadial_Params _1819;
    _1819.transform_local_to_gizmo = _1814.VM4_params.transform_local_to_gizmo;
    _1819.falloff_curve_idx = _1814.VM4_params.falloff_curve_idx;
    _1819.falloff_inverse = _1814.VM4_params.falloff_inverse;
    _1819.domain_repeat_x = _1814.VM4_params.domain_repeat_x;
    _1819.domain_repeat_y = _1814.VM4_params.domain_repeat_y;
    _1819.domain_repeat_z = _1814.VM4_params.domain_repeat_z;
    _1819.influence_scope = _1814.VM4_params.influence_scope;
    _1819.modifier_function = _1814.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_10 = _1819;
    ModifierFactor param_11 = modifier_factor;
    CoordinateSystemTrasforms param_12 = cs_transforms;
    modifier_factor_distance_radial(param_10, param_11, param_12);
    modifier_factor = param_11;
    ModifierFactorFrustumCull_Params _1834;
    _1834.transform_local_to_gizmo = _1829.VM5_params.transform_local_to_gizmo;
    _1834.transform_world_to_view = _1829.VM5_params.transform_world_to_view;
    _1834.transform_projection = _1829.VM5_params.transform_projection;
    _1834.instance_radius = _1829.VM5_params.instance_radius;
    ModifierFactorFrustumCull_Params param_13 = _1834;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_frustum_cull(param_13, param_14, param_15);
    modifier_factor = param_14;
    float mf = (modifier_factor.factor * _1684.instancing_generator_params.function_scale) - _1684.instancing_generator_params.function_threshold;
    if ((mf <= 0.0) || modifier_factor.is_discarded)
    {
        return;
    }
    vec3 instance_scale = _1684.instancing_generator_params.instance_scale_base + (_1684.instancing_generator_params.instance_scale_factor * mf);
    float modifier_factor_v = modifier_factor.factor;
    float modifier_factor_v_dx = modifier_factor.factor;
    float modifier_factor_v_dy = modifier_factor.factor;
    float modifier_factor_v_dz = modifier_factor.factor;
    ModifierFactor modifier_factor_1 = modifier_factor_defaults();
    modifier_factor_1.factor = 1.0;
    modifier_factor_1.hash = id;
    modifier_factor_1.id = id;
    modifier_factor_1.instance_id = id;
    modifier_factor_1.position = instance_position + vec3(instancing_bbox_size.x / float(_1684.instancing_generator_params.resolution.x), 0.0, 0.0);
    modifier_factor_1.is_spawned = true;
    ModifierFactorMulAdd_Params _1902;
    _1902.multiply_value = _1758.VM0_params.multiply_value;
    _1902.add_value = _1758.VM0_params.add_value;
    ModifierFactorMulAdd_Params param_16 = _1902;
    ModifierFactor param_17 = modifier_factor_1;
    modifier_factor_mul_add(param_16, param_17);
    modifier_factor_1 = param_17;
    ModifierFactorNoise_Params _1910;
    _1910.transform_local_to_gizmo = _1771.VM1_params.transform_local_to_gizmo;
    _1910.noise_domain_scale = _1771.VM1_params.noise_domain_scale;
    _1910.modifier_function = _1771.VM1_params.modifier_function;
    _1910.noise_domain_offset = _1771.VM1_params.noise_domain_offset;
    _1910.noise_value_scale = _1771.VM1_params.noise_value_scale;
    _1910.noise_value_offset = _1771.VM1_params.noise_value_offset;
    _1910.influence_scope = _1771.VM1_params.influence_scope;
    _1910._pad0 = _1771.VM1_params._pad0;
    _1910._pad1 = _1771.VM1_params._pad1;
    ModifierFactorNoise_Params param_18 = _1910;
    ModifierFactor param_19 = modifier_factor_1;
    CoordinateSystemTrasforms param_20 = cs_transforms;
    modifier_factor_noise_simplex2(param_18, param_19, param_20);
    modifier_factor_1 = param_19;
    ModifierFactorDistancePlane_Params _1920;
    _1920.transform_local_to_gizmo = _1786.VM2_params.transform_local_to_gizmo;
    _1920.falloff_curve_idx = _1786.VM2_params.falloff_curve_idx;
    _1920.falloff_inverse = _1786.VM2_params.falloff_inverse;
    _1920.domain_mirror = _1786.VM2_params.domain_mirror;
    _1920.domain_repeat = _1786.VM2_params.domain_repeat;
    _1920.influence_scope = _1786.VM2_params.influence_scope;
    _1920.modifier_function = _1786.VM2_params.modifier_function;
    ModifierFactorDistancePlane_Params param_21 = _1920;
    ModifierFactor param_22 = modifier_factor_1;
    CoordinateSystemTrasforms param_23 = cs_transforms;
    modifier_factor_distance_plane(param_21, param_22, param_23);
    modifier_factor_1 = param_22;
    ModifierFactorRangeRemap_Params _1930;
    _1930.input_min = _1801.VM3_params.input_min;
    _1930.input_max = _1801.VM3_params.input_max;
    _1930.output_min = _1801.VM3_params.output_min;
    _1930.output_max = _1801.VM3_params.output_max;
    _1930.min_out_of_bounds_mode = _1801.VM3_params.min_out_of_bounds_mode;
    _1930.max_out_of_bounds_mode = _1801.VM3_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_24 = _1930;
    ModifierFactor param_25 = modifier_factor_1;
    modifier_factor_range_remap(param_24, param_25);
    modifier_factor_1 = param_25;
    ModifierFactorDistanceRadial_Params _1938;
    _1938.transform_local_to_gizmo = _1814.VM4_params.transform_local_to_gizmo;
    _1938.falloff_curve_idx = _1814.VM4_params.falloff_curve_idx;
    _1938.falloff_inverse = _1814.VM4_params.falloff_inverse;
    _1938.domain_repeat_x = _1814.VM4_params.domain_repeat_x;
    _1938.domain_repeat_y = _1814.VM4_params.domain_repeat_y;
    _1938.domain_repeat_z = _1814.VM4_params.domain_repeat_z;
    _1938.influence_scope = _1814.VM4_params.influence_scope;
    _1938.modifier_function = _1814.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_26 = _1938;
    ModifierFactor param_27 = modifier_factor_1;
    CoordinateSystemTrasforms param_28 = cs_transforms;
    modifier_factor_distance_radial(param_26, param_27, param_28);
    modifier_factor_1 = param_27;
    ModifierFactorFrustumCull_Params _1948;
    _1948.transform_local_to_gizmo = _1829.VM5_params.transform_local_to_gizmo;
    _1948.transform_world_to_view = _1829.VM5_params.transform_world_to_view;
    _1948.transform_projection = _1829.VM5_params.transform_projection;
    _1948.instance_radius = _1829.VM5_params.instance_radius;
    ModifierFactorFrustumCull_Params param_29 = _1948;
    ModifierFactor param_30 = modifier_factor_1;
    CoordinateSystemTrasforms param_31 = cs_transforms;
    modifier_factor_frustum_cull(param_29, param_30, param_31);
    modifier_factor_1 = param_30;
    modifier_factor_v_dx = modifier_factor_1.factor;
    ModifierFactor modifier_factor_2 = modifier_factor_defaults();
    modifier_factor_2.factor = 1.0;
    modifier_factor_2.hash = id;
    modifier_factor_2.id = id;
    modifier_factor_2.instance_id = id;
    modifier_factor_2.position = instance_position + vec3(0.0, instancing_bbox_size.y / float(_1684.instancing_generator_params.resolution.y), 0.0);
    modifier_factor_2.is_spawned = true;
    ModifierFactorMulAdd_Params _1980;
    _1980.multiply_value = _1758.VM0_params.multiply_value;
    _1980.add_value = _1758.VM0_params.add_value;
    ModifierFactorMulAdd_Params param_32 = _1980;
    ModifierFactor param_33 = modifier_factor_2;
    modifier_factor_mul_add(param_32, param_33);
    modifier_factor_2 = param_33;
    ModifierFactorNoise_Params _1988;
    _1988.transform_local_to_gizmo = _1771.VM1_params.transform_local_to_gizmo;
    _1988.noise_domain_scale = _1771.VM1_params.noise_domain_scale;
    _1988.modifier_function = _1771.VM1_params.modifier_function;
    _1988.noise_domain_offset = _1771.VM1_params.noise_domain_offset;
    _1988.noise_value_scale = _1771.VM1_params.noise_value_scale;
    _1988.noise_value_offset = _1771.VM1_params.noise_value_offset;
    _1988.influence_scope = _1771.VM1_params.influence_scope;
    _1988._pad0 = _1771.VM1_params._pad0;
    _1988._pad1 = _1771.VM1_params._pad1;
    ModifierFactorNoise_Params param_34 = _1988;
    ModifierFactor param_35 = modifier_factor_2;
    CoordinateSystemTrasforms param_36 = cs_transforms;
    modifier_factor_noise_simplex2(param_34, param_35, param_36);
    modifier_factor_2 = param_35;
    ModifierFactorDistancePlane_Params _1998;
    _1998.transform_local_to_gizmo = _1786.VM2_params.transform_local_to_gizmo;
    _1998.falloff_curve_idx = _1786.VM2_params.falloff_curve_idx;
    _1998.falloff_inverse = _1786.VM2_params.falloff_inverse;
    _1998.domain_mirror = _1786.VM2_params.domain_mirror;
    _1998.domain_repeat = _1786.VM2_params.domain_repeat;
    _1998.influence_scope = _1786.VM2_params.influence_scope;
    _1998.modifier_function = _1786.VM2_params.modifier_function;
    ModifierFactorDistancePlane_Params param_37 = _1998;
    ModifierFactor param_38 = modifier_factor_2;
    CoordinateSystemTrasforms param_39 = cs_transforms;
    modifier_factor_distance_plane(param_37, param_38, param_39);
    modifier_factor_2 = param_38;
    ModifierFactorRangeRemap_Params _2008;
    _2008.input_min = _1801.VM3_params.input_min;
    _2008.input_max = _1801.VM3_params.input_max;
    _2008.output_min = _1801.VM3_params.output_min;
    _2008.output_max = _1801.VM3_params.output_max;
    _2008.min_out_of_bounds_mode = _1801.VM3_params.min_out_of_bounds_mode;
    _2008.max_out_of_bounds_mode = _1801.VM3_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_40 = _2008;
    ModifierFactor param_41 = modifier_factor_2;
    modifier_factor_range_remap(param_40, param_41);
    modifier_factor_2 = param_41;
    ModifierFactorDistanceRadial_Params _2016;
    _2016.transform_local_to_gizmo = _1814.VM4_params.transform_local_to_gizmo;
    _2016.falloff_curve_idx = _1814.VM4_params.falloff_curve_idx;
    _2016.falloff_inverse = _1814.VM4_params.falloff_inverse;
    _2016.domain_repeat_x = _1814.VM4_params.domain_repeat_x;
    _2016.domain_repeat_y = _1814.VM4_params.domain_repeat_y;
    _2016.domain_repeat_z = _1814.VM4_params.domain_repeat_z;
    _2016.influence_scope = _1814.VM4_params.influence_scope;
    _2016.modifier_function = _1814.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_42 = _2016;
    ModifierFactor param_43 = modifier_factor_2;
    CoordinateSystemTrasforms param_44 = cs_transforms;
    modifier_factor_distance_radial(param_42, param_43, param_44);
    modifier_factor_2 = param_43;
    ModifierFactorFrustumCull_Params _2026;
    _2026.transform_local_to_gizmo = _1829.VM5_params.transform_local_to_gizmo;
    _2026.transform_world_to_view = _1829.VM5_params.transform_world_to_view;
    _2026.transform_projection = _1829.VM5_params.transform_projection;
    _2026.instance_radius = _1829.VM5_params.instance_radius;
    ModifierFactorFrustumCull_Params param_45 = _2026;
    ModifierFactor param_46 = modifier_factor_2;
    CoordinateSystemTrasforms param_47 = cs_transforms;
    modifier_factor_frustum_cull(param_45, param_46, param_47);
    modifier_factor_2 = param_46;
    modifier_factor_v_dy = modifier_factor_2.factor;
    ModifierFactor modifier_factor_3 = modifier_factor_defaults();
    modifier_factor_3.factor = 1.0;
    modifier_factor_3.hash = id;
    modifier_factor_3.id = id;
    modifier_factor_3.instance_id = id;
    modifier_factor_3.position = instance_position + vec3(0.0, 0.0, instancing_bbox_size.z / float(_1684.instancing_generator_params.resolution.z));
    modifier_factor_3.is_spawned = true;
    ModifierFactorMulAdd_Params _2058;
    _2058.multiply_value = _1758.VM0_params.multiply_value;
    _2058.add_value = _1758.VM0_params.add_value;
    ModifierFactorMulAdd_Params param_48 = _2058;
    ModifierFactor param_49 = modifier_factor_3;
    modifier_factor_mul_add(param_48, param_49);
    modifier_factor_3 = param_49;
    ModifierFactorNoise_Params _2066;
    _2066.transform_local_to_gizmo = _1771.VM1_params.transform_local_to_gizmo;
    _2066.noise_domain_scale = _1771.VM1_params.noise_domain_scale;
    _2066.modifier_function = _1771.VM1_params.modifier_function;
    _2066.noise_domain_offset = _1771.VM1_params.noise_domain_offset;
    _2066.noise_value_scale = _1771.VM1_params.noise_value_scale;
    _2066.noise_value_offset = _1771.VM1_params.noise_value_offset;
    _2066.influence_scope = _1771.VM1_params.influence_scope;
    _2066._pad0 = _1771.VM1_params._pad0;
    _2066._pad1 = _1771.VM1_params._pad1;
    ModifierFactorNoise_Params param_50 = _2066;
    ModifierFactor param_51 = modifier_factor_3;
    CoordinateSystemTrasforms param_52 = cs_transforms;
    modifier_factor_noise_simplex2(param_50, param_51, param_52);
    modifier_factor_3 = param_51;
    ModifierFactorDistancePlane_Params _2076;
    _2076.transform_local_to_gizmo = _1786.VM2_params.transform_local_to_gizmo;
    _2076.falloff_curve_idx = _1786.VM2_params.falloff_curve_idx;
    _2076.falloff_inverse = _1786.VM2_params.falloff_inverse;
    _2076.domain_mirror = _1786.VM2_params.domain_mirror;
    _2076.domain_repeat = _1786.VM2_params.domain_repeat;
    _2076.influence_scope = _1786.VM2_params.influence_scope;
    _2076.modifier_function = _1786.VM2_params.modifier_function;
    ModifierFactorDistancePlane_Params param_53 = _2076;
    ModifierFactor param_54 = modifier_factor_3;
    CoordinateSystemTrasforms param_55 = cs_transforms;
    modifier_factor_distance_plane(param_53, param_54, param_55);
    modifier_factor_3 = param_54;
    ModifierFactorRangeRemap_Params _2086;
    _2086.input_min = _1801.VM3_params.input_min;
    _2086.input_max = _1801.VM3_params.input_max;
    _2086.output_min = _1801.VM3_params.output_min;
    _2086.output_max = _1801.VM3_params.output_max;
    _2086.min_out_of_bounds_mode = _1801.VM3_params.min_out_of_bounds_mode;
    _2086.max_out_of_bounds_mode = _1801.VM3_params.max_out_of_bounds_mode;
    ModifierFactorRangeRemap_Params param_56 = _2086;
    ModifierFactor param_57 = modifier_factor_3;
    modifier_factor_range_remap(param_56, param_57);
    modifier_factor_3 = param_57;
    ModifierFactorDistanceRadial_Params _2094;
    _2094.transform_local_to_gizmo = _1814.VM4_params.transform_local_to_gizmo;
    _2094.falloff_curve_idx = _1814.VM4_params.falloff_curve_idx;
    _2094.falloff_inverse = _1814.VM4_params.falloff_inverse;
    _2094.domain_repeat_x = _1814.VM4_params.domain_repeat_x;
    _2094.domain_repeat_y = _1814.VM4_params.domain_repeat_y;
    _2094.domain_repeat_z = _1814.VM4_params.domain_repeat_z;
    _2094.influence_scope = _1814.VM4_params.influence_scope;
    _2094.modifier_function = _1814.VM4_params.modifier_function;
    ModifierFactorDistanceRadial_Params param_58 = _2094;
    ModifierFactor param_59 = modifier_factor_3;
    CoordinateSystemTrasforms param_60 = cs_transforms;
    modifier_factor_distance_radial(param_58, param_59, param_60);
    modifier_factor_3 = param_59;
    ModifierFactorFrustumCull_Params _2104;
    _2104.transform_local_to_gizmo = _1829.VM5_params.transform_local_to_gizmo;
    _2104.transform_world_to_view = _1829.VM5_params.transform_world_to_view;
    _2104.transform_projection = _1829.VM5_params.transform_projection;
    _2104.instance_radius = _1829.VM5_params.instance_radius;
    ModifierFactorFrustumCull_Params param_61 = _2104;
    ModifierFactor param_62 = modifier_factor_3;
    CoordinateSystemTrasforms param_63 = cs_transforms;
    modifier_factor_frustum_cull(param_61, param_62, param_63);
    modifier_factor_3 = param_62;
    modifier_factor_v_dz = modifier_factor_3.factor;
    vec3 n;
    n.x = modifier_factor_v_dx - modifier_factor_v;
    n.y = modifier_factor_v_dy - modifier_factor_v;
    n.z = modifier_factor_v_dz - modifier_factor_v;
    n = mix(vec3(0.0, 0.0, 1.0), n, vec3(_1684.instancing_generator_params.orientation_blend));
    n = normalize(n);
    mat3 r;
    r[2] = n;
    r[1] = cross(vec3(0.0, 1.0, 0.0), r[2]);
    r[0] = cross(r[2], r[1]);
    r[1] = cross(r[2], r[0]);
    mat3 s;
    s[0] = vec3(instance_scale.x, 0.0, 0.0);
    s[1] = vec3(0.0, instance_scale.y, 0.0);
    s[2] = vec3(0.0, 0.0, instance_scale.z);
    mat3 transform = r * s;
    transform = s * r;
    transform = transpose(transform);
    Instance instance;
    instance.m0 = vec4(transform[0], instance_position.x);
    instance.m1 = vec4(transform[1], instance_position.y);
    instance.m2 = vec4(transform[2], instance_position.z);
    instance.hash = modifier_factor.hash;
    instance.c = vec4(1.0);
    instance.flipbook_card = 0u;
    InstanceModifierRandomizerV2_Params _2217;
    _2217.replace_previous_rotation_scale = _2212.VM6_params.replace_previous_rotation_scale;
    _2217.randomness_seed = _2212.VM6_params.randomness_seed;
    _2217.replace_previous_position = _2212.VM6_params.replace_previous_position;
    _2217.randomization_input = _2212.VM6_params.randomization_input;
    _2217.position_modifier_base = _2212.VM6_params.position_modifier_base;
    _2217.position_modifier_base_modifier_factor = _2212.VM6_params.position_modifier_base_modifier_factor;
    _2217.position_modifier_range = _2212.VM6_params.position_modifier_range;
    _2217.position_modifier_range_modifier_factor = _2212.VM6_params.position_modifier_range_modifier_factor;
    _2217.rotation_modifier_base = _2212.VM6_params.rotation_modifier_base;
    _2217.rotation_modifier_base_modifier_factor = _2212.VM6_params.rotation_modifier_base_modifier_factor;
    _2217.rotation_modifier_range = _2212.VM6_params.rotation_modifier_range;
    _2217.rotation_modifier_range_modifier_factor = _2212.VM6_params.rotation_modifier_range_modifier_factor;
    _2217.scale_modifier_base = _2212.VM6_params.scale_modifier_base;
    _2217.scale_modifier_base_modifier_factor = _2212.VM6_params.scale_modifier_base_modifier_factor;
    _2217.scale_modifier_range = _2212.VM6_params.scale_modifier_range;
    _2217.scale_modifier_range_modifier_factor = _2212.VM6_params.scale_modifier_range_modifier_factor;
    InstanceModifierRandomizerV2_Params param_64 = _2217;
    ModifierFactor param_65 = modifier_factor;
    Instance param_66 = instance;
    uint param_67 = id;
    instance_modifier_randomizer_v2(param_64, param_65, param_66, param_67);
    modifier_factor = param_65;
    instance = param_66;
    bool _2231 = length(instance.m0.xyz) <= 0.0;
    bool _2240;
    if (!_2231)
    {
        _2240 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _2240 = _2231;
    }
    bool _2249;
    if (!_2240)
    {
        _2249 = length(instance.m1.xyz) <= 0.0;
    }
    else
    {
        _2249 = _2240;
    }
    if (_2249)
    {
        return;
    }
    int _2255 = atomicAdd(_1667.instance_params.instance_count, 1);
    uint instance_id = uint(_2255);
    if (instance_id >= uint(_1667.instance_params.buffer_capacity))
    {
        return;
    }
    _2268.instance_transform[(instance_id * 3u) + 0u] = instance.m0;
    _2268.instance_transform[(instance_id * 3u) + 1u] = instance.m1;
    _2268.instance_transform[(instance_id * 3u) + 2u] = instance.m2;
    _2291.instance_color[(instance_id * 2u) + 0u] = packHalf2x16(instance.c.xy);
    _2291.instance_color[(instance_id * 2u) + 1u] = packHalf2x16(instance.c.zw);
    _2312.instance_hash[instance_id] = instance.hash;
    _2320.instance_flipbook_card[instance_id] = instance.flipbook_card;
}

 