#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
layout(local_size_x = 32, local_size_y = 32, local_size_z = 1) in;

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct BuildRTDispatchElementsParams
{
    uint material_flags;
    uint width_in_tiles;
    uint min_rate;
    uint max_rate;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 0, binding = 3, std140) uniform BuildRTDispatchElementsParamsBuffer
{
    BuildRTDispatchElementsParams params;
} _376;

layout(set = 0, binding = 2, std430) buffer buff_dispatch_elements
{
    uint dispatch_elements[];
} _444;

layout(set = 0, binding = 4) uniform usampler2D imMetalnessRoughnessMaterialTags;
layout(set = 0, binding = 5) uniform usampler2D imNormalMaterial;

shared uint dispatch_count;

void decode_metalness_roughness_material(uvec2 mrm, out float metalness, out float roughness, out uint material)
{
    metalness = float(mrm.x >> uint(8)) * 0.0039215688593685626983642578125;
    roughness = float((mrm.x >> uint(0)) & 255u) * 0.0039215688593685626983642578125;
    material = mrm.y;
}

void decode_component_tags(uint ct, out uint component_tags)
{
    component_tags = ct;
}

MetalnessRoughnessMeterialTags decode_metalness_roughness_material_tags(uvec4 v)
{
    uvec2 param = v.xy;
    float param_1;
    float param_2;
    uint param_3;
    decode_metalness_roughness_material(param, param_1, param_2, param_3);
    MetalnessRoughnessMeterialTags o;
    o.metalness = param_1;
    o.roughness = param_2;
    o.material_index = param_3;
    uint param_4 = v.z;
    uint param_5;
    decode_component_tags(param_4, param_5);
    o.component_tags = param_5;
    o.material_flag_overrides = v.w;
    return o;
}

uint pack_dispatch(uint x, uint y, uint rate, uint mask)
{
    return (((mask << uint(26)) | (rate << uint(24))) | (y << uint(12))) | x;
}

uint dispatch_get_mask(uint dispatch)
{
    return (dispatch >> uint(26)) & 15u;
}

ivec2 dispatch_get_subsample_offset(uint dispatch)
{
    uint param = dispatch;
    uint mask = dispatch_get_mask(param);
    if ((mask & 1u) != 0u)
    {
        return ivec2(0);
    }
    else
    {
        if ((mask & 2u) != 0u)
        {
            return ivec2(1, 0);
        }
        else
        {
            if ((mask & 4u) != 0u)
            {
                return ivec2(0, 1);
            }
            else
            {
                return ivec2(1);
            }
        }
    }
}

vec3 i_octahedral_32(uint data, uint sh)
{
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(data, data >> sh) & uvec2(mu);
    vec2 v = vec2(d) / vec2(float(mu));
    v = vec2(-1.0) + (v * 2.0);
    vec3 nor = vec3(v, (1.0 - abs(v.x)) - abs(v.y));
    float t = max(-nor.z, 0.0);
    float _116;
    if (nor.x > 0.0)
    {
        _116 = -t;
    }
    else
    {
        _116 = t;
    }
    nor.x += _116;
    float _131;
    if (nor.y > 0.0)
    {
        _131 = -t;
    }
    else
    {
        _131 = t;
    }
    nor.y += _131;
    return normalize(nor);
}

vec3 decode_normal(inout uint data)
{
    data &= 2147483647u;
    uint param = data;
    uint param_1 = 15u;
    vec3 n = i_octahedral_32(param, param_1);
    return n;
}

void main()
{
    uvec2 tile_pos = (gl_WorkGroupID.xy * uvec2(32u)) * uvec2(2u);
    bool _277 = gl_LocalInvocationID.x == 0u;
    bool _283;
    if (_277)
    {
        _283 = gl_LocalInvocationID.y == 0u;
    }
    else
    {
        _283 = _277;
    }
    if (_283)
    {
        dispatch_count = 0u;
    }
    barrier();
    uint mask = 0u;
    uint mask_count = 0u;
    for (int iy = 0; iy < 2; iy++)
    {
        for (int ix = 0; ix < 2; ix++)
        {
            uvec2 pixel_pos_in_tile = (gl_LocalInvocationID.xy * uvec2(2u)) + uvec2(uint(ix), uint(iy));
            uvec2 pos = tile_pos + pixel_pos_in_tile;
            uvec4 param = texelFetch(imMetalnessRoughnessMaterialTags, ivec2(pos), 0);
            MetalnessRoughnessMeterialTags metalness_roughness_material_tags = decode_metalness_roughness_material_tags(param);
            uint materialIndex = metalness_roughness_material_tags.material_index;
            MaterialPropertiesGPU _351;
            _351.diffuse = materials.material_properties[materialIndex].diffuse;
            _351.transparency = materials.material_properties[materialIndex].transparency;
            _351.emissive = materials.material_properties[materialIndex].emissive;
            _351.roughness = materials.material_properties[materialIndex].roughness;
            _351.triplanar_factor = materials.material_properties[materialIndex].triplanar_factor;
            _351.refraction = materials.material_properties[materialIndex].refraction;
            _351.normal_factor = materials.material_properties[materialIndex].normal_factor;
            _351.emissive_factor = materials.material_properties[materialIndex].emissive_factor;
            _351.temporal_accumulation_factor = materials.material_properties[materialIndex].temporal_accumulation_factor;
            _351.shadowmap_bias = materials.material_properties[materialIndex].shadowmap_bias;
            _351.metalness = materials.material_properties[materialIndex].metalness;
            _351.albedo_sampler = materials.material_properties[materialIndex].albedo_sampler;
            _351.emissive_sampler = materials.material_properties[materialIndex].emissive_sampler;
            _351.normal_sampler = materials.material_properties[materialIndex].normal_sampler;
            _351.metalic_roughness_sampler = materials.material_properties[materialIndex].metalic_roughness_sampler;
            _351.flags = materials.material_properties[materialIndex].flags;
            _351._pad0 = materials.material_properties[materialIndex]._pad0;
            _351._pad1 = materials.material_properties[materialIndex]._pad1;
            MaterialPropertiesGPU material = _351;
            uint material_flags = material.flags;
            if ((metalness_roughness_material_tags.material_flag_overrides & 2u) != 0u)
            {
                material_flags &= 4294967280u;
                material_flags |= (metalness_roughness_material_tags.material_flag_overrides & 15u);
            }
            bool is_matching = (material_flags & _376.params.material_flags) != 0u;
            if (pos.y >= 1080u)
            {
                is_matching = false;
            }
            if (is_matching)
            {
                mask |= uint(1 << ((iy << 1) | ix));
                mask_count++;
            }
        }
    }
    if (mask_count == 0u)
    {
        return;
    }
    uint base_tile_idx = ((gl_WorkGroupID.y * _376.params.width_in_tiles) + gl_WorkGroupID.x) * 4097u;
    uint base_dispatch_idx = base_tile_idx + 1u;
    uvec2 base_2x2_pos = tile_pos + (gl_LocalInvocationID.xy * uvec2(2u));
    if ((_376.params.max_rate == 0u) || (mask_count == 1u))
    {
        uint _449 = atomicAdd(_444.dispatch_elements[base_tile_idx], mask_count);
        uint idx = _449;
        if ((mask & 1u) != 0u)
        {
            uint param_1 = base_2x2_pos.x + 0u;
            uint param_2 = base_2x2_pos.y + 0u;
            uint param_3 = 0u;
            uint param_4 = 1u;
            _444.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_1, param_2, param_3, param_4);
            idx++;
        }
        if ((mask & 2u) != 0u)
        {
            uint param_5 = base_2x2_pos.x + 1u;
            uint param_6 = base_2x2_pos.y + 0u;
            uint param_7 = 0u;
            uint param_8 = 1u;
            _444.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_5, param_6, param_7, param_8);
            idx++;
        }
        if ((mask & 4u) != 0u)
        {
            uint param_9 = base_2x2_pos.x + 0u;
            uint param_10 = base_2x2_pos.y + 1u;
            uint param_11 = 0u;
            uint param_12 = 1u;
            _444.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_9, param_10, param_11, param_12);
            idx++;
        }
        if ((mask & 8u) != 0u)
        {
            uint param_13 = base_2x2_pos.x + 1u;
            uint param_14 = base_2x2_pos.y + 1u;
            uint param_15 = 0u;
            uint param_16 = 1u;
            _444.dispatch_elements[base_dispatch_idx + idx] = pack_dispatch(param_13, param_14, param_15, param_16);
            idx++;
        }
        return;
    }
    uint refinement_mask = 0u;
    if (false)
    {
        if (_376.params.max_rate == 3u)
        {
            uint param_17 = base_2x2_pos.x + 0u;
            uint param_18 = base_2x2_pos.y + 0u;
            uint param_19 = 3u;
            uint param_20 = mask;
            uint dispatch = pack_dispatch(param_17, param_18, param_19, param_20);
            uint param_21 = dispatch;
            uvec2 offset_in_dispatch = uvec2(dispatch_get_subsample_offset(param_21));
            uvec2 pixel_pos_in_tile_1 = gl_LocalInvocationID.xy * uvec2(2u);
            uvec2 pos_1 = (tile_pos + pixel_pos_in_tile_1) + offset_in_dispatch;
            uint encoded_normal_material = texelFetch(imNormalMaterial, ivec2(pos_1), 0).x;
            uint param_22 = encoded_normal_material;
            vec3 _588 = decode_normal(param_22);
            vec3 base_normal = normalize(_588);
            uint base_mask = uint(1 << findLSB(mask));
            if (((mask & 2u) != 0u) && (base_mask != 2u))
            {
                uint encoded_normal_material_1 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(1, 0), 0).x;
                uint param_23 = encoded_normal_material_1;
                vec3 _614 = decode_normal(param_23);
                vec3 normal = normalize(_614);
                float d = abs(dot(normal, base_normal));
                if (d < 0.5)
                {
                    refinement_mask |= 2u;
                }
            }
            if (((mask & 4u) != 0u) && (base_mask != 4u))
            {
                uint encoded_normal_material_2 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(0, 1), 0).x;
                uint param_24 = encoded_normal_material_2;
                vec3 _647 = decode_normal(param_24);
                vec3 normal_1 = normalize(_647);
                float d_1 = abs(dot(normal_1, base_normal));
                if (d_1 < 0.5)
                {
                    refinement_mask |= 4u;
                }
            }
            if (((mask & 8u) != 0u) && (base_mask != 8u))
            {
                uint encoded_normal_material_3 = texelFetch(imNormalMaterial, ivec2(pos_1) + ivec2(1), 0).x;
                uint param_25 = encoded_normal_material_3;
                vec3 _679 = decode_normal(param_25);
                vec3 normal_2 = normalize(_679);
                float d_2 = abs(dot(normal_2, base_normal));
                if (d_2 < 0.5)
                {
                    refinement_mask |= 8u;
                }
            }
        }
    }
    uint refinement_count = uint(bitCount(refinement_mask));
    mask &= (~refinement_mask);
    uint _705 = atomicAdd(_444.dispatch_elements[base_tile_idx], 1u + refinement_count);
    uint idx_1 = _705;
    uint param_26 = base_2x2_pos.x + 0u;
    uint param_27 = base_2x2_pos.y + 0u;
    uint param_28 = 3u;
    uint param_29 = mask;
    _444.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_26, param_27, param_28, param_29);
    idx_1++;
    if ((refinement_mask & 2u) != 0u)
    {
        uint param_30 = base_2x2_pos.x + 1u;
        uint param_31 = base_2x2_pos.y + 0u;
        uint param_32 = 0u;
        uint param_33 = 1u;
        _444.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_30, param_31, param_32, param_33);
        idx_1++;
    }
    if ((refinement_mask & 4u) != 0u)
    {
        uint param_34 = base_2x2_pos.x + 0u;
        uint param_35 = base_2x2_pos.y + 1u;
        uint param_36 = 0u;
        uint param_37 = 1u;
        _444.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_34, param_35, param_36, param_37);
        idx_1++;
    }
    if ((refinement_mask & 8u) != 0u)
    {
        uint param_38 = base_2x2_pos.x + 1u;
        uint param_39 = base_2x2_pos.y + 1u;
        uint param_40 = 0u;
        uint param_41 = 1u;
        _444.dispatch_elements[base_dispatch_idx + idx_1] = pack_dispatch(param_38, param_39, param_40, param_41);
        idx_1++;
    }
}

 