#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct ParticleState
{
    float life_time;
    float life_span;
    float generation_id;
    uint color;
};

struct ParticleRibbonSegmentInfo
{
    uint segments;
    uint first;
    uint previous;
};

struct RibbonRenderParams
{
    int max_segments;
    float voxelize_thickness;
    int base_segment;
    int particles_per_segment;
    float thickness;
    int lights_num;
    int material_index;
    float first_segment_time_factor;
    int render_as_strips;
    int segment_subdivisions;
    int _pad1;
    int _pad2;
};

struct ParticleRibbonState
{
    float generation_id;
    uint segment_info;
};

struct _589
{
    vec3 vLocalPos;
    vec4 vColor;
    vec2 vUV0;
    uint vIdx;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 0, binding = 1, std430) buffer ParticleStatesData
{
    ParticleState prt_states[];
} _178;

layout(set = 0, binding = 5, std140) uniform RibbonRenderParamsBuffer
{
    RibbonRenderParams ribbon_render_params;
} _238;

layout(set = 0, binding = 2, std430) restrict readonly buffer RibbonStatesData
{
    ParticleRibbonState states[];
} prt_states_snapshots;

layout(set = 0, binding = 3, std430) restrict readonly buffer RibbonPositionsData
{
    float position[];
} prt_position_snapshots;

layout(set = 0, binding = 6, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _740;

layout(set = 0, binding = 4, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(location = 0) out uint instanceID;
layout(location = 1) out _589 vtx_output;

ParticleRibbonSegmentInfo ribbon_decode_segment_info(uint segment_info)
{
    ParticleRibbonSegmentInfo si;
    si.segments = segment_info & 65535u;
    si.first = segment_info >> uint(16);
    si.previous = si.first - 1u;
    if (si.first == 0u)
    {
        si.previous = uint(_238.ribbon_render_params.max_segments - 1);
    }
    return si;
}

uint get_ribbon_segments(uint ribbon_id)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    int s = max(0, (min(_238.ribbon_render_params.max_segments, int(ribbon_si.segments)) - 1));
    return uint(max(1, s));
}

bool prt_is_alive(uint id)
{
    return _178.prt_states[id].life_time < _178.prt_states[id].life_span;
}

float compute_t_from_subsegment(int sub_segment_idx)
{
    return float(sub_segment_idx) / float(_238.ribbon_render_params.segment_subdivisions);
}

int calculate_vidx_for_ribbon_segment(uint ribbon_id, inout int ribbon_segment)
{
    uint param = prt_states_snapshots.states[ribbon_id].segment_info;
    ParticleRibbonSegmentInfo ribbon_si = ribbon_decode_segment_info(param);
    ribbon_segment = int(ribbon_si.first) - ribbon_segment;
    if (ribbon_segment < 0)
    {
        ribbon_segment += _238.ribbon_render_params.max_segments;
    }
    int vidx = (ribbon_segment * _238.ribbon_render_params.particles_per_segment) + int(ribbon_id);
    return vidx;
}

vec3 ribbon_get_coords_for_vidx(int vidx)
{
    return vec3(prt_position_snapshots.position[(vidx * 3) + 0], prt_position_snapshots.position[(vidx * 3) + 1], prt_position_snapshots.position[(vidx * 3) + 2]);
}

vec3 catmull_rom(vec3 p0, vec3 p1, vec3 p2, vec3 p3, float t)
{
    float t2 = t * t;
    float t3 = t2 * t;
    return ((((p1 * 2.0) + (((-p0) + p2) * t)) + (((((p0 * 2.0) - (p1 * 5.0)) + (p2 * 4.0)) - p3) * t2)) + (((((-p0) + (p1 * 3.0)) - (p2 * 3.0)) + p3) * t3)) * 0.5;
}

vec3 ribbon_get_coords_for_t_spline(uint ribbon_idx, uint segment_idx, float t)
{
    uint param = ribbon_idx;
    int control_points_num = int(get_ribbon_segments(param)) + 1;
    int s1 = int(segment_idx);
    int s2 = min((s1 + 1), (control_points_num - 1));
    int s0 = max((s1 - 1), 0);
    int s3 = min((s2 + 1), (control_points_num - 1));
    uint param_1 = ribbon_idx;
    int param_2 = s0;
    int _406 = calculate_vidx_for_ribbon_segment(param_1, param_2);
    int vidx0 = _406;
    uint param_3 = ribbon_idx;
    int param_4 = s1;
    int _412 = calculate_vidx_for_ribbon_segment(param_3, param_4);
    int vidx1 = _412;
    uint param_5 = ribbon_idx;
    int param_6 = s2;
    int _418 = calculate_vidx_for_ribbon_segment(param_5, param_6);
    int vidx2 = _418;
    uint param_7 = ribbon_idx;
    int param_8 = s3;
    int _424 = calculate_vidx_for_ribbon_segment(param_7, param_8);
    int vidx3 = _424;
    int param_9 = vidx0;
    vec3 p0 = ribbon_get_coords_for_vidx(param_9);
    int param_10 = vidx1;
    vec3 p1 = ribbon_get_coords_for_vidx(param_10);
    int param_11 = vidx2;
    vec3 p2 = ribbon_get_coords_for_vidx(param_11);
    int param_12 = vidx3;
    vec3 p3 = ribbon_get_coords_for_vidx(param_12);
    if (s0 == s1)
    {
        p0 = p1 - (p2 - p1);
    }
    if (s3 == s2)
    {
        p3 = p2 + (p2 - p1);
    }
    if (false)
    {
        float d = length(p1 - p0);
        p0 = p1 - (normalize(p1 - p0) * d);
        p3 = p2 + (normalize(p3 - p2) * d);
    }
    vec3 param_13 = p0;
    vec3 param_14 = p1;
    vec3 param_15 = p2;
    vec3 param_16 = p3;
    float param_17 = t;
    return catmull_rom(param_13, param_14, param_15, param_16, param_17);
}

vec3 ribbon_get_coords_for_segment_t(uint ribbon_id, int segment_idx, float t)
{
    uint param = ribbon_id;
    uint param_1 = uint(segment_idx);
    float param_2 = t;
    return ribbon_get_coords_for_t_spline(param, param_1, param_2);
}

vec3 color_convert_uint_to_float3(uint vi)
{
    vec3 v = vec3(0.0);
    uint v_mag = vi >> uint(24);
    float v_mag_rcp = 0.0039215688593685626983642578125 * float(v_mag);
    v.x = float((vi >> uint(0)) & 255u) * v_mag_rcp;
    v.y = float((vi >> uint(8)) & 255u) * v_mag_rcp;
    v.z = float((vi >> uint(16)) & 255u) * v_mag_rcp;
    return v;
}

vec4 prt_get_color(uint id)
{
    vec4 c = vec4(1.0);
    uint param = _178.prt_states[id].color;
    vec3 _207 = color_convert_uint_to_float3(param);
    c.x = _207.x;
    c.y = _207.y;
    c.z = _207.z;
    return c;
}

vec3 apply_vtx_modifier(vec3 pos, vec3 norm, vec3 color, uint ribbon_id)
{
    return pos;
}

ParticleState prt_get_state(uint id)
{
    ParticleState _195;
    _195.life_time = _178.prt_states[id].life_time;
    _195.life_span = _178.prt_states[id].life_span;
    _195.generation_id = _178.prt_states[id].generation_id;
    _195.color = _178.prt_states[id].color;
    ParticleState _194 = _195;
    return _194;
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec4 vector_transform_by_mat_projection(vec3 v, inout mat4 m)
{
    m[0].y = 0.0;
    m[0].z = 0.0;
    m[0].w = 0.0;
    m[1].x = 0.0;
    m[1].z = 0.0;
    m[1].w = 0.0;
    return m * vec4(v, 1.0);
}

void main()
{
    instanceID = uint(gl_InstanceIndex);
    int ribbon_id = gl_InstanceIndex;
    int n = gl_VertexIndex;
    int ribbon_segment = n / _238.ribbon_render_params.segment_subdivisions;
    int ribbon_sub_segment = n - (ribbon_segment * _238.ribbon_render_params.segment_subdivisions);
    uint param = uint(ribbon_id);
    uint ribbon_segments = get_ribbon_segments(param);
    vtx_output.vLocalPos = vec3(0.0);
    vtx_output.vIdx = 0u;
    uint param_1 = uint(ribbon_id);
    bool _599 = !prt_is_alive(param_1);
    bool _607;
    if (!_599)
    {
        _607 = uint(ribbon_segment) > ribbon_segments;
    }
    else
    {
        _607 = _599;
    }
    bool _618;
    if (!_607)
    {
        _618 = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment > 0);
    }
    else
    {
        _618 = _607;
    }
    if (_618 || (ribbon_segments <= 1u))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */));
        return;
    }
    int param_2 = ribbon_sub_segment;
    uint param_3 = uint(ribbon_id);
    int param_4 = ribbon_segment;
    float param_5 = compute_t_from_subsegment(param_2);
    vec3 vInstPosition = ribbon_get_coords_for_segment_t(param_3, param_4, param_5);
    vec3 vInstNormal = vec3(1.0, 0.0, 0.0);
    uint param_6 = uint(ribbon_id);
    vec4 vInstColor = prt_get_color(param_6);
    vec3 param_7 = vInstPosition;
    vec3 param_8 = vInstNormal;
    vec3 param_9 = vInstColor.xyz;
    uint param_10 = uint(ribbon_id);
    vInstColor.x = param_9.x;
    vInstColor.y = param_9.y;
    vInstColor.z = param_9.z;
    vInstPosition = apply_vtx_modifier(param_7, param_8, param_9, param_10);
    uint param_11 = uint(ribbon_id);
    ParticleState vState = prt_get_state(param_11);
    bool is_last = (uint(ribbon_segment) == ribbon_segments) && (ribbon_sub_segment == 0);
    bool is_last_section = uint(ribbon_segment) >= (ribbon_segments - 1u);
    bool is_first_section = ribbon_segment == 0;
    bool _697 = uint(ribbon_segment) == (ribbon_segments - 1u);
    bool _705;
    if (_697)
    {
        _705 = ribbon_sub_segment == (_238.ribbon_render_params.segment_subdivisions - 1);
    }
    else
    {
        _705 = _697;
    }
    bool is_one_before_last = _705;
    bool is_first = (ribbon_segment == 0) && (ribbon_sub_segment == 0);
    bool is_full = ribbon_segments == uint(_238.ribbon_render_params.max_segments - 1);
    uint param_12 = uint(ribbon_id);
    if (!prt_is_alive(param_12))
    {
        gl_Position = vec4(uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), uintBitsToFloat(0x7fc00000u /* nan */), -1.0);
        return;
    }
    vec3 pos = vInstPosition;
    vtx_output.vLocalPos = pos;
    vec3 vPos1 = pos;
    vec3 param_13 = vPos1;
    mat4 param_14 = _740.transform_params.mModelView;
    vec3 _747 = vector_transform_by_mat43(param_13, param_14);
    vec3 vPos = _747;
    MaterialPropertiesGPU _763;
    _763.diffuse = materials.material_properties[_238.ribbon_render_params.material_index].diffuse;
    _763.transparency = materials.material_properties[_238.ribbon_render_params.material_index].transparency;
    _763.emissive = materials.material_properties[_238.ribbon_render_params.material_index].emissive;
    _763.roughness = materials.material_properties[_238.ribbon_render_params.material_index].roughness;
    _763.triplanar_factor = materials.material_properties[_238.ribbon_render_params.material_index].triplanar_factor;
    _763.refraction = materials.material_properties[_238.ribbon_render_params.material_index].refraction;
    _763.normal_factor = materials.material_properties[_238.ribbon_render_params.material_index].normal_factor;
    _763.emissive_factor = materials.material_properties[_238.ribbon_render_params.material_index].emissive_factor;
    _763.temporal_accumulation_factor = materials.material_properties[_238.ribbon_render_params.material_index].temporal_accumulation_factor;
    _763.shadowmap_bias = materials.material_properties[_238.ribbon_render_params.material_index].shadowmap_bias;
    _763.metalness = materials.material_properties[_238.ribbon_render_params.material_index].metalness;
    _763.albedo_sampler = materials.material_properties[_238.ribbon_render_params.material_index].albedo_sampler;
    _763.emissive_sampler = materials.material_properties[_238.ribbon_render_params.material_index].emissive_sampler;
    _763.normal_sampler = materials.material_properties[_238.ribbon_render_params.material_index].normal_sampler;
    _763.metalic_roughness_sampler = materials.material_properties[_238.ribbon_render_params.material_index].metalic_roughness_sampler;
    _763.flags = materials.material_properties[_238.ribbon_render_params.material_index].flags;
    _763._pad0 = materials.material_properties[_238.ribbon_render_params.material_index]._pad0;
    _763._pad1 = materials.material_properties[_238.ribbon_render_params.material_index]._pad1;
    MaterialPropertiesGPU material = _763;
    float remaining_lifetime_based_extrusion_modifier = 1.0;
    float remaining_lifetime_margin = 0.20000000298023223876953125;
    if (vState.life_time > (vState.life_span - remaining_lifetime_margin))
    {
        remaining_lifetime_based_extrusion_modifier = vState.life_time - (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier /= (vState.life_span - remaining_lifetime_margin);
        remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
    }
    else
    {
        if (vState.life_time < remaining_lifetime_margin)
        {
            remaining_lifetime_based_extrusion_modifier = vState.life_time;
            remaining_lifetime_based_extrusion_modifier /= remaining_lifetime_margin;
            remaining_lifetime_based_extrusion_modifier = 1.0 - remaining_lifetime_based_extrusion_modifier;
        }
    }
    remaining_lifetime_based_extrusion_modifier = clamp(remaining_lifetime_based_extrusion_modifier, 0.0, 1.0);
    vtx_output.vColor = vec4(vInstColor);
    vtx_output.vColor.w = remaining_lifetime_based_extrusion_modifier;
    vtx_output.vIdx = 1u;
    vec3 param_15 = vPos;
    mat4 param_16 = _740.transform_params.mProjection;
    vec4 _824 = vector_transform_by_mat_projection(param_15, param_16);
    gl_Position = _824;
}

 