#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require
layout(local_size_x = 32, local_size_y = 1, local_size_z = 1) in;

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct DispatchIndirectParams
{
    uint x;
    uint y;
    uint z;
};

struct BuildDispatchIndirectFromTransformedGeometryParams
{
    uint indirect_buffer_idx;
    uint transformed_geometry_idx;
    uint numerator;
    uint denominator;
};

struct InstanceParams
{
    int buffer_capacity;
    int stride;
    int indices_per_instance;
    int instance_count;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) buffer TransformedDataLocationBuffer
{
    TransformedDataLocation transformed_data_location[];
} _28;

layout(set = 0, binding = 2, std430) buffer DispatchIndirectParamsBuffer
{
    DispatchIndirectParams dispatch_indirect_params[];
} _61;

layout(set = 0, binding = 3, std140) uniform BuildDispatchIndirectFromTransformedGeometryParamsBuffer
{
    BuildDispatchIndirectFromTransformedGeometryParams params;
} _65;

layout(set = 0, binding = 4, std140) uniform DispatchIndirectInstanceParamsBuffer
{
    InstanceParams dispatch_indirect_instance_params;
} _86;

uint transformed_geometry_get_last_face_idx(uint tdl_idx)
{
    return _28.transformed_data_location[tdl_idx].last_face_idx;
}

uint transformed_geometry_get_first_face_idx(uint tdl_idx)
{
    if (tdl_idx > 0u)
    {
        return _28.transformed_data_location[tdl_idx - 1u].last_face_idx + 1u;
    }
    return 0u;
}

void main()
{
    uint idx = gl_GlobalInvocationID.x;
    if (idx == 0u)
    {
        uint param = _65.params.transformed_geometry_idx;
        uint param_1 = _65.params.transformed_geometry_idx;
        _61.dispatch_indirect_params[_65.params.indirect_buffer_idx].x = ((((((transformed_geometry_get_last_face_idx(param) - transformed_geometry_get_first_face_idx(param_1)) + 1u) * _65.params.numerator) * uint(min(_86.dispatch_indirect_instance_params.buffer_capacity, _86.dispatch_indirect_instance_params.instance_count))) + _65.params.denominator) - 1u) / _65.params.denominator;
        _61.dispatch_indirect_params[_65.params.indirect_buffer_idx].y = 1u;
        _61.dispatch_indirect_params[_65.params.indirect_buffer_idx].z = 1u;
    }
}

 