#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif

struct MetalnessRoughnessMeterialTags
{
    float metalness;
    float roughness;
    uint material_index;
    uint material_flag_overrides;
    uint component_tags;
};

struct ModifierFactor
{
    vec3 position;
    vec3 normal;
    vec2 uv0;
    vec4 color;
    uint custom0;
    uint custom1;
    float factor;
    uint id;
    uint hash;
    uint instance_id;
    bool is_spawned;
    bool is_discarded;
    bool has_world_position;
    vec3 world_position;
};

struct ModifierFactorQuantizePosition_Params
{
    vec3 quantization_step;
    float _pad0;
    vec3 offset;
    int quantize_x;
    int quantize_y;
    int quantize_z;
};

struct CoordinateSystemTrasforms
{
    mat4 mat_local_to_model;
    mat4 mat_local_to_instance;
    mat4 mat_local_to_model_inv;
};

struct ModifierFactorNoise_Params
{
    mat4 transform_local_to_gizmo;
    vec3 noise_domain_scale;
    uint modifier_function;
    vec3 noise_domain_offset;
    float noise_value_scale;
    float noise_value_offset;
    int influence_scope;
    int _pad0;
    int _pad1;
};

struct ModifierFactorClamp_Params
{
    float clamp_min;
    float clamp_max;
    int clamp_min_enable;
    int clamp_max_enable;
};

struct ModifierFactorDistancePlane_Params
{
    mat4 transform_local_to_gizmo;
    int falloff_curve_idx;
    int falloff_inverse;
    int domain_mirror;
    int domain_repeat;
    int influence_scope;
    int modifier_function;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct MaterialEval
{
    vec4 albedo;
    vec4 albedo_texture;
    vec3 emissive;
    vec3 emissive_texture;
    float roughness;
    float roughness_texture;
    float metalness;
    float metalness_texture;
    float transparency;
    vec3 normal;
    bool is_discarded;
    uint flag_overrides;
};

struct MaterialEvalInput
{
    vec2 uv0;
    vec3 normal;
    vec4 color;
    vec3 world_coords;
    vec3 local_coords;
    vec3 world_normal;
    vec3 local_normal;
    float modifier_factor;
    uint primitiveID;
};

struct _1328
{
    vec3 vCoords;
    vec3 vNorm;
    vec3 vWorldNorm;
    vec3 vLocalPos;
    vec3 vCameraRelativeWorldPos;
    vec4 vColor;
    vec2 vUV0;
};

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

layout(set = 1, binding = 1, std430) readonly buffer MaterialPropertiesDataBuffer
{
    MaterialPropertiesGPU material_properties[4096];
} materials;

layout(set = 1, binding = 2, std140) uniform BaseMaterialPropertiesBuffer
{
    vec4 colorDiffuse;
    int gUseDerivedNormal;
    int gMaterialMode;
    int materialId;
    int materialIndex;
    int componentTags;
} _1362;

layout(set = 1, binding = 3, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _1376;

layout(set = 1, binding = 4, std140) uniform VM0
{
    ModifierFactorQuantizePosition_Params VM0_params;
} _1515;

layout(set = 1, binding = 5, std140) uniform VM1
{
    layout(row_major) ModifierFactorNoise_Params VM1_params;
} _1530;

layout(set = 1, binding = 6, std140) uniform VM2
{
    ModifierFactorQuantizePosition_Params VM2_params;
} _1544;

layout(set = 1, binding = 7, std140) uniform VM3
{
    layout(row_major) ModifierFactorNoise_Params VM3_params;
} _1557;

layout(set = 1, binding = 8, std140) uniform VM4
{
    ModifierFactorClamp_Params VM4_params;
} _1571;

layout(set = 1, binding = 9, std140) uniform VM5
{
    layout(row_major) ModifierFactorDistancePlane_Params VM5_params;
} _1584;

layout(set = 1, binding = 10) uniform sampler2D s_NoiseRGBA;
layout(set = 1, binding = 11) uniform sampler2D s_Curves;
layout(set = 1, binding = 12) uniform sampler2D material_textures[128];

layout(location = 1) in _1328 vtx_input;
layout(location = 1) out uint outNormalMaterial;
layout(location = 0) out vec4 outAlbedo;
layout(location = 3) out vec4 outEmissive;
layout(location = 2) out uvec4 outMetalnessRoughnessMeterialTags;

vec3 getMaterialNormal(MaterialPropertiesGPU material, vec3 normal, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return normal;
}

bool getMaterialDiscard(MaterialPropertiesGPU material, vec3 worldCoords, vec3 localCoords, vec3 worldNormal, vec3 localNormal)
{
    return false;
}

uint octahedral_32(inout vec3 nor, uint sh)
{
    nor /= vec3((abs(nor.x) + abs(nor.y)) + abs(nor.z));
    float t = max(-nor.z, 0.0);
    float _206;
    if (nor.x > 0.0)
    {
        _206 = t;
    }
    else
    {
        _206 = -t;
    }
    nor.x += _206;
    float _221;
    if (nor.y > 0.0)
    {
        _221 = t;
    }
    else
    {
        _221 = -t;
    }
    nor.y += _221;
    vec2 v = (nor.xy * 0.5) + vec2(0.5);
    uint mu = (1u << sh) - 1u;
    uvec2 d = uvec2(floor((v * float(mu)) + vec2(0.5)));
    return (d.y << sh) | d.x;
}

uint encode_normal_material(vec3 n, int id)
{
    vec3 param = n;
    uint param_1 = 15u;
    uint _269 = octahedral_32(param, param_1);
    uint normal_material = _269;
    normal_material = (uint(id) << 31u) | normal_material;
    return normal_material;
}

ModifierFactor modifier_factor_defaults()
{
    ModifierFactor mf;
    mf.position = vec3(0.0);
    mf.normal = vec3(0.0, 1.0, 0.0);
    mf.uv0 = vec2(0.0);
    mf.custom0 = 0u;
    mf.custom1 = 0u;
    mf.color = vec4(1.0);
    mf.factor = 1.0;
    mf.id = 0u;
    mf.hash = 0u;
    mf.instance_id = 0u;
    mf.is_spawned = false;
    mf.is_discarded = false;
    mf.has_world_position = false;
    mf.world_position = vec3(0.0);
    return mf;
}

mat4 mat_identity()
{
    return mat4(vec4(1.0, 0.0, 0.0, 0.0), vec4(0.0, 1.0, 0.0, 0.0), vec4(0.0, 0.0, 1.0, 0.0), vec4(0.0, 0.0, 0.0, 1.0));
}

void modifier_factor_quantize_position(ModifierFactorQuantizePosition_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 p = modifier_factor.position;
    p = vec4(p, 1.0).xyz;
    p = (floor((p + modifier_params.offset) / modifier_params.quantization_step) * modifier_params.quantization_step) - modifier_params.offset;
    p = vec4(p, 1.0).xyz;
    if (modifier_params.quantize_x != 0)
    {
        modifier_factor.position.x = p.x;
    }
    if (modifier_params.quantize_y != 0)
    {
        modifier_factor.position.y = p.y;
    }
    if (modifier_params.quantize_z != 0)
    {
        modifier_factor.position.z = p.z;
    }
    if (modifier_factor.has_world_position)
    {
        vec3 p_1 = modifier_factor.world_position;
        p_1 = floor(p_1 / modifier_params.quantization_step) * modifier_params.quantization_step;
        if (modifier_params.quantize_x != 0)
        {
            modifier_factor.world_position.x = p_1.x;
        }
        if (modifier_params.quantize_y != 0)
        {
            modifier_factor.world_position.y = p_1.y;
        }
        if (modifier_params.quantize_z != 0)
        {
            modifier_factor.world_position.z = p_1.z;
        }
    }
}

vec3 vector_transform_by_mat43(vec3 v, inout mat4 m)
{
    m[0].w = 0.0;
    m[1].w = 0.0;
    m[2].w = 0.0;
    m[3].w = 1.0;
    return (m * vec4(v, 1.0)).xyz;
}

vec3 voronoise_random3f(vec3 p)
{
    return textureLod(s_NoiseRGBA, ((p.xy + (vec2(3.0, 1.0) * p.z)) + vec2(0.5)) / vec2(256.0), 0.0).xyz;
}

vec3 voronoise(vec3 x)
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    float id = 0.0;
    vec2 res = vec2(100.0);
    for (int k = -1; k <= 1; k++)
    {
        for (int j = -1; j <= 1; j++)
        {
            for (int i = -1; i <= 1; i++)
            {
                vec3 b = vec3(float(i), float(j), float(k));
                vec3 param = p + b;
                vec3 r = (vec3(b) - f) + voronoise_random3f(param);
                float d = dot(r, r);
                if (d < res.x)
                {
                    id = dot(p + b, vec3(1.0, 57.0, 113.0));
                    res = vec2(d, res.x);
                }
                else
                {
                    if (d < res.y)
                    {
                        res.y = d;
                    }
                }
            }
        }
    }
    return vec3((sqrt(res) * 2.0) - vec2(1.0), abs(id));
}

void modifier_process_modifier_factor(inout ModifierFactor modifier_factor, uint modifier_factor_function, float factor)
{
    if (modifier_factor_function == 0u)
    {
    }
    if (modifier_factor_function == 1u)
    {
        modifier_factor.factor = factor;
    }
    if (modifier_factor_function == 2u)
    {
        modifier_factor.factor += factor;
    }
    if (modifier_factor_function == 3u)
    {
        modifier_factor.factor -= factor;
    }
    if (modifier_factor_function == 4u)
    {
        modifier_factor.factor *= factor;
    }
}

void modifier_factor_noise_voronoi(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1121 = vector_transform_by_mat43(param, param_1);
        coords = _1121;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1128 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1128;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = voronoise(param_4).y;
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

vec3 mod289(vec3 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 mod289(vec4 x)
{
    return x - (floor(x * 0.00346020772121846675872802734375) * 289.0);
}

vec4 permute(vec4 x)
{
    vec4 param = ((x * 34.0) + vec4(1.0)) * x;
    return mod289(param);
}

vec4 taylorInvSqrt(vec4 r)
{
    return vec4(1.792842864990234375) - (r * 0.8537347316741943359375);
}

float snoise(vec3 v)
{
    vec3 i = floor(v + vec3(dot(v, vec3(0.3333333432674407958984375))));
    vec3 x0 = (v - i) + vec3(dot(i, vec3(0.16666667163372039794921875)));
    vec3 g = step(x0.yzx, x0);
    vec3 l = vec3(1.0) - g;
    vec3 i1 = min(g, l.zxy);
    vec3 i2 = max(g, l.zxy);
    vec3 x1 = (x0 - i1) + vec3(0.16666667163372039794921875);
    vec3 x2 = (x0 - i2) + vec3(0.3333333432674407958984375);
    vec3 x3 = x0 - vec3(0.5);
    vec3 param = i;
    i = mod289(param);
    vec4 param_1 = vec4(i.z) + vec4(0.0, i1.z, i2.z, 1.0);
    vec4 param_2 = (permute(param_1) + vec4(i.y)) + vec4(0.0, i1.y, i2.y, 1.0);
    vec4 param_3 = (permute(param_2) + vec4(i.x)) + vec4(0.0, i1.x, i2.x, 1.0);
    vec4 p = permute(param_3);
    float n_ = 0.14285714924335479736328125;
    vec3 ns = (vec3(2.0, 0.5, 1.0) * n_) - vec3(0.0, 1.0, 0.0);
    vec4 j = p - (floor((p * ns.z) * ns.z) * 49.0);
    vec4 x_ = floor(j * ns.z);
    vec4 y_ = floor(j - (x_ * 7.0));
    vec4 x = (x_ * ns.x) + ns.yyyy;
    vec4 y = (y_ * ns.x) + ns.yyyy;
    vec4 h = (vec4(1.0) - abs(x)) - abs(y);
    vec4 b0 = vec4(x.xy, y.xy);
    vec4 b1 = vec4(x.zw, y.zw);
    vec4 s0 = (floor(b0) * 2.0) + vec4(1.0);
    vec4 s1 = (floor(b1) * 2.0) + vec4(1.0);
    vec4 sh = -step(h, vec4(0.0));
    vec4 a0 = b0.xzyw + (s0.xzyw * sh.xxyy);
    vec4 a1 = b1.xzyw + (s1.xzyw * sh.zzww);
    vec3 p0 = vec3(a0.xy, h.x);
    vec3 p1 = vec3(a0.zw, h.y);
    vec3 p2 = vec3(a1.xy, h.z);
    vec3 p3 = vec3(a1.zw, h.w);
    vec4 param_4 = vec4(dot(p0, p0), dot(p1, p1), dot(p2, p2), dot(p3, p3));
    vec4 norm = taylorInvSqrt(param_4);
    p0 *= norm.x;
    p1 *= norm.y;
    p2 *= norm.z;
    p3 *= norm.w;
    vec4 m = max(vec4(0.5) - vec4(dot(x0, x0), dot(x1, x1), dot(x2, x2), dot(x3, x3)), vec4(0.0));
    m *= m;
    return 105.0 * dot(m * m, vec4(dot(p0, x0), dot(p1, x1), dot(p2, x2), dot(p3, x3)));
}

void modifier_factor_noise_default(ModifierFactorNoise_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1072 = vector_transform_by_mat43(param, param_1);
        coords = _1072;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1079 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1079;
    vec3 instance_position = rel_coords;
    vec3 param_4 = (instance_position * modifier_params.noise_domain_scale) + modifier_params.noise_domain_offset;
    float v = snoise(param_4);
    v = (v * modifier_params.noise_value_scale) + modifier_params.noise_value_offset;
    ModifierFactor param_5 = modifier_factor;
    uint param_6 = modifier_params.modifier_function;
    float param_7 = v;
    modifier_process_modifier_factor(param_5, param_6, param_7);
    modifier_factor = param_5;
}

void modifier_factor_clamp(ModifierFactorClamp_Params modifier_params, inout ModifierFactor modifier_factor)
{
    float v = modifier_factor.factor;
    if (modifier_params.clamp_min_enable != 0)
    {
        v = max(v, modifier_params.clamp_min);
    }
    if (modifier_params.clamp_max_enable != 0)
    {
        v = min(v, modifier_params.clamp_max);
    }
    modifier_factor.factor = v;
}

float curve_sample(int idx, float t)
{
    return textureLod(s_Curves, vec2(t, (float(idx) + 0.5) / 256.0), 0.0).x;
}

void modifier_factor_distance_plane(ModifierFactorDistancePlane_Params modifier_params, inout ModifierFactor modifier_factor, CoordinateSystemTrasforms cs_transforms)
{
    vec3 coords = modifier_factor.position;
    if (modifier_params.influence_scope == 1)
    {
        vec3 param = coords;
        mat4 param_1 = cs_transforms.mat_local_to_instance;
        vec3 _1209 = vector_transform_by_mat43(param, param_1);
        coords = _1209;
    }
    vec3 param_2 = coords;
    mat4 param_3 = modifier_params.transform_local_to_gizmo;
    vec3 _1216 = vector_transform_by_mat43(param_2, param_3);
    vec3 rel_coords = _1216;
    float influence = rel_coords.z;
    if (modifier_params.domain_mirror != 0)
    {
        influence = abs(influence);
    }
    if (modifier_params.domain_repeat != 0)
    {
        influence = fract(influence);
    }
    influence = clamp(influence, 0.0, 1.0);
    if (modifier_params.falloff_inverse != 0)
    {
        influence = 1.0 - influence;
    }
    int param_4 = modifier_params.falloff_curve_idx;
    float param_5 = influence;
    influence = curve_sample(param_4, param_5);
    float v = influence;
    ModifierFactor param_6 = modifier_factor;
    uint param_7 = uint(modifier_params.modifier_function);
    float param_8 = v;
    modifier_process_modifier_factor(param_6, param_7, param_8);
    modifier_factor = param_6;
}

vec4 mapping_triplanar(sampler2D smpl, vec3 p, vec3 n, vec3 scale)
{
    vec3 coords = p;
    vec3 blending = abs(n);
    blending = normalize(max(blending, vec3(9.9999997473787516355514526367188e-06)));
    float b = (blending.x + blending.y) + blending.z;
    blending /= vec3(b);
    vec4 xaxis = texture(smpl, coords.yz * scale.yz);
    vec4 yaxis = texture(smpl, coords.xz * scale.xz);
    vec4 zaxis = texture(smpl, coords.xy * scale.xy);
    vec4 tex = ((xaxis * blending.x) + (yaxis * blending.y)) + (zaxis * blending.z);
    return tex;
}

void material_evaluate_sample_textures(MaterialPropertiesGPU material, inout MaterialEval material_eval, MaterialEvalInput eval_input)
{
    vec2 uv0 = eval_input.uv0;
    vec3 norm = eval_input.normal;
    bool _1304 = material.emissive_sampler >= 0;
    bool _1311;
    if (_1304)
    {
        _1311 = material.emissive_sampler < 16;
    }
    else
    {
        _1311 = _1304;
    }
    if (_1311)
    {
        if ((material.flags & 1024u) != 0u)
        {
            vec3 param = vtx_input.vLocalPos;
            vec3 param_1 = norm;
            vec3 param_2 = material.triplanar_factor;
            material_eval.emissive_texture = mapping_triplanar(material_textures[material.emissive_sampler], param, param_1, param_2).xyz;
        }
        else
        {
            material_eval.emissive_texture = texture(material_textures[material.emissive_sampler], uv0).xyz;
        }
    }
}

void material_evaluate(MaterialPropertiesGPU material, inout MaterialEval eval, inout MaterialEvalInput eval_input)
{
    MaterialPropertiesGPU param = material;
    MaterialEval param_1 = eval;
    MaterialEvalInput param_2 = eval_input;
    material_evaluate_sample_textures(param, param_1, param_2);
    eval = param_1;
    eval_input = param_2;
    vec4 _1275 = eval.albedo;
    vec3 _1277 = _1275.xyz * eval_input.color.xyz;
    eval.albedo.x = _1277.x;
    eval.albedo.y = _1277.y;
    eval.albedo.z = _1277.z;
    if (eval_input.modifier_factor < 0.5)
    {
        eval.is_discarded = true;
    }
}

uvec2 encode_metalness_roughness_material(float metalness, float roughness, uint material)
{
    return uvec2((uint(min(1.0, metalness) * 255.0) << uint(8)) | (uint(min(1.0, roughness) * 255.0) << uint(0)), material);
}

uint encode_component_tags(uint component_tags)
{
    return component_tags & 65535u;
}

uvec4 encode_metalness_roughness_material_tags(MetalnessRoughnessMeterialTags v)
{
    float param = v.metalness;
    float param_1 = v.roughness;
    uint param_2 = v.material_index;
    uvec2 _316 = encode_metalness_roughness_material(param, param_1, param_2);
    uvec4 o;
    o.x = _316.x;
    o.y = _316.y;
    uint param_3 = v.component_tags;
    o.z = encode_component_tags(param_3);
    o.w = v.material_flag_overrides;
    return o;
}

void main()
{
    MaterialPropertiesGPU _1369;
    _1369.diffuse = materials.material_properties[_1362.materialIndex].diffuse;
    _1369.transparency = materials.material_properties[_1362.materialIndex].transparency;
    _1369.emissive = materials.material_properties[_1362.materialIndex].emissive;
    _1369.roughness = materials.material_properties[_1362.materialIndex].roughness;
    _1369.triplanar_factor = materials.material_properties[_1362.materialIndex].triplanar_factor;
    _1369.refraction = materials.material_properties[_1362.materialIndex].refraction;
    _1369.normal_factor = materials.material_properties[_1362.materialIndex].normal_factor;
    _1369.emissive_factor = materials.material_properties[_1362.materialIndex].emissive_factor;
    _1369.temporal_accumulation_factor = materials.material_properties[_1362.materialIndex].temporal_accumulation_factor;
    _1369.shadowmap_bias = materials.material_properties[_1362.materialIndex].shadowmap_bias;
    _1369.metalness = materials.material_properties[_1362.materialIndex].metalness;
    _1369.albedo_sampler = materials.material_properties[_1362.materialIndex].albedo_sampler;
    _1369.emissive_sampler = materials.material_properties[_1362.materialIndex].emissive_sampler;
    _1369.normal_sampler = materials.material_properties[_1362.materialIndex].normal_sampler;
    _1369.metalic_roughness_sampler = materials.material_properties[_1362.materialIndex].metalic_roughness_sampler;
    _1369.flags = materials.material_properties[_1362.materialIndex].flags;
    _1369._pad0 = materials.material_properties[_1362.materialIndex]._pad0;
    _1369._pad1 = materials.material_properties[_1362.materialIndex]._pad1;
    MaterialPropertiesGPU material = _1369;
    vec3 worldPos = vtx_input.vCameraRelativeWorldPos + _1376.transform_params.vCameraPosition;
    float g = (vtx_input.vNorm.z * 0.5) + 0.5;
    vec3 worldNorm = vtx_input.vWorldNorm;
    vec3 norm = vtx_input.vNorm;
    if ((material.flags & 128u) != 0u)
    {
        vec3 dFdxPos = dFdxFine(vtx_input.vCameraRelativeWorldPos);
        vec3 dFdyPos = dFdyFine(vtx_input.vCameraRelativeWorldPos);
        worldNorm = cross(dFdyPos, dFdxPos);
        dFdxPos = dFdxFine(vtx_input.vLocalPos);
        dFdyPos = dFdyFine(vtx_input.vLocalPos);
        norm = cross(dFdyPos, dFdxPos);
        worldNorm = -worldNorm;
        norm = -norm;
    }
    else
    {
        if (gl_FrontFacing)
        {
            worldNorm = -worldNorm;
            norm = -norm;
        }
    }
    worldNorm = normalize(worldNorm);
    norm = normalize(norm);
    vec3 normal = worldNorm;
    MaterialPropertiesGPU param = material;
    vec3 param_1 = normal;
    vec3 param_2 = worldPos;
    vec3 param_3 = vtx_input.vLocalPos;
    vec3 param_4 = vtx_input.vNorm;
    vec3 param_5 = vtx_input.vWorldNorm;
    normal = getMaterialNormal(param, param_1, param_2, param_3, param_4, param_5);
    MaterialPropertiesGPU param_6 = material;
    vec3 param_7 = worldPos;
    vec3 param_8 = vtx_input.vLocalPos;
    vec3 param_9 = vtx_input.vNorm;
    vec3 param_10 = vtx_input.vWorldNorm;
    bool to_discard = getMaterialDiscard(param_6, param_7, param_8, param_9, param_10);
    if (to_discard)
    {
        discard;
    }
    vec2 uv0 = vtx_input.vUV0;
    uint material_flag_overrides = 0u;
    vec3 param_11 = normal;
    int param_12 = _1362.materialId;
    outNormalMaterial = encode_normal_material(param_11, param_12);
    float factor = 1.0;
    ModifierFactor modifier_factor = modifier_factor_defaults();
    modifier_factor.factor = 1.0;
    modifier_factor.hash = 0u;
    modifier_factor.id = 0u;
    modifier_factor.instance_id = 0u;
    modifier_factor.position = vtx_input.vLocalPos;
    modifier_factor.is_spawned = false;
    modifier_factor.has_world_position = true;
    modifier_factor.world_position = worldPos;
    CoordinateSystemTrasforms cs_transforms;
    cs_transforms.mat_local_to_model = _1376.transform_params.mModel;
    cs_transforms.mat_local_to_instance = mat_identity();
    cs_transforms.mat_local_to_model_inv = _1376.transform_params.mModelInv;
    ModifierFactorQuantizePosition_Params _1520;
    _1520.quantization_step = _1515.VM0_params.quantization_step;
    _1520._pad0 = _1515.VM0_params._pad0;
    _1520.offset = _1515.VM0_params.offset;
    _1520.quantize_x = _1515.VM0_params.quantize_x;
    _1520.quantize_y = _1515.VM0_params.quantize_y;
    _1520.quantize_z = _1515.VM0_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_13 = _1520;
    ModifierFactor param_14 = modifier_factor;
    CoordinateSystemTrasforms param_15 = cs_transforms;
    modifier_factor_quantize_position(param_13, param_14, param_15);
    modifier_factor = param_14;
    ModifierFactorNoise_Params _1535;
    _1535.transform_local_to_gizmo = _1530.VM1_params.transform_local_to_gizmo;
    _1535.noise_domain_scale = _1530.VM1_params.noise_domain_scale;
    _1535.modifier_function = _1530.VM1_params.modifier_function;
    _1535.noise_domain_offset = _1530.VM1_params.noise_domain_offset;
    _1535.noise_value_scale = _1530.VM1_params.noise_value_scale;
    _1535.noise_value_offset = _1530.VM1_params.noise_value_offset;
    _1535.influence_scope = _1530.VM1_params.influence_scope;
    _1535._pad0 = _1530.VM1_params._pad0;
    _1535._pad1 = _1530.VM1_params._pad1;
    ModifierFactorNoise_Params param_16 = _1535;
    ModifierFactor param_17 = modifier_factor;
    CoordinateSystemTrasforms param_18 = cs_transforms;
    modifier_factor_noise_voronoi(param_16, param_17, param_18);
    modifier_factor = param_17;
    ModifierFactorQuantizePosition_Params _1548;
    _1548.quantization_step = _1544.VM2_params.quantization_step;
    _1548._pad0 = _1544.VM2_params._pad0;
    _1548.offset = _1544.VM2_params.offset;
    _1548.quantize_x = _1544.VM2_params.quantize_x;
    _1548.quantize_y = _1544.VM2_params.quantize_y;
    _1548.quantize_z = _1544.VM2_params.quantize_z;
    ModifierFactorQuantizePosition_Params param_19 = _1548;
    ModifierFactor param_20 = modifier_factor;
    CoordinateSystemTrasforms param_21 = cs_transforms;
    modifier_factor_quantize_position(param_19, param_20, param_21);
    modifier_factor = param_20;
    ModifierFactorNoise_Params _1561;
    _1561.transform_local_to_gizmo = _1557.VM3_params.transform_local_to_gizmo;
    _1561.noise_domain_scale = _1557.VM3_params.noise_domain_scale;
    _1561.modifier_function = _1557.VM3_params.modifier_function;
    _1561.noise_domain_offset = _1557.VM3_params.noise_domain_offset;
    _1561.noise_value_scale = _1557.VM3_params.noise_value_scale;
    _1561.noise_value_offset = _1557.VM3_params.noise_value_offset;
    _1561.influence_scope = _1557.VM3_params.influence_scope;
    _1561._pad0 = _1557.VM3_params._pad0;
    _1561._pad1 = _1557.VM3_params._pad1;
    ModifierFactorNoise_Params param_22 = _1561;
    ModifierFactor param_23 = modifier_factor;
    CoordinateSystemTrasforms param_24 = cs_transforms;
    modifier_factor_noise_default(param_22, param_23, param_24);
    modifier_factor = param_23;
    ModifierFactorClamp_Params _1576;
    _1576.clamp_min = _1571.VM4_params.clamp_min;
    _1576.clamp_max = _1571.VM4_params.clamp_max;
    _1576.clamp_min_enable = _1571.VM4_params.clamp_min_enable;
    _1576.clamp_max_enable = _1571.VM4_params.clamp_max_enable;
    ModifierFactorClamp_Params param_25 = _1576;
    ModifierFactor param_26 = modifier_factor;
    modifier_factor_clamp(param_25, param_26);
    modifier_factor = param_26;
    ModifierFactorDistancePlane_Params _1589;
    _1589.transform_local_to_gizmo = _1584.VM5_params.transform_local_to_gizmo;
    _1589.falloff_curve_idx = _1584.VM5_params.falloff_curve_idx;
    _1589.falloff_inverse = _1584.VM5_params.falloff_inverse;
    _1589.domain_mirror = _1584.VM5_params.domain_mirror;
    _1589.domain_repeat = _1584.VM5_params.domain_repeat;
    _1589.influence_scope = _1584.VM5_params.influence_scope;
    _1589.modifier_function = _1584.VM5_params.modifier_function;
    ModifierFactorDistancePlane_Params param_27 = _1589;
    ModifierFactor param_28 = modifier_factor;
    CoordinateSystemTrasforms param_29 = cs_transforms;
    modifier_factor_distance_plane(param_27, param_28, param_29);
    modifier_factor = param_28;
    factor = modifier_factor.factor;
    MaterialEval material_eval;
    material_eval.albedo = vec4(material.diffuse, _1362.colorDiffuse.w);
    material_eval.emissive = vec3(0.0);
    material_eval.roughness = material.roughness;
    material_eval.metalness = material.metalness;
    material_eval.transparency = material.transparency;
    material_eval.is_discarded = false;
    material_eval.normal = normal;
    material_eval.albedo_texture = vec4(1.0);
    material_eval.emissive_texture = vec3(1.0);
    material_eval.roughness_texture = 1.0;
    material_eval.metalness_texture = 1.0;
    material_eval.flag_overrides = 0u;
    MaterialEvalInput eval_input;
    eval_input.uv0 = uv0;
    eval_input.normal = norm;
    eval_input.color = vtx_input.vColor;
    eval_input.world_coords = worldPos;
    eval_input.local_coords = vtx_input.vLocalPos;
    eval_input.world_normal = vtx_input.vWorldNorm;
    eval_input.local_normal = vtx_input.vNorm;
    eval_input.modifier_factor = factor;
    eval_input.primitiveID = uint(gl_PrimitiveID);
    MaterialPropertiesGPU param_30 = material;
    MaterialEval param_31 = material_eval;
    MaterialEvalInput param_32 = eval_input;
    material_evaluate(param_30, param_31, param_32);
    material_eval = param_31;
    eval_input = param_32;
    if ((material_eval.flag_overrides & 2u) != 0u)
    {
        material_flag_overrides = material_eval.flag_overrides;
    }
    if (material_eval.is_discarded)
    {
        discard;
    }
    outAlbedo = material_eval.albedo * material_eval.albedo_texture;
    vec3 _1690 = material_eval.emissive * material_eval.emissive_texture;
    outEmissive.x = _1690.x;
    outEmissive.y = _1690.y;
    outEmissive.z = _1690.z;
    outEmissive.w = material_eval.transparency;
    float roughness = material_eval.roughness * material_eval.roughness_texture;
    float metalness = material_eval.metalness * material_eval.metalness_texture;
    MetalnessRoughnessMeterialTags metalness_roughness_material_tags;
    metalness_roughness_material_tags.metalness = metalness;
    metalness_roughness_material_tags.roughness = roughness;
    metalness_roughness_material_tags.material_index = uint(_1362.materialIndex);
    metalness_roughness_material_tags.component_tags = uint(_1362.componentTags);
    metalness_roughness_material_tags.material_flag_overrides = material_flag_overrides;
    MetalnessRoughnessMeterialTags param_33 = metalness_roughness_material_tags;
    outMetalnessRoughnessMeterialTags = encode_metalness_roughness_material_tags(param_33);
}

 