#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#if defined(GL_ARB_gpu_shader_int64)
#extension GL_ARB_gpu_shader_int64 : require
#else
#error No extension available for 64-bit integers.
#endif
#extension GL_EXT_buffer_reference2 : require

struct PartitionGeometryDrawParams
{
    uint64_t buff_grid_markers_ptr;
    uint instance_idx;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(buffer_reference) buffer RT_BuffPointerToU32;
layout(buffer_reference, buffer_reference_align = 4, std430) buffer RT_BuffPointerToU32
{
    uint v;
};

layout(set = 1, binding = 1, std430) buffer FacesLinkedListTailsBuffer
{
    uint in_faces_list_tails_data[];
} _81;

layout(set = 1, binding = 2, std430) buffer FacesLinkedListBuffer
{
    uint buffer_counter;
    uint occupied_cell_counter;
    uint _pad0;
    uint _pad1;
    uint _pad2;
    uint _pad3;
    uint _pad4;
    uint _pad5;
    uint node_buffer[];
} in_faces_list_data;

layout(set = 1, binding = 3, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _234;

layout(set = 1, binding = 4, std430) buffer BBoxBuffer
{
    vec4 grid_size_raytrace;
    vec4 grid_size_raytrace_recip;
    vec4 grid_size_voxelize;
    vec4 grid_size_voxelize_recip;
    vec4 grid_size_combined;
    vec4 grid_shift_raytrace;
    vec4 grid_shift_voxelize;
    vec4 grid_shift_combined;
    vec4 bbox_raytrace_min;
    vec4 bbox_raytrace_max;
    vec4 bbox_voxelize_min;
    vec4 bbox_voxelize_max;
    vec4 bbox_combined_min;
    vec4 bbox_combined_max;
} in_bbox_data;

layout(set = 1, binding = 5, std140) uniform PartitionGeometryDrawParamsBuffer
{
    PartitionGeometryDrawParams partition_geometry_params;
} _1264;

layout(location = 0) flat in int vOrientationIndex;
layout(location = 5) flat in uint vTriIndex[3];

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_234.in_vtx_data[coord_offset + 0u], _234.in_vtx_data[coord_offset + 1u], _234.in_vtx_data[coord_offset + 2u]);
    return p;
}

uint build_step_dir()
{
    if (vOrientationIndex == 0)
    {
        return 1u;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            return 2u;
        }
        else
        {
            return 4u;
        }
    }
}

ivec3 unpack_step_dir(uint step_dir)
{
    return ivec3(int((step_dir & 1u) != 0u), int((step_dir & 2u) != 0u), int((step_dir & 4u) != 0u));
}

int planeBoxOverlap(vec3 normal, vec3 vert, vec3 maxbox)
{
    vec3 s = step(vec3(0.0), normal);
    vec3 sgn = (s * 2.0) - vec3(1.0);
    vec3 vmin = ((-sgn) * maxbox) - vert;
    vec3 vmax = (sgn * maxbox) - vert;
    if (dot(normal, vmin) > 0.0)
    {
        return 0;
    }
    if (dot(normal, vmax) >= 0.0)
    {
        return 1;
    }
    return 0;
}

int triBoxOverlap(vec3 boxcenter, vec3 boxhalfsize, vec3 tv0, vec3 tv1, vec3 tv2, vec3 normal)
{
    vec3 v0 = tv0 - boxcenter;
    vec3 v1 = tv1 - boxcenter;
    vec3 v2 = tv2 - boxcenter;
    vec3 e0 = v1 - v0;
    vec3 e1 = v2 - v1;
    vec3 e2 = v0 - v2;
    float fex = abs(e0.x);
    float fey = abs(e0.y);
    float fez = abs(e0.z);
    float p0 = (e0.z * v0.y) - (e0.y * v0.z);
    float p2 = (e0.z * v2.y) - (e0.y * v2.z);
    float mi;
    float ma;
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    float rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _379 = mi > rad;
    bool _387;
    if (!_379)
    {
        _387 = ma < (-rad);
    }
    else
    {
        _387 = _379;
    }
    if (_387)
    {
        return 0;
    }
    p0 = ((-e0.z) * v0.x) + (e0.x * v0.z);
    p2 = ((-e0.z) * v2.x) + (e0.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _436 = mi > rad;
    bool _444;
    if (!_436)
    {
        _444 = ma < (-rad);
    }
    else
    {
        _444 = _436;
    }
    if (_444)
    {
        return 0;
    }
    float p1 = (e0.y * v1.x) - (e0.x * v1.y);
    p2 = (e0.y * v2.x) - (e0.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _492 = mi > rad;
    bool _500;
    if (!_492)
    {
        _500 = ma < (-rad);
    }
    else
    {
        _500 = _492;
    }
    if (_500)
    {
        return 0;
    }
    fex = abs(e1.x);
    fey = abs(e1.y);
    fez = abs(e1.z);
    p0 = (e1.z * v0.y) - (e1.y * v0.z);
    p2 = (e1.z * v2.y) - (e1.y * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _556 = mi > rad;
    bool _564;
    if (!_556)
    {
        _564 = ma < (-rad);
    }
    else
    {
        _564 = _556;
    }
    if (_564)
    {
        return 0;
    }
    p0 = ((-e1.z) * v0.x) + (e1.x * v0.z);
    p2 = ((-e1.z) * v2.x) + (e1.x * v2.z);
    if (p0 < p2)
    {
        mi = p0;
        ma = p2;
    }
    else
    {
        mi = p2;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _613 = mi > rad;
    bool _621;
    if (!_613)
    {
        _621 = ma < (-rad);
    }
    else
    {
        _621 = _613;
    }
    if (_621)
    {
        return 0;
    }
    p0 = (e1.y * v0.x) - (e1.x * v0.y);
    p1 = (e1.y * v1.x) - (e1.x * v1.y);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _668 = mi > rad;
    bool _676;
    if (!_668)
    {
        _676 = ma < (-rad);
    }
    else
    {
        _676 = _668;
    }
    if (_676)
    {
        return 0;
    }
    fex = abs(e2.x);
    fey = abs(e2.y);
    fez = abs(e2.z);
    p0 = (e2.z * v0.y) - (e2.y * v0.z);
    p1 = (e2.z * v1.y) - (e2.y * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.y) + (fey * boxhalfsize.z);
    bool _732 = mi > rad;
    bool _740;
    if (!_732)
    {
        _740 = ma < (-rad);
    }
    else
    {
        _740 = _732;
    }
    if (_740)
    {
        return 0;
    }
    p0 = ((-e2.z) * v0.x) + (e2.x * v0.z);
    p1 = ((-e2.z) * v1.x) + (e2.x * v1.z);
    if (p0 < p1)
    {
        mi = p0;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p0;
    }
    rad = (fez * boxhalfsize.x) + (fex * boxhalfsize.z);
    bool _789 = mi > rad;
    bool _797;
    if (!_789)
    {
        _797 = ma < (-rad);
    }
    else
    {
        _797 = _789;
    }
    if (_797)
    {
        return 0;
    }
    p1 = (e2.y * v1.x) - (e2.x * v1.y);
    p2 = (e2.y * v2.x) - (e2.x * v2.y);
    if (p2 < p1)
    {
        mi = p2;
        ma = p1;
    }
    else
    {
        mi = p1;
        ma = p2;
    }
    rad = (fey * boxhalfsize.x) + (fex * boxhalfsize.y);
    bool _844 = mi > rad;
    bool _852;
    if (!_844)
    {
        _852 = ma < (-rad);
    }
    else
    {
        _852 = _844;
    }
    if (_852)
    {
        return 0;
    }
    vec3 mi3 = min(v0, min(v1, v2));
    vec3 ma3 = max(v0, max(v1, v2));
    bool _874 = any(greaterThan(mi3, boxhalfsize));
    bool _883;
    if (!_874)
    {
        _883 = any(lessThan(ma3, -boxhalfsize));
    }
    else
    {
        _883 = _874;
    }
    bool no_overlap = _883;
    if (no_overlap)
    {
        return 0;
    }
    vec3 param = normal;
    vec3 param_1 = v0;
    vec3 param_2 = boxhalfsize;
    return planeBoxOverlap(param, param_1, param_2);
}

bool checkTriCellOverlap(vec3 p0, vec3 p1, vec3 p2, vec3 normal, vec3 ccenter, vec3 csize)
{
    vec3 param = ccenter;
    vec3 param_1 = csize;
    vec3 param_2 = p0;
    vec3 param_3 = p1;
    vec3 param_4 = p2;
    vec3 param_5 = normal;
    return triBoxOverlap(param, param_1, param_2, param_3, param_4, param_5) != 0;
}

void rt_link_list_push_value(uint list_index, uint value)
{
    uint head = _81.in_faces_list_tails_data[list_index];
    uint _97 = atomicAdd(in_faces_list_data.node_buffer[head], 1u);
    uint cntr = _97;
    in_faces_list_data.node_buffer[(head + cntr) + 1u] = value;
}

bool _rt_grid_marker_validate(uint64_t markers_ptr)
{
    return true;
}

void rt_pack_grid_marker_to_uint_buff(uvec3 p, uint grid_res, out uint p_packed, out uint bit)
{
    uvec3 p_low_bits = p & uvec3(3u, 3u, 1u);
    uvec3 p_high_bits = uvec3(p.x >> uint(2), p.y >> uint(2), p.z >> uint(1));
    uint high_linearized = (p_high_bits.x + (p_high_bits.y * (grid_res / 4u))) + ((p_high_bits.z * (grid_res / 4u)) * (grid_res / 4u));
    p_packed = high_linearized;
    bit = (p_low_bits.x + (p_low_bits.y * 4u)) + ((p_low_bits.z * 4u) * 4u);
}

void _rt_write_grid_marker_low_res(uint64_t markers_ptr, ivec3 pos)
{
    uint64_t param = markers_ptr;
    if (_rt_grid_marker_validate(param) == false)
    {
        return;
    }
    uvec3 upos = uvec3(pos);
    bool _171 = upos.x >= 64u;
    bool _178;
    if (!_171)
    {
        _178 = upos.y >= 64u;
    }
    else
    {
        _178 = _171;
    }
    bool _185;
    if (!_178)
    {
        _185 = upos.z >= 64u;
    }
    else
    {
        _185 = _178;
    }
    if (_185)
    {
        return;
    }
    uvec3 param_1 = upos;
    uint param_2 = 64u;
    uint param_3;
    uint param_4;
    rt_pack_grid_marker_to_uint_buff(param_1, param_2, param_3, param_4);
    uint pos_packed = param_3;
    uint bit = param_4;
    RT_BuffPointerToU32 markers = RT_BuffPointerToU32((markers_ptr + uint64_t(pos_packed * 4u)) + 2097152ul);
    if ((markers.v & (1u << bit)) == 0u)
    {
        uint _225 = atomicOr(markers.v, 1u << bit);
    }
}

void main()
{
    vec3 bbox_origin = in_bbox_data.bbox_raytrace_min.xyz;
    vec3 bbox_grid_size = in_bbox_data.grid_size_raytrace.xyz;
    uint param = vTriIndex[0];
    vec3 vTriCoords[3];
    vTriCoords[0] = rt_get_vertex(param);
    uint param_1 = vTriIndex[1];
    vTriCoords[1] = rt_get_vertex(param_1);
    uint param_2 = vTriIndex[2];
    vTriCoords[2] = rt_get_vertex(param_2);
    vec3 s = -bbox_origin;
    vTriCoords[0] += s;
    vTriCoords[1] += s;
    vTriCoords[2] += s;
    vec3 f = vec3(1.0) / bbox_grid_size;
    vTriCoords[0] *= f;
    vTriCoords[1] *= f;
    vTriCoords[2] *= f;
    vec3 vTriNormal = normalize(cross(vTriCoords[1] - vTriCoords[0], vTriCoords[2] - vTriCoords[1]));
    vec3 gc = (gl_FragCoord.xyz / vec3(1.0, 1.0, 0.00390625)) + vec3(0.0);
    gc.y = 255.5 - gc.y;
    gc.z = (gc.z * 0.5) + 128.0;
    ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
    ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
    mi = clamp(mi, ivec3(0), ivec3(255));
    ma = clamp(ma, ivec3(0), ivec3(255));
    uint stepDir = 0u;
    uvec3 stepStart = uvec3(0u);
    uint cy;
    uint cz;
    uint cx;
    int steps;
    if (vOrientationIndex == 0)
    {
        cy = uint(gc.x);
        cz = uint(gc.y);
        cx = uint(gc.z);
        stepStart = uvec3(uint(mi.x), cy, cz);
        steps = ma.x - mi.x;
    }
    else
    {
        if (vOrientationIndex == 1)
        {
            cz = uint(gc.x);
            cx = uint(gc.y);
            cy = uint(gc.z);
            stepStart = uvec3(cx, uint(mi.y), cz);
            steps = ma.y - mi.y;
        }
        else
        {
            cx = uint(gc.x);
            cy = uint(gc.y);
            cz = uint(gc.z);
            stepStart = uvec3(cx, cy, uint(mi.z));
            steps = ma.z - mi.z;
        }
    }
    stepDir = build_step_dir();
    int stepMin = -1;
    int stepCount = 0;
    for (int s_1 = 0; s_1 < steps; s_1++)
    {
        uint param_3 = stepDir;
        vec3 cellPos = vec3(stepStart + uvec3(unpack_step_dir(param_3) * ivec3(s_1)));
        vec3 cellSize = vec3(1.0);
        vec3 param_4 = vTriCoords[0];
        vec3 param_5 = vTriCoords[1];
        vec3 param_6 = vTriCoords[2];
        vec3 param_7 = vTriNormal;
        vec3 param_8 = cellPos + (cellSize * 0.5);
        vec3 param_9 = cellSize * 0.5;
        if (checkTriCellOverlap(param_4, param_5, param_6, param_7, param_8, param_9))
        {
            if (stepMin == (-1))
            {
                stepMin = s_1;
            }
            stepCount++;
        }
    }
    if (stepCount == 0)
    {
        return;
    }
    uint param_10 = stepDir;
    stepStart += uvec3(unpack_step_dir(param_10) * ivec3(stepMin));
    for (;;)
    {
        int _1232 = stepCount;
        int _1233 = _1232 - 1;
        stepCount = _1233;
        if (_1232 > 0)
        {
            uint ccx = stepStart.x;
            uint ccy = stepStart.y;
            uint ccz = stepStart.z;
            uint list_index = (ccx + (ccy * 256u)) + ((ccz * 256u) * 256u);
            uint param_11 = list_index;
            uint param_12 = uint(gl_PrimitiveID);
            rt_link_list_push_value(param_11, param_12);
            uint64_t param_13 = _1264.partition_geometry_params.buff_grid_markers_ptr;
            ivec3 param_14 = ivec3(int(ccx), int(ccy), int(ccz)) >> ivec3(2);
            _rt_write_grid_marker_low_res(param_13, param_14);
            uint param_15 = stepDir;
            stepStart += uvec3(unpack_step_dir(param_15));
            continue;
        }
        else
        {
            break;
        }
    }
}

 