#version 460
#extension GL_EXT_shader_atomic_int64 : require
#extension GL_EXT_shader_explicit_arithmetic_types_int64 : require
#extension GL_EXT_scalar_block_layout : require
#if defined(GL_EXT_control_flow_attributes)
#extension GL_EXT_control_flow_attributes : require
#define SPIRV_CROSS_FLATTEN [[flatten]]
#define SPIRV_CROSS_BRANCH [[dont_flatten]]
#define SPIRV_CROSS_UNROLL [[unroll]]
#define SPIRV_CROSS_LOOP [[dont_unroll]]
#else
#define SPIRV_CROSS_FLATTEN
#define SPIRV_CROSS_BRANCH
#define SPIRV_CROSS_UNROLL
#define SPIRV_CROSS_LOOP
#endif
#extension GL_EXT_buffer_reference2 : require

struct EntityTransformParams
{
    mat4 mModel;
    mat4 mView;
    mat4 mModelNormal;
    mat4 mModelView;
    mat4 mModelViewInvTrans;
    mat4 mProjection;
    mat4 mModelInv;
    mat4 mViewInv;
    float tesselationMaxFactor;
    float tesselationMaxDistance;
    float tesselationMinArea;
    float tesselationAreaFactor;
    vec3 vCameraPosition;
    float _pad2;
};

struct MaterialPropertiesGPU
{
    vec3 diffuse;
    float transparency;
    vec3 emissive;
    float roughness;
    vec3 triplanar_factor;
    float refraction;
    float normal_factor;
    float emissive_factor;
    float temporal_accumulation_factor;
    float shadowmap_bias;
    float metalness;
    int albedo_sampler;
    int emissive_sampler;
    int normal_sampler;
    int metalic_roughness_sampler;
    uint flags;
    uint _pad0;
    uint _pad1;
};

struct LightProperties
{
    vec4 diffuse;
    vec3 direction;
    vec3 position;
    vec3 up;
    vec3 right;
    vec2 dimensions;
    uint lighting_exclusion_tags;
    float intensity;
    float range;
    float cutoff;
    float roughness_modifier;
    int is_area;
    int type;
    int projector_sampler;
    float projector_intensity;
    int downsampled_shadowmap_sampler;
    int shadowmap_sampler0;
    int shadowmap_sampler1;
    int shadowmap_sampler2;
    int shadowmap_sampler3;
    float cascade_distance0;
    float cascade_distance1;
    float cascade_distance2;
    float cascade_distance3;
    float angular_falloff_power;
    int angular_falloff_color_gradient_idx;
    mat4 mat_shadow_mv;
    mat4 mat_shadow_p[4];
    mat4 mat_shadow_mvp[4];
};

struct GeometryInformationAttribute
{
    uint offset;
    uint stride;
    uint _pad0;
    uint _pad1;
};

struct GeometryInformation
{
    uint vtx_num;
    uint surfaces_num;
    uint builtin_attribute_mask;
    uint flipbook_cards_num;
    uint idx_buffer_offset;
    uint is_gpu_allocated;
    uint gpu_memory_allocation_size;
    uint gpu_memory_allocation_size_total;
    uint aux_tracking_0;
    uint aux_tracking_1;
    uint aux_tracking_2;
    uint aux_tracking_3;
    GeometryInformationAttribute attributes[8];
    uint faces_num_per_surface[64];
};

struct GlobalVariables
{
    float time;
    float global_time;
    float time_step;
    int monotonic;
};

struct TransformedDataLocation
{
    uint surface_idx;
    uint last_face_idx;
    uint last_vtx_idx;
    uint material_idx;
    uint raytrace;
    uint voxelize;
    uint _pad0;
    uint _pad1;
    ivec4 bbox_min;
    ivec4 bbox_max;
};

struct TransformedDataFace
{
    uint material_idx;
};

layout(set = 0, binding = 1, std430) readonly buffer InVertexBuffer
{
    float in_vtx_data[];
} _50;

layout(set = 0, binding = 2, std140) uniform TransformParamsBuffer
{
    layout(row_major) EntityTransformParams transform_params;
} _164;

layout(location = 0) out uint instanceID;
layout(location = 1) out Vertex
{
    vec3 vLocalPos;
    uint vIdx;
} vtx_output;


uint rt_mask_vtx_idx(uint vtx_idx)
{
    return vtx_idx & 16777215u;
}

vec3 rt_get_vertex(uint idx)
{
    uint coord_offset = (idx * 3u) + 0u;
    vec3 p = vec3(_50.in_vtx_data[coord_offset + 0u], _50.in_vtx_data[coord_offset + 1u], _50.in_vtx_data[coord_offset + 2u]);
    return p;
}

vec3 get_vertex(uint idx)
{
    uint param = idx;
    return rt_get_vertex(param);
}

uint asuint(float v)
{
    return floatBitsToUint(v);
}

vec3 rt_get_vertex_normal(uint idx)
{
    uint normal_offset = (idx * 2u) + 30000000u;
    float param = _50.in_vtx_data[normal_offset + 0u];
    uint n1 = asuint(param);
    float param_1 = _50.in_vtx_data[normal_offset + 1u];
    uint n2 = asuint(param_1);
    vec3 p = vec3(unpackSnorm2x16(n1), unpackSnorm2x16(n2).x);
    return p;
}

vec3 get_vertex_normal(uint idx)
{
    uint param = idx;
    return rt_get_vertex_normal(param);
}

void main()
{
    instanceID = 0u;
    uint param = uint(gl_VertexIndex);
    uint vtx_idx = rt_mask_vtx_idx(param);
    uint param_1 = vtx_idx;
    vec3 pos = get_vertex(param_1);
    uint param_2 = vtx_idx;
    vec3 norm = get_vertex_normal(param_2);
    vtx_output.vLocalPos = pos;
    vtx_output.vIdx = vtx_idx;
    vec4 vPos1 = vec4(pos, 1.0);
    vec3 vPos = pos;
    gl_Position = _164.transform_params.mProjection * vec4(vPos, 1.0);
}

 